/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.SuffixFilter;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class GetFile
extends JFrame {
    private static final long serialVersionUID = 1L;
    private File theFile;
    private String startingFolder = new File(System.getProperty("user.dir")).getAbsolutePath();
    private boolean selectFolder = false;

    public GetFile() throws ValidationException {
        this.setResizable(false);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        this.initComponents();
    }

    public GetFile(Image icon) throws ValidationException {
        this();
        if (icon != null) {
            this.setIconImage(icon);
        }
    }

    public GetFile(Image icon, String startingFolder, boolean selectFolder) throws ValidationException {
        this(icon);
        this.startingFolder = startingFolder;
        this.selectFolder = selectFolder;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    public void browse(String title, String[] suffixes) {
        StringBuilder suffixList = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < suffixes.length; ++i) {
            if (!first) {
                suffixList.append(", ");
            }
            suffixList.append("*").append(suffixes[i]);
            first = false;
        }
        String suffixStr = suffixList.toString();
        if (GeneralUtils.isWinNT() || this.selectFolder) {
            int result;
            JFileChooser fileChooser = new JFileChooser(this.startingFolder);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setDialogTitle(title);
            if (this.selectFolder) {
                fileChooser.setFileSelectionMode(1);
            }
            if (suffixes.length > 0) {
                fileChooser.setFileFilter(new SuffixFilter(suffixes, suffixStr));
            }
            if ((result = fileChooser.showOpenDialog(this)) == 0) {
                this.theFile = fileChooser.getSelectedFile();
            }
        } else {
            FileDialog fd = new FileDialog((Frame)this, title);
            fd.setDirectory(this.startingFolder);
            if (suffixes.length > 0) {
                fd.setFilenameFilter(new SuffixFilter(suffixes, suffixStr));
            }
            fd.setVisible(true);
            String fileStr = fd.getFile();
            if (fileStr != null) {
                this.theFile = new File(fd.getDirectory(), fileStr);
            }
        }
        this.dispose();
    }

    public File getFile() {
        return this.theFile;
    }

    public InputStream getInputStream() throws ValidationException {
        FileInputStream is = null;
        if (this.theFile != null && !this.selectFolder) {
            try {
                is = new FileInputStream(this.theFile);
            }
            catch (FileNotFoundException e) {
                throw new ValidationException(e);
            }
        }
        return is;
    }
}

