/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.snapshot;

import com.totalvalidator.snapshot.SnapshotFile;
import com.totalvalidator.snapshot.WindowsShell;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot
extends Thread {
    public static final int MAX_BROWSERS = 6;
    private static final String WIN = " (Windows)";
    private static final String LINUX = " (Linux)";
    public static final String OLD_MAC = " (OS/X)";
    public static final String MAC = " (OS X)";
    public static final String ALL = "All";
    public static final String ALL_MAC = "All_Mac";
    public static final String ALL_WIN = "All_Win";
    public static final String ALL_LIN = "All_Lin";
    public static final String IE9 = "IE v9";
    public static final String IE8 = "IE v8";
    public static final String IE7 = "IE v7";
    public static final String IE6 = "IE v6";
    public static final String IE55 = "IE v5.5";
    public static final String IE5 = "IE v5";
    public static final String IE4 = "IE v4";
    public static final String FF1 = "Firefox v1";
    public static final String FF10 = "Firefox v1.0";
    public static final String FF15 = "Firefox v1.5";
    public static final String FF2 = "Firefox v2";
    public static final String FF20 = "Firefox v2.0";
    public static final String FF3 = "Firefox v3";
    public static final String FF30 = "Firefox v3.0";
    public static final String FF35 = "Firefox v3.5";
    public static final String FF36 = "Firefox v3.6";
    public static final String FF40 = "Firefox v4.0";
    public static final String SEA = "SeaMonkey";
    public static final String MOZ1 = "Mozilla v1.7";
    public static final String NET6 = "Netscape v6.2";
    private static final String MOZ1_OLD = "Mozilla v1.7 (Netscape v7)";
    private static final String NET6_OLD = "Netscape v6.2 (Mozilla 0.9)";
    public static final String NET4 = "Netscape v4.8";
    public static final String NET3 = "Netscape v3.0";
    public static final String OP11 = "Opera v11";
    public static final String OP10 = "Opera v10";
    public static final String OP9 = "Opera v9";
    public static final String OP8 = "Opera v8";
    public static final String OP7 = "Opera v7";
    public static final String GOOGLE1 = "Google v1";
    public static final String GOOGLE = "Google Chrome";
    public static final String LYNX2 = "Lynx v2.8";
    public static final String EPIPH2 = "Epiphany/Gnome v2";
    public static final String EPIPH1 = "Epiphany v1.6";
    public static final String KONQ34 = "Konqueror v3.4";
    public static final String KONQ4 = "Konqueror v4";
    public static final String KONQ3 = "Konqueror v3";
    public static final String SAFARI = "Safari";
    public static final String SAFARI5 = "Safari v5";
    public static final String SAFARI4 = "Safari v4";
    public static final String SAFARI3 = "Safari v3";
    public static final String SAFARI30 = "Safari v3.0";
    public static final String SAFARI31 = "Safari v3.1";
    public static final String SAFARI2 = "Safari v2";
    public static final String SAFARI20 = "Safari v2.0";
    public static final String CAMINO15 = "Camino v1.5";
    public static final String CAMINO16 = "Camino v1.6";
    public static final String CAMINO = "Camino";
    public static final String IE9WIN = "IE v9 (Windows)";
    public static final String IE8WIN = "IE v8 (Windows)";
    public static final String IE7WIN = "IE v7 (Windows)";
    public static final String IE6WIN = "IE v6 (Windows)";
    public static final String IE55WIN = "IE v5.5 (Windows)";
    public static final String IE5WIN = "IE v5 (Windows)";
    public static final String IE4WIN = "IE v4 (Windows)";
    public static final String FF3WIN = "Firefox v3 (Windows)";
    public static final String FF40WIN = "Firefox v4.0 (Windows)";
    public static final String FF36WIN = "Firefox v3.6 (Windows)";
    public static final String FF35WIN = "Firefox v3.5 (Windows)";
    public static final String FF30WIN = "Firefox v3.0 (Windows)";
    public static final String FF2WIN = "Firefox v2 (Windows)";
    public static final String FF20WIN = "Firefox v2.0 (Windows)";
    public static final String FF15WIN = "Firefox v1.5 (Windows)";
    public static final String FF1WIN = "Firefox v1 (Windows)";
    public static final String FF10WIN = "Firefox v1.0 (Windows)";
    public static final String SEAWIN = "SeaMonkey (Windows)";
    public static final String MOZ1WIN = "Mozilla v1.7 (Windows)";
    public static final String NET6WIN = "Netscape v6.2 (Windows)";
    public static final String NET4WIN = "Netscape v4.8 (Windows)";
    public static final String NET3WIN = "Netscape v3.0 (Windows)";
    public static final String OP11WIN = "Opera v11 (Windows)";
    public static final String OP10WIN = "Opera v10 (Windows)";
    public static final String OP9WIN = "Opera v9 (Windows)";
    public static final String OP8WIN = "Opera v8 (Windows)";
    public static final String OP7WIN = "Opera v7 (Windows)";
    public static final String LYNX2WIN = "Lynx v2.8 (Windows)";
    public static final String SAFARI5WIN = "Safari v5 (Windows)";
    public static final String SAFARI4WIN = "Safari v4 (Windows)";
    public static final String SAFARI3WIN = "Safari v3 (Windows)";
    public static final String SAFARI31WIN = "Safari v3.1 (Windows)";
    public static final String GOOGLE1WIN = "Google v1 (Windows)";
    public static final String GOOGLEWIN = "Google Chrome (Windows)";
    public static final String DEFAULT = "IE v8 (Windows)";
    public static final String FF3LX = "Firefox v3 (Linux)";
    public static final String FF30LX = "Firefox v3.0 (Linux)";
    public static final String FF35LX = "Firefox v3.5 (Linux)";
    public static final String FF36LX = "Firefox v3.6 (Linux)";
    public static final String FF40LX = "Firefox v4.0 (Linux)";
    public static final String FF2LX = "Firefox v2 (Linux)";
    public static final String FF20LX = "Firefox v2.0 (Linux)";
    public static final String FF15LX = "Firefox v1.5 (Linux)";
    public static final String FF1LX = "Firefox v1 (Linux)";
    public static final String FF10LX = "Firefox v1.0 (Linux)";
    public static final String OP11LX = "Opera v11 (Linux)";
    public static final String OP10LX = "Opera v10 (Linux)";
    public static final String OP9LX = "Opera v9 (Linux)";
    public static final String SEALX = "SeaMonkey (Linux)";
    public static final String MOZ1LX = "Mozilla v1.7 (Linux)";
    public static final String LYNX2LX = "Lynx v2.8 (Linux)";
    public static final String EPIPH2LX = "Epiphany/Gnome v2 (Linux)";
    public static final String EPIPH1LX = "Epiphany v1.6 (Linux)";
    public static final String KONQ4LX = "Konqueror v4 (Linux)";
    public static final String KONQ34LX = "Konqueror v3.4 (Linux)";
    public static final String KONQ3LX = "Konqueror v3 (Linux)";
    public static final String GOOGLELX = "Google Chrome (Linux)";
    public static final String SAFARI5MAC = "Safari v5 (OS X)";
    public static final String SAFARI4MAC = "Safari v4 (OS X)";
    public static final String SAFARI3MAC = "Safari v3 (OS X)";
    public static final String SAFARI31MAC = "Safari v3.1 (OS X)";
    public static final String SAFARI30MAC = "Safari v3.0 (OS X)";
    public static final String SAFARI2MAC = "Safari v2 (OS X)";
    public static final String SAFARI20MAC = "Safari v2.0 (OS X)";
    public static final String LYNX2MAC = "Lynx v2.8 (OS X)";
    public static final String FF3MAC = "Firefox v3 (OS X)";
    public static final String FF30MAC = "Firefox v3.0 (OS X)";
    public static final String FF35MAC = "Firefox v3.5 (OS X)";
    public static final String FF36MAC = "Firefox v3.6 (OS X)";
    public static final String FF40MAC = "Firefox v4.0 (OS X)";
    public static final String FF2MAC = "Firefox v2 (OS X)";
    public static final String FF20MAC = "Firefox v2.0 (OS X)";
    public static final String FF15MAC = "Firefox v1.5 (OS X)";
    public static final String SEAMAC = "SeaMonkey (OS X)";
    public static final String MOZ1MAC = "Mozilla v1.7 (OS X)";
    public static final String OP11MAC = "Opera v11 (OS X)";
    public static final String OP10MAC = "Opera v10 (OS X)";
    public static final String OP9MAC = "Opera v9 (OS X)";
    public static final String CAMINOMAC = "Camino (OS X)";
    public static final String GOOGLEMAC = "Google Chrome (OS X)";
    public static final int PORT = 9099;
    public static final int LISTEN_PORT = 9098;
    public static final String RES_DEFAULT = "DEFAULT";
    public static final String RES_1280 = "1280x1024";
    public static final String RES_1280W = "1280x768";
    public static final String RES_1024 = "1024x768";
    public static final String RES_800 = "800x600";
    public static final String RES_640 = "640x480";
    public static final char PREFIX = 'B';
    public static final String PNG = "png";
    public static final String JPG = "jpg";
    private static final String VISTA_HOST = "VISTA_HOST";
    private static final String XP_HOST = "XP_HOST";
    private static final String NT_HOST = "NT_HOST";
    private static final String LINUX_HOST = "LINUX_HOST";
    private static final String MAC_HOST = "MAC_HOST";
    private static final String MAC_WOL_COMMAND = "MAC_WOL_COMMAND";
    private static final String VISTA_VM = "VISTA_VM";
    private static final String XP_VM = "XP_VM";
    private static final String NT_VM = "NT_VM";
    private static final String LINUX_VM = "LINUX_VM";
    private static final String VISTA_WAKEUP_1 = "VISTA_WAKEUP_1";
    private static final String VISTA_WAKEUP_2 = "VISTA_WAKEUP_2";
    private static final String XP_WAKEUP_1 = "XP_WAKEUP_1";
    private static final String XP_WAKEUP_2 = "XP_WAKEUP_2";
    private static final String NT_WAKEUP_1 = "NT_WAKEUP_1";
    private static final String NT_WAKEUP_2 = "NT_WAKEUP_2";
    private static final String LINUX_WAKEUP_1 = "LINUX_WAKEUP_1";
    private static final String LINUX_WAKEUP_2 = "LINUX_WAKEUP_2";
    private static final String MAC_WAKEUP_1 = "MAC_WAKEUP_1";
    private static final String MAC_WAKEUP_2 = "MAC_WAKEUP_2";
    private static final String NO_SNAPSHOT = "No snapshot for ";
    private static final String MAINT_MESSAGE = "This browser is currently out of service. Please try again later.";
    static final String NO_SERVICE = "The online service could not be reached at this time. Please try again later.";
    static final String NO_SOURCE = "Could not read the page source for snapshot";
    private static final String REPORT_PREFIX = "</div><p class=\"centered\"><img alt=\"screen shot\" src=\"";
    private static final long MAX_FILE_SIZE = 512000L;
    private static final String VALIDATOR_LIVE_FOLDER = "/home/halford/workspace/ValidatorLive/";
    private static final String RESTART_VM = "/home/halford/workspace/ValidatorLive/RestartVM.sh ";
    private static final long VM_RESTART_PAUSE = 30000L;
    private List<String> fileNames = new ArrayList<String>();
    private List<String> browsersToUse;
    private String theUrl;
    private String outputDir;
    private boolean returning;
    private boolean savePicture;
    private long waitTime;
    private String resolution;
    private Socket socket;
    static Map<String, String> browserHosts = new HashMap<String, String>();
    private static Map<String, String> vms = new HashMap<String, String>();
    private static Map<String, String> wolCommands = new HashMap<String, String>();
    private static Map<String, String> wakeupTime1 = new HashMap<String, String>();
    private static Map<String, String> wakeupTime2 = new HashMap<String, String>();
    private static String macHost;
    private static String linuxHost;
    private static String ntHost;
    private static String xpHost;
    private static String vistaHost;
    public static List<String> windowsScreenShots;
    public static List<String> windowsScreenShotLabels;
    public static List<String> oldWindows;
    public static List<String> oldWindowsLabels;
    public static List<String> linuxScreenShots;
    public static List<String> linuxScreenShotLabels;
    public static List<String> oldLinux;
    public static List<String> oldLinuxLabels;
    public static List<String> macScreenShots;
    public static List<String> macScreenShotLabels;
    public static List<String> oldMac;
    public static List<String> oldMacLabels;
    public static List<String> resolutions;
    public static Map<String, Dimension> dimensions;

    public static void main(String[] args) {
        GeneralUtils.setupLogging();
        String browser = "IE v8 (Windows)";
        String theUrl = "http://www.totalvalidator.com";
        String outputDir = VALIDATOR_LIVE_FOLDER;
        String resolution = RES_1024;
        String propsFile = "/home/halford/workspace/ValidatorLive/snapshot.props";
        int delay = 3;
        boolean savePicture = true;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-url") && i + 1 < args.length) {
                    theUrl = args[++i];
                    continue;
                }
                if (args[i].equals("-dir") && i + 1 < args.length) {
                    outputDir = args[++i];
                    continue;
                }
                if (args[i].equals("-browser") && i + 1 < args.length) {
                    browser = args[++i];
                    continue;
                }
                if (args[i].equals("-resolution") && i + 1 < args.length) {
                    resolution = args[++i];
                    continue;
                }
                if (args[i].equals("-dontsave")) {
                    savePicture = false;
                    continue;
                }
                if (args[i].equals("-props") && i + 1 < args.length) {
                    propsFile = args[++i];
                    continue;
                }
                if (!args[i].equals("-delay") || i + 1 >= args.length) continue;
                delay = Integer.parseInt(args[++i]);
            }
        }
        Snapshot.setSnapshotProperties(propsFile);
        ArrayList<String> resolutions = new ArrayList<String>();
        if (ALL.equals(resolution)) {
            resolutions.add(RES_1024);
            resolutions.add(RES_800);
            resolutions.add(RES_640);
            resolutions.add(RES_1280);
            resolutions.add(RES_1280W);
            resolutions.add(RES_1024);
        } else {
            resolutions.add(resolution);
        }
        for (String res : resolutions) {
            Snapshot ss;
            System.out.println(res);
            if (browser.equals(ALL)) {
                for (String brwser : browserHosts.keySet()) {
                    System.out.println(brwser);
                    ss = new Snapshot(null, theUrl, outputDir, false, savePicture, delay, res);
                    ss.takePicture(brwser);
                }
                continue;
            }
            if (browser.equals(ALL_MAC)) {
                for (String brwser : browserHosts.keySet()) {
                    if (!macHost.equals(browserHosts.get(brwser))) continue;
                    System.out.println(brwser);
                    ss = new Snapshot(null, theUrl, outputDir, false, savePicture, delay, res);
                    ss.takePicture(brwser);
                }
                continue;
            }
            if (browser.equals(ALL_WIN)) {
                for (String brwser : browserHosts.keySet()) {
                    if (!ntHost.equals(browserHosts.get(brwser)) && !xpHost.equals(browserHosts.get(brwser)) && !vistaHost.equals(browserHosts.get(brwser))) continue;
                    System.out.println(brwser);
                    ss = new Snapshot(null, theUrl, outputDir, false, savePicture, delay, res);
                    ss.takePicture(brwser);
                }
                continue;
            }
            if (browser.equals(ALL_LIN)) {
                for (String brwser : browserHosts.keySet()) {
                    if (!linuxHost.equals(browserHosts.get(brwser))) continue;
                    System.out.println(brwser);
                    ss = new Snapshot(null, theUrl, outputDir, false, savePicture, delay, res);
                    ss.takePicture(brwser);
                }
                continue;
            }
            System.out.println(browser);
            Snapshot ss2 = new Snapshot(null, theUrl, outputDir, false, savePicture, delay, res);
            ss2.takePicture(browser);
        }
        System.exit(0);
    }

    public Snapshot(List<String> browsersToUse, String theUrl, String outputDir, boolean returning, boolean savePicture, long waitTime, String resolution) {
        this.browsersToUse = browsersToUse;
        this.theUrl = theUrl;
        this.outputDir = outputDir;
        this.returning = returning;
        this.savePicture = savePicture;
        this.waitTime = waitTime;
        this.resolution = resolution;
    }

    @Override
    public void run() {
        for (String browser : this.browsersToUse) {
            List<String> newNames = this.takePicture(browser);
            this.fileNames.add('B' + browser);
            if (newNames != null) {
                this.fileNames.addAll(newNames);
                continue;
            }
            this.fileNames.add(MAINT_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> takePicture(String browser) {
        block97: {
            block100: {
                block94: {
                    block99: {
                        block93: {
                            bos = null;
                            bos2 = null;
                            fileNames = new ArrayList<String>();
                            ssf = new SnapshotFile();
                            ssf.theUrl = this.theUrl;
                            ssf.theBrowser = browser;
                            ssf.waitTime = this.waitTime;
                            ssf.resolution = this.resolution;
                            if (!this.theUrl.toLowerCase(Locale.ENGLISH).startsWith("file:")) break block97;
                            bis = null;
                            baos = null;
                            try {
                                try {
                                    index = this.theUrl.toLowerCase(Locale.ENGLISH).indexOf("c:");
                                    if (index == -1) {
                                        index = 7;
                                    }
                                    if ((f = new File(URLDecoder.decode(this.theUrl.substring(index), "UTF-8"))).length() > 512000L) {
                                        var10_12 = null;
                                        var12_14 = null;
                                        break block93;
                                    }
                                    bis = new BufferedInputStream(new FileInputStream(f));
                                    baos = new ByteArrayOutputStream();
                                    i = -1;
                                    while ((i = bis.read()) != -1) {
                                        baos.write(i);
                                    }
                                    ssf.theFile = baos.toByteArray();
                                    break block94;
                                }
                                catch (Exception e) {
                                    GeneralUtils.LOGGER.log(Level.SEVERE, "Error reading Snapshot sent by Server", e);
                                    f = null;
                                    var12_16 = null;
                                    try {
                                        if (bis != null) {
                                            bis.close();
                                        }
                                        if (baos != null) {
                                            baos.close();
                                        }
                                    }
                                    catch (IOException e1) {
                                        // empty catch block
                                    }
                                    bis = null;
                                    return f;
                                }
                            }
                            catch (Throwable var11_37) {
                                block98: {
                                    var12_17 = null;
                                    ** try [egrp 2[TRYBLOCK] [6 : 252->275)] { 
lbl50:
                                    // 1 sources

                                    if (bis != null) {
                                        bis.close();
                                    }
                                    if (baos != null) {
                                        baos.close();
                                    }
                                    break block98;
lbl55:
                                    // 1 sources

                                    catch (IOException e1) {
                                        // empty catch block
                                    }
                                }
                                bis = null;
                                baos = null;
                                throw var11_37;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [6 : 252->275)] { 
lbl63:
                        // 1 sources

                        if (bis != null) {
                            bis.close();
                        }
                        if (baos != null) {
                            baos.close();
                        }
                        break block99;
lbl68:
                        // 1 sources

                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    bis = null;
                    return var10_12;
                }
                var12_15 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 252->275)] { 
lbl76:
                // 1 sources

                if (bis != null) {
                    bis.close();
                }
                if (baos != null) {
                    baos.close();
                }
                break block100;
lbl81:
                // 1 sources

                catch (IOException e1) {
                    // empty catch block
                }
            }
            bis = null;
            baos = null;
        }
        if (!Snapshot.browserHosts.containsKey(browser)) {
            GeneralUtils.LOGGER.severe("Missing browser in table: " + browser);
            return null;
        }
        host = Snapshot.browserHosts.get(browser);
        command = Snapshot.wolCommands.get(host);
        wakeUp = command != null && command.length() > 0;
        vm = Snapshot.vms.get(host);
        virtualMachine = vm != null && vm.length() > 0;
        try {
            block96: {
                block101: {
                    block102: {
                        if (!wakeUp) break block101;
                        if (this.runWOL(command)) break block102;
                        var11_38 = null;
                        var20_43 = null;
                        ssf = null;
                        ** GOTO lbl358
                    }
                    if (this.runWOL(command)) break block101;
                    var11_39 = null;
                    ** GOTO lbl371
                }
                try {
                    this.socket = new Socket(host, 9099);
                }
                catch (Exception e) {
                    if (virtualMachine) {
                        try {
                            WindowsShell.runCommand("/home/halford/workspace/ValidatorLive/RestartVM.sh \"" + vm + "\"", true, true, false);
                        }
                        catch (Exception e1) {
                            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed running VM restart", e1);
                            e1 = null;
                            var20_45 = null;
                            ssf = null;
                            try {
                                if (bos != null) {
                                    bos.flush();
                                    bos.close();
                                }
                                if (bos2 != null) {
                                    bos2.flush();
                                    bos2.close();
                                }
                                if (this.socket == null) return e1;
                                this.socket.close();
                                return e1;
                            }
                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e1;
                        }
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (Exception e2) {
                            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst waiting for VM restart", e);
                        }
                        try {
                            this.socket = new Socket(host, 9099);
                        }
                        catch (Exception e1) {
                            e1 = null;
                            var20_46 = null;
                            ssf = null;
                            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl152:
                            // 1 sources

                            if (bos != null) {
                                bos.flush();
                                bos.close();
                            }
                            if (bos2 != null) {
                                bos2.flush();
                                bos2.close();
                            }
                            if (this.socket == null) return e1;
                            this.socket.close();
                            return e1;
lbl161:
                            // 1 sources

                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e1;
                        }
                    }
                    if (wakeUp) {
                        if (!this.runWOL(command)) {
                            e1 = null;
                            var20_47 = null;
                            ssf = null;
                            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl171:
                            // 1 sources

                            if (bos != null) {
                                bos.flush();
                                bos.close();
                            }
                            if (bos2 != null) {
                                bos2.flush();
                                bos2.close();
                            }
                            if (this.socket == null) return e1;
                            this.socket.close();
                            return e1;
lbl180:
                            // 1 sources

                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e1;
                        }
                        if (!this.runWOL(command)) {
                            e1 = null;
                            var20_48 = null;
                            ssf = null;
                            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl189:
                            // 1 sources

                            if (bos != null) {
                                bos.flush();
                                bos.close();
                            }
                            if (bos2 != null) {
                                bos2.flush();
                                bos2.close();
                            }
                            if (this.socket == null) return e1;
                            this.socket.close();
                            return e1;
lbl198:
                            // 1 sources

                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e1;
                        }
                        try {
                            pause = Long.parseLong(Snapshot.wakeupTime1.get(host));
                            Thread.sleep(pause);
                        }
                        catch (Exception e2) {
                            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst waiting for dehibernate", e);
                        }
                        if (!this.runWOL(command)) {
                            e2 = null;
                            var20_49 = null;
                            ssf = null;
                            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl213:
                            // 1 sources

                            if (bos != null) {
                                bos.flush();
                                bos.close();
                            }
                            if (bos2 != null) {
                                bos2.flush();
                                bos2.close();
                            }
                            if (this.socket == null) return e2;
                            this.socket.close();
                            return e2;
lbl222:
                            // 1 sources

                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e2;
                        }
                        if (!this.runWOL(command)) {
                            e2 = null;
                            var20_50 = null;
                            ssf = null;
                            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl231:
                            // 1 sources

                            if (bos != null) {
                                bos.flush();
                                bos.close();
                            }
                            if (bos2 != null) {
                                bos2.flush();
                                bos2.close();
                            }
                            if (this.socket == null) return e2;
                            this.socket.close();
                            return e2;
lbl240:
                            // 1 sources

                            catch (IOException e1) {
                                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                            }
                            return e2;
                        }
                        try {
                            this.socket = new Socket(host, 9099);
                        }
                        catch (Exception e1) {
                            try {
                                pause = Long.parseLong(Snapshot.wakeupTime2.get(host));
                                Thread.sleep(pause);
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            try {
                                this.socket = new Socket(host, 9099);
                                break block96;
                            }
                            catch (Exception e3) {
                                var14_69 = null;
                                var20_51 = null;
                                ssf = null;
                                ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl262:
                                // 1 sources

                                if (bos != null) {
                                    bos.flush();
                                    bos.close();
                                }
                                if (bos2 != null) {
                                    bos2.flush();
                                    bos2.close();
                                }
                                if (this.socket == null) return var14_69;
                                this.socket.close();
                                return var14_69;
lbl271:
                                // 1 sources

                                catch (IOException e1) {
                                    GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                                }
                                return var14_69;
                            }
                        }
                    }
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst waiting for socket", e);
                    e1 = null;
                    var20_52 = null;
                    ssf = null;
                    ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl280:
                    // 1 sources

                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                    if (bos2 != null) {
                        bos2.flush();
                        bos2.close();
                    }
                    if (this.socket == null) return e1;
                    this.socket.close();
                    return e1;
lbl289:
                    // 1 sources

                    catch (IOException e1) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                    }
                    return e1;
                }
            }
            os = this.socket.getOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(os));
            oos.writeObject(ssf);
            oos.flush();
            ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
            ssf = (SnapshotFile)ois.readObject();
            for (i = 0; i < ssf.snapshots.size(); ++i) {
                image = (byte[])ssf.snapshots.get(i);
                if (image == null || image.length <= 0) continue;
                saveFile = File.createTempFile("snapshot", (String)ssf.snapshotTypes.get(i), new File(this.outputDir, "images"));
                fileName = "images/" + saveFile.getName();
                bos = new BufferedOutputStream(new FileOutputStream(saveFile));
                if (this.savePicture) {
                    bos.write(image);
                }
                if (this.returning) {
                    bos2 = new BufferedOutputStream(new FileOutputStream(FileUtils.getWebRoot() + fileName));
                    fileName = "/" + fileName;
                    bos2.write(image);
                    if (host.equals(Snapshot.macHost)) {
                        bos3 = new BufferedOutputStream(new FileOutputStream("/home/halford/workspace/ValidatorLive/" + fileName));
                        bos3.write(image);
                        bos3.close();
                    }
                }
                fileNames.add(fileName);
                image = null;
            }
            ** GOTO lbl386
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst communicating with SnapshotServer", e);
            if (e instanceof SocketException && e.getMessage() != null && e.getMessage().equals("socket closed")) {
                this.restartServer(host);
            }
            var12_15 = null;
            var20_54 = null;
            ssf = null;
            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl329:
            // 1 sources

            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (bos2 != null) {
                bos2.flush();
                bos2.close();
            }
            if (this.socket == null) return var12_15;
            this.socket.close();
            return var12_15;
lbl338:
            // 1 sources

            catch (IOException e1) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
            }
            return var12_15;
        }
        {
            catch (Throwable var19_75) {
                var20_55 = null;
                ssf = null;
                ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl346:
                // 1 sources

                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
                if (bos2 != null) {
                    bos2.flush();
                    bos2.close();
                }
                if (this.socket == null) throw var19_75;
                this.socket.close();
                throw var19_75;
lbl355:
                // 1 sources

                catch (IOException e1) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
                }
                throw var19_75;
            }
lbl358:
            // 1 sources

            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl359:
            // 1 sources

            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (bos2 != null) {
                bos2.flush();
                bos2.close();
            }
            if (this.socket == null) return var11_38;
            this.socket.close();
            return var11_38;
lbl368:
            // 1 sources

            catch (IOException e1) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
            }
            return var11_38;
lbl371:
            // 1 sources

            var20_44 = null;
            ssf = null;
            ** try [egrp 13[TRYBLOCK] [39 : 1245->1286)] { 
lbl374:
            // 1 sources

            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (bos2 != null) {
                bos2.flush();
                bos2.close();
            }
            if (this.socket == null) return var11_39;
            this.socket.close();
            return var11_39;
lbl383:
            // 1 sources

            catch (IOException e1) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
            }
            return var11_39;
lbl386:
            // 1 sources

            var20_53 = null;
            ssf = null;
            try {}
            catch (IOException e1) {}
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst closing streams", e1);
            return fileNames;
            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (bos2 != null) {
                bos2.flush();
                bos2.close();
            }
            if (this.socket == null) return fileNames;
            this.socket.close();
            return fileNames;
        }
    }

    private void restartServer(String host) {
        try {
            Socket socket = new Socket(host, 9098);
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            os.write(1);
            os.flush();
            is.read();
            socket.close();
            GeneralUtils.LOGGER.log(Level.SEVERE, "Restarted Snapshot server");
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed whilst restarting Snapshot server", e);
        }
    }

    private boolean runWOL(String command) {
        try {
            WindowsShell.runCommand(command, false, true, false);
        }
        catch (Exception e1) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "Failed running WOL", e1);
            return false;
        }
        return true;
    }

    public static boolean testResolution(String resolution) {
        return resolutions.contains(resolution);
    }

    public static List<String> printSnapshots(String[] snapshots, StringBuilder output, String folder, String upLink) {
        boolean first = true;
        ArrayList<String> failedList = new ArrayList<String>();
        if (snapshots != null && snapshots.length > 0) {
            output.append("<a id=\"screenshots\" name=\"screenshots\"></a>");
            for (int i = 0; i < snapshots.length; ++i) {
                String snapshot = snapshots[i];
                if (snapshot.charAt(0) == 'B') {
                    if (!first) {
                        output.append(upLink);
                    }
                    output.append("<h2>" + snapshot.substring(1) + " screenshots</h2>\n");
                    first = false;
                    continue;
                }
                if (snapshots[i].equals(MAINT_MESSAGE)) {
                    failedList.add(NO_SNAPSHOT + snapshots[i - 1]);
                    output.append("<p>This browser is currently out of service. Please try again later.</p>\n");
                    continue;
                }
                if (snapshots[i].equals(NO_SERVICE)) {
                    failedList.add(NO_SNAPSHOT + snapshots[i - 1]);
                    output.append("<p>The online service could not be reached at this time. Please try again later.</p>\n");
                    continue;
                }
                if (snapshots[i].equals(NO_SOURCE)) {
                    failedList.add(NO_SNAPSHOT + snapshots[i - 1]);
                    output.append("<p>Could not read the page source for snapshot</p>\n");
                    continue;
                }
                if (folder != null && snapshot.charAt(0) != '/') {
                    snapshot = folder + "/" + snapshot;
                }
                output.append(REPORT_PREFIX).append(snapshot).append("\" /></p><div class=\"main\">\n");
            }
            output.append(upLink);
        }
        return failedList;
    }

    public List<String> getSnapshots() {
        return this.fileNames;
    }

    public static String mapOldToNew(String browser) {
        int index = browser.indexOf(OLD_MAC);
        if (index != -1) {
            browser = browser.substring(0, index) + MAC;
        }
        if (MOZ1MAC.equals(browser)) {
            browser = FF2MAC;
        } else if (FF30MAC.equals(browser)) {
            browser = FF3MAC;
        } else if (FF20MAC.equals(browser)) {
            browser = FF2MAC;
        } else if (browser.startsWith(CAMINO15) || browser.startsWith(CAMINO16)) {
            browser = CAMINOMAC;
        } else if (SAFARI4MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (SAFARI31MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (SAFARI30MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (SAFARI3MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (SAFARI2MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (SAFARI20MAC.equals(browser)) {
            browser = SAFARI5MAC;
        } else if (OP9MAC.equals(browser)) {
            browser = OP11MAC;
        } else if (OP10MAC.equals(browser)) {
            browser = OP11MAC;
        }
        if (FF30LX.equals(browser)) {
            browser = FF3LX;
        } else if (FF20LX.equals(browser)) {
            browser = FF2LX;
        } else if (FF10LX.equals(browser)) {
            browser = FF1LX;
        } else if (EPIPH1LX.equals(browser)) {
            browser = EPIPH2LX;
        } else if (KONQ34LX.equals(browser)) {
            browser = KONQ4LX;
        } else if (KONQ3LX.equals(browser)) {
            browser = KONQ4LX;
        } else if (OP9LX.equals(browser)) {
            browser = OP11LX;
        } else if (OP10LX.equals(browser)) {
            browser = OP11LX;
        } else if (browser.startsWith(MOZ1_OLD)) {
            browser = MOZ1LX;
        } else {
            index = browser.indexOf(" (Win");
            if (index != -1) {
                browser = browser.substring(0, index) + WIN;
            }
            if (NET3WIN.equals(browser)) {
                browser = NET4WIN;
            } else if (browser.startsWith(NET6_OLD)) {
                browser = NET6WIN;
            } else if (browser.startsWith(MOZ1_OLD)) {
                browser = MOZ1WIN;
            } else if (FF30WIN.equals(browser)) {
                browser = FF3WIN;
            } else if (FF20WIN.equals(browser)) {
                browser = FF2WIN;
            } else if (FF10WIN.equals(browser)) {
                browser = FF1WIN;
            } else if (SAFARI4WIN.equals(browser)) {
                browser = SAFARI5WIN;
            } else if (SAFARI31WIN.equals(browser)) {
                browser = SAFARI5WIN;
            } else if (SAFARI3WIN.equals(browser)) {
                browser = SAFARI5WIN;
            } else if (GOOGLE1WIN.equals(browser)) {
                browser = GOOGLEWIN;
            }
        }
        return browser;
    }

    public void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setSnapshotProperties(String propsFile) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propsFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        vistaHost = props.getProperty(VISTA_HOST, "vistaVM");
        xpHost = props.getProperty(XP_HOST, "winXPVM");
        ntHost = props.getProperty(NT_HOST, "win2kVM");
        linuxHost = props.getProperty(LINUX_HOST, "linuxVM");
        macHost = props.getProperty(MAC_HOST, "macmini");
        browserHosts.put(IE9WIN, vistaHost);
        browserHosts.put(FF40WIN, vistaHost);
        browserHosts.put("IE v8 (Windows)", xpHost);
        browserHosts.put(IE7WIN, xpHost);
        browserHosts.put(IE6WIN, xpHost);
        browserHosts.put(IE55WIN, xpHost);
        browserHosts.put(IE5WIN, xpHost);
        browserHosts.put(IE4WIN, xpHost);
        browserHosts.put(NET6WIN, xpHost);
        browserHosts.put(FF36WIN, xpHost);
        browserHosts.put(FF35WIN, xpHost);
        browserHosts.put(FF3WIN, xpHost);
        browserHosts.put(FF2WIN, xpHost);
        browserHosts.put(FF15WIN, xpHost);
        browserHosts.put(FF1WIN, xpHost);
        browserHosts.put(OP11WIN, xpHost);
        browserHosts.put(OP10WIN, xpHost);
        browserHosts.put(OP9WIN, xpHost);
        browserHosts.put(OP8WIN, xpHost);
        browserHosts.put(OP7WIN, xpHost);
        browserHosts.put(LYNX2WIN, xpHost);
        browserHosts.put(SEAWIN, xpHost);
        browserHosts.put(MOZ1WIN, xpHost);
        browserHosts.put(NET4WIN, xpHost);
        browserHosts.put(SAFARI5WIN, xpHost);
        browserHosts.put(GOOGLEWIN, xpHost);
        browserHosts.put(FF40LX, linuxHost);
        browserHosts.put(FF36LX, linuxHost);
        browserHosts.put(FF35LX, linuxHost);
        browserHosts.put(FF3LX, linuxHost);
        browserHosts.put(OP11LX, linuxHost);
        browserHosts.put(SEALX, linuxHost);
        browserHosts.put(MOZ1LX, linuxHost);
        browserHosts.put(FF1LX, linuxHost);
        browserHosts.put(FF15LX, linuxHost);
        browserHosts.put(FF2LX, linuxHost);
        browserHosts.put(EPIPH2LX, linuxHost);
        browserHosts.put(LYNX2LX, linuxHost);
        browserHosts.put(KONQ4LX, linuxHost);
        browserHosts.put(GOOGLELX, linuxHost);
        browserHosts.put(SAFARI5MAC, macHost);
        browserHosts.put(FF40MAC, macHost);
        browserHosts.put(FF36MAC, macHost);
        browserHosts.put(FF35MAC, macHost);
        browserHosts.put(FF3MAC, macHost);
        browserHosts.put(FF2MAC, macHost);
        browserHosts.put(FF15MAC, macHost);
        browserHosts.put(SEAMAC, macHost);
        browserHosts.put(OP11MAC, macHost);
        browserHosts.put(CAMINOMAC, macHost);
        browserHosts.put(GOOGLEMAC, macHost);
        wolCommands.put(macHost, props.getProperty(MAC_WOL_COMMAND, "/usr/bin/wakeonlan 00:16:cb:a5:bc:9e"));
        vms.put(vistaHost, props.getProperty(VISTA_VM, "VistaVM"));
        vms.put(xpHost, props.getProperty(XP_VM, "WinXPVM"));
        vms.put(ntHost, props.getProperty(NT_VM, "Win2000"));
        vms.put(linuxHost, props.getProperty(LINUX_VM, "LinuxVM"));
        wakeupTime1.put(vistaHost, props.getProperty(VISTA_WAKEUP_1, "1"));
        wakeupTime2.put(vistaHost, props.getProperty(VISTA_WAKEUP_2, "1"));
        wakeupTime1.put(xpHost, props.getProperty(XP_WAKEUP_1, "1"));
        wakeupTime2.put(xpHost, props.getProperty(XP_WAKEUP_2, "1"));
        wakeupTime1.put(ntHost, props.getProperty(NT_WAKEUP_1, "1"));
        wakeupTime2.put(ntHost, props.getProperty(NT_WAKEUP_2, "1"));
        wakeupTime1.put(linuxHost, props.getProperty(LINUX_WAKEUP_1, "1"));
        wakeupTime2.put(linuxHost, props.getProperty(LINUX_WAKEUP_2, "1"));
        wakeupTime1.put(macHost, props.getProperty(MAC_WAKEUP_1, "2000"));
        wakeupTime2.put(macHost, props.getProperty(MAC_WAKEUP_2, "1000"));
    }

    static {
        windowsScreenShots = new ArrayList<String>();
        windowsScreenShotLabels = new ArrayList<String>();
        oldWindows = new ArrayList<String>();
        oldWindowsLabels = new ArrayList<String>();
        linuxScreenShots = new ArrayList<String>();
        linuxScreenShotLabels = new ArrayList<String>();
        oldLinux = new ArrayList<String>();
        oldLinuxLabels = new ArrayList<String>();
        macScreenShots = new ArrayList<String>();
        macScreenShotLabels = new ArrayList<String>();
        oldMac = new ArrayList<String>();
        oldMacLabels = new ArrayList<String>();
        resolutions = new ArrayList<String>();
        dimensions = new HashMap<String, Dimension>();
        windowsScreenShots.add(IE9WIN);
        windowsScreenShotLabels.add(IE9);
        windowsScreenShots.add(FF40WIN);
        windowsScreenShotLabels.add(FF40);
        windowsScreenShots.add(OP11WIN);
        windowsScreenShotLabels.add(OP11);
        windowsScreenShots.add(SAFARI5WIN);
        windowsScreenShotLabels.add(SAFARI5);
        windowsScreenShots.add("IE v8 (Windows)");
        windowsScreenShotLabels.add(IE8);
        windowsScreenShots.add(FF36WIN);
        windowsScreenShotLabels.add(FF36);
        windowsScreenShots.add(GOOGLEWIN);
        windowsScreenShotLabels.add(GOOGLE);
        windowsScreenShots.add(LYNX2WIN);
        windowsScreenShotLabels.add(LYNX2);
        windowsScreenShots.add(IE7WIN);
        windowsScreenShotLabels.add(IE7);
        windowsScreenShots.add(FF35WIN);
        windowsScreenShotLabels.add(FF35);
        windowsScreenShots.add(FF3WIN);
        windowsScreenShotLabels.add(FF3);
        windowsScreenShots.add(SEAWIN);
        windowsScreenShotLabels.add(SEA);
        oldWindows.add(IE6WIN);
        oldWindowsLabels.add(IE6);
        oldWindows.add(FF2WIN);
        oldWindowsLabels.add(FF2);
        oldWindows.add(OP10WIN);
        oldWindowsLabels.add(OP10);
        oldWindows.add(MOZ1WIN);
        oldWindowsLabels.add(MOZ1);
        oldWindows.add(IE55WIN);
        oldWindowsLabels.add(IE55);
        oldWindows.add(FF15WIN);
        oldWindowsLabels.add(FF15);
        oldWindows.add(OP9WIN);
        oldWindowsLabels.add(OP9);
        oldWindows.add(NET6WIN);
        oldWindowsLabels.add(NET6);
        oldWindows.add(IE5WIN);
        oldWindowsLabels.add(IE5);
        oldWindows.add(FF1WIN);
        oldWindowsLabels.add(FF1);
        oldWindows.add(OP8WIN);
        oldWindowsLabels.add(OP8);
        oldWindows.add(NET4WIN);
        oldWindowsLabels.add(NET4);
        linuxScreenShots.add(FF40LX);
        linuxScreenShotLabels.add(FF40);
        linuxScreenShots.add(KONQ4LX);
        linuxScreenShotLabels.add(KONQ4);
        linuxScreenShots.add(OP11LX);
        linuxScreenShotLabels.add(OP11);
        linuxScreenShots.add(FF36LX);
        linuxScreenShotLabels.add(FF36);
        linuxScreenShots.add(GOOGLELX);
        linuxScreenShotLabels.add(GOOGLE);
        linuxScreenShots.add(EPIPH2LX);
        linuxScreenShotLabels.add(EPIPH2);
        linuxScreenShots.add(FF35LX);
        linuxScreenShotLabels.add(FF35);
        linuxScreenShots.add(LYNX2LX);
        linuxScreenShotLabels.add(LYNX2);
        linuxScreenShots.add(SEALX);
        linuxScreenShotLabels.add(SEA);
        oldLinux.add(FF3LX);
        oldLinuxLabels.add(FF3);
        oldLinux.add(FF2LX);
        oldLinuxLabels.add(FF2);
        oldLinux.add(FF15LX);
        oldLinuxLabels.add(FF15);
        oldLinux.add(FF1LX);
        oldLinuxLabels.add(FF1);
        oldLinux.add(MOZ1LX);
        oldLinuxLabels.add(MOZ1);
        macScreenShots.add(FF40MAC);
        macScreenShotLabels.add(FF40);
        macScreenShots.add(SAFARI5MAC);
        macScreenShotLabels.add(SAFARI5);
        macScreenShots.add(OP11MAC);
        macScreenShotLabels.add(OP11);
        macScreenShots.add(FF36MAC);
        macScreenShotLabels.add(FF36);
        macScreenShots.add(GOOGLEMAC);
        macScreenShotLabels.add(GOOGLE);
        macScreenShots.add(CAMINOMAC);
        macScreenShotLabels.add(CAMINO);
        macScreenShots.add(FF35MAC);
        macScreenShotLabels.add(FF35);
        macScreenShots.add(SEAMAC);
        macScreenShotLabels.add(SEA);
        oldMac.add(FF3MAC);
        oldMacLabels.add(FF3);
        oldMac.add(FF2MAC);
        oldMacLabels.add(FF2);
        oldMac.add(FF15MAC);
        oldMacLabels.add(FF15);
        resolutions.add(RES_1280);
        resolutions.add(RES_1024);
        resolutions.add(RES_800);
        resolutions.add(RES_640);
        dimensions.put(RES_1280, new Dimension(1280, 1024));
        dimensions.put(RES_1280W, new Dimension(1280, 768));
        dimensions.put(RES_1024, new Dimension(1024, 768));
        dimensions.put(RES_800, new Dimension(800, 600));
        dimensions.put(RES_640, new Dimension(640, 480));
    }
}

