/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.parser;

import com.totalvalidator.css.CSSProperty;
import com.totalvalidator.utils.DirSelector;
import com.totalvalidator.utils.GeneralUtils;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class CSSRuleParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File objectFile;
    private Map<String, CSSProperty> cssProps;

    public static void main(String[] args) {
        GeneralUtils.setupLogging();
        try {
            CSSRuleParser.parseProperties();
            JOptionPane.showMessageDialog(new Frame(), "CSS Parsing Finished", "Validator", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(new Frame(), e.getMessage() != null ? e.getMessage() : "Error - No Message", "CSS Parsing Error", 0);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void parseProperties() {
        File folder;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DirSelector ds = new DirSelector(null, "Select a folder to parse", ".");
        String dir = ds.getDirectory();
        if (dir != null && (folder = new File(ds.getDirectory())).isDirectory()) {
            CSSRuleParser.parseFolder(folder);
        }
    }

    private static void parseFolder(File folder) {
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                CSSRuleParser.parseFolder(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(".rules")) continue;
            CSSRuleParser parser = new CSSRuleParser();
            parser.objectFile = new File(files[i].getAbsolutePath() + ".object");
            try {
                parser.parseFile(new FileReader(files[i]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (parser == null) continue;
            CSSRuleParser.serialise(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void serialise(CSSRuleParser parser) {
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new FileOutputStream(parser.objectFile));
        oos.writeObject(parser);
        oos.flush();
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw throwable;
        }
    }

    private void parseFile(Reader stream) throws IOException {
        this.cssProps = new HashMap<String, CSSProperty>();
        BufferedReader br = new BufferedReader(stream);
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            String name = st.nextToken().trim();
            name = name.substring(1, name.length() - 1);
            String values = st.nextToken().trim();
            String initialVal = st.nextToken().trim();
            String appliesTo = st.nextToken().trim();
            String inherited = st.nextToken().trim();
            String percentages = st.nextToken().trim();
            String mediaGroup = st.nextToken().trim();
            CSSProperty cssProperty = new CSSProperty(name, values, initialVal, appliesTo, inherited, percentages, mediaGroup);
            GeneralUtils.LOGGER.info(cssProperty.toString());
            this.cssProps.put(name, cssProperty);
        }
    }
}

