/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations.problem;

import com.totalvalidator.validations.problem.CoreProblem;
import com.totalvalidator.validations.problem.CssError;
import com.totalvalidator.validations.problem.HtmlError;
import com.totalvalidator.validations.problem.HtmlWarning;
import com.totalvalidator.validations.problem.LinkError;
import com.totalvalidator.validations.problem.LinkWarning;
import com.totalvalidator.validations.problem.ParsingError;
import com.totalvalidator.validations.problem.ParsingWarning;
import com.totalvalidator.validations.problem.SpellingWarning;
import com.totalvalidator.validations.problem.wai.WaiA2Error;
import com.totalvalidator.validations.problem.wai.WaiA2Warning;
import com.totalvalidator.validations.problem.wai.WaiA508Error;
import com.totalvalidator.validations.problem.wai.WaiA508Warning;
import com.totalvalidator.validations.problem.wai.WaiAA2Error;
import com.totalvalidator.validations.problem.wai.WaiAA508Error;
import com.totalvalidator.validations.problem.wai.WaiAAA2Error;
import com.totalvalidator.validations.problem.wai.WaiAAAError;
import com.totalvalidator.validations.problem.wai.WaiAAError;
import com.totalvalidator.validations.problem.wai.WaiAAWarning;
import com.totalvalidator.validations.problem.wai.WaiAError;
import java.util.HashMap;
import java.util.Map;

public class ValidationProblem {
    private String shortMessage;
    private CoreProblem coreProblem;
    public static final String SEE = " See matching tag(s) on line(s): ";
    public static final String WHICH_IS_DIFFERENT = ", which is different to the value given here:";
    public static final String THE = "The '";
    public static final int LINK_PIECE_LIMIT = 8000;
    public static final int MAX_PIECE_LIMIT = 15000;
    public static final ValidationProblem BINARY_FILE = new ValidationProblem("This page was not checked as it appeared to contain a binary file:", new ParsingError("E000", "One or more characters were discovered which appear to mean that the file is a binary file and not a web page."));
    public static final ValidationProblem MAX_TAGS = new ValidationProblem("This page was not checked as it contains too many tags:", new ParsingError("E000", "Due to the online service being subjected to DoS attacks in the past we've had to limit pages to no more than 15000 tags. This restriction does not apply to the desktop tools."));
    public static final ValidationProblem BROKEN_LINKS = new ValidationProblem("Broken links were not checked for on this page as it contains too many links:", new ParsingError("E000", "Due to the online service being subjected to DoS attacks in the past we've had to limit pages to no more than 8000 links. This restriction does not apply to the desktop tools."));
    public static final ValidationProblem NO_TAGS = new ValidationProblem("Page didn't contain any (X)HTML tags to validate:", new ParsingError("E000", "The page appeared to be empty or didn't contain any (X)HTML tags."));
    public static final int WELL_FORMED = 0;
    public static final int MALFORMED = 1;
    public static final int MISSING_END = 2;
    public static final int MISSING_START = 3;
    public static final int EXTRA_START = 4;
    public static final int EXTRA_END = 5;
    private static final String SEE_CHARSET = "See <a target=\"help\" href=\"http://www.w3.org/TR/html4/charset.html#h-5.3.2\">http://www.w3.org/TR/html4/charset.html#h-5.3.2</a> (displayed in new window).";
    public static final ValidationProblem MISSING_END_ERROR = new ValidationProblem("There is either a &gt; missing or you may have used &lt; instead of &amp;lt; in the content:", new ParsingError("E001", "A &gt; character was expected but was not found. Sometimes this error appears when you have mismatched quotes, but more often it is caused by using a &lt; character in the text. The &lt; character should only be used to start a new tag. Within text you should use the character reference &amp;lt; instead. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/charset.html#h-5.3.2\">http://www.w3.org/TR/html4/charset.html#h-5.3.2</a> (displayed in new window)."));
    public static final ValidationProblem MISSING_START_ERROR = new ValidationProblem("There is either a &lt; missing or you may have used &gt; instead of &amp;gt; in the content:", new ParsingError("E002", "A &lt; character was expected but was not found. Sometimes this error appears when you have mismatched quotes, but more often it is caused by using a &gt; character in the text. The &gt; character should only be used to end a tag. Within text you should use the character reference &amp;gt; instead. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/charset.html#h-5.3.2\">http://www.w3.org/TR/html4/charset.html#h-5.3.2</a> (displayed in new window)."));
    public static final ValidationProblem EXTRA_START_ERROR = new ValidationProblem("There is either an extra &lt; or you may have used &lt; instead of &amp;lt; in the content:", new ParsingError("E003", "A &lt; character was found in an unexpected place. This is often caused by using a &lt; character in the text. The &lt; character should only be used to start a new tag. Within text you should use the character reference &amp;lt; instead. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/charset.html#h-5.3.2\">http://www.w3.org/TR/html4/charset.html#h-5.3.2</a> (displayed in new window)."));
    public static final ValidationProblem EXTRA_END_ERROR = new ValidationProblem("There is either an extra &gt; or you may have used &gt; instead of &amp;gt; in the content:", new ParsingError("E004", "A &gt; character was found in an unexpected place. This is often caused by using a &gt; character in the text. The &gt; character should only be used to end a tag. Within text you should use the character reference &amp;gt; instead. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/charset.html#h-5.3.2\">http://www.w3.org/TR/html4/charset.html#h-5.3.2</a> (displayed in new window)."));
    public static final ValidationProblem MISMATCHED_QUOTES = new ValidationProblem("Extra quote character found or quote character missing:", new ParsingError("E005", "There is either an unnecessary extra single or double quote character or there is a missing quote. This may be caused by putting single or double quote characters within quoted text eg \"Mary said \"hello\" to her friends\". In this case you should replace the quote character with the character reference equivalent e.g. \"Mary said &amp;#34;hello&amp;#34; to her friends\". Note that this error may cause several others to appear that can all be fixed by correcting this issue. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.2\">http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.2</a> (displayed in new window)."));
    public static final String MISSING_ATTR_PLAIN = "The attribute's value is missing:";
    public static final String MISSING_ATTR_VALUE_TEXT = "' attribute's value is missing:";
    public static final CoreProblem MISSING_ATTR_VALUE = new ParsingError("E006", "It appears that you have specified an attribute name but not supplied the attribute's value. If the value does appear to be present then this error may have been be caused by a badly formatted tag possibly with single or double quotes in the wrong place or even mismatched.");
    public static final String NOT_ENTITY_ATTR_0 = "Found '&amp;' within '";
    public static final String NOT_ENTITY_ATTR_1 = "'. You should use '&amp;amp;' instead:";
    public static final CoreProblem NOT_ENTITY_ATTR = new ParsingError("E007", "You should not use the &amp; character within attribute values as this may be confused with the start of character references. This error may also appear if you used a character reference but did not terminate it with a semicolon. Only the first problem in the attribute will be marked, so look out for others.");
    public static final String BAD_ENTITY_0 = "Found invalid character reference '&amp;";
    public static final String BAD_ENTITY_1 = "' within '";
    public static final CoreProblem BAD_ENTITY = new ParsingError("E008", "A character entity reference was found in an attribute that is not defined as part of the HTML specification being validated against. This error may be caused by using an &amp; character when no character reference was intended, in which case use '&amp;amp;' instead.It may also be caused by specifying an invalid numeric reference containing non-numeric characters.");
    public static final String INVALID_ATTR_CHARS_0 = "Invalid characters found in";
    public static final String INVALID_ATTR_CHARS_1 = " attribute's value starting at index: ";
    public static final CoreProblem INVALID_ATTR_CHARS = new ParsingError("E009", "It is good practice to always put quotes around an attribute's value. But if you do not use quotes then you are only allowed to use the characters (a-z and A-Z), digits (0-9), hyphen (ASCII decimal 45), period (ASCII decimal 46), underscore (ASCII decimal 95), and colon (ASCII decimal 58). See <a target=\"help\" href=\"http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.2\">http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.2</a> (displayed in new window).");
    private static final String SEE_DOCTYPE = " <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window).";
    public static final ValidationProblem UNRECOGNISED_DTD = new ValidationProblem("Unrecognised or malformed &lt;!DOCTYPE&gt; tag (if \"auto-detecting\" then a best-fit &lt;!DOCTYPE&gt; will be used):", new ParsingError("E010", "Common reasons for this error are a misspelt declaration, the wrong case used (the declaration is case-sensitive), or an incomplete declaration. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
    public static final ValidationProblem INCOMPLETE_ENTITY = new ValidationProblem("Found '&amp;' within content without a terminating ';':", new ParsingError("E011", "You should not use the &amp; character within content as this may be confused with the start of character references. You should use '&amp;amp;' instead."));
    public static final ValidationProblem INVALID_ENTITY = new ValidationProblem("Found invalid character reference:", new ParsingError("E012", "A character entity reference was found that is not defined as part of the HTML specification being validated against. This error may be caused by using an &amp; character when no character reference was intended, in which case use '&amp;amp;' instead. It may also be caused by specifying an invalid numeric reference containing non-numeric characters."));
    public static final ValidationProblem BADLY_DEFINED_SINGLETON = new ValidationProblem("Badly defined self-closing tag:", new ParsingError("E013", "A self closing tag should end with '/>'. There should be no whitespace between the '/' and the '>' characters. Note that in the report above this extra whitespace will have been removed for you, so you need to consult the original source."));
    public static final ValidationProblem INCOMPLETE_HTML_ENTITY = new ValidationProblem("Found '&amp;' within content without a terminating ';':", new ParsingError("E014", "This error typically appears if you used a character reference but did not terminate it with a semicolon."));
    public static final ValidationProblem BAD_HEX_REPRESENTATION = new ValidationProblem("Found 'X' within character entity reference:", new ParsingError("E015", "This error appears if you used a hexadecimal entity reference with a capital 'X'. In XHTML you must use a lowercase 'x'. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml1/#h-4.12\">http://www.w3.org/TR/xhtml1/#h-4.12</a> (displayed in new window)."));
    public static final String DUPLICATE_ATTR_TEXT = "' attribute is duplicated:";
    public static final CoreProblem DUPLICATE_ATTR = new ParsingError("E016", "It appears that you have specified two attributes with the same case-insensitive name. The second attribute will normally be ignored but this cannot be guaranteed.");
    public static final ValidationProblem BAD_COMMENT_ERROR = new ValidationProblem("There appears to be a badly formed comment on this line (only start of comment shown):", new ParsingWarning("E017", "Most browsers can cope with badly formed comments but some robots may not. So it pays to define comments correctly to ensure your site is indexed properly. The definition of a valid comment in HTML may be found at <a target=\"help\" href=\"http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.4\">http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.4</a> (displayed in new window)."));
    public static final ValidationProblem BAD_CDATA = new ValidationProblem("There appears to be a badly formed CDATA section on this line (only start of section shown):", new ParsingWarning("E018", "The end of the CDATA section could not be found."));
    public static final ValidationProblem EXTRA_WHITESPACE = new ValidationProblem("There should not be any white space at the start or end of an attribute's value:", new ParsingWarning("W001", "There should not be any white space at the start or end of an attribute's value. This is a minor issue and can probably be ignored. See <a target=\"help\" href=\"http://www.w3.org/TR/html4/types.html#type-id\">here</a> (displayed in new window) for more info."));
    public static final ValidationProblem BAD_COMMENT = new ValidationProblem("There appears to be a badly formed comment on this line (only start of comment shown). Comments must start with \"&lt;!--\" :", new ParsingWarning("W002", "Most browsers can cope with badly formed comments but some robots may not. So it pays to define comments correctly to ensure your site is indexed properly. The definition of a valid comment in HTML may be found at <a target=\"help\" href=\"http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.4\">http://www.w3.org/TR/html4/intro/sgmltut.html#h-3.2.4</a> (displayed in new window)."));
    public static final ValidationProblem MISSING_TAG = new ValidationProblem("No matching start tag found:", new ParsingError("E020", "There are two common causes of this error. Either you have forgotten the start tag, or you may have tags that are improperly nested e.g. &lt;b&gt;&lt;i&gt;&lt;/b&gt;&lt;/i&gt;"));
    public static final ValidationProblem EMPTY_TAG = new ValidationProblem("Empty tag:", new ParsingError("E021", "This error may be caused by inadvertently using &lt; and &gt; characters together in the text rather than representing these characters using &amp;lt; and &amp;gt; instead"));
    public static final ValidationProblem END_WITH_ATTRIBUTES = new ValidationProblem("Attributes are not allowed in end tags:", new ParsingError("E022", "End tags cannot have attributes. You may have inadvertently added a '/' character at the beginning of a tag by mistake."));
    public static final ValidationProblem MISSING_ATTR_NAME = new ValidationProblem("An attribute name is missing", new ParsingError("E023", "It appears that you have specified an attribute value but not supplied the attribute's name. This tends to indicate a badly formatted tag possibly with single or double quotes in the wrong place or mismatched. Check that there are no extra or missing quote characters."));
    public static final ValidationProblem ENDTAG_AND_SINGLETON = new ValidationProblem("Extra '/' character found within tag:", new ParsingError("E024", "A '/' character was found at the start of a tag and at the end of a tag. One of the two '/' characters should be removed."));
    public static final ValidationProblem CONDITIONAL_COMMENT = new ValidationProblem("Unrecognised reserved name - possibly an invalid conditional comment:", new ParsingError("E030", "Most browsers can cope with invalid tags but some robots may not. So it pays to use valid tags to ensure your site is indexed properly. In this case you may be using a Microsoft 'downlevel-revealed conditional comment'. If so, try converting this to a 'downlevel-hidden conditional comment' by hiding it within a &lt;!-- comment --&gt;"));
    public static final String BOM_MISMATCH_TEXT = "The BOM specifies a character set of UTF16, but the 'content-type' HTTP header specifies ";
    public static final CoreProblem BOM_MISMATCH = new ParsingError("E031", "The web page starts with a Byte Order Mark (BOM) that is different to the character encoding specified in the 'content-type' HTTP header. The HTTP header information always takes precedence and this may cause the entire document to be full of errors.");
    public static final ValidationProblem SPELLING = new ValidationProblem("Possible spelling mistakes: ", new SpellingWarning("W031", "Words that are not found in the dictionary are highlighted followed by a list of suggested replacements in brackets. To correct this warning replace the word with one of the suggestions or an alternative word. If you believe the word to be correct then if online upload your own dictionary of additional words using the Advanced Form, or if using the Pro or Advanced desktop tool add the word to a dictionary as described in the help."));
    public static final ValidationProblem SPELL_LANG = new ValidationProblem("Document language doesn't match the spell check language: ", new SpellingWarning("W032", "If the document language isn't the same as the language set for spellchecking then the document will not be spellchecked. So you may have spelling errors on this page. If this wasn't intentional either change the language used for spellchecking or correct the language of the document. A list of supported languages may be found in the <a target=\"help\" href=\"http://www.totalvalidator.com/support/options.html#spellcheck\">support pages</a> (displayed in new window)."));
    public static final String LINK_MESSAGE = "Problem with link: ";
    public static final ValidationProblem NOT_HTML = new ValidationProblem("URL appears invalid:", new LinkError("E040", "The link being tested was not recognised as a valid URL. You should test this link manually."));
    public static final String CONNECTION_FAILURE_TEXT = "Connection failure: ";
    public static final CoreProblem CONNECTION_FAILURE = new LinkError("E041", "The link could not be tested due to a connection failure. You should test this link manually.");
    public static final int BAD_CHAR_NUM = 42;
    public static final String BAD_CHAR = "Bad character(s) found in link in attribute '";
    public static final int BAD_REDIRECTED_CHAR_NUM = 43;
    public static final String BAD_REDIRECTED_CHAR = "Bad character(s) found in redirected link in attribute '";
    public static final String FILE_NOT_FOUND_TEXT = "File not found: ";
    public static final LinkError FILE_NOT_FOUND = new LinkError("E044", "The page links to a file that could not be found. Check that the page referred to exists and is in the correct folder, and it, and its parent folders, have sufficient permissions.");
    public static final ValidationProblem FILE_NOT_READABLE = new ValidationProblem("File could not be read:", new LinkError("E045", "A link referred to a file that was found but there were insufficient permissions to allow this file to be read."));
    public static final ValidationProblem NOT_FILE = new ValidationProblem("Not a recognisable file:", new LinkError("E046", "This error is normally caused when a link refers to a folder and not to a file."));
    public static final ValidationProblem TOO_MANY_REDIRECTS = new ValidationProblem("Link cannot be tested as it redirects more than 7 times:", new LinkError("E047", "This error is often caused by pages that redirect to each other in an infinite loop."));
    private static final String DEFAULT_LINK_MESSAGE = "No detailed information available about this problem.";
    private static final Map<Integer, String> linkMessages = new HashMap<Integer, String>();
    public static final ValidationProblem NO_SUCH_ELEMENT;
    public static final ValidationProblem TOP_LEVEL_ELEMENT;
    public static final ValidationProblem NOT_FIRST_TAG;
    public static final ValidationProblem NO_END_TAG_ALLOWED;
    public static final ValidationProblem MISSING_END_TAG;
    public static final ValidationProblem NOT_TOP_LEVEL_ELEMENT_OLD;
    public static final ValidationProblem NOT_TOP_LEVEL_ELEMENT;
    public static final ValidationProblem MISSING_DOCTYPE;
    public static final String INCORRECT_ELEMENT_TEXT = "This tag or content is not allowed here. One of the following was expected: ";
    public static final CoreProblem INCORRECT_ELEMENT;
    public static final String MISSING_ELEMENT_TEXT = "One or more of the following tags are missing from within the enclosing tag: ";
    public static final CoreProblem MISSING_ELEMENT;
    public static final ValidationProblem ONLY_ONE_ALLOWED;
    public static final ValidationProblem INCORRECT_ELEMENT2;
    public static final ValidationProblem WRONG_DOCTYPE_ERROR;
    public static final String NO_SUCH_ATTRIBUTE_TEXT = "' attribute is not valid for this tag here:";
    public static final CoreProblem NO_SUCH_ATTRIBUTE;
    public static final String MISSING_ATTRIBUTE_TEXT = "' attribute for this tag is missing:";
    public static final CoreProblem MISSING_ATTRIBUTE;
    public static final String INVALID_ATTR_VALUE_TEXT = "' attribute does not have a valid value: ";
    public static final CoreProblem INVALID_ATTR_VALUE;
    public static final ValidationProblem MISSING_QUOTES;
    private static final String MEDIA_TYPES = "See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window).";
    public static final ValidationProblem BAD_XML_CONTENT_TYPE;
    public static final ValidationProblem BAD_HTML_CONTENT_TYPE;
    public static final ValidationProblem WRONG_CASE_ELEMENT;
    public static final ValidationProblem WRONG_CASE_ATTRIBUTE;
    public static final ValidationProblem BAD_SINGLETON;
    public static final ValidationProblem BAD_ANCHOR;
    public static final ValidationProblem DIFFERENT_ID_AND_NAME;
    public static final String NON_UNIQUE_ID_TEXT = "Anchor 'name' and 'id' attributes must be unique in the same document:";
    public static final CoreProblem NON_UNIQUE_ID;
    public static final ValidationProblem BAD_REDIRECT_ANCHOR;
    public static final ValidationProblem BAD_XML_CONTENT_TYPE_HEADER;
    public static final ValidationProblem BAD_HTML_CONTENT_TYPE_HEADER;
    public static final ValidationProblem XML_DEC_NOT_FIRST;
    public static final ValidationProblem XML_DEC_DUPLICATE;
    public static final ValidationProblem MISSING_XML_VERSION;
    public static final ValidationProblem BAD_XML_VERSION;
    public static final ValidationProblem BAD_XML_ENCODING;
    public static final ValidationProblem BAD_XML_STANDALONE;
    public static final ValidationProblem UNKNOWN_XML_ATTRIBUTE;
    public static final ValidationProblem MISSING_ROOT_ELEMENT;
    public static final ValidationProblem MISSING_PUBLIC_KEYWORD;
    public static final ValidationProblem XML_DOCTYPE_MIXED_CASE;
    public static final ValidationProblem PUBLIC_MIXED_CASE;
    public static final ValidationProblem ROOT_MIXED_CASE;
    public static final ValidationProblem BAD_CHARSET;
    public static final ValidationProblem DEFAULT_SCRIPTING_LANGUAGE;
    public static final ValidationProblem DEFAULT_STYLE_LANGUAGE;
    public static final ValidationProblem NO_MATCHING_CONTROL;
    public static final ValidationProblem NO_MATCHING_CELL;
    public static final ValidationProblem NO_MATCHING_MAP;
    public static final ValidationProblem MISSING_SYSTEM_KEYWORD;
    public static final ValidationProblem SYSTEM_MIXED_CASE;
    public static final String INVALID_ATTR_NAME_TEXT = "' attribute name has an invalid character at index: ";
    public static final CoreProblem INVALID_ATTR_NAME;
    public static final ValidationProblem DIFFERENT_LANGS;
    public static final ValidationProblem MISSING_LANG;
    public static final ValidationProblem NO_MATCHING_ID;
    public static final ValidationProblem NO_MATCHING_DATALIST;
    public static final ValidationProblem NO_MATCHING_MENU;
    public static final ValidationProblem NO_MATCHING_FORM;
    public static final ValidationProblem NO_MATCHING_REFID;
    public static final String SIBLING_NOT_ALLOWED_TEXT = "' attribute is not allowed for this input 'type':";
    public static final CoreProblem SIBLING_NOT_ALLOWED;
    public static final ValidationProblem META_EXACTLY_ONE;
    public static final ValidationProblem ONLY_ONE_CHARSET;
    public static final ValidationProblem UTF8_ONLY;
    public static final ValidationProblem BLANK_CONTENT;
    public static final String ATTRIBUTE_NOT_ALLOWED_TEXT = "' attribute is not allowed in this context:";
    public static final CoreProblem ATTRIBUTE_NOT_ALLOWED;
    public static final ValidationProblem SCRIPT_TYPE;
    public static final ValidationProblem MISSING_META_CHARSET;
    public static final ValidationProblem CONTENT_LANG;
    public static final ValidationProblem TABLE_SUMMARY;
    public static final String XML_ATTRIBUTE_TEXT = "' attribute has a boolean value, and this may be ignored or cause errors in older browsers/robots:";
    public static final CoreProblem XML_ATTRIBUTE;
    public static final ValidationProblem WRONG_DOCTYPE_WARNING;
    public static final ValidationProblem MISSING_SYSTEM_ID;
    public static final ValidationProblem POOR_XML_CONTENT_TYPE;
    public static final ValidationProblem POOR_XML_CONTENT_TYPE_HEADER;
    public static final String MISMATCH_TEXT = "The 'content-type' HTTP header specifies a character set of ";
    public static final CoreProblem CHARSET_MISMATCH;
    public static final String BOM_TEXT = "The BOM specifies character set of ";
    public static final CoreProblem CHARSET_MISMATCH_BOM;
    public static final ValidationProblem MISSING_CHARSET;
    public static final ValidationProblem IMG_BORDER;
    public static final ValidationProblem A_NAME;
    public static final ValidationProblem SCRIPT_LANGUAGE;
    public static final ValidationProblem CHARSET_NOT_ALLOWED;
    public static final ValidationProblem BAD_CSS_COMMENT_ERROR;
    public static final ValidationProblem MISSING_CSS_QUOTE;
    public static final ValidationProblem MISSING_BLOCK_END;
    public static final ValidationProblem MISSING_SEMI;
    public static final ValidationProblem MISSING_BLOCK;
    public static final ValidationProblem MISSING_SELECTOR;
    public static final ValidationProblem BLOCK_NOT_LAST;
    public static final ValidationProblem EMPTY_SELECTOR;
    private static final String SECTION_508 = "and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window).";
    public static final ValidationProblem A11;
    public static final ValidationProblem A63a;
    public static final ValidationProblem A11b;
    public static final ValidationProblem A11c;
    public static final ValidationProblem A62;
    public static final ValidationProblem A121;
    public static final ValidationProblem A11d;
    public static final ValidationProblem A11e;
    public static final ValidationProblem A11f;
    private static final String HTML5_LAYOUT_TABLE = " If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>.";
    public static final ValidationProblem A51;
    public static final ValidationProblem A52;
    public static final ValidationProblem AA32;
    public static final ValidationProblem AA33;
    public static final ValidationProblem AA34;
    public static final ValidationProblem AA35;
    public static final ValidationProblem AA65;
    public static final ValidationProblem AA72;
    public static final ValidationProblem AA73;
    public static final ValidationProblem AA74;
    public static final ValidationProblem AA93;
    public static final ValidationProblem AA101;
    private static final WaiAA508Error E831;
    public static final ValidationProblem AA124;
    public static final ValidationProblem AA124a;
    public static final ValidationProblem AA124b;
    public static final ValidationProblem AA124c;
    public static final ValidationProblem AA124d;
    private static final String LINK_TEXT = "See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text</a> (displayed in new window).";
    public static final ValidationProblem AA131a;
    public static final ValidationProblem AA131b;
    public static final String AA131c_TEXT = "[WCAG v1 13.1 (AA)] Use the 'title' attribute to distinguish between different links that use the same link text:";
    public static final CoreProblem AA131c;
    public static final String AA131d_TEXT = "[WCAG v1 13.1 (AA)] Use different values for 'title' attributes with links that use the same link text:";
    public static final CoreProblem AA131d;
    public static final ValidationProblem AA132;
    public static final ValidationProblem AAA43;
    public static final ValidationProblem AAA42;
    public static final ValidationProblem AAA55;
    public static final ValidationProblem AAA55a;
    public static final ValidationProblem AAA56;
    public static final ValidationProblem A63;
    public static final ValidationProblem A91;
    public static final ValidationProblem A11g;
    public static final ValidationProblem AA36;
    public static final ValidationProblem WCAG2_F65;
    public static final ValidationProblem WCAG2_F65A;
    public static final ValidationProblem WCAG2_F30;
    public static final ValidationProblem WCAG2_H67;
    public static final ValidationProblem WCAG2_H35;
    public static final ValidationProblem WCAG2_H53;
    public static final ValidationProblem WCAG2_H65;
    public static final String WCAG2_H2_TEXT = "[WCAG v2 2.4.4 (A)] Unnecessary duplication of link description:";
    public static final CoreProblem WCAG2_H2;
    public static final String WCAG2_H2A_TEXT = "[WCAG v2 2.4.4 (A)] Unnecessary duplication of link description:";
    public static final CoreProblem WCAG2_H2A;
    public static final ValidationProblem WCAG2_F25;
    public static final ValidationProblem WCAG2_F25A;
    public static final ValidationProblem WCAG2_H30;
    public static final ValidationProblem WCAG2_H32;
    public static final ValidationProblem WCAG2_H39;
    private static final WaiA2Error E874;
    public static final ValidationProblem WCAG2_H44A;
    public static final ValidationProblem WCAG2_H44B;
    public static final ValidationProblem WCAG2_H46;
    public static final ValidationProblem WCAG2_H73;
    public static final ValidationProblem WCAG2_H63;
    public static final ValidationProblem WCAG2_H64;
    public static final ValidationProblem WCAG2_131;
    public static final ValidationProblem WCAG2_131A;
    public static final ValidationProblem WCAG2_H71;
    public static final ValidationProblem WCAG2_F41;
    public static final ValidationProblem WCAG2_F43;
    public static final ValidationProblem WCAG2_F47;
    private static final WaiA2Error E885;
    public static final ValidationProblem WCAG2_F68;
    public static final ValidationProblem WCAG2_F68B;
    public static final ValidationProblem WCAG2_F68C;
    public static final ValidationProblem WCAG2_F68D;
    public static final ValidationProblem WCAG2_H36;
    public static final ValidationProblem WCAG2_F55;
    public static final ValidationProblem WCAG2_H45;
    public static final ValidationProblem WCAG2_H45A;
    public static final ValidationProblem WCAG2_F16;
    public static final ValidationProblem WCAG2_F54;
    public static final ValidationProblem WCAG2_G140;
    public static final ValidationProblem WCAG2_F20;
    public static final String WCAG2_F62_TEXT = "[WCAG v2 4.1.1 (A)] Duplicate 'id' value found:";
    public static final CoreProblem WCAG2_F62;
    public static final ValidationProblem WCAG2_F62A;
    public static final String WCAG2_F17_TEXT = "[WCAG v2 1.3.1 (A)] Duplicate 'accesskey' value:";
    public static final CoreProblem WCAG2_F17;
    public static final ValidationProblem WCAG2_F17A;
    public static final String WCAG2_244A_TEXT = "[WCAG v2 2.4.4 (A)] Different links that use the same link text may be confusing:";
    public static final CoreProblem WCAG2_244A;
    public static final String WCAG2_244B_TEXT = "[WCAG v2 2.4.4 (A)] Use different values for 'title' attributes with links that use the same link text:";
    public static final CoreProblem WCAG2_244B;
    public static final ValidationProblem WCAG2_144;
    public static final ValidationProblem WCAG2_G131;
    public static final ValidationProblem WCAG2_H28;
    public static final ValidationProblem WCAG2_F88;
    public static final ValidationProblem WCAG2_F84;
    public static final ValidationProblem WCAG2_H67W;
    public static final ValidationProblem WCAG2_H33W;
    public static final ValidationProblem WCAG2_H71W;
    public static final ValidationProblem WCAG2_H57W;
    public static final ValidationProblem WCAG2_H71AW;
    public static final ValidationProblem WCAG2_H45W;
    public static final ValidationProblem WCAG2_H45WA;

    public ValidationProblem(String shortMessage, CoreProblem coreProblem) {
        this.shortMessage = shortMessage;
        this.coreProblem = coreProblem;
    }

    public CoreProblem getCoreProblem() {
        return this.coreProblem;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public static ValidationProblem newSpellWarning(String message) {
        return new ValidationProblem(SPELLING.getShortMessage() + message, SPELLING.getCoreProblem());
    }

    public static ValidationProblem newLinkWarning(int problemNumber, String shortMessage) {
        String longMessage = linkMessages.get(problemNumber);
        if (longMessage == null) {
            longMessage = DEFAULT_LINK_MESSAGE;
        }
        return new ValidationProblem(shortMessage, new LinkWarning("W" + problemNumber, longMessage));
    }

    public static ValidationProblem newLinkError(int problemNumber, String shortMessage) {
        String longMessage;
        String problemNum = "E" + problemNumber;
        if (problemNumber < 100) {
            problemNum = "E0" + problemNumber;
        }
        if ((longMessage = linkMessages.get(problemNumber)) == null) {
            longMessage = DEFAULT_LINK_MESSAGE;
        }
        return new ValidationProblem(shortMessage, new LinkError(problemNum, longMessage));
    }

    static {
        linkMessages.put(42, "One or more characters were found in the link that are invalid according to <a target=\"help\" href=\"http://www.ietf.org/rfc/rfc2396.txt\">rfc2396</a> (displayed in new window). A common mistake is to include spaces. An invalid &lt;base&gt; tag, will also cause this error.");
        linkMessages.put(43, "One or more characters were found in the redirect link that are invalid according to <a target=\"help\" href=\"http://www.ietf.org/rfc/rfc2396.txt\">rfc2396</a> (displayed in new window). A common mistake is to include spaces.");
        linkMessages.put(300, "Multiple choices: The server has responded that there is more than one item that matches the link. You should manually view this link and if necessary change it to point directly to the required item.");
        linkMessages.put(301, "Item moved permanently: The item has been moved elsewhere, and you should change your link to point to the new location as your existing link may become invalid without your knowledge.");
        linkMessages.put(302, "Item moved temporarily: The item has been moved elsewhere, but there should be no reason to change your link.");
        linkMessages.put(303, "See other location: The item resides at a different location, and you should change your link to point to the new location.");
        linkMessages.put(400, "Bad Request: The remote server reported a syntax error in the URL. You should check the link manually to determine the error.");
        linkMessages.put(401, "Unauthorized: The remote server requires authorisation in order to access this document. You may be able to set the user/password for this link on the Advanced Form.");
        linkMessages.put(403, "Forbidden: The remote server denied access to the document for an unknown reason.");
        linkMessages.put(404, "Not Found: The remote server could not find a document at the URL provided. The link may refer to a document that no longer exists, or is pointing to the wrong place.");
        linkMessages.put(410, "Gone: The document no longer exists and has been permanently removed from the remote server.");
        linkMessages.put(500, "Internal Server Error: This appears when a link to a document caused part of the remote server to fail (e.g. a CGI program) or encounter a configuration error.");
        linkMessages.put(503, "Service Unavailable: The document referred to in the link is temporarily unavailable.");
        NO_SUCH_ELEMENT = new ValidationProblem("This element is not recognised:", new HtmlError("E600", "This error is often raised when a browser-specific tag has been used such as &lt;embed&gt;. Alternatively you may have mis-spelled the name or tried to use a tag that is not valid with the HTML specification you are validating against."));
        TOP_LEVEL_ELEMENT = new ValidationProblem("This tag should not be nested within any other tags:", new HtmlError("E601", "This error is normally due to other errors within the page, such as using a frame set with the wrong &lt;!DOCTYPE&gt; tag. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        NOT_FIRST_TAG = new ValidationProblem("This should be the first HTML tag or content in the file:", new HtmlError("E602", "The &lt;!DOCTYPE&gt; tag should appear before all other HTML tags or non-whitespace content (with XHTML it may appear after the XML declaration)."));
        NO_END_TAG_ALLOWED = new ValidationProblem("An end tag is not allowed for this element:", new HtmlError("E603", "This error occurs when you use an end tag where no end tag is allowed according to the HTML specification being validated against. Correcting this error is normally a matter of deleting the end tag indicated."));
        MISSING_END_TAG = new ValidationProblem("The matching end tag appears to be missing:", new HtmlError("E604", "According to the HTML specification being validated against, the tag must have an end tag. Sometimes this error is caused by improperly nested tags where the end tag exists but cannot be matched with the corresponding start tag."));
        NOT_TOP_LEVEL_ELEMENT_OLD = new ValidationProblem("This tag or content must be nested within another tag:", new HtmlError("E606", "The tag or content appears at the top level, but it must be nested inside another tag. This error is typically caused by missing or misplaced &lt;html&gt;, &lt;head&gt; and &lt;body&gt; start and end tags. Although these three tags are actually optional in HTML, it is poor practice to miss them off and often causes problems for search engine robots."));
        NOT_TOP_LEVEL_ELEMENT = new ValidationProblem("This tag or content must be nested within another tag:", new HtmlError("E607", "The tag or content appears at the top level, but it must be nested inside another tag. This error is typically caused by missing or misplaced &lt;html&gt;, &lt;head&gt; and &lt;body&gt; start and end tags. Although these three tags are actually optional in HTML, it is poor practice to miss them off and often causes problems for search engine robots."));
        MISSING_DOCTYPE = new ValidationProblem("There must be a &lt;!DOCTYPE&gt; tag at the top of the page (if 'auto-detecting' then a best-fit &lt;!DOCTYPE&gt; will be used):", new HtmlError("E608", "A &lt;!DOCTYPE&gt; tag should be placed before any other HTML tag or non-whitespace characters on the page. Sometimes the &lt;!DOCTYPE&gt; tag is in the wrong place, but is usually missing altogether in these cases. A correct &lt;!DOCTYPE&gt; tag is needed to ensure that the browser interprets the HTML correctly. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        INCORRECT_ELEMENT = new HtmlError("E609", "If this error is preceded by an E604 error (missing end tag) then correcting the earlier E604 error may correct this one. Otherwise note that there are strict rules as to what tags may be nested within others, as well as the order and number of tags allowed. Try removing the item marked with this error or nesting it within one of the tags listed. Note that in rare cases it is possible that a tag in the list provided also may not be allowed, but a simple test should quickly resolve this.");
        MISSING_ELEMENT = new HtmlError("E610", "The HTML specification being tested against defines that the tag identified must have one or more specific tags nested within it. You should add one or more of the missing tag(s) as appropriate.");
        ONLY_ONE_ALLOWED = new ValidationProblem("Only one of this type of tag should be used within the enclosing tag:", new HtmlError("E611", "This error occurs when the specification only allows one of a certain tag to be nested within the enclosing tag, and more than one tag was found."));
        INCORRECT_ELEMENT2 = new ValidationProblem("This tag or content is not allowed here:", new HtmlError("E612", "Each tag is defined by the HTML specification as only being allowed to contain certain other items nested within it, and sometimes these nested items may only appear once or only in a certain order. A common problem is to use a tag where it may not be obvious that it is not allowed, and may be accepted by many browsers. Try removing the offending item or nesting it within one of the other tags listed."));
        WRONG_DOCTYPE_ERROR = new ValidationProblem("The &lt;!DOCTYPE&gt; tag does not match the HTML specification being checked against:", new HtmlError("E614", "The &lt;!DOCTYPE&gt; tag should exactly match the one that uniquely identifies the specification being tested.  You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        NO_SUCH_ATTRIBUTE = new HtmlError("E620", "The most common reason for this error is the use of a browser-specific attribute (such as 'leftmargin' in the &lt;body&gt; tag), which is not part of the official HTML specification being tested against. If the attribute is for purely for layout then consider using CSS instead.");
        MISSING_ATTRIBUTE = new HtmlError("E621", "The HTML specification being validated against requires that the attribute indicated should be used.");
        INVALID_ATTR_VALUE = new HtmlError("E622", "The HTML specification being validated against defines certain valid values for each attribute. Usually a list of valid values will be displayed when you see this message. Note that many values must be in lower case in XHTML, including the 'x' in numeric hex entity references. Note also that what values are allowed varies from standard to standard.");
        MISSING_QUOTES = new ValidationProblem("The values of all attributes must be enclosed by quotes:", new HtmlError("E623", "In XHTML all attribute values must be enclosed by quotes. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml1/#h-4.4\">http://www.w3.org/TR/xhtml1/#h-4.4</a> (displayed in new window). This error is sometimes caused by a badly formatted tag possibly with single or double quotes in the wrong place or mismatched. Check that there are no extra or missing quote characters."));
        BAD_XML_CONTENT_TYPE = new ValidationProblem("The 'content' attribute should have a value of 'application/xhtml+xml' for XHTML:", new HtmlError("E624", "Note that &lt;meta&gt; tags override HTTP headers and XHTML should be served with a content type of 'application/xhtml+xml', but the content type used was not recognised. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        BAD_HTML_CONTENT_TYPE = new ValidationProblem("The 'content' attribute should have a value of 'text/html' for HTML:", new HtmlError("E625", "Note that &lt;meta&gt; tags override HTTP headers and HTML should be served with a content type of 'text/html'. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        WRONG_CASE_ELEMENT = new ValidationProblem("All element names must be in lower case:", new HtmlError("E626", "XML is case-sensitive and in XHTML all element names are defined as being in lower case. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml1/#h-4.2\">http://www.w3.org/TR/xhtml1/#h-4.2</a> (displayed in new window)."));
        WRONG_CASE_ATTRIBUTE = new ValidationProblem("All attribute names must be in lower case:", new HtmlError("E627", "XML is case-sensitive and in XHTML all attribute names are defined as being in lower case. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml1/#h-4.2\">http://www.w3.org/TR/xhtml1/#h-4.2</a> (displayed in new window)."));
        BAD_SINGLETON = new ValidationProblem("Self-closing tags are not allowed in HTML:", new HtmlError("E628", "With HTML you are not allowed to end a tag with the '/' character. This is only valid with XHTML documents."));
        BAD_ANCHOR = new ValidationProblem("No matching anchor name:", new HtmlError("E629", "A link was found to an anchor in the same page, but that anchor could could not be found. You need to either remove the link or add a matching anchor name."));
        DIFFERENT_ID_AND_NAME = new ValidationProblem("The 'name' and 'id' attributes must have the same value:", new HtmlError("E630", "When 'id' and 'name' attributes appear in the same element they must have the same value. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/struct/links.html#h-12.2.3\">http://www.w3.org/TR/html401/struct/links.html#h-12.2.3</a> (displayed in new window)."));
        NON_UNIQUE_ID = new HtmlError("E631", "All 'id' and anchor 'name' attributes in the same document must have unique values. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/struct/links.html#h-12.2.3\">http://www.w3.org/TR/html401/struct/links.html#h-12.2.3</a> (displayed in new window).");
        BAD_REDIRECT_ANCHOR = new ValidationProblem("No matching anchor name:", new HtmlError("E632", "A link was found in a redirect that points to an anchor in the same page, but that anchor could could not be found. You need to amend the redirect or add a matching anchor name."));
        BAD_XML_CONTENT_TYPE_HEADER = new ValidationProblem("The 'content-type' HTTP header should have a value of 'application/xhtml+xml' for XHTML:", new HtmlError("E633", "XHTML should be served with a content type of 'application/xhtml+xml', but the content type used was not recognised. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        BAD_HTML_CONTENT_TYPE_HEADER = new ValidationProblem("The 'content-type' HTTP header should have a value of 'text/html' for HTML:", new HtmlError("E634", "HTML should be served with a content type of 'text/html'. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        XML_DEC_NOT_FIRST = new ValidationProblem("The XML declaration must appear before any other content or tags:", new HtmlError("E635", "The XML declaration (if supplied) must be the first thing in the file, before any other content or tags."));
        XML_DEC_DUPLICATE = new ValidationProblem("Only one XML declaration is allowed:", new HtmlError("E636", "Only one XML declaration may be supplied and this must be the first thing in the file, before any other content or tags."));
        MISSING_XML_VERSION = new ValidationProblem("The XML declaration must contain a 'version' attribute:", new HtmlError("E637", "The XML declaration must contain a 'version' attribute. Check the spelling of any attributes supplied."));
        BAD_XML_VERSION = new ValidationProblem("Invalid value for the 'version' attribute:", new HtmlError("E638", "The 'version' attribute must be set to the string '1.0'."));
        BAD_XML_ENCODING = new ValidationProblem("Invalid value for the 'encoding' attribute:", new HtmlError("E639", "The 'encoding' attribute must begin with a letter [a-zA-Z] and may be followed by any number of letters, digits [0-9], hyphens, underscores, and periods."));
        BAD_XML_STANDALONE = new ValidationProblem("Invalid value for the 'standalone' attribute:", new HtmlError("E640", "The 'standalone' attribute must be set to either 'yes' or 'no'."));
        UNKNOWN_XML_ATTRIBUTE = new ValidationProblem("Unknown or invalid attribute:", new HtmlError("E641", "The XML declaration contains an unrecognised or invalid attribute. Check for spelling mistakes."));
        MISSING_ROOT_ELEMENT = new ValidationProblem("The root element name 'html' is missing from the &lt;!DOCTYPE&gt; tag:", new HtmlError("E642", "The root element name 'html' is either missing from the &lt;!DOCTYPE&gt; tag, misspelt, or the wrong root element name has been used. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        MISSING_PUBLIC_KEYWORD = new ValidationProblem("The keyword 'PUBLIC' is missing from the &lt;!DOCTYPE&gt; tag:", new HtmlError("E643", "The keyword 'PUBLIC' is either missing from the &lt;!DOCTYPE&gt; tag, or misspelt. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        XML_DOCTYPE_MIXED_CASE = new ValidationProblem("The word '!DOCTYPE' must be in uppercase for XHTML documents:", new HtmlError("E644", "The name '!DOCTYPE' must be all in uppercase for XHTML documents. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        PUBLIC_MIXED_CASE = new ValidationProblem("The keyword 'PUBLIC' must be in uppercase for XHTML documents:", new HtmlError("E645", "The keyword 'PUBLIC' must be all in uppercase for XHTML documents. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        ROOT_MIXED_CASE = new ValidationProblem("The root element name 'html' must be in lowercase for XHTML documents:", new HtmlError("E646", "The root element name 'html' must be all in in lowercase for XHTML documents. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        BAD_CHARSET = new ValidationProblem("The character set is not recognised:", new HtmlError("E647", "The character set specified is not recognised. This may be because it is mispelled."));
        DEFAULT_SCRIPTING_LANGUAGE = new ValidationProblem("The default scripting language must be specified for an intrinsic event:", new HtmlError("E649", "When intrinsic events (onclick, onmouseover etc) are specified the default scripting language should be specified using a Content-Script-Type HTTP header or &lt;meta&gt; tag. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/interact/scripts.html#h-18.2.2.1\">http://www.w3.org/TR/html401/interact/scripts.html#h-18.2.2.1</a> (displayed in new window)."));
        DEFAULT_STYLE_LANGUAGE = new ValidationProblem("The default style sheet language must be specified when style attributes are used:", new HtmlError("E650", "When style attributes are used the default style sheet language should be specified using a Content-Style-Type HTTP header or &lt;meta&gt; tag. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/present/styles.html#h-14.2.1\">http://www.w3.org/TR/html401/present/styles.html#h-14.2.1</a> (displayed in new window)."));
        NO_MATCHING_CONTROL = new ValidationProblem("The value of the 'for' attribute must match the 'id' of a control element in the same form:", new HtmlError("E651", "When you include a 'for' attribute to associate a label with a control you must provide a control with a matching 'id' value in the same form. Referencing controls in different forms, or outside of forms produces an inaccessible page.See <a target=\"help\" href=\"http://www.w3.org/TR/html401/interact/forms.html#h-17.9.1\">http://www.w3.org/TR/html401/interact/forms.html#h-17.9.1</a> (displayed in new window)."));
        NO_MATCHING_CELL = new ValidationProblem("The values in the 'headers' attribute must have matching table cell ids:", new HtmlError("E652", "When you include a 'headers' attribute to associate one cell with another you must provide matching ids in cells in the same table. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/struct/tables.html#edef-TD\">http://www.w3.org/TR/html401/struct/tables.html#edef-TD</a> (displayed in new window)."));
        NO_MATCHING_MAP = new ValidationProblem("The value of the 'usemap' attribute must match the 'id' or 'name' of the &lt;map&gt; it refers to:", new HtmlError("E653", "When you include a 'usemap' attribute for a client-side map you must provide a &lt;map&gt; with a matching 'id' or 'name'."));
        MISSING_SYSTEM_KEYWORD = new ValidationProblem("The keyword 'SYSTEM' is missing from the &lt;!DOCTYPE&gt; tag:", new HtmlError("E654", "The keyword 'SYSTEM' is either missing from the &lt;!DOCTYPE&gt; tag, or misspelt. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        SYSTEM_MIXED_CASE = new ValidationProblem("The keyword 'SYSTEM' must be in uppercase for XHTML documents:", new HtmlError("E655", "The keyword 'SYSTEM' must be all in uppercase for XHTML documents. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        INVALID_ATTR_NAME = new HtmlError("E656", "The specification being validated against does not allow attribute names with certain characters in them, this restriction may include namespace prefixes.");
        DIFFERENT_LANGS = new ValidationProblem("The 'xml:lang' and 'lang' attributes must have the same value:", new HtmlError("E657", "When 'xml:lang' and 'lang' attributes appear in the same element they must have the same value."));
        MISSING_LANG = new ValidationProblem("The 'xml:lang' and 'lang' attributes must have the same value:", new HtmlError("E658", "When the 'xml:lang' attribute is used you must also add a 'lang' attribute to the same element. See <a target=\"help\" href=\"http://www.w3.org/TR/html5/\">http://www.w3.org/TR/html5/</a> (displayed in new window)."));
        NO_MATCHING_ID = new ValidationProblem("The values in the 'for' attribute must have matching ids:", new HtmlError("E659", "When you include a 'for' attribute each of the ids listed must match elements elsewhere in the document."));
        NO_MATCHING_DATALIST = new ValidationProblem("The value of the 'list' attribute must match the 'id' of the &lt;datalist&gt; it refers to:", new HtmlError("E660", "When you include a 'list' attribute you must provide a &lt;datalist&gt; with a matching 'id'."));
        NO_MATCHING_MENU = new ValidationProblem("The value of the 'contextmenu' attribute must match the 'id' of the &lt;menu&gt; it refers to:", new HtmlError("E661", "When you include a 'contextmenu' attribute you must provide a &lt;menu&gt; with a matching 'id'."));
        NO_MATCHING_FORM = new ValidationProblem("The value of the 'form' attribute must match the 'name' or 'id (HTML5) of the &lt;form&gt; it refers to:", new HtmlError("E662", "When you include a 'form' attribute you must provide a &lt;form&gt; with a matching 'name' or 'id (HTML5)."));
        NO_MATCHING_REFID = new ValidationProblem("The value of the 'refid' attribute must match the 'id' of the element it refers to:", new HtmlError("E663", "When you include a 'refid' attribute you must provide an element with a matching 'id'."));
        SIBLING_NOT_ALLOWED = new HtmlError("E664", "For each 'type' attribute only a limited set of other attributes are allowed. See the relevant (X)HTML standard for details.");
        META_EXACTLY_ONE = new ValidationProblem("Attribute missing, or conflicting ones specified:", new HtmlError("E665", "Exactly one of the 'name', 'http-equiv', 'charset', and 'itemprop' attributes must be specified."));
        ONLY_ONE_CHARSET = new ValidationProblem("Only one charset may be specified per document:", new HtmlError("E666", "You can only use one &lt;meta&gt; tag with a 'charset' or 'http-equiv=content-type' attribute."));
        UTF8_ONLY = new ValidationProblem("For XHTML documents the value must be 'UTF-8':", new HtmlError("E667", "For XHTML documents the 'charset' attribute must be a case-insensitive match for 'UTF-8'."));
        BLANK_CONTENT = new ValidationProblem("Missing value for 'content' attribute:", new HtmlError("E668", "If either 'name', 'http-equiv', or 'itemprop' is specified, then the 'content' attribute must have a value or be omitted."));
        ATTRIBUTE_NOT_ALLOWED = new HtmlError("E669", "The HTML specification being validated against specifies that the attribute is not allowed due to other restrictions.");
        SCRIPT_TYPE = new ValidationProblem("Invalid value for 'type' attribute:", new HtmlError("E670", "If the 'language' attribute is specified on the &lt;script&gt; tag then the 'type' attribute must be omitted or be equal to 'text/javascript'."));
        MISSING_META_CHARSET = new ValidationProblem("The charset part of the 'content' attribute is missing:", new HtmlError("E671", "The 'content' attribute must contain a 'charset' value."));
        CONTENT_LANG = new ValidationProblem("Obsolete value for 'http-equiv':", new HtmlError("E672", "Using the &lt;meta&gt; element to specify the document-wide default language is obsolete. Consider specifying the language on the &lt;html&gt; element instead."));
        TABLE_SUMMARY = new ValidationProblem("The 'summary' attribute is obsolete:", new HtmlError("E673", "Authors are encouraged to consider whether the expanatory text in the 'summary' attribute is likely to be useful to the visually impaired, and also whether it would be more useful to the visually unimpaired to put this before the table or in a &lt;caption&gt;."));
        XML_ATTRIBUTE = new HtmlWarning("W600", "Some older browsers and search engine robots do not recognise XHTML style boolean attributes such as selected=\"selected\". For backwards compatibility just use the attribute without any value, e.g. 'selected'");
        WRONG_DOCTYPE_WARNING = new ValidationProblem("The &lt;!DOCTYPE&gt; tag does not match the HTML specification being checked against:", new HtmlWarning("W602", "The &lt;!DOCTYPE&gt; tag should exactly match the one that uniquely identifies the specification being tested.  You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        MISSING_SYSTEM_ID = new ValidationProblem("The 'system ID' is missing from the &lt;!DOCTYPE&gt; tag:", new HtmlWarning("W603", "Although not a serious problem, the &lt;!DOCTYPE&gt; tag should exactly match the one that uniquely identifies the specification that the page follows. In this case the 'system ID' is missing and should be added for completeness. This is a URL pointing to the DTD used to validate the page. You can find a list of the &lt;!DOCTYPE&gt; tags that Total Validator recognises <a target=\"help\" href=\"http://www.totalvalidator.com/support/doctypes.html\">here</a> (displayed in new window)."));
        POOR_XML_CONTENT_TYPE = new ValidationProblem("The 'content' attribute should have a value of 'application/xhtml+xml' for XHTML:", new HtmlWarning("W607", "Note that &lt;meta&gt; tags override HTTP headers and XHTML should be served with a content type of 'application/xhtml+xml'. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        POOR_XML_CONTENT_TYPE_HEADER = new ValidationProblem("The 'content-type' HTTP header should have a value of 'application/xhtml+xml' for XHTML:", new HtmlWarning("W608", "XHTML should be served with a content type of 'application/xhtml+xml'. See <a target=\"help\" href=\"http://www.w3.org/TR/xhtml-media-types/#summary\">http://www.w3.org/TR/xhtml-media-types/#summary</a> (displayed in new window)."));
        CHARSET_MISMATCH = new HtmlWarning("W609", "The 'content-type' HTTP header specifies a different character set to that specified in the tag. In this case the HTTP header takes precedence.");
        CHARSET_MISMATCH_BOM = new HtmlWarning("W610", "The BOM (Byte Order Mark) of the document specifies a different character set to that specified in the tag. In this case the BOM takes precedence.");
        MISSING_CHARSET = new ValidationProblem("No character set is specified in either the 'content-type' HTTP header, &lt;meta&gt; tag, or XML declaration:", new HtmlWarning("W611", "The character set (character encoding) should be specified in either a HTTP header or &lt;meta&gt; tag, (and/or XML declaration for XHTML documents). If it isn't then the user agent may select an incorrect character set by mistake. See <a target=\"help\" href=\"http://www.w3.org/TR/html401/charset.html#h-5.2.2\">http://www.w3.org/TR/html401/charset.html#h-5.2.2</a> (displayed in new window)."));
        IMG_BORDER = new ValidationProblem("The 'border' attribute is obsolete:", new HtmlWarning("W613", "Authors should not specify a 'border' attribute on an &lt;img&gt; element. CSS should be used instead."));
        A_NAME = new ValidationProblem("The 'name' attribute is obsolete:", new HtmlWarning("W614", "The 'name' attribute on the &lt;a&gt; element is obsolete. Consider putting an 'id' attribute on the nearest container instead."));
        SCRIPT_LANGUAGE = new ValidationProblem("The 'language' attribute is obsolete:", new HtmlWarning("W616", "Authors should not specify the 'language' attribute on the &lt;script&gt; element. The 'type' attribute should be used instead."));
        CHARSET_NOT_ALLOWED = new ValidationProblem("With XHTML you should not use the 'content' attribute to set the content type or character set:", new HtmlWarning("W617", "With XHTML the character set should be set by an xml declaration or HTTP header."));
        BAD_CSS_COMMENT_ERROR = new ValidationProblem("Missing end of comment:", new CssError("E700", "A CSS comment was found, but the end of the comment was missing."));
        MISSING_CSS_QUOTE = new ValidationProblem("Closing quote is missing:", new CssError("E701", "An opening quote was found, but the matching end quote was missing."));
        MISSING_BLOCK_END = new ValidationProblem("Closing brace '}' is missing:", new CssError("E702", "The start of a block '{' was found, but the matching end brace '}' was missing."));
        MISSING_SEMI = new ValidationProblem("TODO", new CssError("E703", "TODO"));
        MISSING_BLOCK = new ValidationProblem("TODO", new CssError("E704", "TODO"));
        MISSING_SELECTOR = new ValidationProblem("TODO", new CssError("E705", "TODO"));
        BLOCK_NOT_LAST = new ValidationProblem("TODO", new CssError("E706", "TODO"));
        EMPTY_SELECTOR = new ValidationProblem("TODO", new CssError("E706", "TODO"));
        A11 = new ValidationProblem("[WCAG v1 1.1 (A), US-508-a] Provide a text equivalent for non-text items using 'alt':", new WaiA508Error("E800", "When using &lt;img&gt;, specify a short text equivalent with the 'alt' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#image-text-equivalent\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#image-text-equivalent</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A63a = new ValidationProblem("[WCAG v1 6.3 (A)] Put some content between the start and end tag to provide a text equivalent for non-text items:", new WaiAError("E801", "When using &lt;object&gt; or &lt;applet&gt; you should put some content between the start and end tag to a provide a text alternative. With the &lt;applet&gt; tag this is in addition to any 'alt' text you may have defined. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#applet-text-equivalent\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#applet-text-equivalent</a> (displayed in new window)."));
        A11b = new ValidationProblem("[WCAG v1 1.1 (A)] The 'alt' attribute is for short descriptions. Use 'longdesc' for long ones:", new WaiAError("E802", "The 'alt' text you specified was at least 150 characters long. For long descriptions you should use the 'longdesc' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#long-descriptions\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#long-descriptions</a> (displayed in new window)."));
        A11c = new ValidationProblem("[WCAG v1 1.1 (A)] The 'alt' attribute is for short descriptions. Use a descriptive link for long ones:", new WaiAError("E803", "The 'alt' text you specified was at least 150 characters long. For long descriptions (when 'longdesc' is not supported) you should use a separate description link. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#long-descriptions\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#long-descriptions</a> (displayed in new window)."));
        A62 = new ValidationProblem("[WCAG v1 6.2 (A)] Do not use images as frame targets, always point to web pages:", new WaiAError("E804", "Rather than point directly to an image, embed the image in a web page. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#frame-has-html-src\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#frame-has-html-src</a> (displayed in new window)."));
        A121 = new ValidationProblem("[WCAG v1 12.1 (A), US-508-i] Add a 'title' attribute to facilitate identification and navigation:", new WaiA508Error("E805", "Title each frame to facilitate frame identification and navigation. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#frame-names\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#frame-names</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A11d = new ValidationProblem("[WCAG v1 1.1 (A), US-508-a] Image buttons should have 'alt' text that describes them:", new WaiA508Error("E806", "When using image buttons, specify a short text equivalent with the 'alt' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#forms-graphical-buttons\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#forms-graphical-buttons</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A11e = new ValidationProblem("[WCAG v1 1.1 (A), US-508-a] Provide a text equivalent for non-text items using 'alt':", new WaiA508Error("E807", "When using &lt;applet&gt;, specify a short text equivalent with the 'alt' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#applet-text-equivalent\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#applet-text-equivalent</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A11f = new ValidationProblem("[WCAG v1 1.1 (A), US-508-a] Provide a text equivalent for non-text items using 'alt':", new WaiA508Error("E808", "When using &lt;area&gt;, specify a short text equivalent with the 'alt' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#client-side-text-equivs\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#client-side-text-equivs</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A51 = new ValidationProblem("[WCAG v1 5.1 (A), US-508-g] For data tables identify row and column headers:", new WaiA508Error("E809", "No &lt;th&gt; tags where found in the table, suggesting that you have not clearly identified any row and column headers. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#identifying-table-rows-columns\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#identifying-table-rows-columns</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window). If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>. Or this is a [WCAG v1 5.4 (AA)] error as there is a &lt;caption&gt; or 'summary' present."));
        A52 = new ValidationProblem("[WCAG v1 5.2 (A), US-508-h] Use markup to associate data cells and header cells:", new WaiA508Error("E810", "For data tables you should use markup to associate data cells and header cells, and no such markup was found. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#identifying-table-rows-columns\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#identifying-table-rows-columns</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window). If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>. Or this may be a [WCAG v1 5.4 (AA)] error as there is structural markup present."));
        AA32 = new ValidationProblem("[WCAG v1 3.2 (AA)] Add a &lt;!DOCTYPE&gt; tag to the page:", new WaiAAError("E820", "Validating to a published formal grammar and declaring that validation at the beginning of a document lets the user know that the structure of the document is sound. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#doctype\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#doctype</a> (displayed in new window)."));
        AA33 = new ValidationProblem("[WCAG v1 3.3 (AA)] Use CSS for presentation effects, use &lt;em&gt; or &lt;strong&gt; for emphasis:", new WaiAAError("E821", "Tags that create a visual presentation effect should not be used. You should use style sheets to control layout and presentation. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#text-emphasis\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#text-emphasis</a> (displayed in new window)."));
        AA34 = new ValidationProblem("[WCAG v1 3.4 (AA)] Use relative, rather than absolute units:", new WaiAAError("E822", "Using relative units helps the page to be rendered correctly at different resolutions and people with sight difficulties often 'zoom in' to pages to read them. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10/#tech-relative-units\">http://www.w3.org/TR/WCAG10/#tech-relative-units</a> (displayed in new window)."));
        AA35 = new ValidationProblem("[WCAG v1 3.5 (AA)] Nest headings properly (H1 &gt; H2 &gt; H3):", new WaiAAError("E823", "Heading elements must be ordered properly. For example, in HTML H2 elements should follow H1 elements, H3 elements should follow H2 elements, etc. Developers should not skip levels (e.g., H1 directly to H3). Do not use headings to create font effects. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#document-headers\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#document-headers</a> (displayed in new window)."));
        AA65 = new ValidationProblem("[WCAG v1 6.5 (AA)] Provide a &lt;noframes&gt; tag for user agents that do not support frames:", new WaiAAError("E825", "A page which uses a &lt;frameset&gt; and which does not have a &lt;noframes&gt; alternative may be entirely unusable for some people. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#noframes\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#noframes</a> (displayed in new window)."));
        AA72 = new ValidationProblem("[WCAG v1 7.2 (AA)] Do not use this tag. Consider &lt;em&gt; or using CSS instead:", new WaiAAError("E826", "Until user agents allow users to control blinking, avoid causing content to blink. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#scripts-movement-blinking\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#scripts-movement-blinking</a> (displayed in new window)."));
        AA73 = new ValidationProblem("[WCAG v1 7.3 (AA)] Do not use this tag. Consider &lt;em&gt; or using CSS instead:", new WaiAAError("E827", "Until user agents allow users to freeze moving content, avoid movement in pages. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-CSS-TECHS/#style-text\">http://www.w3.org/TR/WCAG10-CSS-TECHS/#style-text</a> (displayed in new window)."));
        AA74 = new ValidationProblem("[WCAG v1 7.4 (AA)] Do not use 'refresh' to refresh or redirect pages:", new WaiAAError("E828", "Until user agents provide the ability to stop the refresh, do not create periodically auto-refreshing pages. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-CORE-TECHS/#auto-page-refresh\">http://www.w3.org/TR/WCAG10-CORE-TECHS/#auto-page-refresh</a> (displayed in new window)."));
        AA93 = new ValidationProblem("[WCAG v1 9.3 (AA)] Do not use 'ondblclick' or 'onmousemove' as these do not have keyboard equivalents:", new WaiAAError("E829", "For scripts, specify logical event handlers rather than device-dependent event handlers. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#directly-accessible-scripts\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#directly-accessible-scripts</a> (displayed in new window)."));
        AA101 = new ValidationProblem("[WCAG v1 10.1 (AA)] Do not use '_blank' targets with frames:", new WaiAAError("E830", "Until user agents allow users to turn off spawned windows, do not cause pop-ups or other windows to appear. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#no-new-windows\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#no-new-windows</a> (displayed in new window)."));
        E831 = new WaiAA508Error("E831", "Associate labels explicitly with their controls. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#forms-labels\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#forms-labels</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window).");
        AA124 = new ValidationProblem("[WCAG v1 12.4 (AA), US-508-n] Associate form controls with &lt;label&gt; tags using the 'id' attribute:", E831);
        AA124a = new ValidationProblem("[WCAG v1 12.4 (AA), US-508-n] No matching &lt;label&gt; tag could be found, or label is empty:", E831);
        AA124b = new ValidationProblem("[WCAG v1 12.4 (AA), US-508-n] Associate &lt;label&gt; tags with form controls using the 'for' attribute:", E831);
        AA124c = new ValidationProblem("[WCAG v1 12.4 (AA), US-508-n] Label text is missing:", E831);
        AA124d = new ValidationProblem("[WCAG v1 12.4 (AA), US-508-n] Associate labels with just one form control:", E831);
        AA131a = new ValidationProblem("[WCAG v1 13.1 (AA)] Clearly identify the target of each link with some text:", new WaiAAError("E833", "Use text or an image to identify the target of links. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text</a> (displayed in new window)."));
        AA131b = new ValidationProblem("[WCAG v1 13.1 (AA)] Link text should make sense when read out of context:", new WaiAAError("E834", "Don't use link text such as 'click here'. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text</a> (displayed in new window)."));
        AA131c = new WaiAAError("E835", "This error appears when you have not used the 'title' attribute and have different links with the same link text. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text</a> (displayed in new window).");
        AA131d = new WaiAAError("E836", "This error appears when you have used the same 'title' attribute for different links with the same link text. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#link-text</a> (displayed in new window).");
        AA132 = new ValidationProblem("[WCAG v1 13.2 (AA)] Add a &lt;title&gt; tag to the page to describe it:", new WaiAAError("E837", "You should provide metadata, such as the &lt;title&gt; tag, to add semantic information to pages and sites. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#doc-title\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#doc-title</a> (displayed in new window)."));
        AAA43 = new ValidationProblem("[WCAG v1 4.3 (AAA)] Use the 'lang' or 'xml:lang' attribute to denote the primary language of the document:", new WaiAAAError("E854", "You should always identify the primary natural language of a document. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#identify-primary-lang\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#identify-primary-lang</a> (displayed in new window)."));
        AAA42 = new ValidationProblem("[WCAG v1 4.2 (AAA)] Use a 'title' attribute to indicate what the abbreviation or acronym means:", new WaiAAAError("E855", "Mark up abbreviations and acronyms with &lt;abbr&gt; and &lt;acronym&gt; using the 'title' attribute to indicate what they mean. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#text-abbr\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#text-abbr</a> (displayed in new window)."));
        AAA55 = new ValidationProblem("[WCAG v1 5.5 (AAA)] Provide a description for data tables:", new WaiAAAError("E856", "Provide either a &lt;caption&gt;, 'title' or 'summary' attributes to describe the table. This must be a proper description and not a terse one. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info</a> (displayed in new window). If this is not a data table then this is a [WCAG v1 5.4 (AA)] error as there is a &lt;th&gt; or 'summary' present."));
        AAA55a = new ValidationProblem("[WCAG v1 5.5 (AAA)] Provide a descriptive summary for complex data tables:", new WaiAAAError("E857", "Provide a descriptive 'summary' attribute for complex data tables. This must be a proper description and not a terse one. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info</a> (displayed in new window). If this is not a data table then this is a [WCAG v1 5.4 (AA)] error as there is structural markup present."));
        AAA56 = new ValidationProblem("[WCAG v1 5.6 (AAA)] Provide abbreviations for long header labels in data tables:", new WaiAAAError("E858", "Provide terse substitutes for header labels with the 'abbr' attribute on &lt;th&gt;. These will be particularly useful for future speaking technologies that can read row and column labels for each cell. Abbreviations cut down on repetition and reading time. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#table-summary-info</a> (displayed in new window). If this is not a data table then this is a [WCAG v1 5.4 (AA)] error as there is a &lt;caption&gt; or 'summary' present."));
        A63 = new ValidationProblem("[WCAG v1 6.3 (A), US-508-l] Consider providing a &lt;noscript&gt; alternative after each &lt;script&gt; tag:", new WaiA508Warning("W800", "This warning appears if you have defined a &lt;script&gt; and there is no &lt;noscript&gt; alternative following it. You should ensure that pages are usable when scripts are turned off or not supported. Using &lt;noscript&gt; is a common way of doing this, but if you have used an alternative mechanism you can ignore this warning. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10/#tech-scripts\">http://www.w3.org/TR/WCAG10/#tech-scripts</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A91 = new ValidationProblem("[WCAG v1 9.1 (A), US-508-f] If possible use a client-side instead of a server-side image map:", new WaiA508Warning("W801", "Unless you are using regions that cannot be defined with an available geometric shape, you should use a client-side instead of a server-side image map. If you have to use a server-side map ensure that there is an accessible alternative available. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10/#tech-client-side-maps\">http://www.w3.org/TR/WCAG10/#tech-client-side-maps</a> (displayed in new window), and <a target=\"help\" href=\"http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web\"> +http://www.section508.gov/index.cfm?fuseAction=stdsdoc#Web</a> (displayed in new window)."));
        A11g = new ValidationProblem("[WCAG v1 1.1 (A), US-508-a] Is the 'alt' text deliberately empty?:", new WaiA508Warning("W802", "When using &lt;img&gt;, it is valid to have an empty 'alt' attribute for images that have no content; such as spacers and parts of larger images that have been broken up or used for other layout purposes. You may wish to check that in this case the alt-text has not simply been forgotten, in which case it would be a [WCAG v1 1.1 (A), US-508-a] error."));
        AA36 = new ValidationProblem("[WCAG v1 3.6 (AA)] Do not use this tag for layout:", new WaiAAWarning("W820", "This warning appears if you have defined a &lt;ul&gt;, &lt;ol&gt;, or &lt;dl&gt; tag, without any list items within it. The assumption is that you are using these tags purely for layout purposes. If so see the following for help: <a target=\"help\" href=\"http://www.w3.org/TR/WCAG10-HTML-TECHS/#identify-primary-lang\">http://www.w3.org/TR/WCAG10-HTML-TECHS/#identify-primary-lang</a> (displayed in new window)."));
        WCAG2_F65 = new ValidationProblem("[WCAG v2 1.1.1 (A)] When using images, specify a short text alternative with the 'alt' attribute:", new WaiA2Error("E860", "If there is no 'alt' attribute, then assistive technologies are not able to identify the image or to convey its purpose to the userSee <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F65.html\">http://www.w3.org/TR/WCAG20-TECHS/F65.html</a> (displayed in new window)"));
        WCAG2_F65A = new ValidationProblem("[WCAG v2 1.1.1 (A)] When using the &lt;area&gt; element, specify a short text alternative with the 'alt' attribute:", new WaiA2Error("E861", "Ensure the &lt;area&gt; element 'alt' attribute value is displayed in response to attaining focus (including keyboard focus), and that this applies when images are loaded and not loaded. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H24.html\">http://www.w3.org/TR/WCAG20-TECHS/H24.html</a> (displayed in new window)"));
        WCAG2_F30 = new ValidationProblem("[WCAG v2 1.1.1 (A)] When using a text alternative it must be meaningful:", new WaiA2Error("E862", "If the text in the 'text alternative' cannot be used in place of the non-text content without losing information or function then it fails because it is not, in fact, an alternative to the non-text content.See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F30.html\">http://www.w3.org/TR/WCAG20-TECHS/F30.html</a> (displayed in new window)"));
        WCAG2_H67 = new ValidationProblem("[WCAG v2 1.1.1 (A)] The 'title' attribute must be missing or empty when ignoring non-text content:", new WaiA2Error("E863", "When using &lt;img&gt;, it is valid to have an empty 'alt' attribute for images that have no content, but the 'title' attribute should be missing or empty as well. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H67.html\">http://www.w3.org/TR/WCAG20-TECHS/H67.html</a> (displayed in new window)"));
        WCAG2_H35 = new ValidationProblem("[WCAG v2 1.1.1 (A)] Applets should have a text alternative in an 'alt' attribute and in the body text:", new WaiA2Error("E864", "When using &lt;applet&gt;, you should provide an 'alt' attribute with a non-blank value and provide a text alternative in the body text of the applet. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H35.html\">http://www.w3.org/TR/WCAG20-TECHS/H35.html</a> (displayed in new window)"));
        WCAG2_H53 = new ValidationProblem("[WCAG v2 1.1.1 (A)] Objects should have a text alternative:", new WaiA2Error("E865", "When using &lt;object&gt;, you should provide a text alternative in the body text of the object.See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H53.html\">http://www.w3.org/TR/WCAG20-TECHS/H53.html</a> (displayed in new window)"));
        WCAG2_H65 = new ValidationProblem("[WCAG v2 1.1.1 (A)] Form controls without a label must have a 'title' attribute:", new WaiA2Error("E866", "Use the 'title' attribute to label form controls when the visual design cannot accommodate the label (for example, if there is no text on the screen that can be identified as a label) or where it might be confusing to display a label. User agents, including assistive technology, can speak the 'title' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H65.html\">http://www.w3.org/TR/WCAG20-TECHS/H65.html</a> (displayed in new window)"));
        WCAG2_H2 = new WaiA2Error("E867", "A 'stuttering' effect occurs when you have two adjacent links containing the same description. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H2.html\">http://www.w3.org/TR/WCAG20-TECHS/H2.html</a> (displayed in new window)");
        WCAG2_H2A = new WaiA2Error("E868", "A 'stuttering' effect occurs when you have the same link text as the 'alt' text of an image within the link. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H2.html\">http://www.w3.org/TR/WCAG20-TECHS/H2.html</a> (displayed in new window)");
        WCAG2_F25 = new ValidationProblem("[WCAG v2 2.4.2 (A)] Add a &lt;title&gt; tag to the page to describe it:", new WaiA2Error("E869", "You should always provide a &lt;title&gt; element in the head section that defines in a simple phrase the purpose of the document. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F25.html\">http://www.w3.org/TR/WCAG20-TECHS/F25.html</a> (displayed in new window)"));
        WCAG2_F25A = new ValidationProblem("[WCAG v2 2.4.2 (A)] Add a concise, meaningful &lt;title&gt; tag to the page to describe it:", new WaiA2Error("E870", "The &lt;title&gt; should contain a concise, meaningful description, less than 150 characters long. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F25.html\">http://www.w3.org/TR/WCAG20-TECHS/F25.html</a> (displayed in new window)"));
        WCAG2_H30 = new ValidationProblem("[WCAG v2 1.1.1 (A)] Link text is missing:", new WaiA2Error("E871", "Describe the purpose of a link by providing descriptive text as the content of the &lt;a&gt; element. The description lets a user distinguish this link from other links in the Web page and helps the user determine whether to follow the link. The URI of the destination is generally not sufficiently descriptive. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H30.html\">http://www.w3.org/TR/WCAG20-TECHS/H30.html</a> (displayed in new window)"));
        WCAG2_H32 = new ValidationProblem("[WCAG v2 3.2.2 (A)] The submit button is missing:", new WaiA2Error("E872", "You must provide a mechanism that allows users to explicitly request changes of context. The intended use of a submit button is to generate an HTTP request that submits data entered in a form, so it is an appropriate control to use for causing a change of context. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H32.html\">http://www.w3.org/TR/WCAG20-TECHS/H32.html</a> (displayed in new window)"));
        WCAG2_H39 = new ValidationProblem("[WCAG v2 1.3.1 (A)] The 'summary' and 'caption' are the same:", new WaiA2Error("E873", "Making the 'caption' and 'summary' the same is unnecessarily confusing. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H39.html\">http://www.w3.org/TR/WCAG20-TECHS/H39.html</a> (displayed in new window)"));
        E874 = new WaiA2Error("E831", "Associate labels properly with their controls. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H44.html\">http://www.w3.org/TR/WCAG20-TECHS/H44.html</a> (displayed in new window)");
        WCAG2_H44A = new ValidationProblem("[WCAG v2 3.3.2 (A)] The matching &lt;label&gt; tag must appear after the control:", E874);
        WCAG2_H44B = new ValidationProblem("[WCAG v2 3.3.2 (A)] The matching &lt;label&gt; tag must appear before the control:", E874);
        WCAG2_H46 = new ValidationProblem("[WCAG v2 1.1.1 (A)] The corresponding &lt;noembed&gt; element is missing or misplaced:", new WaiA2Error("E875", "For each &lt;embed&gt; element you should provide either a nested &lt;noembed&gt; element or a &lt;noembed&gt; element immediately following it. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H46.html\">http://www.w3.org/TR/WCAG20-TECHS/H46.html</a> (displayed in new window)"));
        WCAG2_H73 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Provide a descriptive summary for complex data tables:", new WaiA2Error("E876", "Provide a descriptive 'summary' attribute for complex data tables. This must be a proper description and not a terse one. See <a target=\"help\" href=\"http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/H73\">http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/H73</a> (displayed in new window).  If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>. Or this is an accessibility error as there is structural markup present. See <a target=\"help\" href=\"http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46\">http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46</a> (displayed in new window)."));
        WCAG2_H63 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Invalid value for 'scope' attribute:", new WaiA2Error("E877", "The 'scope' attribute must have one of the following values: row, col, rowgroup, or colgroup. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H63.html\">http://www.w3.org/TR/WCAG20-TECHS/H63.html</a> (displayed in new window)"));
        WCAG2_H64 = new ValidationProblem("[WCAG v2 4.1.2 (A)] Add a 'title' attribute to facilitate identification and navigation:", new WaiA2Error("E878", "Title each &lt;frame&gt; and &lt;iframe&gt; to facilitate identification and navigation. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H64.html\">http://www.w3.org/TR/WCAG20-TECHS/H64.html</a> (displayed in new window)"));
        WCAG2_131 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Provide a description for data tables:", new WaiA2Error("E879", "Provide either a &lt;caption&gt;, 'title' or 'summary' attributes to describe the table. This must be a proper description and not a terse one. See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/content-structure-separation-programmatic.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/content-structure-separation-programmatic.html</a> (displayed in new window).  If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>. Or this is an accessibility error as there is structural markup present. See <a target=\"help\" href=\"http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46\">http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46</a> (displayed in new window)."));
        WCAG2_131A = new ValidationProblem("[WCAG v2 1.3.1 (A)] For data tables use markup to associate data cells and header cells:", new WaiA2Error("E880", "For data tables you must use markup to associate data cells and header cells, and no such markup was found. See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/content-structure-separation-programmatic.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/content-structure-separation-programmatic.html</a> (displayed in new window). If this is not a data table and it is an HTML5 page then this is an HTML5 error as <a target=\"help\" href=\"http://www.w3.org/TR/html5/tabular-data.html#the-table-element\">layout tables should not be used in HTML5</a>. Or this is an accessibility error as there is structural markup present. See <a target=\"help\" href=\"http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46\">http://www.w3.org/TR/2008/NOTE-WCAG20-TECHS-20081211/F46</a> (displayed in new window)."));
        WCAG2_H71 = new ValidationProblem("[WCAG v2 1.3.1 (A)] The &lt;fieldset&gt; element should only be used within a form:", new WaiA2Error("E881", "Using a &lt;fieldset&gt; outside of a form usually indicates it is being used for presentation effects.See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H71.html\">http://www.w3.org/TR/WCAG20-TECHS/H71.html</a> (displayed in new window)"));
        WCAG2_F41 = new ValidationProblem("[WCAG v2 2.2.1 (A)] You should not use a non-zero page refresh or redirect:", new WaiA2Error("E882", "It is important that the time-out is set to zero, to avoid that content is displayed before the new page is loaded. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F41.html\">http://www.w3.org/TR/WCAG20-TECHS/F41.html</a> (displayed in new window)"));
        WCAG2_F43 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Nest headings properly (H1 &gt; H2 &gt; H3):", new WaiA2Error("E883", "Heading elements must be ordered properly. For example, H2 elements should follow H1 elements, H3 elements should follow H2 elements, etc. Developers should not skip levels or use headings for presentation effects. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F43.html\">http://www.w3.org/TR/WCAG20-TECHS/F43.html</a> (displayed in new window)"));
        WCAG2_F47 = new ValidationProblem("[WCAG v2 2.2.2 (A)] Do not use this tag. Consider &lt;em&gt; or using CSS instead:", new WaiA2Error("E884", "Using blink causes any text inside the element to blink at a predetermined rate, which cannot be interrupted by the user or disabled. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F47.html\">http://www.w3.org/TR/WCAG20-TECHS/F47.html</a> (displayed in new window)"));
        E885 = new WaiA2Error("E885", "Associate labels properly with their controls. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F68.html\">http://www.w3.org/TR/WCAG20-TECHS/F68.html</a> (displayed in new window)");
        WCAG2_F68 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Associate form controls with &lt;label&gt; tags using the 'id' attribute:", E885);
        WCAG2_F68B = new ValidationProblem("[WCAG v2 1.3.1 (A)] Associate &lt;label&gt; tags with form controls using the 'for' attribute:", E885);
        WCAG2_F68C = new ValidationProblem("[WCAG v2 1.3.1 (A)] Label text is missing:", E885);
        WCAG2_F68D = new ValidationProblem("[WCAG v2 1.3.1 (A)] Associate labels with just one form control:", E885);
        WCAG2_H36 = new ValidationProblem("[WCAG v2 1.1.1 (A)] Do not use the 'alt' attribute here:", new WaiA2Error("E886", "Although HTML may allow the 'alt' attribute here, it should only be used on image submit buttons. User agent support for this attribute on other types of form controls is not well defined. Other mechanisms are available to label these controls. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H36.html\">http://www.w3.org/TR/WCAG20-TECHS/H36.html</a> (displayed in new window)"));
        WCAG2_F55 = new ValidationProblem("[WCAG v2 2.4.7 (A)] Do not remove focus when focus is received:", new WaiA2Error("E887", "The system focus indicator is an important part of accessibility for keyboard users.  Removing focus entirely means the content can only be accessed by a pointer device. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F55.html\">http://www.w3.org/TR/WCAG20-TECHS/F55.html</a> (displayed in new window)"));
        WCAG2_H45 = new ValidationProblem("[WCAG v2 1.1.1 (A)] The 'alt' attribute is for short descriptions. Use 'longdesc' for long ones:", new WaiA2Error("E888", "The 'alt' text you specified was at least 100 characters long. For long descriptions you should use the 'longdesc' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H45.html\">http://www.w3.org/TR/WCAG20-TECHS/H45.html</a> (displayed in new window)"));
        WCAG2_H45A = new ValidationProblem("[WCAG v2 1.1.1 (A)] The 'alt' attribute is for short descriptions. Use 'longdesc' for long ones:", new WaiA2Error("E889", "The 'alt' text you specified was at least 100 characters long. For long descriptions (when 'longdesc' is not supported) you should use a separate description link. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H45.html\">http://www.w3.org/TR/WCAG20-TECHS/H45.html</a> (displayed in new window)"));
        WCAG2_F16 = new ValidationProblem("[WCAG v2 2.2.2 (A)] Do not use this tag. Consider an alternative instead:", new WaiA2Error("E890", "With the &lt;marquee&gt; element there is moving or scrolling content that cannot be paused and resumed by users. Some users with low vision or cognitive disabilities will not be able to perceive the content. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F16.html\">http://www.w3.org/TR/WCAG20-TECHS/F16.html</a> (displayed in new window)"));
        WCAG2_F54 = new ValidationProblem("[WCAG v2 2.1.1 (A)] Server-side image maps are not keyboard accessible:", new WaiA2Error("E891", "Server-side image maps are not keyboard accessible. Consider an accessible alternative instead.See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/keyboard-operation-keyboard-operable.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/keyboard-operation-keyboard-operable.html</a> (displayed in new window)"));
        WCAG2_G140 = new ValidationProblem("[WCAG v2 1.3.1 (A)] Use CSS for presentation effects, use &lt;em&gt; or &lt;strong&gt; for emphasis:", new WaiA2Error("E892", "Tags that are being used purely to create a visual presentation effect should not be used. You should use CSS to control layout and presentation so that users and their aids may control it. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/G140.html\">http://www.w3.org/TR/WCAG20-TECHS/G140.html</a> (displayed in new window)"));
        WCAG2_F20 = new ValidationProblem("[WCAG v2 4.1.2 (A)] Do not use images as frame targets, always point to web pages:", new WaiA2Error("E893", "Rather than point directly to an image, embed the image in a web page so that if the content of the frame is changed the text-alternative can follow this change. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F20.html\">http://www.w3.org/TR/WCAG20-TECHS/F20.html</a> (displayed in new window)"));
        WCAG2_F62 = new WaiA2Error("E894", "IDs must be unique within a document to ensure that Web pages can be interpreted consistently. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F62.html\">http://www.w3.org/TR/WCAG20-TECHS/F62.html</a> (displayed in new window)");
        WCAG2_F62A = new ValidationProblem("[WCAG v2 1.3.1 (A)] Reference to a missing or incorrect 'id' attribute:", new WaiA2Error("E895", "References to other parts of the same document must exist to ensure that Web pages can be interpreted properly. Note that certain attributes such as 'for' can only reference certain elements in the same &lt;form&gt;, others can only reference elements in the same table. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F62.html\">http://www.w3.org/TR/WCAG20-TECHS/F62.html</a> (displayed in new window)"));
        WCAG2_F17 = new WaiA2Error("E896", "Accesskeys must have unique values in order to be useful. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F17.html\">http://www.w3.org/TR/WCAG20-TECHS/F17.html</a> (displayed in new window)");
        WCAG2_F17A = new ValidationProblem("[WCAG v2 1.3.1 (A)] Missing 'id' attribute corresponding to the 'axis' attribute:", new WaiA2Error("E897", "If you specify an 'axis' attribute you must also specify an 'id' attribute and this 'id' attribute must also exist in at least one 'headers' attribute in another table cell in the same table. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F17.html\">http://www.w3.org/TR/WCAG20-TECHS/F17.html</a> (displayed in new window)"));
        WCAG2_244A = new WaiA2Error("E898", "If you have different links with the same link text it can be confusing to the user. So you should either change the link text or add a unique 'title' attribute to each link. See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-refs.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-refs.html</a> (displayed in new window)");
        WCAG2_244B = new WaiA2Error("E899", "If you have different links with the same link text and 'title' it can be confusing to the user. So you should either change the link text or add a unique 'title' to each link. See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-refs.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-refs.html</a> (displayed in new window)");
        WCAG2_144 = new ValidationProblem("[WCAG v2 1.4.4 (AA)] Use relative, rather than absolute units:", new WaiAA2Error("E910", "Using relative units helps the page to be rendered correctly at different resolutions and allows people with sight difficulties to 'zoom in' to pages to read them. See <a target=\"help\" href=\"http://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-scale.html\">http://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-scale.html</a> (displayed in new window)"));
        WCAG2_G131 = new ValidationProblem("[WCAG v2 2.4.6 (AA)] Provide descriptive text:", new WaiAA2Error("E911", "Any descriptive text supplied should be clear. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/G131.html\">http://www.w3.org/TR/WCAG20-TECHS/G131.html</a> (displayed in new window)"));
        WCAG2_H28 = new ValidationProblem("[WCAG v2 3.1.4 (AAA)] Add a 'title' attribute to the element to describe it:", new WaiAAA2Error("E920", "Ensure that &lt;abbr&gt; and &lt;acronym&gt; elements have a 'title' attribute that describes the abbreviation/acronym. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H28.html\">http://www.w3.org/TR/WCAG20-TECHS/H28.html</a> (displayed in new window)"));
        WCAG2_F88 = new ValidationProblem("[WCAG v2 1.4.8 (AAA)] You should not use justified text:", new WaiAAA2Error("E921", "Many people with cognitive disabilities have a great deal of trouble with blocks of text that are justified (aligned to both the left and the right margins). See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F88.html\">http://www.w3.org/TR/WCAG20-TECHS/F88.html</a> (displayed in new window)"));
        WCAG2_F84 = new ValidationProblem("[WCAG v2 2.4.9 (AAA)] Provide descriptive link text:", new WaiAAA2Error("E922", "You should always provide a way of allowing users to know the destination from the link text alone. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F84.html\">http://www.w3.org/TR/WCAG20-TECHS/F84.html</a> (displayed in new window)"));
        WCAG2_H67W = new ValidationProblem("[WCAG v2 1.1.1 (A)] Is the 'alt' text deliberately empty?:", new WaiA2Warning("W860", "When using &lt;img&gt;, it is valid to have an empty 'alt' attribute for images that have no content; such as spacers and parts of larger images that have been broken up or used for other layout purposes. You may wish to check that in this case the alt text has not simply been forgotten. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/F30.html\">http://www.w3.org/TR/WCAG20-TECHS/F30.html</a> (displayed in new window)"));
        WCAG2_H33W = new ValidationProblem("[WCAG v2 1.1.1 (A)] Is the 'title' text deliberately empty?:", new WaiA2Warning("W861", "The 'title' attribute is used to provide additional information to help clarify or further describe the purpose of a link, but in this case it has been found to be empty. You may wish to check that the title text has not simply been forgotten. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H33.html\">http://www.w3.org/TR/WCAG20-TECHS/H33.html</a> (displayed in new window)"));
        WCAG2_H71W = new ValidationProblem("[WCAG v2 1.3.1 (A)] The &lt;fieldset&gt; element should be used to group radio buttons and checkboxes:", new WaiA2Warning("W863", "Because groups of radio buttons and checkboxes are multiple controls, it is particularly important that they be grouped semantically so they can be more easily treated as a single control. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H71.html\">http://www.w3.org/TR/WCAG20-TECHS/H71.html</a> (displayed in new window)"));
        WCAG2_H57W = new ValidationProblem("[WCAG v2 3.1.1 (A)] Use the 'lang' or 'xml:lang' attribute to denote the primary language of the document:", new WaiA2Warning("W864", "You should always identify the primary natural language of a document. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H57.html\">http://www.w3.org/TR/WCAG20-TECHS/H57.html</a> (displayed in new window)"));
        WCAG2_H71AW = new ValidationProblem("[WCAG v2 1.3.1 (A)] Each &lt;fieldset&gt; should have a &lt;legend&gt; element that includes a description of that group:", new WaiA2Warning("W865", "The first element inside the &lt;fieldset&gt; should be a &lt;legend&gt;, which provides a label or instructions for the group. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H71.html\">http://www.w3.org/TR/WCAG20-TECHS/H71.html</a> (displayed in new window)"));
        WCAG2_H45W = new ValidationProblem("[WCAG v2 1.1.1 (A)] The 'alt' attribute is for short descriptions. Use 'longdesc' for long ones:", new WaiA2Error("W866", "The 'alt' text you specified was at least 75 characters long. For long descriptions you should use the 'longdesc' attribute. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H45.html\">http://www.w3.org/TR/WCAG20-TECHS/H45.html</a> (displayed in new window)"));
        WCAG2_H45WA = new ValidationProblem("[WCAG v2 1.1.1 (A)] The 'alt' attribute is for short descriptions. Use 'longdesc' for long ones:", new WaiA2Error("W867", "The 'alt' text you specified was at least 75 characters long. For long descriptions (when 'longdesc' is not supported) you should use a separate description link. See <a target=\"help\" href=\"http://www.w3.org/TR/WCAG20-TECHS/H45.html\">http://www.w3.org/TR/WCAG20-TECHS/H45.html</a> (displayed in new window)"));
    }
}

