/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.Tab;
import com.totalvalidator.exceptions.CommandLineException;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.utils.GeneralUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTab
extends JPanel
implements Tab {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ActionURL";
    private static final String SUBMIT = "SubmitButton";
    private static final String NAMES = "Names";
    private static final String VALUES = "Values";
    private static final String SEP = "|";
    private static final String REGEX = "ActionRegex";
    private JTextField actionURL;
    private JTextField submitButton;
    private JTable table;
    private DefaultTableModel tableModel;
    private JCheckBox regex;

    public FormTab(final JTabbedPane tabbedPane, Properties props, CommandLineParser ffclp) {
        this.setLayout(new GridBagLayout());
        this.setBackground(TotalValidator.TOTAL_LIGHT_BLUE);
        this.setOpaque(true);
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new GridBagLayout());
        actionPanel.setOpaque(false);
        actionPanel.setBorder(new TitledBorder("Form details"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)actionPanel, gridBagConstraints);
        JLabel actionLabel = new JLabel();
        actionLabel.setText("Action URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        actionPanel.add((Component)actionLabel, gridBagConstraints);
        this.actionURL = new JTextField();
        this.actionURL.setEditable(true);
        this.actionURL.setToolTipText("The 'action' attribute value to search for");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        actionPanel.add((Component)this.actionURL, gridBagConstraints);
        this.regex = new JCheckBox("Regular expression");
        this.regex.setOpaque(false);
        this.regex.setToolTipText("The Action URL is a regular expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        actionPanel.add((Component)this.regex, gridBagConstraints);
        JLabel submitLabel = new JLabel();
        submitLabel.setText("Submit button:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        actionPanel.add((Component)submitLabel, gridBagConstraints);
        this.submitButton = new JTextField();
        this.submitButton.setEditable(true);
        this.submitButton.setToolTipText("The name of the submit button to use if there is more than one");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        actionPanel.add((Component)this.submitButton, gridBagConstraints);
        JPanel nvPanel = new JPanel();
        nvPanel.setLayout(new GridBagLayout());
        nvPanel.setOpaque(false);
        nvPanel.setBorder(new TitledBorder("Parameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)nvPanel, gridBagConstraints);
        this.table = new JTable();
        this.table.setToolTipText("Double click an item to edit it");
        this.table.setSelectionMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        if (GeneralUtils.isMacOSX()) {
            tableScrollPane.setVerticalScrollBarPolicy(22);
            tableScrollPane.setHorizontalScrollBarPolicy(32);
        }
        tableScrollPane.setMinimumSize(new Dimension(100, 200));
        tableScrollPane.setPreferredSize(new Dimension(100, 200));
        JViewport jViewport = tableScrollPane.getViewport();
        jViewport.setScrollMode(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        nvPanel.add((Component)tableScrollPane, gridBagConstraints);
        JPanel editPanel = new JPanel();
        editPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        nvPanel.add((Component)editPanel, gridBagConstraints);
        JButton add = new JButton("Add");
        if (GeneralUtils.isMacOSX()) {
            add.setOpaque(false);
        }
        add.setToolTipText("Add a new line");
        add.setVerifyInputWhenFocusTarget(false);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormTab.this.finishEditing();
                FormTab.this.tableModel.addRow(new String[]{"", ""});
            }
        });
        editPanel.add(add);
        JButton del = new JButton("Delete");
        if (GeneralUtils.isMacOSX()) {
            add.setOpaque(false);
        }
        del.setToolTipText("Delete the selected line");
        del.setVerifyInputWhenFocusTarget(false);
        del.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormTab.this.finishEditing();
                int selectedRow = FormTab.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    FormTab.this.tableModel.removeRow(selectedRow);
                    if (FormTab.this.tableModel.getRowCount() == 0) {
                        FormTab.this.tableModel.addRow(new String[]{"", ""});
                    }
                }
            }
        });
        editPanel.add(del);
        JButton clear = new JButton("Clear");
        if (GeneralUtils.isMacOSX()) {
            clear.setOpaque(false);
        }
        clear.setToolTipText("Delete all lines");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormTab.this.makeNewModel();
            }
        });
        editPanel.add(clear);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        JButton reset = new JButton();
        if (GeneralUtils.isMacOSX()) {
            reset.setOpaque(false);
        }
        reset.setText("Reset Tab");
        reset.setMnemonic(82);
        reset.setToolTipText("Reset settings on this tab to defaults");
        reset.setVerifyInputWhenFocusTarget(false);
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int result = JOptionPane.showConfirmDialog(tabbedPane.getParent(), TotalValidator.MESSAGES, "Reset to defaults", 0);
                if (result == 0) {
                    FormTab.this.resetTab();
                }
            }
        });
        buttonPanel.add(reset);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)buttonPanel, gridBagConstraints);
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)filler, gridBagConstraints);
        this.updateTab(props, ffclp);
        tabbedPane.addTab("Forms", null, this, "Form Options");
    }

    protected void finishEditing() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    protected void makeNewModel() {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Name");
        this.tableModel.addColumn("Value");
        this.tableModel.addRow(new String[]{"", ""});
        this.table.setModel(this.tableModel);
    }

    private void getNVPairs(Properties props, CommandLineParser ffclp) {
        Vector<String> names = this.toVector(props.getProperty(NAMES, ""));
        if (ffclp != null) {
            names = ffclp.getFormNames();
        }
        Vector<String> values = this.toVector(props.getProperty(VALUES, ""));
        if (ffclp != null) {
            values = ffclp.getFormValues();
        }
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn((Object)"Name", names);
        this.tableModel.addColumn((Object)"Value", values);
        this.table.setModel(this.tableModel);
    }

    private Vector<String> toVector(String list) {
        Vector<String> items = new Vector<String>();
        int index = list.indexOf(SEP);
        boolean includeLast = true;
        if (index != -1) {
            do {
                items.add(list.substring(0, index));
                if (index + 1 < list.length()) {
                    list = list.substring(index + 1, list.length());
                    index = list.indexOf(SEP);
                    continue;
                }
                includeLast = false;
            } while (index != -1 && includeLast);
        }
        if (includeLast) {
            items.add(list);
        }
        return items;
    }

    @Override
    public void getFields(List<String> options) throws CommandLineException {
        String action = this.actionURL.getText().trim();
        if (action.length() > 0) {
            options.add("-action");
            options.add(action);
            if (this.regex.isSelected()) {
                options.add("-actionregex");
            }
            String submit = this.submitButton.getText().trim();
            if (action.length() > 0) {
                options.add("-submit");
                options.add(submit);
            }
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                String name = ((String)this.tableModel.getValueAt(i, 0)).trim();
                String value = (String)this.tableModel.getValueAt(i, 1);
                if (name.length() <= 0) continue;
                options.add("-name" + i);
                options.add(name);
                if (value.length() <= 0) continue;
                options.add("-value" + i);
                options.add(value);
            }
        }
    }

    @Override
    public void resetTab() {
        this.actionURL.setText("");
        this.regex.setSelected(false);
        this.submitButton.setText("");
        this.makeNewModel();
    }

    public void updateTab(Properties props, CommandLineParser ffclp) {
        String actionTxt = props.getProperty(ACTION, "");
        String submitTxt = props.getProperty(SUBMIT, "");
        if (ffclp != null) {
            actionTxt = ffclp.getActionURL();
            this.regex.setSelected(ffclp.isActionRegex());
            submitTxt = ffclp.getSubmitButton();
        } else {
            String regexVal = props.getProperty(REGEX, "false");
            this.regex.setSelected(regexVal.equals("true"));
        }
        this.actionURL.setText(actionTxt);
        this.submitButton.setText(submitTxt);
        this.getNVPairs(props, ffclp);
    }

    @Override
    public void saveProperties(Properties props) {
        props.setProperty(ACTION, this.actionURL.getText());
        props.setProperty(REGEX, this.regex.isSelected() + "");
        props.setProperty(SUBMIT, this.submitButton.getText());
        StringBuilder namesTxt = new StringBuilder();
        StringBuilder valuesTxt = new StringBuilder();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String name = ((String)this.tableModel.getValueAt(i, 0)).trim();
            String value = (String)this.tableModel.getValueAt(i, 1);
            if (name.length() <= 0) continue;
            namesTxt.append(name).append(SEP);
            valuesTxt.append(value).append(SEP);
        }
        props.setProperty(NAMES, namesTxt.toString());
        props.setProperty(VALUES, valuesTxt.toString());
    }
}

