/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.Agent;
import com.totalvalidator.app.AgentComparator;
import com.totalvalidator.app.BasicTab;
import com.totalvalidator.utils.GeneralUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUserAgents
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Edit Identification";
    private static EditUserAgents eua;
    private JTable table;
    private DefaultTableModel tableModel;
    private boolean cancelled = false;

    public EditUserAgents(Frame frame, Set<Agent> agentList) {
        super(frame, TITLE, true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditUserAgents.this.cancel();
            }
        });
        JPanel panel = new JPanel();
        panel.setBackground(TotalValidator.TOTAL_LIGHT_BLUE);
        panel.setLayout(new GridBagLayout());
        this.add(panel);
        this.table = new JTable();
        this.setAgents(agentList);
        this.table.setToolTipText("Double click an item to edit it");
        this.table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        if (GeneralUtils.isMacOSX()) {
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setHorizontalScrollBarPolicy(32);
        }
        scrollPane.setMinimumSize(new Dimension(400, 200));
        scrollPane.setPreferredSize(new Dimension(400, 200));
        JViewport jViewport = scrollPane.getViewport();
        jViewport.setScrollMode(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)scrollPane, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        JButton add = new JButton("Add");
        if (GeneralUtils.isMacOSX()) {
            add.setOpaque(false);
        }
        add.setMnemonic(65);
        add.setToolTipText("Add identity to list");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUserAgents.this.finishEditing();
                EditUserAgents.this.tableModel.addRow(new String[]{"", ""});
            }
        });
        buttonPanel.add(add);
        JButton delete = new JButton("Delete");
        if (GeneralUtils.isMacOSX()) {
            delete.setOpaque(false);
        }
        delete.setMnemonic(68);
        delete.setToolTipText("Remove selected identity from list");
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUserAgents.this.finishEditing();
                int selectedRow = EditUserAgents.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    EditUserAgents.this.tableModel.removeRow(selectedRow);
                    if (EditUserAgents.this.tableModel.getRowCount() == 0) {
                        EditUserAgents.this.tableModel.addRow(new String[]{"Total Validator", "TotalValidator/6.0"});
                    }
                }
            }
        });
        buttonPanel.add(delete);
        JButton reset = new JButton("Reset");
        if (GeneralUtils.isMacOSX()) {
            reset.setOpaque(false);
        }
        reset.setMnemonic(82);
        reset.setToolTipText("Reset to defaults");
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUserAgents.this.finishEditing();
                int result = JOptionPane.showConfirmDialog(EditUserAgents.this, "This will reset all of the entries to the defaults. Are you sure?", "Reset to defaults", 0);
                if (result == 0) {
                    EditUserAgents.this.setAgents(BasicTab.readAgentsList(true));
                }
            }
        });
        buttonPanel.add(reset);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        panel.add((Component)buttonPanel, gridBagConstraints);
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panel.add((Component)filler, gridBagConstraints);
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setOpaque(false);
        JButton exit = new JButton("OK");
        if (GeneralUtils.isMacOSX()) {
            exit.setOpaque(false);
        }
        exit.setMnemonic(88);
        exit.setToolTipText("Apply all changes");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUserAgents.this.finishEditing();
                EditUserAgents.this.setVisible(false);
            }
        });
        buttonPanel2.add(exit);
        JButton cancel = new JButton("Cancel");
        if (GeneralUtils.isMacOSX()) {
            cancel.setOpaque(false);
        }
        cancel.setToolTipText("Ignore all changes");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditUserAgents.this.cancel();
            }
        });
        buttonPanel2.add(cancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        panel.add((Component)buttonPanel2, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void finishEditing() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private void setAgents(Set<Agent> agentList) {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Agent");
        this.tableModel.addColumn("String");
        this.table.setModel(this.tableModel);
        for (Agent agent : agentList) {
            this.tableModel.addRow(new String[]{agent.getIdentity(), agent.getDetails()});
        }
        if (agentList.size() == 0) {
            this.tableModel.addRow(new String[]{"Total Validator", "TotalValidator/6.0"});
        }
    }

    protected void cancel() {
        this.cancelled = true;
        this.setVisible(false);
    }

    public static synchronized void showEditor(Container container, Set<Agent> agentList) {
        if (eua == null) {
            while (!(container instanceof Frame)) {
                container = container.getParent();
            }
            eua = new EditUserAgents((Frame)container, agentList);
        } else {
            eua.setAgents(agentList);
        }
        EditUserAgents.eua.cancelled = false;
        eua.setVisible(true);
        eua.toFront();
    }

    public static Set<Agent> getAgents() {
        TreeSet<Object> agents = new TreeSet<Object>(new AgentComparator());
        for (int i = 0; i < EditUserAgents.eua.tableModel.getRowCount(); ++i) {
            String identity = ((String)EditUserAgents.eua.tableModel.getValueAt(i, 0)).trim();
            String details = ((String)EditUserAgents.eua.tableModel.getValueAt(i, 1)).trim();
            if (identity.length() <= 0 || details.length() <= 0) continue;
            agents.add(new Agent(identity, details));
        }
        return agents;
    }

    public static boolean isCancelled() {
        return EditUserAgents.eua.cancelled;
    }
}

