/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.app;

import com.totalvalidator.TotalValidator;
import com.totalvalidator.app.AuthenticationPanel;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.ProxyDetails;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.HttpURLConnection;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class AuthenticationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField userName;
    private JPasswordField password;
    private static int count = 0;
    private boolean okay = false;
    private static final String TITLE = "Authentication Required";
    private static final String OKAY = "OK";
    private static final String REALM = "realm=\"";
    private static final String NO_REALM = "No Realm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAuthDetails(Frame frame, HttpURLConnection httpConnection, boolean proxy, String url, int dialogCount) {
        int retry = -1;
        String realm = AuthenticationDialog.getRealm(httpConnection, proxy);
        if (realm == null) {
            realm = NO_REALM;
        }
        GeneralUtils.LOGGER.info(realm);
        Class<AuthenticationDialog> clazz = AuthenticationDialog.class;
        synchronized (AuthenticationDialog.class) {
            if (dialogCount < count) {
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return count;
            }
            AuthenticationDialog ad = new AuthenticationDialog(frame == null ? AuthenticationDialog.makeFrame() : frame, realm, url);
            if (ad.isOkay()) {
                if (proxy) {
                    ProxyDetails proxyDetails = new ProxyDetails(false, httpConnection.getHeaderField("Host"), null, ad.getUserName(), ad.getPassword());
                    GeneralUtils.getAuthenticator().addProxyAuthentication(proxyDetails);
                } else {
                    GeneralUtils.getAuthenticator().addServerAuthentication(ad.getUserName(), ad.getPassword(), url, realm.equals(NO_REALM) ? null : realm);
                }
                retry = ++count;
            }
            ad.dispose();
            ad = null;
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return retry;
        }
    }

    private static Frame makeFrame() {
        JFrame frame = new JFrame();
        Image icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("com/totalvalidator/images/tv64.gif"));
        MediaTracker tracker = new MediaTracker(frame);
        tracker.addImage(icon, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ((Frame)frame).setIconImage(icon);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return frame;
    }

    private static String getRealm(HttpURLConnection httpConnection, boolean proxy) {
        int index2;
        String realm = httpConnection.getHeaderField(proxy ? "Proxy-Authenticate" : "WWW-Authenticate");
        int index1 = realm.indexOf(REALM);
        if (index1 != -1 && (index1 += REALM.length()) < realm.length() && (index2 = realm.indexOf("\"", index1)) != -1 && index2 > index1) {
            realm = "Realm: " + realm.substring(index1, index2);
        }
        if (realm.toLowerCase(Locale.ENGLISH).startsWith("negotiate")) {
            realm = "Windows Authentication";
        }
        if ("".equals(realm)) {
            realm = null;
        }
        return realm;
    }

    public AuthenticationDialog(Frame frame, String realm, String url) {
        super(frame, TITLE, true);
        this.setResizable(false);
        JPanel panel = new JPanel();
        panel.setBackground(TotalValidator.TOTAL_LIGHT_BLUE);
        panel.setLayout(new GridBagLayout());
        this.add(panel);
        this.userName = new JTextField("", 20);
        this.password = new JPasswordField("", 20);
        AuthenticationPanel webPanel = new AuthenticationPanel(this.userName, this.password, url, realm, true, null, null, null, null, null, null);
        webPanel.setBackground(TotalValidator.TOTAL_LIGHT_BLUE);
        webPanel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)webPanel, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        JButton ok = new JButton(OKAY);
        if (GeneralUtils.isMacOSX()) {
            ok.setOpaque(false);
        }
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (AuthenticationDialog.this.getUserName() != null) {
                    AuthenticationDialog.this.okay = true;
                    AuthenticationDialog.this.setVisible(false);
                }
            }
        });
        buttonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        if (GeneralUtils.isMacOSX()) {
            cancel.setOpaque(false);
        }
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AuthenticationDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(cancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)buttonPanel, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
        this.toFront();
    }

    public String getUserName() {
        String userNameStr = this.userName.getText().trim();
        if ("".equals(userNameStr)) {
            userNameStr = null;
        }
        return userNameStr;
    }

    public String getPassword() {
        return new String(this.password.getPassword()).trim();
    }

    public boolean isOkay() {
        return this.okay;
    }

    public static void resetCount() {
        count = 0;
    }
}

