/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.spelling;

import com.totalvalidator.spelling.WordDifferences;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.language.DoubleMetaphone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellingDictionary {
    private Map<String, Set<String>> dictionary = new HashMap<String, Set<String>>();
    private DoubleMetaphone doubleMeta = new DoubleMetaphone();

    public void addMoreWords(Reader reader) {
        Scanner scanner = new Scanner(reader);
        while (scanner.hasNext()) {
            String word = scanner.next().toLowerCase();
            if (word.length() <= 0) continue;
            String sound = this.doubleMeta.doubleMetaphone(word);
            Set<String> similarSoundingWords = this.dictionary.get(sound);
            if (similarSoundingWords == null) {
                similarSoundingWords = new HashSet<String>();
                similarSoundingWords.add(word);
                this.dictionary.put(sound, similarSoundingWords);
                continue;
            }
            similarSoundingWords.add(word);
        }
    }

    public void close() {
        this.dictionary.clear();
        this.dictionary = null;
    }

    public boolean checkWord(String word) {
        Set<String> similarSoundingWords = this.dictionary.get(this.doubleMeta.doubleMetaphone(word));
        return similarSoundingWords != null && similarSoundingWords.contains(word.toLowerCase());
    }

    public Set<String> getAlternatives(String word, boolean ignorePlurals) {
        Set<String> singulars;
        word = word.toLowerCase();
        String sound = this.doubleMeta.doubleMetaphone(word);
        HashSet<String> alternatives = new HashSet<String>();
        Set<String> inDictionary = this.dictionary.get(sound);
        if (inDictionary != null) {
            alternatives.addAll(inDictionary);
        }
        if (ignorePlurals && sound.endsWith("S") && sound.length() > 1 && (singulars = this.dictionary.get(sound = sound.substring(0, sound.length() - 1))) != null) {
            alternatives.addAll(singulars);
        }
        char[] chars = word.toCharArray();
        for (int i = 0; i < chars.length - 1; ++i) {
            char ch = chars[i];
            chars[i] = chars[i + 1];
            chars[i + 1] = ch;
            Set<String> swappedWords = this.dictionary.get(this.doubleMeta.doubleMetaphone(new String(chars)));
            if (swappedWords != null) {
                alternatives.addAll(swappedWords);
            }
            chars[i + 1] = chars[i];
            chars[i] = ch;
        }
        if (alternatives.isEmpty()) {
            return null;
        }
        TreeSet<String> closestWords = new TreeSet<String>();
        TreeSet<String> moreWords = new TreeSet<String>();
        for (String similarWord : alternatives) {
            int distance = WordDifferences.getDistance(word, similarWord);
            String dist = this.convert(distance);
            if (distance < 200) {
                closestWords.add(dist + similarWord);
                continue;
            }
            if (distance >= 400) continue;
            moreWords.add(dist + similarWord);
        }
        return closestWords.isEmpty() ? moreWords : closestWords;
    }

    private String convert(int distance) {
        String result = distance + "";
        if (distance < 10) {
            result = "00" + result;
        } else if (distance < 100) {
            result = "0" + result;
        }
        return result;
    }
}

