/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.sgml.Attribute;
import com.totalvalidator.utils.GeneralUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean xml = true;
    private boolean startTag = true;
    private boolean endTag = true;
    private boolean noEndTag = false;
    private String name;
    private Map<String, String> rules = new HashMap<String, String>();
    private List<String> orderedList = new ArrayList<String>();
    private List<String> unorderedList = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private List<String> specialIncludes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private boolean orList = false;
    private Attribute attr;
    public static final String ONE_OR_MORE = "+";
    public static final String NOT_ALLOWED = "-";
    public static final String SPECIAL_INCLUDE = "!";
    public static final String JUST_ONE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String LIST_GROUP = "LIST_GROUP";
    public static final String EMPTY = "empty";
    public static final String PCDATA = "#pcdata";
    private static final String COLON = " : ";
    private static final String DASH = "-";
    private static final String OH = "o";
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final String COMMA = ",";
    private static final String PIPE = "|";
    private Map<String, List<String>> listGroups = new HashMap<String, List<String>>();
    private Map<String, Boolean> orLists = new HashMap<String, Boolean>();

    public Element(String name, String value) throws ValidationException {
        this.name = name;
        StringTokenizer st = new StringTokenizer(value);
        String tagValue = st.nextToken();
        String content = JUST_ONE;
        if ("-".equals(tagValue) || OH.equals(tagValue)) {
            this.xml = false;
            this.startTag = "-".equals(tagValue);
            this.endTag = "-".equals(st.nextToken());
            content = st.nextToken();
            if (EMPTY.equals(content)) {
                this.noEndTag = true;
            }
        } else {
            content = tagValue;
        }
        if (!content.equals(EMPTY)) {
            if (content.charAt(0) != '(') {
                this.rules.put(content, JUST_ONE);
            } else {
                int endIndex;
                String newRule;
                boolean orListItem;
                ArrayList<String> listGroup;
                StringTokenizer st2;
                String extraRule;
                int index = value.indexOf(content) + 1;
                value = value.substring(index);
                index = value.indexOf(41);
                String group = value.substring(0, index);
                String rule = JUST_ONE;
                int i = index;
                do {
                    if (++i >= value.length()) continue;
                    rule = value.charAt(i) + JUST_ONE;
                } while (" ".equals(rule));
                if ("-".equals(rule)) {
                    rule = JUST_ONE;
                }
                if (ONE_OR_MORE.equals(rule) && i + 1 < value.length() && value.charAt(i + 1) == '(') {
                    rule = JUST_ONE;
                }
                boolean simple = true;
                if (value.indexOf(COMMA) != -1) {
                    simple = false;
                    boolean endOfList = false;
                    st = new StringTokenizer(value, COMMA);
                    while (st.hasMoreTokens()) {
                        content = st.nextToken().trim();
                        if (content.endsWith(")")) {
                            content = content.substring(0, content.length() - 1).trim();
                            endOfList = true;
                        }
                        String item = content;
                        if (content.charAt(0) == '(') {
                            endOfList = false;
                            index = content.indexOf(41);
                            if (index == -1) {
                                index = content.length();
                            }
                            group = content.substring(1, index);
                            extraRule = JUST_ONE;
                            if (index + 1 < content.length()) {
                                extraRule = JUST_ONE + content.charAt(index + 1);
                            }
                            st2 = new StringTokenizer(group, " |");
                            listGroup = new ArrayList<String>();
                            orListItem = false;
                            while (st2.hasMoreTokens()) {
                                content = st2.nextToken();
                                if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                                    newRule = JUST_ONE + content.charAt(content.length() - 1);
                                    content = content.substring(0, content.length() - 1);
                                    this.rules.put(content, newRule);
                                    orListItem = true;
                                } else {
                                    this.rules.put(content, extraRule);
                                }
                                listGroup.add(content);
                            }
                            item = LIST_GROUP + this.listGroups.size();
                            this.listGroups.put(item, listGroup);
                            this.orLists.put(item, orListItem);
                        } else if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                            extraRule = JUST_ONE + content.charAt(content.length() - 1);
                            content = content.substring(0, content.length() - 1);
                            this.rules.put(content, extraRule);
                            item = content;
                        } else {
                            this.rules.put(content, JUST_ONE);
                        }
                        this.orderedList.add(item);
                        if (!endOfList) continue;
                        break;
                    }
                } else if (value.indexOf(38) != -1) {
                    simple = false;
                    boolean endOfList = false;
                    st = new StringTokenizer(value, "& ");
                    while (st.hasMoreTokens()) {
                        content = st.nextToken().trim();
                        if (content.endsWith(")")) {
                            content = content.substring(0, content.length() - 1);
                            endOfList = true;
                        }
                        String item = content;
                        if (content.length() > 0 && content.charAt(0) == '(') {
                            endOfList = false;
                            index = content.indexOf(41);
                            if (index == -1) {
                                index = content.length();
                            }
                            group = content.substring(1, index);
                            extraRule = JUST_ONE;
                            if (index + 1 < content.length()) {
                                extraRule = JUST_ONE + content.charAt(index + 1);
                            }
                            st2 = new StringTokenizer(group, " |");
                            listGroup = new ArrayList();
                            orListItem = false;
                            while (st2.hasMoreTokens()) {
                                content = st2.nextToken();
                                if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                                    newRule = JUST_ONE + content.charAt(content.length() - 1);
                                    content = content.substring(0, content.length() - 1);
                                    this.rules.put(content, newRule);
                                    orListItem = true;
                                } else {
                                    this.rules.put(content, extraRule);
                                }
                                listGroup.add(content);
                            }
                            item = LIST_GROUP + this.listGroups.size();
                            this.listGroups.put(item, listGroup);
                            this.orLists.put(item, orListItem);
                        } else if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                            extraRule = JUST_ONE + content.charAt(content.length() - 1);
                            content = content.substring(0, content.length() - 1);
                            this.rules.put(content, extraRule);
                            item = content;
                        } else {
                            this.rules.put(content, JUST_ONE);
                        }
                        this.unorderedList.add(item);
                        if (!endOfList) continue;
                        break;
                    }
                } else if (value.charAt(0) == '(') {
                    simple = false;
                    if (PIPE.equals(rule)) {
                        simple = true;
                        value = value.substring(1, index) + value.substring(index + 1);
                        index = value.indexOf(41);
                        group = value.substring(0, index);
                        rule = JUST_ONE;
                        if (index + 1 < value.length()) {
                            rule = value.charAt(index + 1) + JUST_ONE;
                        }
                    } else {
                        index = value.indexOf(41);
                        group = value.substring(1, index);
                        st = new StringTokenizer(group, PIPE);
                        ArrayList<String> listGroup2 = new ArrayList<String>();
                        boolean orListItem2 = false;
                        while (st.hasMoreTokens()) {
                            content = st.nextToken().trim();
                            if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                                extraRule = JUST_ONE + content.charAt(content.length() - 1);
                                content = content.substring(0, content.length() - 1);
                                this.rules.put(content, extraRule);
                                orListItem2 = true;
                            } else {
                                this.rules.put(content, rule);
                            }
                            listGroup2.add(content);
                        }
                        String item = LIST_GROUP + this.listGroups.size();
                        this.listGroups.put(item, listGroup2);
                        this.orLists.put(item, orListItem2);
                        value = value.substring(index + 2);
                        st = new StringTokenizer(value, " |)");
                        while (st.hasMoreTokens()) {
                            content = st.nextToken().trim();
                            if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                                String extraRule2 = JUST_ONE + content.charAt(content.length() - 1);
                                content = content.substring(0, content.length() - 1);
                                this.rules.put(content, extraRule2);
                                this.orList = true;
                                continue;
                            }
                            this.rules.put(content, rule);
                        }
                    }
                }
                if (simple) {
                    st = new StringTokenizer(group, PIPE);
                    while (st.hasMoreTokens()) {
                        content = st.nextToken().trim();
                        if (content.endsWith(ONE_OR_MORE) || content.endsWith(ZERO_OR_ONE) || content.endsWith(ZERO_OR_MORE)) {
                            String extraRule3 = JUST_ONE + content.charAt(content.length() - 1);
                            content = content.substring(0, content.length() - 1);
                            this.rules.put(content, extraRule3);
                            this.orList = true;
                            continue;
                        }
                        this.rules.put(content, rule);
                    }
                }
                index = value.indexOf(content);
                if ((index = value.indexOf(40, index)) != -1 && (content = this.includesExcludes(group = (endIndex = value.indexOf(41, index)) != -1 ? value.substring(index - 2, endIndex + 1).trim() : value.substring(index - 2).trim())) != null) {
                    index = value.indexOf(content, index);
                    if ((index = value.indexOf(40, index)) != -1) {
                        endIndex = value.indexOf(41, index);
                        group = JUST_ONE;
                        group = endIndex != -1 ? value.substring(index - 2, endIndex + 1).trim() : value.substring(index - 2).trim();
                        content = this.includesExcludes(group);
                    }
                }
            }
        }
        GeneralUtils.LOGGER.info("Element: " + this.getName() + COLON + this.mustHaveStartTag() + COLON + this.mustHaveEndTag() + COLON + this.mustntHaveEndTag() + COLON + this.rules + COLON + this.orderedList + COLON + this.unorderedList + COLON + this.includes + COLON + this.specialIncludes + COLON + this.excludes);
    }

    private String includesExcludes(String group) throws ValidationException {
        StringTokenizer st = new StringTokenizer(group, " (|)");
        String extraRule = st.nextToken();
        String content = null;
        while (st.hasMoreTokens()) {
            content = st.nextToken();
            if (extraRule.equals(ONE_OR_MORE)) {
                this.rules.put(content, ZERO_OR_MORE);
                if (this.unorderedList.size() > 0) {
                    this.unorderedList.add(content);
                }
                this.includes.add(content);
                continue;
            }
            if (extraRule.equals(SPECIAL_INCLUDE)) {
                this.rules.put(content, ZERO_OR_MORE);
                if (this.unorderedList.size() > 0) {
                    this.unorderedList.add(content);
                }
                this.specialIncludes.add(content);
                continue;
            }
            if (extraRule.equals("-")) {
                this.rules.remove(content);
                if (this.unorderedList.size() > 0) {
                    this.unorderedList.remove(content);
                }
                for (String groupName : this.listGroups.keySet()) {
                    List<String> listGroup = this.listGroups.get(groupName);
                    if (!listGroup.contains(content)) continue;
                    listGroup.remove(content);
                }
                this.excludes.add(content);
                continue;
            }
            throw new ValidationException("Unknown rule in element " + this.name + COLON + extraRule);
        }
        return content;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean mustHaveEndTag() {
        return this.endTag;
    }

    public final boolean mustntHaveEndTag() {
        return this.noEndTag;
    }

    public final boolean mustHaveStartTag() {
        return this.startTag;
    }

    public void setAttr(Attribute attr) {
        this.attr = attr;
    }

    public List<String> getOrderedList() {
        return new ArrayList<String>(this.orderedList);
    }

    public String getRule(String item) {
        if (item == null) {
            return null;
        }
        String o = this.rules.get(item);
        return o != null ? o : null;
    }

    public List<String> getUnorderedList() {
        return new ArrayList<String>(this.unorderedList);
    }

    public boolean isXml() {
        return this.xml;
    }

    public Attribute getAttr() {
        return this.attr;
    }

    public Map<String, String> getRules() {
        return this.rules;
    }

    public List<String> getListGroup(String candidate) {
        return this.listGroups.get(candidate);
    }

    public Map<String, List<String>> getListGroups() {
        return this.listGroups;
    }

    public boolean isOrList() {
        return this.orList;
    }

    public boolean isOrList(String candidate) {
        return this.orLists.get(candidate);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getSpecialIncludes() {
        return this.specialIncludes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }
}

