/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.hotedit.edit;

import dk.hfalk.db.DBHotEditManager;
import dk.hfalk.db.DBHotSpotGroup;
import dk.hfalk.db.DBHotSpotItem;
import dk.hfalk.hotedit.edit.MarkToolAction;
import dk.hfalk.hotedit.gui.HotEditInternalAction;
import dk.hfalk.hotedit.gui.HotEditInternalFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JComponent;

public class JHotSpotCanvas
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Image image;
    int imageWidth = 0;
    int imageHeight = 0;
    private Image bufferImage = null;
    MediaTracker tracker = new MediaTracker(this);
    HotEditInternalFrame frame;
    PopupMenu popup = null;
    MenuItem m1;
    MenuItem m2;
    MenuItem m3;
    PopupMenu popupItem = null;
    MenuItem m1Item;
    MenuItem m2Item;
    int lastX = -1;
    int lastY = -1;
    int lastDX = -1;
    int lastDY = -1;
    boolean isRightMouseEvent;
    HotEditInternalAction controller;

    public JHotSpotCanvas(HotEditInternalAction hotEditInternalAction, Image image) {
        this.image = image;
        this.frame = hotEditInternalAction.iframe;
        this.controller = hotEditInternalAction;
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.enableEvents(32L);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean clearHotSpot() {
        this.lastX = -1;
        this.lastY = -1;
        this.update(this.getGraphics());
        return true;
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        if (DBHotEditManager.instance().state == 2) {
            return;
        }
        DBHotSpotItem dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected();
        switch (DBHotEditManager.instance().state) {
            case 4: {
                if (dBHotSpotItem == null || this.lastDX == -1 || this.lastDY == -1) break;
                dBHotSpotItem.translate(mouseEvent.getX() - this.lastDX, mouseEvent.getY() - this.lastDY);
                this.paint(graphics);
                this.frame.setTitle(this.controller.getTitle() + " " + dBHotSpotItem.asString());
                break;
            }
            case 8: {
                if (dBHotSpotItem == null) break;
                dBHotSpotItem.resize(mouseEvent.getX(), mouseEvent.getY());
                this.paint(graphics);
                this.frame.setTitle(this.controller.getTitle() + " " + dBHotSpotItem.asString());
                break;
            }
            default: {
                this.frame.setTitle(this.controller.getTitle());
            }
        }
        this.lastDX = mouseEvent.getX();
        this.lastDY = mouseEvent.getY();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (DBHotEditManager.instance().state == 2) {
            this.setCursor(new Cursor(1));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(0));
    }

    public void rightButton(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        if (DBHotEditManager.instance().state == 0) {
            dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected();
            if (this.popup == null) {
                this.m1 = new MenuItem(this.controller.getMainController().getResource("dk.hfalk.hotedit.edit.JHotSpotCanvasL", "JHotSpotCanvasL_MenuEditStartMarkPOLY"));
                MarkToolAction markToolAction = new MarkToolAction();
                markToolAction.setup(this.controller.getMainController(), "POLY");
                this.m1.addActionListener(markToolAction);
                this.m2 = new MenuItem(this.controller.getMainController().getResource("dk.hfalk.hotedit.edit.JHotSpotCanvasL", "JHotSpotCanvasL_MenuEditStartMarkRECT"));
                MarkToolAction markToolAction2 = new MarkToolAction();
                markToolAction2.setup(this.controller.getMainController(), "RECT");
                this.m2.addActionListener(markToolAction2);
                this.m3 = new MenuItem(this.controller.getMainController().getResource("dk.hfalk.hotedit.edit.JHotSpotCanvasL", "JHotSpotCanvasL_MenuEditStartMarkCIRCLE"));
                MarkToolAction markToolAction3 = new MarkToolAction();
                markToolAction3.setup(this.controller.getMainController(), "CIRCLE");
                this.m3.addActionListener(markToolAction3);
                MenuItem menuItem = new MenuItem(this.controller.getMainController().getResource("dk.hfalk.edit.hotedit.JHotSpotCanvasL", "JHotSpotCanvasL_MenuEditImageName"));
                MenuItem menuItem2 = new MenuItem(this.controller.getMainController().getResource("dk.hfalk.hotedit.edit.JHotSpotCanvasL", "JHotSpotCanvasL_MenuEditImageDescription"));
                this.popup = new PopupMenu();
                this.add(this.popup);
                this.popup.add(this.m1);
                this.popup.add(this.m2);
                this.popup.add(this.m3);
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (!this.isRightMouseEvent) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void paint(Graphics graphics) {
        this.setSize(this.image.getWidth(this), this.image.getHeight(this));
        if (this.bufferImage == null) {
            this.imageWidth = this.image.getWidth(this);
            this.imageHeight = this.image.getHeight(this);
            this.bufferImage = this.createImage(this.imageWidth, this.imageHeight);
        }
        Graphics graphics2 = this.bufferImage.getGraphics();
        graphics2.drawImage(this.image, 0, 0, this);
        Enumeration enumeration = this.frame.getController().hotSpotGroup.items().elements();
        while (enumeration.hasMoreElements()) {
            ((DBHotSpotItem)enumeration.nextElement()).paint(graphics2, true);
        }
        graphics.clipRect(0, 0, this.imageWidth, this.imageHeight);
        graphics.drawImage(this.bufferImage, 0, 0, this);
    }

    public void refresh() {
        this.paint(this.getGraphics());
    }

    public boolean saveHotSpot(String string) {
        String string2 = string.substring(0, string.length() - 4);
        this.saveHotSpotBinary(string2 + ".HSB");
        return true;
    }

    public boolean saveHotSpotBinary(String string) {
        return true;
    }

    public boolean setImage(Image image) {
        this.image = image;
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.update(this.getGraphics());
        return true;
    }

    public boolean showHotSpot(DBHotSpotItem dBHotSpotItem) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        this.paint(graphics);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        dBHotSpotItem.paint(graphics, true);
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        if (DBHotEditManager.instance().state == 2) {
            return;
        }
        dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected();
        if (dBHotSpotItem != null && dBHotSpotItem.isOnAnchor(mouseEvent.getX(), mouseEvent.getY())) {
            DBHotEditManager.instance().state = 8;
            return;
        }
        dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected();
        if (dBHotSpotItem != null && dBHotSpotItem.isOnBorder(mouseEvent.getX(), mouseEvent.getY())) {
            DBHotEditManager.instance().state = 4;
            this.lastDX = mouseEvent.getX();
            this.lastDY = mouseEvent.getY();
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (DBHotEditManager.instance().state == 2 && this.controller.currentItem.type().equals("POLY")) {
                int n = this.controller.currentItem.value() == null ? 0 : this.controller.currentItem.value().length;
                int[] nArray = new int[n + 2];
                if (n != 0) {
                    int[] nArray2 = this.controller.currentItem.value();
                    int n2 = 0;
                    while (n2 < nArray2.length) {
                        nArray[n2] = nArray2[n2];
                        ++n2;
                    }
                }
                nArray[n] = mouseEvent.getX();
                nArray[n + 1] = mouseEvent.getY();
                this.frame.endmarkToolFunc();
                return;
            }
            this.rightButton(mouseEvent);
            return;
        }
        if (DBHotEditManager.instance().state == 4 || DBHotEditManager.instance().state == 8) {
            DBHotEditManager.instance().state = 0;
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        DBHotSpotGroup dBHotSpotGroup = this.controller.hotSpotGroup;
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        this.isRightMouseEvent = false;
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        if (DBHotEditManager.instance().state == 2) {
            int n = this.controller.currentItem.value() == null ? 0 : this.controller.currentItem.value().length;
            int[] nArray = new int[n + 2];
            if (n != 0) {
                int[] nArray2 = this.controller.currentItem.value();
                int n2 = 0;
                while (n2 < nArray2.length) {
                    nArray[n2] = nArray2[n2];
                    ++n2;
                }
            }
            nArray[n] = mouseEvent.getX();
            nArray[n + 1] = mouseEvent.getY();
            if (this.controller.currentItem.type().equals("RECT") && nArray.length == 4) {
                this.isRightMouseEvent = true;
                this.controller.currentItem.setValue(nArray);
                this.frame.endmarkToolFunc();
                return;
            }
            if (this.controller.currentItem.type().equals("CIRCLE") && nArray.length == 4) {
                this.isRightMouseEvent = true;
                this.controller.currentItem.setValue(nArray);
                this.frame.endmarkToolFunc();
                return;
            }
            this.controller.currentItem.setValue(nArray);
            return;
        }
        dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected();
        if (dBHotSpotItem != null) {
            dBHotSpotItem.setSelected(false);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paint(graphics);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            dBHotSpotItem.paint(graphics, false);
        }
        if ((dBHotSpotItem = this.frame.getController().hotSpotGroup.select(mouseEvent.getX(), mouseEvent.getY())) != null) {
            dBHotSpotItem.setSelected(true);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            dBHotSpotItem.paint(graphics, false);
        }
        if ((dBHotSpotItem = this.frame.getController().hotSpotGroup.getSelected()) != null) {
            this.frame.setTitle(this.controller.getTitle() + " " + dBHotSpotItem.asString());
        } else {
            this.frame.setTitle(this.controller.getTitle());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (DBHotEditManager.instance().state == 0) {
            return;
        }
        if (DBHotEditManager.instance().state == 2) {
            int n;
            String string;
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = this.getVisibleRect();
            if (this.controller.currentItem.type().equals("POLY")) {
                String string2 = " - POLY XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                this.frame.setTitle(this.controller.getTitle() + " " + string2);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.controller.currentItem.paint(graphics, false);
                    this.controller.currentItem.setSelected(true);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.drawLine(this.lastX, this.lastY, mouseEvent.getX(), mouseEvent.getY());
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, mouseEvent.getY() - 2, 5, 5);
                }
                return;
            }
            if (this.controller.currentItem.type().equals("RECT")) {
                string = " - RECT XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                this.frame.setTitle(this.controller.getTitle() + " " + string);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    n = Math.min(this.lastX, mouseEvent.getX());
                    int n2 = Math.min(this.lastY, mouseEvent.getY());
                    int n3 = Math.abs(mouseEvent.getX() - this.lastX);
                    int n4 = Math.abs(mouseEvent.getY() - this.lastY);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.drawRect(n, n2, n3, n4);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, mouseEvent.getY() - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, mouseEvent.getY() - 2, 5, 5);
                }
            }
            if (this.controller.currentItem.type().equals("CIRCLE")) {
                string = " - CIRCLE XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                this.frame.setTitle(this.controller.getTitle() + " " + string);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    n = (int)Math.round(Math.sqrt(Math.pow(mouseEvent.getX() - this.lastX, 2.0) + Math.pow(mouseEvent.getY() - this.lastY, 2.0)));
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.getGraphics().drawArc(this.lastX - n, this.lastY - n, n * 2, n * 2, 0, 360);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY + n - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - n - 2, 5, 5);
                    graphics.fillRect(this.lastX + n - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - n - 2, this.lastY - 2, 5, 5);
                }
            }
        }
        if (DBHotEditManager.instance().state == 16) {
            DBHotEditManager.instance().state = 2;
            this.clearHotSpot();
            this.setCursor(new Cursor(1));
        }
    }
}

