/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.db;

import dk.hfalk.hotedit.util.PropertyItem;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

public class DBHotSpotItem
extends Observable
implements Serializable,
Cloneable {
    protected String type;
    protected String name = "";
    protected int[] value;
    protected String description = "";
    protected boolean isVisible;
    protected boolean isSelected;
    private int anchorNumber = 0;
    private long uid;
    private Hashtable attribute;

    public DBHotSpotItem() {
    }

    public DBHotSpotItem(String string, String string2, int[] nArray, String string3, boolean bl) {
        this.type = string;
        this.name = string2;
        this.value = nArray;
        this.description = string3;
        this.isVisible = bl;
        this.isSelected = false;
    }

    public String asString() {
        String string = null;
        int[] nArray = this.value();
        if (this.type.equals("RECT")) {
            string = " - RECT (" + String.valueOf(nArray[0]) + "," + String.valueOf(nArray[1]) + " ; " + String.valueOf(nArray[2]) + "," + String.valueOf(nArray[3]) + " )";
        }
        if (this.type.equals("POLY")) {
            string = " - POLY (" + String.valueOf(nArray[0]) + "," + String.valueOf(nArray[1]) + " ;...; " + String.valueOf(nArray[nArray.length - 2]) + "," + String.valueOf(nArray[nArray.length - 1]) + " )";
        }
        if (this.type.equals("CIRCLE")) {
            int n = (int)Math.round(Math.sqrt(Math.pow(this.value[2] - this.value[0], 2.0) + Math.pow(this.value[3] - this.value[1], 2.0)));
            string = " - CIRCLE (" + String.valueOf(nArray[0]) + "," + String.valueOf(nArray[1]) + " ; radius=" + n + " )";
        }
        return string;
    }

    public String description() {
        return this.description;
    }

    protected void drawAnchor(Graphics graphics, int n, int n2) {
        graphics.fillRect(n - 2, n2 - 2, 5, 5);
    }

    public boolean isOnAnchor(int n, int n2) {
        int n3;
        if (this.type.equals("RECT")) {
            if (Math.abs(this.value[0] - n) <= 4 && Math.abs(this.value[1] - n2) <= 4) {
                this.anchorNumber = 1;
                return true;
            }
            if (Math.abs(this.value[0] - n) <= 4 && Math.abs(this.value[3] - n2) <= 4) {
                this.anchorNumber = 2;
                return true;
            }
            if (Math.abs(this.value[2] - n) <= 4 && Math.abs(this.value[1] - n2) <= 4) {
                this.anchorNumber = 3;
                return true;
            }
            if (Math.abs(this.value[2] - n) <= 4 && Math.abs(this.value[3] - n2) <= 4) {
                this.anchorNumber = 4;
                return true;
            }
        }
        if (this.type.equals("CIRCLE")) {
            n3 = (int)Math.round(Math.sqrt(Math.pow(this.value[2] - this.value[0], 2.0) + Math.pow(this.value[3] - this.value[1], 2.0)));
            if (Math.abs(this.value[0] - n3 - n) <= 4 && Math.abs(this.value[1] - n2) <= 4) {
                this.anchorNumber = 1;
                return true;
            }
            if (Math.abs(this.value[0] + n3 - n) <= 4 && Math.abs(this.value[1] - n2) <= 4) {
                this.anchorNumber = 2;
                return true;
            }
            if (Math.abs(this.value[0] - n) <= 4 && Math.abs(this.value[1] - n3 - n2) <= 4) {
                this.anchorNumber = 3;
                return true;
            }
            if (Math.abs(this.value[0] - n) <= 4 && Math.abs(this.value[1] + n3 - n2) <= 4) {
                this.anchorNumber = 4;
                return true;
            }
        }
        if (this.type.equals("POLY")) {
            n3 = 0;
            while (n3 < this.value.length) {
                if (Math.abs(this.value[n3] - n) <= 4 && Math.abs(this.value[n3 + 1] - n2) <= 4) {
                    this.anchorNumber = (n3 + 2) / 2;
                    return true;
                }
                n3 += 2;
            }
        }
        return false;
    }

    public boolean isOnBorder(int n, int n2) {
        if (this.type.equals("RECT")) {
            return this.isOnLine(this.value[0], this.value[1], this.value[2], this.value[1], n, n2) || this.isOnLine(this.value[0], this.value[3], this.value[0], this.value[1], n, n2) || this.isOnLine(this.value[2], this.value[1], this.value[2], this.value[3], n, n2) || this.isOnLine(this.value[2], this.value[3], this.value[0], this.value[3], n, n2);
        }
        if (this.type.equals("CIRCLE")) {
            int n3 = (int)Math.round(Math.sqrt(Math.pow(this.value[2] - this.value[0], 2.0) + Math.pow(this.value[3] - this.value[1], 2.0)));
            int n4 = (int)Math.round(Math.sqrt(Math.pow(n - this.value[0], 2.0) + Math.pow(n2 - this.value[1], 2.0)));
            return Math.abs(0) <= 2 && Math.abs(n4 - n3) <= 2;
        }
        if (this.type.equals("POLY")) {
            int n5 = 0;
            while (n5 < this.value.length - 2) {
                if (this.isOnLine(this.value[n5], this.value[n5 + 1], this.value[n5 + 2], this.value[n5 + 3], n, n2)) {
                    return true;
                }
                n5 += 2;
            }
            return this.isOnLine(this.value[this.value.length - 2], this.value[this.value.length - 1], this.value[0], this.value[1], n, n2);
        }
        return false;
    }

    protected boolean isOnLine(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((n4 - 2 <= n6 && n6 <= n2 + 2 || n2 - 2 <= n6 && n6 <= n4 + 2) && (n - 2 <= n5 && n5 <= n3 + 2 || n3 - 2 <= n5 && n5 <= n + 2)) {
            if (n2 == n4 || n == n3) {
                return true;
            }
            double d = (double)(n4 - n2) / (double)(n3 - n);
            double d2 = (double)(n6 - n2) / d + (double)n - (double)n5;
            double d3 = d * (double)(n5 - n) + (double)n2 - (double)n6;
            if ((int)Math.abs(d2 * d3 / Math.sqrt(d2 * d2 + d3 * d3)) <= 2) {
                return true;
            }
            if (d2 == 0.0 || d3 == 0.0) {
                return true;
            }
        }
        return false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String name() {
        return this.name;
    }

    public void paint(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        if (!this.isVisible) {
            return;
        }
        if (this.type.equals("POLY")) {
            if (this.value == null) {
                return;
            }
            if (this.value.length == 0 || this.value.length == 2) {
                return;
            }
            if (this.value.length == 4) {
                graphics.drawLine(this.value[0], this.value[1], this.value[2], this.value[3]);
                this.drawAnchor(graphics, this.value[0], this.value[1]);
                this.drawAnchor(graphics, this.value[2], this.value[3]);
                return;
            }
            Polygon polygon = new Polygon();
            n3 = 0;
            while (n3 < this.value.length) {
                n2 = this.value[n3];
                n = this.value[n3 + 1];
                polygon.addPoint(n2, n);
                n3 += 2;
            }
            graphics.drawPolygon(polygon);
            if (this.isSelected()) {
                n2 = 0;
                while (n2 < this.value.length) {
                    this.drawAnchor(graphics, this.value[n2], this.value[n2 + 1]);
                    n2 += 2;
                }
            }
            polygon = null;
        }
        if (this.type.equals("RECT")) {
            if (this.value == null) {
                return;
            }
            if (this.value.length == 0 || this.value.length == 2) {
                return;
            }
            if (this.value.length == 4) {
                int n4 = Math.min(this.value[0], this.value[2]);
                n3 = Math.min(this.value[1], this.value[3]);
                n2 = Math.abs(this.value[2] - this.value[0]);
                n = Math.abs(this.value[3] - this.value[1]);
                graphics.drawRect(n4, n3, n2, n);
                if (this.isSelected()) {
                    this.drawAnchor(graphics, this.value[0], this.value[1]);
                    this.drawAnchor(graphics, this.value[2], this.value[1]);
                    this.drawAnchor(graphics, this.value[0], this.value[3]);
                    this.drawAnchor(graphics, this.value[2], this.value[3]);
                }
                return;
            }
        }
        if (this.type.equals("CIRCLE")) {
            if (this.value == null) {
                return;
            }
            if (this.value.length == 0 || this.value.length == 2) {
                return;
            }
            if (this.value.length == 4) {
                int n5 = (int)Math.round(Math.sqrt(Math.pow(this.value[2] - this.value[0], 2.0) + Math.pow(this.value[3] - this.value[1], 2.0)));
                graphics.drawArc(this.value[0] - n5, this.value[1] - n5, n5 * 2, n5 * 2, 0, 360);
                if (this.isSelected()) {
                    this.drawAnchor(graphics, this.value[0], this.value[1] + n5);
                    this.drawAnchor(graphics, this.value[0], this.value[1] - n5);
                    this.drawAnchor(graphics, this.value[0] + n5, this.value[1]);
                    this.drawAnchor(graphics, this.value[0] - n5, this.value[1]);
                }
                return;
            }
        }
    }

    public void refresh() {
        this.setChanged();
        this.notifyObservers();
    }

    public void resize(int n, int n2) {
        if (this.type.equals("RECT")) {
            switch (this.anchorNumber) {
                case 1: {
                    this.value[0] = n;
                    this.value[1] = n2;
                    break;
                }
                case 2: {
                    this.value[0] = n;
                    this.value[3] = n2;
                    break;
                }
                case 3: {
                    this.value[2] = n;
                    this.value[1] = n2;
                    break;
                }
                case 4: {
                    this.value[2] = n;
                    this.value[3] = n2;
                    break;
                }
            }
        }
        if (this.type.equals("POLY")) {
            this.value[(this.anchorNumber - 1) * 2] = n;
            this.value[(this.anchorNumber - 1) * 2 + 1] = n2;
        }
        if (this.type.equals("CIRCLE")) {
            this.value[2] = n;
            this.value[3] = n2;
        }
    }

    public void setDescription(String string) {
        if (this.description == null) {
            this.description = new String();
        }
        if (!this.description.equals(string)) {
            this.description = string;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void setName(String string) {
        if (this.name == null) {
            this.name = new String();
        }
        if (!this.name.equals(string)) {
            this.name = string;
        }
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public void setType(String string) {
        if (this.type == null) {
            this.type = new String();
        }
        if (!this.type.equals(string)) {
            this.type = string;
        }
    }

    public void setValue(int[] nArray) {
        this.value = nArray;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        this.setChanged();
        this.notifyObservers();
    }

    public void translate(int n, int n2) {
        if (this.type.equals("RECT")) {
            this.value[0] = this.value[0] + n;
            this.value[1] = this.value[1] + n2;
            this.value[2] = this.value[2] + n;
            this.value[3] = this.value[3] + n2;
        }
        if (this.type.equals("POLY")) {
            int n3 = 0;
            while (n3 < this.value.length) {
                int n4 = n3;
                this.value[n4] = this.value[n4] + n;
                int n5 = n3 + 1;
                this.value[n5] = this.value[n5] + n2;
                n3 += 2;
            }
        }
        if (this.type.equals("CIRCLE")) {
            this.value[0] = this.value[0] + n;
            this.value[1] = this.value[1] + n2;
            this.value[2] = this.value[2] + n;
            this.value[3] = this.value[3] + n2;
        }
    }

    public String type() {
        return this.type;
    }

    public int[] value() {
        return this.value;
    }

    public Hashtable getAttributes() {
        if (this.attribute == null) {
            this.attribute = new Hashtable();
        }
        return this.attribute;
    }

    public void addAttribute(PropertyItem propertyItem) {
        if (this.attribute == null) {
            this.attribute = new Hashtable();
        }
        this.attribute.put(propertyItem.getName(), propertyItem);
    }

    public void updateAttribute(String string, String string2) {
        if (this.attribute == null) {
            this.attribute = new Hashtable();
        }
        Enumeration enumeration = this.attribute.elements();
        while (enumeration.hasMoreElements()) {
            PropertyItem propertyItem = (PropertyItem)enumeration.nextElement();
            if (!propertyItem.getName().equals(string)) continue;
            propertyItem.setValue(string2);
            return;
        }
    }

    public Object getAttribute(String string) {
        if (this.attribute == null) {
            return "";
        }
        Enumeration enumeration = this.attribute.elements();
        while (enumeration.hasMoreElements()) {
            PropertyItem propertyItem = (PropertyItem)enumeration.nextElement();
            if (!propertyItem.getName().equals(string)) continue;
            return propertyItem.getValue();
        }
        return "";
    }

    public boolean hasAttribute(String string, String string2) {
        if (this.attribute == null) {
            this.attribute = new Hashtable();
            return false;
        }
        Enumeration enumeration = this.attribute.elements();
        while (enumeration.hasMoreElements()) {
            PropertyItem propertyItem = (PropertyItem)enumeration.nextElement();
            if (!propertyItem.getName().equals(string2) || !propertyItem.getPlugin().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setUID(long l) {
        this.uid = l;
    }

    public long getUID() {
        return this.uid;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("Cannot clone DBHotSpotItem!");
        }
        return object;
    }
}

