/*
 * Decompiled with CFR 0.152.
 */
package dk.hfalk.gui;

import dk.hfalk.HotEditAction;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class FilePreviewer
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File f = null;
    HotEditAction controller = null;

    public FilePreviewer(HotEditAction hotEditAction, JFileChooser jFileChooser) {
        this.controller = hotEditAction;
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    public FilePreviewer(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        ImageIcon imageIcon = this.f != null ? new ImageIcon(this.f.getPath()) : this.controller.getImage("nographics");
        if (imageIcon.getIconWidth() > 90) {
            try {
                this.thumbnail = new ImageIcon(imageIcon.getImage().getScaledInstance(90, 90, 2));
            }
            catch (Exception exception) {
                System.out.println("Exception");
            }
        } else {
            this.thumbnail = imageIcon;
        }
    }

    public void paint(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "SelectedFileChangedProperty") {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof File) {
                this.f = (File)object;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            } else {
                this.f = null;
            }
        }
    }
}

