/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.WordTokenizer;
import java.text.BreakIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.html.HTMLDocument;

public class DocumentWordTokenizer
implements WordTokenizer {
    private int currentWordPos = 0;
    private int currentWordEnd = 0;
    private int nextWordPos = -1;
    private Document document;
    private Segment text;
    private int wordCount = 0;
    private boolean moreTokens = true;
    private boolean first = true;
    private BreakIterator sentanceIterator;
    private boolean startsSentance = true;

    public DocumentWordTokenizer(Document document) {
        this.document = document;
        this.text = new Segment();
        this.sentanceIterator = BreakIterator.getSentenceInstance();
        try {
            document.getText(0, document.getLength(), this.text);
            this.sentanceIterator.setText(this.text);
            this.currentWordPos = DocumentWordTokenizer.getNextWordStart(this.text, 0);
            if (this.currentWordPos != -1) {
                this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
                this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
            } else {
                this.moreTokens = false;
            }
        }
        catch (BadLocationException badLocationException) {
            this.moreTokens = false;
        }
    }

    private static int getNextWordStart(Segment segment, int n) {
        if (n <= segment.getEndIndex()) {
            char c = segment.setIndex(n);
            while (c != '\uffff') {
                if (Character.isLetterOrDigit(c)) {
                    return segment.getIndex();
                }
                c = segment.next();
            }
        }
        return -1;
    }

    private static int getNextWordEnd(Segment segment, int n) {
        char c = segment.setIndex(n);
        while (c != '\uffff') {
            if (!Character.isLetterOrDigit(c)) {
                return segment.getIndex();
            }
            c = segment.next();
        }
        return segment.getEndIndex();
    }

    @Override
    public boolean hasMoreWords() {
        return this.moreTokens;
    }

    @Override
    public int getCurrentWordPosition() {
        return this.currentWordPos;
    }

    @Override
    public int getCurrentWordEnd() {
        return this.currentWordEnd;
    }

    @Override
    public String nextWord() {
        if (!this.first) {
            this.currentWordPos = this.nextWordPos;
            this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
            this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd + 1);
            int n = this.sentanceIterator.current();
            if (n == this.currentWordPos) {
                this.startsSentance = true;
            } else {
                this.startsSentance = false;
                if (this.currentWordEnd > n) {
                    this.sentanceIterator.next();
                }
            }
        }
        String string = null;
        try {
            string = this.document.getText(this.currentWordPos, this.currentWordEnd - this.currentWordPos);
        }
        catch (BadLocationException badLocationException) {
            this.moreTokens = false;
        }
        ++this.wordCount;
        this.first = false;
        if (this.nextWordPos == -1) {
            this.moreTokens = false;
        }
        return string;
    }

    @Override
    public int getCurrentWordCount() {
        return this.wordCount;
    }

    @Override
    public void replaceWord(String string) {
        if (this.currentWordPos != -1) {
            try {
                Element element = ((HTMLDocument)this.document).getCharacterElement(this.currentWordPos);
                AttributeSet attributeSet = element.getAttributes();
                this.document.remove(this.currentWordPos, this.currentWordEnd - this.currentWordPos);
                this.document.insertString(this.currentWordPos, string, attributeSet);
                this.document.getText(0, this.document.getLength(), this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException.getMessage());
            }
            this.first = true;
            this.currentWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordPos + string.length());
            if (this.currentWordPos != -1) {
                this.currentWordEnd = DocumentWordTokenizer.getNextWordEnd(this.text, this.currentWordPos);
                this.nextWordPos = DocumentWordTokenizer.getNextWordStart(this.text, this.currentWordEnd);
                this.sentanceIterator.setText(this.text);
                this.sentanceIterator.following(this.currentWordPos);
            } else {
                this.moreTokens = false;
            }
        }
    }

    @Override
    public String getContext() {
        return this.text.toString();
    }

    @Override
    public boolean isNewSentance() {
        return this.startsSentance;
    }
}

