/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.Folder;
import sunw.hotjava.ui.ListContainer;

public class ListItem
implements Cloneable {
    Color color;
    Component canvas;
    boolean grabbed = false;
    Point grabbedAt;
    Rectangle boundingBox;
    int icon_width = 20;
    int icon_height = 20;
    int text_width = -1;
    int text_height = -1;
    public Point location;
    ListContainer myContainer;
    boolean selected = false;
    String text;

    public ListItem() {
    }

    public ListItem(ListContainer listContainer, String string) {
        this.text = string;
        this.myContainer = listContainer;
        this.location = new Point(0, 0);
    }

    public final Point getPoint() {
        return this.location;
    }

    public void mouseDownAction(int n, int n2) {
        this.location = new Point(n, n2);
    }

    public boolean doubleClick(int n, int n2) {
        return false;
    }

    public void mouseDragAction(int n, int n2) {
        this.location = new Point(n, n2);
        int n3 = this.icon_width + this.text_width;
        int n4 = this.text_height < this.icon_height ? this.icon_height : this.text_height;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = rectangle.union(this.boundingBox);
        this.canvas.repaint(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
        this.boundingBox = rectangle;
    }

    public void mouseUpAction(int n, int n2) {
        this.mouseDragAction(n, n2);
    }

    public void move(Point point, int n, int n2) {
        if (this.boundingBox == null) {
            return;
        }
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        Point point2 = this.location;
        point2.x += n3;
        point2.y += n4;
        int n5 = this.icon_width + this.text_width;
        int n6 = this.text_height < this.icon_height ? this.icon_height : this.text_height;
        Rectangle rectangle = new Rectangle(point2.x, point2.y, n5, n6);
        point.x = n;
        point.y = n2;
        Rectangle rectangle2 = rectangle.union(this.boundingBox);
        this.canvas.repaint(rectangle2.x, rectangle2.y, rectangle2.width + 1, rectangle2.height + 1);
        this.boundingBox = rectangle;
    }

    public void drawItem(Graphics graphics) {
        Point point = this.location;
        int n = point.x;
        int n2 = point.y;
        this.showBackground(graphics);
        graphics.setColor(this.color);
        graphics.fillRect(n, n2, this.icon_width, this.icon_height);
        graphics.setColor(Color.black);
        graphics.drawString(this.text, n + this.icon_width, n2 + this.icon_width);
        graphics.drawRect(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width - 1, this.boundingBox.height - 1);
    }

    protected void showBackground(Graphics graphics) {
        if (this.selected || this.grabbed()) {
            HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
            String string = "hotlistframe.selection.color";
            graphics.setColor(hJBProperties.getColor(string, Color.yellow));
            graphics.fillRect(this.boundingBox.x + this.icon_width + 1, this.boundingBox.y, this.boundingBox.width - this.icon_width + 1, this.boundingBox.height);
        }
    }

    public void drawItemOnCanvas(Graphics graphics) {
        this.drawItem(graphics);
    }

    public void drawChildren(Graphics graphics) {
        this.drawItem(graphics);
    }

    public void setBoundingBox(Graphics graphics) {
        int n;
        Point point = this.location;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.text_height = fontMetrics.getHeight();
        this.text_width = fontMetrics.stringWidth(this.text);
        int n2 = point.x;
        int n3 = point.y;
        int n4 = this.icon_width + this.text_width;
        if (this.text_height < this.icon_height) {
            n = this.icon_height + fontMetrics.getDescent();
            n3 += this.icon_height - this.text_height;
        } else {
            n = this.text_height;
        }
        this.boundingBox = new Rectangle(n2, n3, n4, n);
    }

    public void setParentListContainer(ListContainer listContainer) {
        this.myContainer = listContainer;
    }

    public ListContainer getParentListContainer() {
        return this.myContainer;
    }

    public void removeMyself() {
        this.myContainer.removeItem(this);
        if (this.myContainer instanceof Folder) {
            Folder folder = (Folder)this.myContainer;
            folder.total_contents = folder.isTopList() ? folder.recalculatePositions(true) : folder.recalculatePositions();
        }
        this.myContainer.getCanvas().repaint(50L);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void toggleSelected() {
        this.selected = !this.selected;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setCanvas(Component component) {
        this.canvas = component;
    }

    public Component getCanvas() {
        return this.canvas;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void mouseDown(int n, int n2) {
        this.mouseDownAction(n, n2);
    }

    public void mouseDrag(int n, int n2) {
        if (this.grabbed) {
            this.move(this.grabbedAt, n, n2);
            return;
        }
        this.mouseDragAction(n, n2);
    }

    public void mouseUp(int n, int n2) {
        if (!this.grabbed) {
            this.mouseUpAction(n, n2);
        }
    }

    public final boolean grabbed() {
        return this.grabbed;
    }

    public Point grabbedPoint() {
        if (this.grabbed) {
            return this.grabbedAt;
        }
        return null;
    }

    public void grab(int n, int n2) {
        this.grabbedAt = new Point(n, n2);
        this.grabbed = true;
        this.canvas.repaint();
    }

    public void release() {
        this.grabbed = false;
    }

    public boolean inside(int n, int n2) {
        if (this.boundingBox != null) {
            return this.boundingBox.inside(n, n2);
        }
        return false;
    }

    public boolean insideOnDrag(int n, int n2) {
        if (this.boundingBox == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle(this.boundingBox);
        rectangle.width = this.getCanvas().size().width;
        rectangle.x = 0;
        return rectangle.inside(n, n2);
    }

    public boolean intersects(Point point) {
        if (this.boundingBox == null) {
            return false;
        }
        int n = point.x;
        int n2 = point.y;
        return this.boundingBox.inside(n, n2);
    }

    public boolean intersectsOnDrop(Point point) {
        if (this.boundingBox == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle(this.boundingBox);
        rectangle.width = this.getCanvas().size().width;
        rectangle.x = 0;
        int n = point.x;
        int n2 = point.y;
        return rectangle.inside(n, n2);
    }

    public final Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public int getHeight() {
        return this.icon_height;
    }

    public int getWidth() {
        return this.icon_width;
    }

    public String getTitle() {
        return this.text;
    }

    public void setTitle(String string) {
        this.text = string;
    }
}

