/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;

class InstrumentPanelControlsLayout
extends GridBagLayout {
    int toolbarAlignment;
    Vector toolbarList = new Vector();
    Component spacer;
    Component monitor;

    public InstrumentPanelControlsLayout() {
        this(10);
    }

    public InstrumentPanelControlsLayout(int n) {
        this.toolbarAlignment = n;
    }

    public InstrumentPanelControlsLayout(String string) {
        this(10);
        if ("left".equalsIgnoreCase(string)) {
            this.toolbarAlignment = 17;
            return;
        }
        if ("right".equalsIgnoreCase(string)) {
            this.toolbarAlignment = 13;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        String string = (String)object;
        if ("Toolbar".equalsIgnoreCase(string)) {
            this.addToolbar(component);
        } else if ("ActivityMonitor".equalsIgnoreCase(string)) {
            this.monitor = component;
        } else if ("Spacer".equalsIgnoreCase(string)) {
            this.spacer = component;
            this.spacer.setVisible(false);
        }
        this.resetConstraints();
    }

    public void removeLayoutComponent(Component component) {
        if (this.toolbarList.contains(component)) {
            this.removeToolbar(component);
        } else if (component == this.monitor) {
            this.monitor = null;
        }
        this.resetConstraints();
    }

    private void clearConstraints() {
        this.comptable.clear();
    }

    private void addToolbar(Component component) {
        this.toolbarList.addElement(component);
    }

    private void removeToolbar(Component component) {
        this.toolbarList.removeElement(component);
    }

    public boolean haveToolbars() {
        return this.toolbarList.size() > 0;
    }

    public boolean hasActivityMonitor() {
        return this.monitor != null;
    }

    public Component getActivityMonitor() {
        return this.monitor;
    }

    protected void resetConstraints() {
        this.clearConstraints();
        int n = this.toolbarList.size();
        if (n > 0) {
            if (this.monitor != null) {
                this.constrainToolsAndMonitor();
                return;
            }
            this.constrainTools();
            return;
        }
        if (this.monitor != null) {
            this.constrainMonitor();
        }
    }

    private void constrainToolsAndMonitor() {
        this.monitor.getPreferredSize();
        this.spacer.setVisible(false);
        this.constrainToolbars(this.toolbarList.size(), 1, 0, 1, this.toolbarAlignment, 0, 1.0);
        this.constrain(this.monitor, this.toolbarList.size() + 1, 0, 1, 13, 0);
    }

    private void constrainTools() {
        this.spacer.setVisible(false);
        this.constrainToolbars(this.toolbarList.size(), 0, 0, 0, this.toolbarAlignment, 0, 1.0);
    }

    private void constrainMonitor() {
        Dimension dimension = this.monitor.getPreferredSize();
        this.spacer.setSize(dimension.width, dimension.height);
        this.constrain(this.spacer, 0, 0, 1, 17, 2);
        this.spacer.setVisible(true);
        this.constrain(this.monitor, 2, 0, 1, 13, 0, 1.0);
    }

    private void constrainToolbars(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        if (n > 1) {
            int n7 = 0;
            while (n7 < n - 1) {
                this.constrain((Component)this.toolbarList.elementAt(n7), n2 + n7, n3, 1, n5, n6, d);
                ++n7;
            }
            this.constrain((Component)this.toolbarList.elementAt(n - 1), n2 + n - 1, n3, n4, n5, n6, d);
            return;
        }
        this.constrain((Component)this.toolbarList.elementAt(0), n2, n3, n4, n5, n6, d);
    }

    private void constrain(Component component, int n, int n2, int n3, int n4, int n5) {
        this.constrain(component, n, n2, n3, n4, n5, 0.0);
    }

    private void constrain(Component component, int n, int n2, int n3, int n4, int n5, double d) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.weightx = d;
        this.setConstraints(component, gridBagConstraints);
    }
}

