/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sunw.hotjava.doc.BulletTagItem;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.tags.UL;
import sunw.html.Attributes;

public class LI
extends BulletTagItem {
    private Document doc;
    private static final int xOffset = 2;
    private static final int numericRightOffset = 4;
    static final int DISC_IMG_INDEX = 0;
    static final int CIRCLE_IMG_INDEX = 1;
    static final int SQUARE_IMG_INDEX = 2;
    private static int[] bulletOrder;
    private static String[] bulletNames;
    private static final char[][] romanChars;

    public synchronized void init(Document document) {
        this.doc = document;
    }

    private int getItemNumber(DocStyle docStyle) {
        int n = 0;
        int n2 = docStyle.next.tag.getIndex() + 1;
        while (n2 <= docStyle.tag.getIndex()) {
            DocItem docItem = docStyle.doc.getItem(n2);
            TagItem tagItem = docItem.getTag(docStyle.doc);
            if (tagItem != null && tagItem.getName().equals("li")) {
                ++n;
            }
            if (docItem.getOffset() > 0) {
                n2 += docItem.getOffset();
            }
            ++n2;
        }
        return n;
    }

    static int bulletNameToType(String string) {
        int n = 0;
        while (n < bulletNames.length) {
            if (string.equalsIgnoreCase(bulletNames[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    static int nextBulletType(int n) {
        int n2 = 0;
        while (n2 < bulletOrder.length - 1) {
            if (bulletOrder[n2] == n) {
                return bulletOrder[n2 + 1];
            }
            ++n2;
        }
        return 0;
    }

    public boolean formatStartTag(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (!super.formatStartTag(formatter, formatState, formatState2)) {
            int n = this.getIndex();
            if (n <= this.doc.nitems && this.doc.getTagName(this.doc.getItem(n + 1)).equals("pre")) {
                formatState.state = 0;
            }
            return false;
        }
        return true;
    }

    public int paintBullet(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        DocStyle docStyle = formatter.displayStyle;
        int n3 = this.style.left;
        if (docStyle == null || docStyle.next == null || docStyle.next.tag == null) {
            return n3;
        }
        TagItem tagItem = docStyle.next.tag;
        String string = tagItem.getName();
        if ("ul".equals(string) || "menu".equals(string) || "dir".equals(string)) {
            this.paintUnorderedItem(formatter, graphics, docStyle, n + n3, n2, docLine);
        } else if ("ol".equals(string)) {
            this.paintOrderedItem(graphics, docStyle, n, n2, docLine);
        }
        return n3;
    }

    private void paintUnorderedItem(Formatter formatter, Graphics graphics, DocStyle docStyle, int n, int n2, DocLine docLine) {
        HJBProperties.getHJBProperties("beanPropertiesKey");
        int n3 = docStyle.ascent;
        n -= n3 + 2;
        Color color = formatter.getFormatterBackgroundColor();
        if (n3 >= 0) {
            formatter.getFormatterBackgroundColor();
            Graphics graphics2 = formatter.getHackGraphics();
            if (graphics2 != null) {
                graphics = graphics2;
            }
            int n4 = n + 2;
            int n5 = n2 + 2 + docLine.baseline - n3;
            this.drawBullet(graphics, color, docStyle, n4, n5, n3 - 6);
        }
    }

    private void drawBullet(Graphics graphics, Color color, DocStyle docStyle, int n, int n2, int n3) {
        TagItem tagItem = docStyle.next.tag;
        int n4 = 0;
        Color color2 = graphics.getColor();
        if (this.atts != null) {
            String string = this.atts.get("type");
            if (string != null) {
                n4 = LI.bulletNameToType(string);
                if (tagItem instanceof UL) {
                    UL uL = (UL)tagItem;
                    uL.bulletType = n4;
                }
            }
        } else if (tagItem instanceof UL) {
            UL uL = (UL)tagItem;
            n4 = uL.bulletType;
        }
        graphics.setColor(docStyle.color);
        ++n2;
        switch (n4) {
            case 0: {
                if (n3 > 6) {
                    graphics.fillOval(n, n2, n3, n3);
                    break;
                }
                if (n3 < 3) {
                    ++n3;
                }
                graphics.fillRect(n, n2, n3, n3);
                break;
            }
            case 1: {
                graphics.setColor(color);
                graphics.fillOval(n, n2, n3, n3);
                graphics.setColor(docStyle.color);
                graphics.drawOval(n, n2, n3, n3);
                break;
            }
            case 2: {
                graphics.drawRect(n, n2, n3, n3);
                break;
            }
        }
        graphics.setColor(color2);
    }

    private void paintOrderedItem(Graphics graphics, DocStyle docStyle, int n, int n2, DocLine docLine) {
        Attributes attributes = docStyle.next.tag.getAttributes();
        boolean bl = false;
        int n3 = 0;
        Attributes attributes2 = docStyle.tag.getAttributes();
        if (attributes2 != null) {
            try {
                n3 = Integer.parseInt(attributes2.get("value"));
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            n3 = this.getItemNumber(docStyle);
            if (attributes != null) {
                int n4 = 1;
                try {
                    n4 = Integer.parseInt(attributes.get("start"));
                }
                catch (Exception exception) {}
                n3 += n4 - 1;
            }
        }
        graphics.setFont(docStyle.font);
        graphics.setColor(docStyle.color);
        String string = String.valueOf(this.formatItemNum(n3, attributes, attributes2)) + ".";
        n += this.style.left - 4;
        FontMetrics fontMetrics = docStyle.font.getFontMetrics(docStyle);
        n -= fontMetrics.stringWidth(string);
        n = Math.max(0, n);
        graphics.drawString(string, n, n2 + docLine.baseline);
    }

    private String formatItemNum(int n, Attributes attributes, Attributes attributes2) {
        String string;
        String string2;
        String string3 = "1";
        if (attributes != null && (string2 = attributes.get("type")) != null) {
            string3 = string2;
        }
        if (attributes2 != null && (string2 = attributes2.get("type")) != null) {
            string3 = string2;
        }
        boolean bl = false;
        switch (string3.charAt(0)) {
            default: {
                string = String.valueOf(n);
                break;
            }
            case 'A': {
                bl = true;
            }
            case 'a': {
                string = this.formatAlphaNumerals(n);
                break;
            }
            case 'I': {
                bl = true;
            }
            case 'i': {
                string = this.formatRomanNumerals(n);
            }
        }
        if (bl) {
            string = string.toUpperCase();
        }
        return string;
    }

    private String formatAlphaNumerals(int n) {
        String string = "";
        string = n > 26 ? String.valueOf(this.formatAlphaNumerals(n / 26)) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
        return string;
    }

    private String formatRomanNumerals(int n) {
        return this.formatRomanNumerals(0, n);
    }

    private String formatRomanNumerals(int n, int n2) {
        if (n2 < 10) {
            return this.formatRomanDigit(n, n2);
        }
        return String.valueOf(this.formatRomanNumerals(n + 1, n2 / 10)) + this.formatRomanDigit(n, n2 % 10);
    }

    private String formatRomanDigit(int n, int n2) {
        String string = "";
        if (n2 == 9) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n + 1][0];
            return string;
        }
        if (n2 == 4) {
            string = String.valueOf(string) + romanChars[n][0];
            string = String.valueOf(string) + romanChars[n][1];
            return string;
        }
        if (n2 >= 5) {
            string = String.valueOf(string) + romanChars[n][1];
            n2 -= 5;
        }
        int n3 = 0;
        while (n3 < n2) {
            string = String.valueOf(string) + romanChars[n][0];
            ++n3;
        }
        return string;
    }

    public boolean measureStartTag(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        if (!super.measureStartTag(formatter, formatState, measurement, measureState)) {
            int n = this.getIndex();
            if (n <= this.doc.nitems && this.doc.getTagName(this.doc.getItem(n + 1)).equals("pre")) {
                formatState.state = 0;
            }
            return false;
        }
        return true;
    }

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        bulletOrder = nArray;
        bulletNames = new String[]{"disc", "circle", "square"};
        romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
    }
}

