/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.VBreakInfo;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Length;
import sunw.hotjava.tables.BGColorInfo;
import sunw.hotjava.tables.CellInfoVector;
import sunw.hotjava.tables.CellSpec;
import sunw.hotjava.tables.ConstraintSummary;
import sunw.hotjava.tables.DeliberatelyPaintable;
import sunw.hotjava.tables.TableElementPanel;
import sunw.hotjava.tables.TableElementPanelEnumerator;
import sunw.hotjava.tables.TableGrid;
import sunw.hotjava.tables.TableVBreakInfo;
import sunw.hotjava.tags.Align;
import sunw.hotjava.tags.TagAppletPanel;
import sunw.html.Attributes;

public class TablePanel
extends Container
implements DocPanel,
DocConstants,
DeliberatelyPaintable {
    private static final int RAISED_BORDER_THRESHOLD = 3;
    private Document doc;
    private TagItem item;
    private Formatter parentFormatter;
    private int border = -1;
    private int borderWidth = 1;
    private Length givenWidth;
    private Length givenHeight;
    private int cellPadding = 1;
    private int cellSpacing = 2;
    private int numRows;
    private int numCols;
    private TableElementPanel[][] tableGridArray;
    private boolean[][] isUpperLeftArray;
    private int maxRowSpan;
    private int maxColSpan;
    private int tableAlignment;
    private int captionAlignment;
    private DocItem captionItem;
    private TableElementPanel captionPanel;
    private boolean hasBorder;
    private TableGrid tableGrid = new TableGrid();
    private CellInfoVector colInfo;
    private CellInfoVector rowInfo;
    private int tableWidth;
    private int tableHeight;
    private int minTableWidth;
    private int maxWidth;
    boolean suppressRepaint = false;
    boolean firstCall = true;
    private int prevX;
    private int prevY;

    TablePanel(Formatter formatter, TagItem tagItem, Document document) {
        this.setVisible(false);
        this.setLayout(null);
        this.parentFormatter = formatter;
        this.doc = document;
        this.item = tagItem;
        Color color = formatter.getFormatterBackgroundColor();
        BGColorInfo bGColorInfo = new BGColorInfo(color);
        if (formatter.isFormatterBackgroundColorDeliberate()) {
            bGColorInfo.setColor(color);
        }
        BGColorInfo bGColorInfo2 = new BGColorInfo(bGColorInfo);
        Attributes attributes = tagItem.getAttributes();
        if (attributes != null) {
            this.givenWidth = new Length(attributes.get("width"));
            this.givenHeight = new Length(attributes.get("height"));
            this.borderWidth = this.parseIntAtt(attributes, "border", 1);
            this.hasBorder = (attributes.get("border") != null || attributes.get("dummy") != null) && this.borderWidth > 0;
            this.cellPadding = this.parseIntAtt(attributes, "cellpadding", 1);
            this.cellSpacing = this.parseIntAtt(attributes, "cellspacing", 2);
            if (this.cellPadding == 0 && this.hasBorder) {
                this.cellPadding = 1;
            }
            this.tableAlignment = this.parseHorizAlign(attributes, "align", 7);
            this.parseColor(attributes, "bgcolor", bGColorInfo2);
        } else {
            this.givenWidth = new Length(null);
            this.givenHeight = new Length(null);
        }
        this.parseRows(bGColorInfo, bGColorInfo2);
        this.initInfoVectors();
        formatter.claimResponsibilityFor(this, tagItem.getIndex(), tagItem.getIndex() + tagItem.getOffset());
    }

    TablePanel(TablePanel tablePanel, Formatter formatter, DocumentState documentState) {
        this.setLayout(null);
        this.doc = tablePanel.doc;
        this.item = tablePanel.item;
        this.parentFormatter = formatter;
        this.border = tablePanel.border;
        this.borderWidth = tablePanel.borderWidth;
        this.givenWidth = tablePanel.givenWidth;
        this.givenHeight = tablePanel.givenHeight;
        this.cellPadding = tablePanel.cellPadding;
        this.cellSpacing = tablePanel.cellSpacing;
        this.numRows = tablePanel.numRows;
        this.numCols = tablePanel.numCols;
        this.maxRowSpan = tablePanel.maxRowSpan;
        this.maxColSpan = tablePanel.maxColSpan;
        this.tableAlignment = tablePanel.tableAlignment;
        this.captionAlignment = tablePanel.captionAlignment;
        this.captionItem = tablePanel.captionItem;
        this.tableGrid = new TableGrid(tablePanel.tableGrid, this, documentState);
        this.colInfo = new CellInfoVector(this.numCols, this.cellPadding, this.cellSpacing);
        this.rowInfo = new CellInfoVector(this.numRows, this.cellPadding, this.cellSpacing);
        if (this.captionItem != null) {
            int n = 0;
            if (this.captionAlignment == 5) {
                n = this.numRows - 1;
            }
            this.captionPanel = this.tableGrid.elementAt(0, n);
        }
        this.hasBorder = tablePanel.hasBorder;
    }

    public Component copyForPrinting(Formatter formatter, DocumentState documentState) {
        return new TablePanel(this, formatter, documentState);
    }

    private void initInfoVectors() {
        this.colInfo = new CellInfoVector(this.numCols, this.cellPadding, this.cellSpacing);
        this.rowInfo = new CellInfoVector(this.numRows, this.cellPadding, this.cellSpacing);
    }

    private void parseRows(BGColorInfo bGColorInfo, BGColorInfo bGColorInfo2) {
        DocItem docItem;
        int n;
        int n2 = 0;
        int n3 = this.item.getIndex() + 1;
        while ((n = (docItem = this.doc.getItem(n3)).getOffset()) >= 0) {
            if (this.isTag(docItem, "tr")) {
                this.parseTableRow(docItem, n3, n2, bGColorInfo2);
                ++n2;
            } else if (this.isTag(docItem, "caption")) {
                this.parseCaption(docItem);
            }
            n3 += n;
            ++n3;
        }
        this.canonicalizeTable();
        if (this.captionItem != null) {
            this.captionPanel = this.makeCaptionPanel(bGColorInfo);
            this.tableGrid.insertCaption(this.captionPanel, this.captionAlignment == 0, this.numCols);
            this.add(this.captionPanel);
            ++this.numRows;
        }
    }

    private void parseCaption(DocItem docItem) {
        Attributes attributes;
        if (this.captionItem != null) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! multiple captions");
            return;
        }
        this.captionItem = docItem;
        this.captionAlignment = 0;
        TagItem tagItem = docItem.getTag(this.doc);
        if (tagItem != null && (attributes = tagItem.getAttributes()) != null) {
            this.captionAlignment = this.parseAlignment(attributes, "align", 33, 0);
        }
    }

    TableElementPanel makeCaptionPanel(BGColorInfo bGColorInfo) {
        return new TableElementPanel(this.doc, this.parentFormatter.getDocumentState(), this.captionItem, null, this.item, this, new Length(null), new Length(null), this.captionAlignment, this.numCols, 1, bGColorInfo);
    }

    private void parseTableRow(DocItem docItem, int n, int n2, BGColorInfo bGColorInfo) {
        Attributes attributes;
        int n3 = 2;
        BGColorInfo bGColorInfo2 = new BGColorInfo(bGColorInfo);
        TagItem tagItem = docItem.getTag(this.doc);
        if (tagItem != null && (attributes = tagItem.getAttributes()) != null) {
            n3 = this.parseVertAlign(attributes, "valign", n3);
            this.parseColor(attributes, "bgcolor", bGColorInfo2);
        }
        int n4 = docItem.getIndex() + 1;
        DocItem docItem2;
        int n5;
        while ((n5 = (docItem2 = this.doc.getItem(n4)).getOffset()) >= 0) {
            if (this.isTag(docItem2, "td") || this.isTag(docItem2, "th")) {
                this.parseElements(n2, docItem2, docItem, n3, bGColorInfo2);
            }
            n4 += n5;
            ++n4;
        }
        return;
    }

    private void parseElements(int n, DocItem docItem, DocItem docItem2, int n2, BGColorInfo bGColorInfo) {
        TagItem tagItem = docItem.getTag(this.doc);
        if (tagItem != null) {
            Length length;
            Length length2;
            int n3;
            int n4;
            int n5;
            Attributes attributes = tagItem.getAttributes();
            if (attributes == null) {
                n5 = 1;
                n4 = 1;
                n3 = n2;
            } else {
                n5 = this.parseIntAtt(attributes, "rowspan", 1);
                n4 = this.parseIntAtt(attributes, "colspan", 1);
                n3 = this.parseVertAlign(attributes, "valign", n2);
                if (n4 == 0) {
                    n4 = 1;
                }
                if (n5 == 0) {
                    n5 = 1;
                }
            }
            if (this.maxRowSpan < n5) {
                this.maxRowSpan = n5;
            }
            if (this.maxColSpan < n4) {
                this.maxColSpan = n4;
            }
            if (attributes == null) {
                length2 = new Length(null);
                length = new Length(null);
            } else {
                length2 = new Length(attributes.get("width"));
                length = new Length(attributes.get("height"));
            }
            BGColorInfo bGColorInfo2 = new BGColorInfo(bGColorInfo);
            this.parseColor(attributes, "bgcolor", bGColorInfo2);
            int n6 = this.tableGrid.findNextFreeCol(n);
            int n7 = n6 + n4;
            int n8 = n + n5;
            if (this.numCols < n7) {
                this.numCols = n7;
            }
            if (this.numRows < n8) {
                this.numRows = n8;
            }
            TableElementPanel tableElementPanel = new TableElementPanel(this.doc, this.parentFormatter.getDocumentState(), docItem, docItem2, this.item, this, length2, length, n3, n4, n5, bGColorInfo2);
            this.tableGrid.addElement(tableElementPanel, n6, n, n4, n5);
            this.add(tableElementPanel);
        }
    }

    protected int parseIntAtt(Attributes attributes, String string, int n) {
        int n2;
        block2: {
            String string2;
            n2 = n;
            if (attributes == null || (string2 = attributes.get(string)) == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    private boolean isTag(DocItem docItem, String string) {
        TagItem tagItem = docItem.getTag(this.doc);
        if (tagItem == null) {
            return false;
        }
        return string.equals(tagItem.getName());
    }

    private int parseHorizAlign(Attributes attributes, String string, int n) {
        int n2 = Align.getCheckedAlign(attributes, string, 388, n);
        if (n2 < 0) {
            n2 = n;
        }
        return n2;
    }

    private int parseVertAlign(Attributes attributes, String string, int n) {
        int n2 = Align.getCheckedAlign(attributes, string, 53, n);
        if (n2 < 0) {
            n2 = n;
        }
        return n2;
    }

    private int parseAlignment(Attributes attributes, String string, int n, int n2) {
        int n3 = Align.getCheckedAlign(attributes, string, n, n2);
        return n3;
    }

    private void parseColor(Attributes attributes, String string, BGColorInfo bGColorInfo) {
        Color color;
        String string2;
        if (attributes != null && (string2 = attributes.get(string)) != null && (color = Globals.mapNamedColor(string2)) != null) {
            bGColorInfo.setColor(color);
        }
    }

    private void canonicalizeTable() {
        boolean bl = this.removeExtraRows();
        if (bl &= this.removeExtraCols()) {
            this.updateMaxSpanInfo();
        }
    }

    private boolean removeExtraRows() {
        boolean bl = false;
        int n = 0;
        while (n < this.numRows) {
            TableElementPanel tableElementPanel;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < this.numCols) {
                TableElementPanel tableElementPanel2 = this.tableGrid.elementAt(n2, n);
                if (tableElementPanel2 != null) {
                    if (n > 0 && !bl2 && (tableElementPanel = this.tableGrid.elementAt(n2, n - 1)) != null && tableElementPanel != tableElementPanel2) {
                        bl2 = true;
                    }
                    if (n < this.numRows - 1 && !bl3 && (tableElementPanel = this.tableGrid.elementAt(n2, n + 1)) != tableElementPanel2) {
                        bl3 = true;
                    }
                    n2 += tableElementPanel2.getColSpan() - 1;
                }
                ++n2;
            }
            if (n > 0 && !bl2 || n < this.numRows - 1 && !bl3) {
                int n3 = 0;
                while (n3 < this.numCols) {
                    tableElementPanel = this.tableGrid.elementAt(n3, n);
                    if (tableElementPanel != null) {
                        n3 += tableElementPanel.getColSpan() - 1;
                        tableElementPanel.adjustSpanBy(-1, false);
                    }
                    ++n3;
                }
                this.tableGrid.removeRow(n);
                --n;
                --this.numRows;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean removeExtraCols() {
        boolean bl = false;
        int n = 1;
        while (n < this.numCols) {
            TableElementPanel tableElementPanel;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.numRows) {
                TableElementPanel tableElementPanel2 = this.tableGrid.elementAt(n, n2);
                if (tableElementPanel2 != null) {
                    tableElementPanel = this.tableGrid.elementAt(n - 1, n2);
                    if (tableElementPanel != tableElementPanel2) {
                        bl2 = true;
                        break;
                    }
                    n2 += tableElementPanel2.getRowSpan() - 1;
                }
                ++n2;
            }
            if (!bl2) {
                int n3 = 0;
                while (n3 < this.numRows) {
                    tableElementPanel = this.tableGrid.elementAt(n, n3);
                    if (tableElementPanel != null) {
                        n3 += tableElementPanel.getRowSpan() - 1;
                        tableElementPanel.adjustSpanBy(-1, true);
                    }
                    ++n3;
                }
                this.tableGrid.removeColumn(n);
                --n;
                --this.numCols;
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private void updateMaxSpanInfo() {
        this.maxColSpan = 0;
        this.maxRowSpan = 0;
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                TableElementPanel tableElementPanel = this.tableGrid.elementAt(n2, n);
                if (tableElementPanel != null) {
                    this.maxColSpan = Math.max(this.maxColSpan, tableElementPanel.getColSpan());
                    this.maxRowSpan = Math.max(this.maxRowSpan, tableElementPanel.getRowSpan());
                }
                ++n2;
            }
            ++n;
        }
    }

    int getCellPadding() {
        return this.cellPadding;
    }

    int getCellSpacing() {
        return this.cellSpacing;
    }

    public static void paintWithClipping(Graphics graphics, Component component) {
        Graphics graphics2;
        block2: {
            graphics2 = component.getGraphics();
            Rectangle rectangle = component.getBounds();
            try {
                boolean bl = TablePanel.clipGraphicsToParent(graphics, graphics2, component, rectangle);
                if (!bl) break block2;
                ((DeliberatelyPaintable)((Object)component)).paintDeliberately(graphics2);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        Object var5_5 = null;
        graphics2.dispose();
    }

    public static void paintWithClipping(Graphics graphics, Component component, Rectangle rectangle) {
        Graphics graphics2;
        block2: {
            graphics2 = component.getGraphics();
            try {
                boolean bl = TablePanel.clipGraphicsToParent(graphics, graphics2, component, rectangle);
                if (!bl) break block2;
                ((DeliberatelyPaintable)((Object)component)).paintDeliberately(graphics2);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        Object var5_5 = null;
        graphics2.dispose();
    }

    private boolean paintRangeNoFloatersWithClipping(Graphics graphics, int n, int n2, boolean bl, TableElementPanel tableElementPanel) {
        Graphics graphics2;
        boolean bl2;
        block2: {
            bl2 = false;
            graphics2 = tableElementPanel.getGraphics();
            Rectangle rectangle = tableElementPanel.getBounds();
            try {
                boolean bl3 = TablePanel.clipGraphicsToParent(graphics, graphics2, tableElementPanel, rectangle);
                if (!bl3) break block2;
                bl2 = tableElementPanel.paintRangeNoFloaters(graphics2, n, n2, bl);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        Object var10_10 = null;
        graphics2.dispose();
        return bl2;
    }

    private boolean paintRangeWithClipping(Graphics graphics, int n, int n2, boolean bl, TableElementPanel tableElementPanel) {
        Graphics graphics2;
        boolean bl2;
        block2: {
            bl2 = false;
            graphics2 = tableElementPanel.getGraphics();
            Rectangle rectangle = tableElementPanel.getBounds();
            try {
                boolean bl3 = TablePanel.clipGraphicsToParent(graphics, graphics2, tableElementPanel, rectangle);
                if (!bl3) break block2;
                bl2 = tableElementPanel.paintRange(graphics2, n, n2, bl);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        Object var10_10 = null;
        graphics2.dispose();
        return bl2;
    }

    private static boolean clipGraphicsToParent(Graphics graphics, Graphics graphics2, Component component, Rectangle rectangle) {
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 != null) {
            if (!rectangle.intersects(rectangle2)) {
                return false;
            }
            Point point = component.getLocation();
            graphics2.clipRect(rectangle2.x - point.x, rectangle2.y - point.y, rectangle2.width, rectangle2.height);
        }
        return true;
    }

    void getFormPanel(Vector vector) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((TableElementPanel)enumeration.nextElement()).getFormPanel(vector);
        }
    }

    public void activateSubItems() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).activateSubItems();
        }
    }

    public void start() {
        Color color = this.parentFormatter.getFormatterBackgroundColor();
        if (color != null) {
            this.setBackground(color);
        }
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).start();
        }
    }

    public void unregisterListeners() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component instanceof TablePanel) {
                ((TablePanel)component).unregisterListeners();
                continue;
            }
            if (!(component instanceof TableElementPanel)) continue;
            ((TableElementPanel)component).unregisterListeners();
        }
    }

    public void stop() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).stop();
        }
    }

    public void destroy() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).destroy();
        }
        this.parentFormatter.disclaimResponsibilityFor(this, this.item.getIndex(), this.item.getIndex() + this.item.getOffset());
    }

    public void interruptLoading() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).interruptLoading();
        }
    }

    public void notify(Document document, int n, int n2, int n3) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).notify(document, n, n2, n3);
        }
    }

    public void reformat() {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            ((DocPanel)enumeration.nextElement()).reformat();
        }
    }

    public int findYFor(int n) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            if (!tableElementPanel.containsPos(n)) continue;
            return tableElementPanel.findYFor(n);
        }
        return 0;
    }

    public boolean paintRange(Graphics graphics, int n, int n2, boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        boolean bl2 = false;
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            if (!tableElementPanel.intersectsRange(n, n2)) continue;
            bl2 |= this.paintRangeWithClipping(graphics, n, n2, bl, tableElementPanel);
        }
        return bl2;
    }

    public boolean paintRangeNoFloaters(Graphics graphics, int n, int n2, boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        boolean bl2 = false;
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            if (!tableElementPanel.intersectsRange(n, n2)) continue;
            bl2 |= this.paintRangeNoFloatersWithClipping(graphics, n, n2, bl, tableElementPanel);
        }
        return bl2;
    }

    public void paint(Graphics graphics) {
        this.paintBackgroundAndBorder(graphics);
        this.paintDeliberately(graphics);
    }

    public void setVisible(boolean bl) {
        if (this.firstCall && bl) {
            super.setVisible(bl);
            this.firstCall = false;
            return;
        }
        if (this.isVisible() != bl) {
            this.suppressRepaint = true;
            super.setVisible(bl);
            this.suppressRepaint = false;
        }
    }

    public void repaint() {
        if (!this.suppressRepaint) {
            super.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintDeliberately(Graphics graphics) {
        int n = this.getComponentCount();
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        Container container = this;
        while (container != null) {
            if (container instanceof ScrollPane) break;
            container = container.getParent();
        }
        if (container == null) {
            System.out.println("Couldn't find a scrollpane");
            return;
        }
        ScrollPane scrollPane = (ScrollPane)container;
        Dimension dimension = scrollPane.getViewportSize();
        int n6 = dimension.width;
        int n7 = dimension.height;
        int n8 = this.prevX < n2 ? n4 + n2 - n6 : n2;
        int n9 = this.prevY < n3 ? n5 + n3 - n7 : n3;
        this.prevX = n8;
        this.prevY = n9;
        rectangle = graphics.getClipBounds();
        this.paintBackgroundAndBorder(graphics);
        int n10 = 0;
        while (n10 < n) {
            Component component = this.getComponent(n10);
            Rectangle rectangle2 = component.getBounds();
            if (rectangle2.intersects(rectangle)) {
                TablePanel.paintWithClipping(graphics, component, rectangle2);
            }
            ++n10;
        }
    }

    private void paintBack(Graphics graphics, int n, int n2, int n3, int n4) {
        DocumentState documentState = this.parentFormatter.getDocumentState();
        if (documentState.bg != null) {
            if (!(graphics instanceof PrintGraphics)) {
                Point point = new Point(0, 0);
                this.getBackgroundDisplacement(point);
                documentState.bg.paint(graphics, point.x, point.y, n, n2, n3, n4);
                return;
            }
        } else if (this.getBackground() != null) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(color);
        }
    }

    void getBackgroundDisplacement(Point point) {
        Point point2 = this.getLocation();
        int n = this.parentFormatter.findPos(this.item.getIndex() << 12);
        point2.y = this.parentFormatter.findYOfDocLine(n);
        point.translate(-point2.x, -point2.y);
        this.parentFormatter.getBackgroundDisplacement(point);
    }

    private void paintBackgroundAndBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.paintBack(graphics, 0, 0, dimension.width, dimension.height);
        Point point = new Point(0, 0);
        this.adjustForCaption(point, dimension);
        if (this.hasBorder) {
            DocumentState documentState = this.parentFormatter.getDocumentState();
            this.draw3DBorder(graphics, dimension, point, documentState.background);
        }
    }

    private void printBackgroundAndBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        Point point = new Point(0, 0);
        this.adjustForCaption(point, dimension);
        if (this.hasBorder) {
            if (this.borderWidth < 3) {
                this.drawBorder(graphics, dimension, point);
                return;
            }
            this.draw3DBorder(graphics, dimension, point, Color.white);
        }
    }

    private void drawBorder(Graphics graphics, Dimension dimension, Point point) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n = 0;
        while (n < this.borderWidth) {
            graphics.drawRect(n + point.x, n + point.y, dimension.width - (2 * n + 1), dimension.height - (2 * n + 1));
            ++n;
        }
        graphics.setColor(color);
    }

    private void draw3DBorder(Graphics graphics, Dimension dimension, Point point, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(Globals.getVisible3DColor(color));
        int n = 0;
        while (n < this.borderWidth) {
            graphics.draw3DRect(n + point.x, n + point.y, dimension.width - (2 * n + 1), dimension.height - (2 * n + 1), true);
            ++n;
        }
        graphics.setColor(color2);
    }

    private void adjustForCaption(Point point, Dimension dimension) {
        if (this.captionPanel == null) {
            return;
        }
        dimension.height -= this.captionPanel.getElementHeight() + this.cellSpacing;
        if (this.captionAlignment == 0) {
            point.y += this.captionPanel.getElementHeight() + this.cellSpacing;
        }
    }

    int findSplitY(int n, int n2, TableVBreakInfo tableVBreakInfo) {
        int n3 = 0;
        if (tableVBreakInfo != null) {
            n3 = tableVBreakInfo.getStartRow();
        }
        int n4 = n3;
        block0: while (n4 < this.numRows) {
            int n5 = 0;
            while (n5 < this.numCols) {
                TableElementPanel tableElementPanel;
                if (this.isUpperLeftArray[n4][n5] && (tableElementPanel = this.tableGridArray[n4][n5]) != null) {
                    Rectangle rectangle = tableElementPanel.getBounds();
                    int n6 = rectangle.y + rectangle.height;
                    if (n6 >= n) {
                        int n7 = rectangle.height;
                        if (n7 >= n2 || !this.hasBorder) break block0;
                        return rectangle.y;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        if (n4 >= this.numRows) {
            return n;
        }
        return this.findRowSplitY(n4, n, n2, tableVBreakInfo);
    }

    private int findRowSplitY(int n, int n2, int n3, TableVBreakInfo tableVBreakInfo) {
        int n4 = n2;
        int n5 = 0;
        while (n5 < this.numCols) {
            TableElementPanel tableElementPanel;
            if (this.isUpperLeftArray[n][n5] && (tableElementPanel = this.tableGridArray[n][n5]) != null) {
                Rectangle rectangle = tableElementPanel.getBounds();
                int n6 = rectangle.y + rectangle.height;
                if (n6 >= n2) {
                    int n7;
                    VBreakInfo vBreakInfo = null;
                    if (tableVBreakInfo != null) {
                        vBreakInfo = tableVBreakInfo.getItemBreakInfo(tableElementPanel);
                    }
                    if ((n7 = tableElementPanel.findSplitY(n2 - rectangle.y, n3, vBreakInfo) + rectangle.y) < n4) {
                        n4 = n7;
                    }
                }
            }
            ++n5;
        }
        return n4;
    }

    void recordBreakInfo(int n, int n2, TableVBreakInfo tableVBreakInfo, TableVBreakInfo tableVBreakInfo2) {
        int n3 = 0;
        if (tableVBreakInfo != null) {
            n3 = tableVBreakInfo.getStartRow();
        }
        int n4 = this.borderWidth + this.cellSpacing;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.numRows) {
            if (n4 >= n) {
                bl = n4 == n;
                break;
            }
            n4 += this.rowInfo.getAssignedSize(n5) + this.cellSpacing;
            ++n5;
        }
        tableVBreakInfo2.setEndRow(this.numRows);
        tableVBreakInfo.setEndRow(n5);
        this.recordPanelFloaterBreakInfo(n, n2, tableVBreakInfo, tableVBreakInfo2, n3, n5);
        if (bl) {
            tableVBreakInfo2.setStartRow(n5);
            if (n5 >= this.numRows) {
                return;
            }
            --n5;
        } else {
            tableVBreakInfo2.setStartRow(--n5);
        }
        if (n5 < 0) {
            return;
        }
        int n6 = 0;
        while (n6 < this.numCols) {
            TableElementPanel tableElementPanel = this.tableGridArray[n5][n6];
            if (tableElementPanel != null && (n6 <= 0 || tableElementPanel != this.tableGridArray[n5][n6 - 1])) {
                Rectangle rectangle = tableElementPanel.getBounds();
                if (rectangle.y < n && rectangle.y + rectangle.height > n2) {
                    tableElementPanel.recordBreakInfo(n - rectangle.y, n2 - rectangle.y, tableVBreakInfo, tableVBreakInfo2);
                }
            }
            ++n6;
        }
    }

    private void recordPanelFloaterBreakInfo(int n, int n2, TableVBreakInfo tableVBreakInfo, TableVBreakInfo tableVBreakInfo2, int n3, int n4) {
        int n5 = n3;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < this.numCols) {
                TableElementPanel tableElementPanel = this.tableGridArray[n5][n6];
                if (tableElementPanel != null && !(n5 == n3 ? n6 > 0 && tableElementPanel == this.tableGridArray[n5][n6 - 1] : !this.isUpperLeftArray[n5][n6])) {
                    Rectangle rectangle = tableElementPanel.getBounds();
                    tableElementPanel.recordFloaterBreakInfo(n - rectangle.y, n2 - rectangle.y, tableVBreakInfo, tableVBreakInfo2);
                }
                ++n6;
            }
            ++n5;
        }
    }

    void print(Graphics graphics, TableVBreakInfo tableVBreakInfo) {
        int n = 0;
        int n2 = this.numRows;
        if (tableVBreakInfo != null) {
            n = tableVBreakInfo.getStartRow();
            n2 = tableVBreakInfo.getEndRow();
        }
        this.printBackgroundAndBorder(graphics);
        if (n >= this.numRows) {
            return;
        }
        int n3 = 0;
        while (n3 < this.numCols) {
            TableElementPanel tableElementPanel;
            if (!this.isRowStart(n3, n) && this.isColStart(n3, n) && (tableElementPanel = this.tableGrid.elementAt(n3, n)) != null) {
                this.printTableElement(graphics, tableElementPanel, tableVBreakInfo);
            }
            ++n3;
        }
        int n4 = n;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < this.numCols) {
                TableElementPanel tableElementPanel = this.tableGrid.elementAt(n5, n4);
                if (tableElementPanel != null && this.tableGrid.isUpperLeft(n5, n4)) {
                    this.printTableElement(graphics, tableElementPanel, tableVBreakInfo);
                }
                ++n5;
            }
            ++n4;
        }
    }

    private void printTableElement(Graphics graphics, TableElementPanel tableElementPanel, TableVBreakInfo tableVBreakInfo) {
        VBreakInfo vBreakInfo = null;
        if (tableVBreakInfo != null) {
            vBreakInfo = tableVBreakInfo.getItemBreakInfo(tableElementPanel);
        }
        Rectangle rectangle = tableElementPanel.getBounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            tableElementPanel.print(graphics2, vBreakInfo);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            graphics2.dispose();
            throw throwable;
        }
        Object var8_7 = null;
        graphics2.dispose();
    }

    private boolean isRowStart(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        TableElementPanel tableElementPanel = this.tableGridArray[n2][n];
        return tableElementPanel != null && tableElementPanel != this.tableGridArray[n2 - 1][n];
    }

    private boolean isColStart(int n, int n2) {
        if (n == 0) {
            return true;
        }
        TableElementPanel tableElementPanel = this.tableGridArray[n2][n];
        return tableElementPanel != null && tableElementPanel != this.tableGridArray[n2][n - 1];
    }

    boolean needsBorder() {
        return this.hasBorder;
    }

    public Enumeration enumeratePanels() {
        return new TableElementPanelEnumerator(this);
    }

    public TagAppletPanel getAppletPanel(String string) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            TagAppletPanel tagAppletPanel = tableElementPanel.getAppletPanel(string);
            if (tagAppletPanel == null) continue;
            return tagAppletPanel;
        }
        return null;
    }

    public void getAppletPanels(Vector vector) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            tableElementPanel.getAppletPanels(vector);
        }
    }

    void format(FormatState formatState) {
        this.maxWidth = formatState.maxWidth;
        this.layout();
    }

    int getHeight() {
        this.validate();
        return this.tableHeight + 2 * (this.borderWidth + this.cellSpacing);
    }

    int getAvailableWidth() {
        int n;
        int n2 = n = this.maxWidth == 0 ? this.parentFormatter.getAvailableWidth(this.item.getIndex() << 12) : this.maxWidth;
        if (this.givenWidth.isSet()) {
            n = this.givenWidth.isPercentage() ? (int)((double)n * ((double)this.givenWidth.getValue() / 100.0)) : this.givenWidth.getValue();
        }
        return n - 2 * (this.borderWidth + this.cellSpacing);
    }

    int getGivenHeight() {
        if (this.givenHeight.isSet()) {
            if (this.givenHeight.isPercentage()) {
                return (int)((double)this.givenHeight.getValue() / 100.0 * (double)this.parentFormatter.getAvailableHeight());
            }
            return this.givenHeight.getValue();
        }
        return -1;
    }

    public void layout() {
        this.tableGridArray = new TableElementPanel[this.numRows][this.numCols];
        this.isUpperLeftArray = new boolean[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                this.tableGridArray[n][n2] = this.tableGrid.elementAt(n2, n);
                this.isUpperLeftArray[n][n2] = this.tableGridArray[n][n2] == null ? false : this.tableGrid.isUpperLeft(n2, n);
                ++n2;
            }
            ++n;
        }
        this.initInfoVectors();
        this.measureTableWidth();
        this.scaleWidthForPercentages();
        this.distributeLeftoverSpace(this.tableWidth, this.colInfo);
        this.setFormatterWidths();
        this.alignCommonBaselines();
        this.measureTableHeight();
        this.tableHeight = this.scaleForPercentages(this.rowInfo, this.tableHeight);
        this.layoutSubPanels();
    }

    private void setFormatterWidths() {
        new Measurement();
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            while (n2 < this.numCols) {
                if (this.isUpperLeftArray[n][n2]) {
                    TableElementPanel tableElementPanel = this.tableGridArray[n][n2];
                    int n3 = 0;
                    int n4 = n2;
                    while (n4 < this.numCols && tableElementPanel == this.tableGridArray[n][n4]) {
                        n3 += this.colInfo.getAssignedSize(n4) + this.cellSpacing;
                        ++n4;
                    }
                    tableElementPanel.setAssignedWidth(n3);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void alignCommonBaselines() {
        Measurement measurement = new Measurement();
        int n = 0;
        while (n < this.numRows) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.numCols) {
                if (this.isUpperLeftArray[n][n3]) {
                    TableElementPanel tableElementPanel = this.tableGridArray[n][n3];
                    n2 = Math.max(n2, tableElementPanel.getBaseline());
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.numCols) {
                if (this.isUpperLeftArray[n][n4]) {
                    TableElementPanel tableElementPanel = this.tableGridArray[n][n4];
                    int n5 = tableElementPanel.getElementHeight();
                    tableElementPanel.setCommonBaseline(n2);
                    int n6 = tableElementPanel.getAdjustedElementHeight();
                    if (n5 < n6) {
                        measurement.reset();
                        measurement.setMinWidth(n6);
                        measurement.setPreferredWidth(n6);
                        this.rowInfo.addConstraintInfo(n, tableElementPanel.getRowSpan(), measurement, -1);
                    }
                }
                ++n4;
            }
            ++n;
        }
    }

    private void layoutSubPanels() {
        int n = this.borderWidth + this.cellSpacing;
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = this.borderWidth + this.cellSpacing;
            int n4 = 0;
            while (n4 < this.numCols) {
                if (this.isUpperLeftArray[n2][n4]) {
                    TableElementPanel tableElementPanel = this.tableGridArray[n2][n4];
                    this.setPanelSize(tableElementPanel, n4, n2);
                    tableElementPanel.doVerticalAlignment();
                    if (n2 == 0 && this.captionPanel != null && this.captionAlignment == 0) {
                        tableElementPanel.setLocation(n3, n - this.borderWidth);
                    } else if (n2 == this.numRows - 1 && this.captionPanel != null && this.captionAlignment == 5) {
                        tableElementPanel.setLocation(n3, n + this.borderWidth);
                    } else {
                        tableElementPanel.setLocation(n3, n);
                    }
                }
                n3 += this.colInfo.getAssignedSize(n4) + this.cellSpacing;
                ++n4;
            }
            n += this.rowInfo.getAssignedSize(n2) + this.cellSpacing;
            ++n2;
        }
        this.tableHeight = Math.max(n - this.borderWidth - 2 * this.cellSpacing, this.getGivenHeight());
        this.resizeTableToFit();
    }

    private void setPanelSize(TableElementPanel tableElementPanel, int n, int n2) {
        int n3 = -this.cellSpacing;
        int n4 = -this.cellSpacing;
        int n5 = n2 + tableElementPanel.getRowSpan();
        int n6 = n + tableElementPanel.getColSpan();
        int n7 = n2;
        while (n7 < n5) {
            n3 += this.rowInfo.getAssignedSize(n7) + this.cellSpacing;
            ++n7;
        }
        int n8 = n;
        while (n8 < n6) {
            n4 += this.colInfo.getAssignedSize(n8) + this.cellSpacing;
            ++n8;
        }
        tableElementPanel.setSize(n4, n3);
    }

    private void measureTableWidth() {
        Measurement measurement = new Measurement();
        MeasureState measureState = new MeasureState();
        this.measure(measurement, measureState);
        this.tableWidth = measurement.getPreferredWidth();
        this.minTableWidth = measurement.getMinWidth();
    }

    private void scaleWidthForPercentages() {
        if (this.getDesiredWidth() > 0) {
            if (!this.givenWidth.isPercentage() && this.givenWidth.getValue() < this.minTableWidth) {
                String string = Integer.toString(this.minTableWidth);
                this.givenWidth = new Length(string);
            }
            this.scaleWidthWithFixedTableSize();
            return;
        }
        Measurement measurement = new Measurement();
        int n = this.getAvailableWidth();
        this.setForMinTableWidth(measurement, n);
        if (this.minTableWidth >= n) {
            this.tableWidth = this.minTableWidth;
        }
        this.adjustCellWidthsPerRow(measurement, n);
        this.scalePercentageColumnsByRow(measurement);
        this.tableWidth = this.growForSpanners(true, this.colInfo, this.tableWidth);
        this.apportionRemainingColumnSpace();
        this.tableWidth = this.sumAssignedSizes(this.colInfo);
        if (this.tableWidth > n) {
            this.scaleWidthBackToFit();
        }
    }

    private void setForMinTableWidth(Measurement measurement, int n) {
        int n2 = 0;
        while (n2 < this.numRows) {
            int n3 = -this.cellSpacing;
            int n4 = -this.cellSpacing;
            int n5 = 0;
            while (n5 < this.numCols) {
                TableElementPanel tableElementPanel = this.tableGridArray[n2][n5];
                if (tableElementPanel != null) {
                    TableElementPanel tableElementPanel2;
                    int n6 = n5 + 1;
                    TableElementPanel tableElementPanel3 = tableElementPanel2 = n6 < this.numCols ? this.tableGridArray[n2][n6] : null;
                    if (tableElementPanel2 != tableElementPanel) {
                        int n7;
                        measurement.reset();
                        tableElementPanel.measure(measurement);
                        int n8 = measurement.getMinWidth();
                        n4 += measurement.getPreferredWidth() + this.cellSpacing;
                        if (tableElementPanel.getColSpan() == 1 && (n7 = this.colInfo.getAssignedSize(n5)) < n8) {
                            this.colInfo.setAssignedSize(n5, n8);
                        }
                        n3 += n8 + this.cellSpacing;
                    }
                }
                ++n5;
            }
            this.minTableWidth = Math.max(this.minTableWidth, Math.max(n3, this.sumAssignedSizes(this.colInfo)));
            if (this.tableWidth < n4) {
                this.tableWidth = n4;
            }
            if (this.minTableWidth <= n) {
                int n9 = 0;
                while (n9 < this.numCols) {
                    TableElementPanel tableElementPanel = this.tableGridArray[n2][n9];
                    if (tableElementPanel != null) {
                        TableElementPanel tableElementPanel4;
                        int n10 = n9 + 1;
                        TableElementPanel tableElementPanel5 = tableElementPanel4 = n10 < this.numCols ? this.tableGridArray[n2][n10] : null;
                        if (tableElementPanel4 != tableElementPanel) {
                            measurement.reset();
                            tableElementPanel.measure(measurement);
                            Length length = tableElementPanel.getCellWidth();
                            if (length.isSet() && length.isPercentage() && !tableElementPanel.isEmpty()) {
                                int n11 = (int)((double)measurement.getPreferredWidth() * 100.0 / (double)length.getValue());
                                this.tableWidth = this.tableWidth >= n11 ? this.tableWidth : n11;
                            }
                        }
                    }
                    ++n9;
                }
            }
            ++n2;
        }
    }

    private void adjustCellWidthsPerRow(Measurement measurement, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numCols) {
            n3 = 10000;
            n2 = -1;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            int n13 = 0;
            while (n13 < this.numRows) {
                TableElementPanel tableElementPanel = this.tableGridArray[n13][n5];
                if (tableElementPanel != null && tableElementPanel.getColSpan() == 1) {
                    measurement.reset();
                    tableElementPanel.measure(measurement);
                    n6 = Math.max(n6, measurement.getMinWidth());
                    n10 = measurement.getPreferredWidth();
                    n7 = Math.max(n7, n10);
                    Length length = tableElementPanel.getCellWidth();
                    if (length.isSet()) {
                        int n14 = length.getValue();
                        if (length.isPercentage() && !tableElementPanel.isEmpty()) {
                            if (n3 > n14) {
                                n3 = n14;
                            }
                            if (n2 < n14) {
                                n2 = n14;
                            }
                        } else {
                            n8 = Math.max(n8, n14);
                        }
                    } else {
                        n9 = n7;
                    }
                }
                ++n13;
            }
            if (n2 > 0) {
                if (n8 > 0) {
                    n11 = n3;
                    n12 = Math.max(n8, n6);
                } else {
                    n11 = n2;
                    n12 = n7;
                }
                n4 += n11;
            } else {
                n11 = -1;
                n12 = n8;
                if (n9 > 0) {
                    n12 = Math.max(n12, n7);
                }
            }
            this.colInfo.setAssignedSize(n5, n12, n11);
            ++n5;
        }
        if (n4 > 100) {
            n3 = 0;
            while (n3 < this.numCols) {
                n2 = this.colInfo.getPercentage(n3);
                if (n2 > 0) {
                    this.colInfo.setPercentage(n3, Math.max(1, n2 * 100 / n4));
                }
                ++n3;
            }
        }
    }

    private void scalePercentageColumnsByRow(Measurement measurement) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 10000;
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.numCols) {
            n3 = this.colInfo.getPercentage(n8);
            n2 = this.colInfo.getAssignedSize(n8);
            if (n3 == -1) {
                n4 += n2;
            } else {
                n5 += n3;
                if (n6 > n3) {
                    n6 = n3;
                }
                if ((n = n2 * 100 / n3) > n7) {
                    n7 = n;
                }
            }
            ++n8;
        }
        n3 = 0;
        if (n4 != 0) {
            if (n5 == 100) {
                --n5;
            }
            n3 = n4 * 100 / (100 - n5);
        }
        this.tableWidth = Math.max(this.tableWidth, Math.max(n7, n3));
        n2 = 0;
        while (n2 < this.numCols) {
            n = this.colInfo.getPercentage(n2);
            if (n != -1) {
                int n9 = this.tableWidth * n / 100;
                this.colInfo.setAssignedSize(n2, n9);
            }
            ++n2;
        }
    }

    private void apportionRemainingColumnSpace() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numCols) {
            if (this.isPercent(n3)) {
                n += this.colInfo.getAssignedSize(n3);
            } else {
                n2 += this.getPreferredColWidth(n3);
            }
            ++n3;
        }
        if (n == 0) {
            return;
        }
        if (n2 > 0) {
            int n4 = this.tableWidth - n;
            int n5 = 0;
            while (n5 < this.numCols) {
                if (!this.isPercent(n5)) {
                    int n6 = this.getPreferredColWidth(n5) * n4 / n2;
                    this.colInfo.setAssignedSize(n5, n6);
                }
                ++n5;
            }
        }
    }

    private void scaleWidthUpToFit() {
        int n = this.cellSpacing * (this.numCols - 1);
        int n2 = this.getDesiredWidth();
        double d = ((double)n2 - (double)n) / (double)(this.tableWidth - n);
        this.tableWidth = n2;
        int n3 = 0;
        while (n3 < this.numCols) {
            int n4 = this.colInfo.getAssignedSize(n3);
            n4 = (int)((double)n4 * d);
            this.colInfo.setAssignedSize(n3, n4);
            ++n3;
        }
    }

    private int getDesiredWidth() {
        int n = this.maxWidth == 0 ? this.parentFormatter.getAvailableWidth(this.item.getIndex() << 12) : this.maxWidth;
        int n2 = 0;
        if (this.givenWidth.isSet()) {
            n2 = this.givenWidth.isPercentage() ? (int)((double)n * ((double)this.givenWidth.getValue() / 100.0)) : this.givenWidth.getValue();
            n2 -= 2 * (this.borderWidth + this.cellSpacing);
        }
        return n2;
    }

    private boolean isPercent(int n) {
        int n2 = 0;
        while (n2 < this.numRows) {
            Length length;
            TableElementPanel tableElementPanel = this.tableGridArray[n2][n];
            if (tableElementPanel != null && tableElementPanel.getColSpan() <= 1 && (length = tableElementPanel.getCellWidth()).isSet() && length.isPercentage()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int getPreferredColWidth(int n) {
        Measurement measurement = new Measurement();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            TableElementPanel tableElementPanel = this.tableGridArray[n3][n];
            if (tableElementPanel != null && tableElementPanel.getColSpan() <= 1) {
                measurement.reset();
                tableElementPanel.measure(measurement);
                n2 = Math.max(n2, measurement.getPreferredWidth());
            }
            ++n3;
        }
        return n2;
    }

    private int getMinColWidth(int n) {
        Measurement measurement = new Measurement();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            TableElementPanel tableElementPanel = this.tableGrid.elementAt(n, n3);
            if (tableElementPanel != null && tableElementPanel.getColSpan() <= 1) {
                measurement.reset();
                tableElementPanel.measure(measurement);
                n2 = Math.max(n2, measurement.getMinWidth());
            }
            ++n3;
        }
        return n2;
    }

    private void setMinColWidth(int n, int n2) {
        if (n < 0 || n > this.numCols - 1) {
            return;
        }
        int n3 = 0;
        while (n3 < this.numRows) {
            TableElementPanel tableElementPanel = this.tableGridArray[n3][n];
            if (tableElementPanel != null && tableElementPanel.getColSpan() <= 1) {
                tableElementPanel.setMinWidth(n2);
                return;
            }
            ++n3;
        }
    }

    private void scaleWidthWithFixedTableSize() {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        int n4 = this.getDesiredWidth();
        Measurement measurement = new Measurement();
        boolean[] blArray = new boolean[this.numRows];
        this.minTableWidth = -this.cellSpacing;
        int[] nArray = new int[this.numCols];
        int n5 = 0;
        while (n5 < this.numCols) {
            n3 = -1;
            n2 = -1;
            nArray[n5] = 0;
            n = 0;
            while (n < this.numRows) {
                TableElementPanel tableElementPanel = this.tableGrid.elementAt(n5, n);
                if (tableElementPanel != null) {
                    if (tableElementPanel.getColSpan() > 1) {
                        blArray[n] = true;
                    } else {
                        measurement.reset();
                        tableElementPanel.measure(measurement);
                        nArray[n5] = Math.max(nArray[n5], measurement.getMinWidth());
                        serializable = tableElementPanel.getCellWidth();
                        if (((Length)serializable).isSet()) {
                            n3 = ((Length)serializable).isPercentage() ? Math.max(n3, n4 * ((Length)serializable).getValue() / 100) : Math.max(n3, ((Length)serializable).getValue());
                        } else {
                            n2 = Math.max(n2, measurement.getPreferredWidth());
                        }
                    }
                }
                ++n;
            }
            this.minTableWidth += nArray[n5] + this.cellSpacing;
            n3 = n3 < 0 ? n2 : Math.max(n3, nArray[n5]);
            this.colInfo.setAssignedSize(n5, n3);
            ++n5;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < this.numRows) {
            if (blArray[n2]) {
                n = -this.cellSpacing;
                int n6 = 0;
                while (n6 < this.numCols) {
                    serializable = this.tableGridArray[n2][n6];
                    if (serializable != null) {
                        if (((TableElementPanel)serializable).getColSpan() > 1) {
                            measurement.reset();
                            ((TableElementPanel)serializable).measure(measurement);
                            n += measurement.getMinWidth() + this.cellSpacing;
                            n6 += ((TableElementPanel)serializable).getColSpan() - 1;
                        } else {
                            n += nArray[n6] + this.cellSpacing;
                        }
                    }
                    ++n6;
                }
                n3 = Math.max(n3, n);
            }
            ++n2;
        }
        this.minTableWidth = Math.max(this.minTableWidth, n3);
        this.tableWidth = Math.max(this.sumAssignedSizes(this.colInfo), this.minTableWidth);
        this.tableWidth = this.growForSpanners(true, this.colInfo, this.tableWidth);
        if (this.tableWidth > n4) {
            this.scaleWidthBackToFit();
            return;
        }
        if (this.tableWidth < n4 && !this.expandUnconstrainedColumns()) {
            this.scaleWidthUpToFit();
        }
    }

    private boolean expandUnconstrainedColumns() {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.numCols) {
            if (!this.colIsConstrained(n3)) {
                ++n;
                n2 = n3;
            }
            ++n3;
        }
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            int n4 = this.getDesiredWidth();
            int n5 = this.colInfo.getAssignedSize(n2);
            this.colInfo.setAssignedSize(n2, n5 += n4 - this.tableWidth);
            this.tableWidth = n4;
            return true;
        }
        int n6 = this.getDesiredWidth();
        int n7 = n;
        int n8 = 0;
        while (n7 > 0 && n8 < this.numCols) {
            if (!this.colIsConstrained(n8)) {
                int n9 = (n6 - this.tableWidth) / n7;
                int n10 = this.colInfo.getAssignedSize(n8);
                this.tableWidth += n9;
                this.colInfo.setAssignedSize(n8, n10 += n9);
                --n7;
            }
            ++n8;
        }
        return true;
    }

    private boolean colIsConstrained(int n) {
        int n2 = 0;
        while (n2 < this.numRows) {
            Length length;
            TableElementPanel tableElementPanel = this.tableGrid.elementAt(n, n2);
            if (tableElementPanel != null && tableElementPanel.getColSpan() <= 1 && (length = tableElementPanel.getCellWidth()).isSet()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int sumAssignedSizes(CellInfoVector cellInfoVector) {
        int n = cellInfoVector.length();
        int n2 = -this.cellSpacing;
        int n3 = 0;
        while (n3 < n) {
            n2 += cellInfoVector.getAssignedSize(n3) + this.cellSpacing;
            ++n3;
        }
        return n2;
    }

    private void distributeLeftoverSpace(int n, CellInfoVector cellInfoVector) {
        int n2;
        int n3 = n - this.sumAssignedSizes(cellInfoVector);
        if (n3 > 0 && (n2 = cellInfoVector.length()) > 0) {
            int n4 = (n3 + n2 - 1) / n2;
            int n5 = 0;
            while (n5 < n2 && n3 > 0) {
                int n6 = cellInfoVector.getAssignedSize(n5) + n4;
                cellInfoVector.setAssignedSize(n5, n6);
                n3 -= n4;
                ++n5;
            }
        }
    }

    private void scaleWidthBackToFit() {
        int n = this.getAvailableWidth();
        n = Math.max(n, this.minTableWidth);
        int n2 = this.cellSpacing * (this.numCols - 1);
        double d = 1.0;
        if (this.tableWidth != this.minTableWidth) {
            d = ((double)n - (double)n2 - (double)this.minTableWidth) / (double)(this.tableWidth - this.minTableWidth);
        }
        this.tableWidth = n;
        int n3 = 0;
        while (n3 < this.numCols) {
            int n4 = this.colInfo.getAssignedSize(n3);
            int n5 = this.getMinColWidth(n3);
            n4 = n5 + (int)((double)(n4 - n5) * d);
            this.colInfo.setAssignedSize(n3, n4);
            ++n3;
        }
    }

    private int scaleForPercentages(CellInfoVector cellInfoVector, int n) {
        int n2 = n;
        int n3 = cellInfoVector.getMaxSpan();
        int n4 = cellInfoVector.length();
        int n5 = 1;
        while (n5 <= n3) {
            int n6 = 0;
            while (n6 < n4) {
                ConstraintSummary constraintSummary = cellInfoVector.getConstraintFor(n6, n5);
                if (constraintSummary != null && constraintSummary.minPercent >= 0) {
                    double d = (double)constraintSummary.minPercent / 100.0;
                    int n7 = constraintSummary.prefSize;
                    int n8 = this.getSubordinateLength(cellInfoVector, n6, n5);
                    if (d * (double)n2 < (double)(n7 = Math.max(n7, n8))) {
                        n2 = (int)((double)n7 / d);
                    }
                }
                ++n6;
            }
            ++n5;
        }
        return Math.max(n2, this.getGivenHeight());
    }

    private int growForSpanners(boolean bl, CellInfoVector cellInfoVector, int n) {
        int n2 = cellInfoVector.getMaxSpan();
        int n3 = cellInfoVector.length();
        int n4 = n;
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = cellInfoVector.getAssignedSize(n5);
            ++n5;
        }
        int n6 = 2;
        while (n6 <= n2) {
            int n7 = 0;
            while (n7 < n3) {
                block10: {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    block11: {
                        int n12;
                        int n13;
                        ConstraintSummary constraintSummary = cellInfoVector.getConstraintFor(n7, n6);
                        if (constraintSummary == null) break block10;
                        n11 = Math.max(n7 - n6 + 1, 0);
                        n10 = constraintSummary.minSize + this.cellSpacing;
                        n9 = -this.cellSpacing;
                        n8 = -this.cellSpacing;
                        int n14 = n11;
                        while (n14 <= n7) {
                            if (bl) {
                                n8 += this.getMinColWidth(n14) + this.cellSpacing;
                            }
                            n9 += nArray[n14] + this.cellSpacing;
                            ++n14;
                        }
                        if (n10 <= n9) break block11;
                        int n15 = (n6 - 1) * this.cellSpacing;
                        double d = 1.0;
                        if (n9 - n15 > 0) {
                            d = (double)(n10 - n15) / (double)(n9 - n15);
                        }
                        int n16 = n10 - n9;
                        n4 += n16;
                        int n17 = -this.cellSpacing;
                        int n18 = n11;
                        while (n18 <= n7) {
                            n13 = nArray[n18];
                            n12 = (int)((double)n13 * d);
                            n17 += n12 + this.cellSpacing;
                            cellInfoVector.setAssignedSize(n18, n12);
                            if (bl) {
                                this.setMinColWidth(n18, n12);
                            }
                            ++n18;
                        }
                        n13 = n10 - n17;
                        if (n13 <= 0) break block10;
                        n12 = cellInfoVector.getAssignedSize(n7);
                        cellInfoVector.setAssignedSize(n7, n12 += n13);
                        if (!bl) break block10;
                        this.setMinColWidth(n7, n12);
                        break block10;
                    }
                    if (bl && n10 > n8) {
                        float f = (float)n10 / (float)n9;
                        int n19 = n11;
                        while (n19 <= n7) {
                            int n20 = nArray[n19];
                            this.setMinColWidth(n19, (int)(f * (float)n20));
                            ++n19;
                        }
                    }
                }
                ++n7;
            }
            ++n6;
        }
        return n4;
    }

    private int getMinSize(CellInfoVector cellInfoVector) {
        int n = cellInfoVector.length() - 1;
        CellSpec cellSpec = cellInfoVector.cells[n];
        return cellSpec.cumulativeMinSize;
    }

    private void apportionSpace(CellInfoVector cellInfoVector, int n) {
        ConstraintSummary constraintSummary;
        int n2;
        int n3 = cellInfoVector.length();
        int n4 = -this.cellSpacing;
        int n5 = 0;
        while (n5 < n3) {
            n2 = 0;
            constraintSummary = cellInfoVector.getConstraintFor(n5, 1);
            if (constraintSummary != null) {
                n2 = constraintSummary.prefSize;
            }
            cellInfoVector.setAssignedSize(n5, n2);
            n4 += n2 + this.cellSpacing;
            ++n5;
        }
        if (n4 < n) {
            n2 = this.cellSpacing * (n3 - 1);
            double d = (double)(n - n2) / (double)(n4 - n2);
            int n6 = 0;
            while (n6 < n3) {
                int n7 = cellInfoVector.getAssignedSize(n6);
                constraintSummary = cellInfoVector.getConstraintFor(n6, 1);
                int n8 = constraintSummary == null || constraintSummary.minPercent < 0 ? (int)((double)n7 * d) : (int)((double)constraintSummary.minPercent / 100.0 * (double)n);
                cellInfoVector.setAssignedSize(n6, n8);
                ++n6;
            }
        }
    }

    private void measureTableHeight() {
        Measurement measurement = new Measurement();
        int n = 0;
        while (n < this.numRows) {
            ConstraintSummary constraintSummary;
            int n2 = 0;
            while (n2 < this.numCols) {
                TableElementPanel tableElementPanel = this.tableGridArray[n][n2];
                if (tableElementPanel != null) {
                    ConstraintSummary constraintSummary2 = constraintSummary = n + 1 < this.numRows ? this.tableGridArray[n + 1][n2] : null;
                    if (constraintSummary != tableElementPanel) {
                        int n3 = tableElementPanel.getElementHeight();
                        int n4 = -1;
                        Length length = tableElementPanel.getCellHeight();
                        if (length.isSet()) {
                            if (length.isPercentage()) {
                                n4 = length.getValue();
                            } else if (n3 < length.getValue()) {
                                n3 = length.getValue();
                            }
                        }
                        measurement.reset();
                        measurement.setMinWidth(n3);
                        measurement.setPreferredWidth(n3);
                        int n5 = tableElementPanel.getRowSpan();
                        this.rowInfo.addConstraintInfo(n, n5, measurement, n4);
                    }
                }
                ++n2;
            }
            int n6 = 0;
            constraintSummary = this.rowInfo.getConstraintFor(n, 1);
            if (constraintSummary != null) {
                n6 = constraintSummary.prefSize;
            }
            this.rowInfo.setAssignedSize(n, n6);
            ++n;
        }
        this.growForSpanners(false, this.rowInfo, 0);
        this.tableHeight = Math.max(this.sumAssignedSizes(this.rowInfo), this.getGivenHeight());
    }

    private void resizeTableToFit() {
        this.setSize(this.tableWidth + 2 * (this.borderWidth + this.cellSpacing), this.tableHeight + 2 * (this.borderWidth + this.cellSpacing));
    }

    void measureWidth(Measurement measurement, MeasureState measureState) {
        this.measure(measurement, measureState);
        measurement.adjustBy(2 * (this.borderWidth + this.cellSpacing));
    }

    void measure(Measurement measurement, MeasureState measureState) {
        int n;
        Measurement measurement2 = new Measurement();
        int n2 = 0;
        while (n2 < this.numCols) {
            n = 0;
            while (n < this.numRows) {
                TableElementPanel tableElementPanel;
                TableElementPanel tableElementPanel2 = this.tableGrid.elementAt(n2, n);
                if (tableElementPanel2 != null && (tableElementPanel = this.tableGrid.elementAt(n2 + 1, n)) != tableElementPanel2) {
                    measurement2.reset();
                    tableElementPanel2.measure(measurement2);
                    int n3 = -1;
                    Length length = tableElementPanel2.getCellWidth();
                    if (length.isSet() && length.isPercentage()) {
                        n3 = length.getValue();
                    }
                    this.colInfo.addConstraintInfo(n2, tableElementPanel2.getColSpan(), measurement2, n3);
                }
                ++n;
            }
            ++n2;
        }
        this.colInfo.measure(measurement);
        if (this.givenWidth.isSet()) {
            n = this.givenWidth.isPercentage() ? (int)((double)this.givenWidth.getValue() / 100.0 * (double)(this.maxWidth == 0 ? this.parentFormatter.getAvailableWidth(this.item.getIndex() << 12) : this.maxWidth)) : this.givenWidth.getValue();
            if (n > measurement.getMinWidth()) {
                measurement.setMinWidth(n);
                measurement.setPreferredWidth(n);
                return;
            }
            measurement.setPreferredWidth(measurement.getMinWidth());
        }
    }

    private int getSubordinateLength(CellInfoVector cellInfoVector, int n, int n2) {
        if (n2 == 1) {
            return 0;
        }
        int n3 = -this.cellSpacing;
        int n4 = n - n2 + 1;
        while (n4 <= n) {
            ConstraintSummary constraintSummary = cellInfoVector.getConstraintFor(n4, 1);
            if (constraintSummary != null) {
                n3 += constraintSummary.prefSize + this.cellSpacing;
            }
            ++n4;
        }
        return n3;
    }

    private int getMinSubordinateLength(CellInfoVector cellInfoVector, int n, int n2) {
        if (n2 == 1) {
            return 0;
        }
        int n3 = -this.cellSpacing;
        int n4 = n - n2 + 1;
        while (n4 <= n) {
            ConstraintSummary constraintSummary = cellInfoVector.getConstraintFor(n4, 1);
            if (constraintSummary != null) {
                n3 += constraintSummary.minSize + this.cellSpacing;
            }
            ++n4;
        }
        return n3;
    }

    public Formatter getParentFormatter() {
        return this.parentFormatter;
    }

    void touch(boolean bl, int n) {
        this.parentFormatter.touch(bl, n, this.item);
    }

    void touch(boolean bl, int n, DocItem docItem) {
        this.parentFormatter.touch(bl, n, this.item);
    }

    public void addTablePanelFormatters(Vector vector) {
        Enumeration enumeration = this.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            vector.addElement(tableElementPanel.current);
        }
    }

    public void setObsolete(boolean bl) {
    }
}

