/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

public class RequestProcessor
implements Runnable {
    private RequestNode requestQueue;
    private RequestNode nodeSave;
    private Thread dispatcher;
    private boolean shutdown = false;
    private long restartInterval;
    private final Object lock = new Object();
    private static final long defaultRestartInterval = 300000L;
    private static RequestProcessor hjBeanQueue = null;

    public boolean isCurrentThread() {
        return Thread.currentThread() == this.dispatcher;
    }

    public void postRequest(Request request) {
        this.postRequest(request, 0);
    }

    public void postRequest(Request request, int n) {
        long l = (long)n + System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            RequestNode requestNode = this.nodeSave;
            this.nodeSave = null;
            if (requestNode == null) {
                requestNode = new RequestNode();
            }
            requestNode.request = request;
            requestNode.when = l;
            if (this.requestQueue == null) {
                this.requestQueue = requestNode;
            } else if (this.requestQueue.when > requestNode.when) {
                requestNode.next = this.requestQueue;
                this.requestQueue = requestNode;
            } else {
                RequestNode requestNode2 = this.requestQueue;
                while (requestNode2.next != null && requestNode2.next.when <= requestNode.when) {
                    requestNode2 = requestNode2.next;
                }
                requestNode.next = requestNode2.next;
                requestNode2.next = requestNode;
            }
            this.lock.notifyAll();
            return;
        }
    }

    public void run() {
        String string;
        Object object;
        long l = System.currentTimeMillis() + this.restartInterval;
        while (System.currentTimeMillis() < l) {
            object = null;
            try {
                try {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        long l2;
                        while (this.requestQueue == null) {
                            l2 = l - System.currentTimeMillis();
                            if (l2 > 0L) {
                                this.lock.wait(l2);
                            }
                            if (System.currentTimeMillis() <= l) continue;
                            throw new InterruptedException();
                        }
                        l2 = System.currentTimeMillis();
                        while (this.requestQueue.when > l2) {
                            this.lock.wait(this.requestQueue.when - l2);
                            l2 = System.currentTimeMillis();
                        }
                        object = this.requestQueue;
                        this.requestQueue = this.requestQueue.next;
                    }
                    ((RequestNode)object).request.execute();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    System.out.println("Exception on request processor: <" + throwable + ">");
                    throwable.printStackTrace();
                }
                string = null;
                if (object == null) continue;
                ((RequestNode)object).request = null;
                ((RequestNode)object).next = null;
                this.nodeSave = object;
            }
            catch (Throwable throwable) {
                string = null;
                if (object != null) {
                    ((RequestNode)object).request = null;
                    ((RequestNode)object).next = null;
                    this.nodeSave = object;
                }
                throw throwable;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.shutdown) {
                string = this.dispatcher.getName();
                int n = this.dispatcher.getPriority();
                this.dispatcher = new Thread((Runnable)this, string);
                this.dispatcher.setPriority(n);
                this.dispatcher.start();
            }
            return;
        }
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.dispatcher.interrupt();
    }

    public RequestProcessor(String string) {
        this(string, 300000L);
    }

    public RequestProcessor(String string, long l) {
        this.restartInterval = l;
        this.dispatcher = new Thread((Runnable)this, string);
        this.dispatcher.setPriority(7);
        this.dispatcher.start();
    }

    public static RequestProcessor getHJBeanQueue() {
        if (hjBeanQueue == null) {
            hjBeanQueue = new RequestProcessor("HotJava bean request queue");
        }
        return hjBeanQueue;
    }

    public static abstract class Request {
        public abstract void execute();
    }

    private static final class RequestNode {
        Request request;
        long when;
        RequestNode next;

        RequestNode() {
        }
    }
}

