/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.bean.ImageCacher;
import sunw.hotjava.doc.BasefontTagRecord;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocError;
import sunw.hotjava.doc.DocException;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocItemEnumeration;
import sunw.hotjava.doc.DocNotEditableException;
import sunw.hotjava.doc.DocParser;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.DocView;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventMulticaster;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.EndTagItem;
import sunw.hotjava.doc.FlowTagItem;
import sunw.hotjava.doc.OverlappingStringMatch;
import sunw.hotjava.doc.Range;
import sunw.hotjava.doc.SizeItem;
import sunw.hotjava.doc.StyleSheet;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextItem;
import sunw.hotjava.forms.FORM;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.URLConnector;
import sunw.hotjava.tags.APPLET;
import sunw.hotjava.tags.FRAME;
import sunw.hotjava.tags.FRAMESET;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.IMG;
import sunw.hotjava.tags.ImageMap;
import sunw.html.Attributes;
import sunw.html.DTD;
import sunw.html.Element;
import sunw.html.HTMLOutputWriter;
import sunw.html.Parser;
import sunw.html.Tag;

public final class Document
implements DocConstants,
PropertyChangeListener,
DocumentEventSource,
UpdateClient {
    private int state;
    private boolean reloaded = false;
    private Thread owner;
    private Parser currentParser;
    private String pragma;
    private Hashtable props = new Hashtable(11);
    private int ncompleted = 524287;
    public int nitems;
    public DocItem[] items = new DocItem[10];
    private int endPtr = this.items.length;
    private DocumentEventMulticaster listeners = new DocumentEventMulticaster();
    private int nviews;
    private DocView[] views = new DocView[4];
    private BasefontTagRecord basefontTagRecord;
    private URLConnector connector;
    private boolean parsingCompleted = false;
    private String documentError;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private VetoableChangeSupport vchanges = new VetoableChangeSupport(this);
    private Hashtable imageMaps;
    private Hashtable sizeItemListWidth;
    private Hashtable sizeItemListHeight;
    private static final Integer dummyInt = new Integer(0);
    private boolean bIsOkToFormat = false;
    private Hashtable javaScriptTags;
    private boolean framed = false;
    private Stack timeOutStack = new Stack();
    private String clientPullSpec;
    private CharArrayWriter cw = new CharArrayWriter();
    private byte[] srcBuffer;
    private int srcLength;
    private static Hashtable tagClassCache = new Hashtable();
    private static boolean GZIPOutputStream;
    private static Constructor GZIPOutputStreamCon;
    private static Method GZIPOutputStreamWrite;
    private static Method GZIPOutputStreamClose;
    private static boolean GZIPInputStream;
    private static Constructor GZIPInputStreamCon;
    private static Method GZIPInputStreamRead;
    private static Method GZIPInputStreamClose;
    private Vector frameList;
    private boolean windowHandlerExists = false;
    private boolean hasScriptWrites = false;
    private static final String[] windowHandlers;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$InputStream;

    public Document() {
        this(Globals.getDefaultDTD(), null, null, null, null);
    }

    public Document(String string) {
        this(Globals.getDefaultDTD(), null, string, null, null);
    }

    public Document(String string, String string2) {
        this(Globals.getDefaultDTD(), null, string, string2, null);
    }

    public Document(URL uRL) {
        this(Globals.getDefaultDTD(), uRL, null, null, null);
    }

    public Document(URL uRL, URL uRL2) {
        this(Globals.getDefaultDTD(), uRL, null, null, uRL2);
    }

    public Document(URL uRL, String string) {
        this(Globals.getDefaultDTD(), uRL, string, null, null);
    }

    public Document(DTD dTD, URL uRL, String string) {
        this(Globals.getDefaultDTD(), uRL, string, null, null);
    }

    public Document(DTD dTD, URL uRL, String string, String string2, URL uRL2) {
        this.basefontTagRecord = new BasefontTagRecord(this);
        try {
            this.setProperty("dtd", dTD);
            if (uRL != null) {
                this.setProperty("url", uRL);
            }
            if (string != null) {
                this.setProperty("title", string);
            }
            if (string2 != null) {
                this.setProperty("doctype", string2);
            }
            if (uRL2 != null) {
                this.setProperty("referer", uRL2);
            }
        }
        catch (DocException docException) {}
        this.sizeItemListWidth = new Hashtable();
        this.sizeItemListHeight = new Hashtable();
        this.bIsOkToFormat = false;
        this.setDocumentTitle(string);
    }

    public int hashCode() {
        Object object = this.getProperty("url");
        if (object != null) {
            return object.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object object) {
        Object object2;
        if (object == this) {
            return true;
        }
        return object != null && object instanceof Document && (object2 = ((Document)object).getProperty("url")) != null && object2.equals(this.getProperty("url"));
    }

    public boolean wasReloaded() {
        return this.reloaded;
    }

    public void setReloaded(boolean bl) {
        if (bl) {
            this.reloaded = true;
        }
    }

    public void setClientPullSpec(String string) {
        this.clientPullSpec = string;
    }

    public String getClientPullSpec() {
        return this.clientPullSpec;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public int getState() {
        return this.state;
    }

    public synchronized void setState(int n) throws DocBusyException {
        if (n >= 10 && this.owner != null && this.owner != Thread.currentThread()) {
            throw new DocBusyException(this, "document busy");
        }
        if (this.state != n) {
            this.state = n;
            this.dispatchDocumentEvent(1005, new Integer(n));
        }
    }

    public DocView[] getViews() {
        return this.views;
    }

    public DocView getView() {
        DocView docView = null;
        int n = 0;
        while (n < this.views.length) {
            if (this.views[n] != null && this.views[n] instanceof DocumentFormatter) {
                docView = this.views[n];
            }
            ++n;
        }
        return docView;
    }

    /*
     * Unable to fully structure code
     */
    private boolean needsActivation(int var1_1) {
        if (this.items[var1_1].needsActivation()) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.items[var1_1];
            var3_3 = var2_2.offset;
            if (var3_3 > 0) {
                if (!var2_2.needsActivation()) continue;
                return false;
            }
            if (var3_3 >= 0) continue;
            var1_1 += var3_3;
lbl10:
            // 4 sources

            ** while (var1_1-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public void setCompleted(int n) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n2;
                int n3;
                int n4;
                if (this.owner == null || this.owner != Thread.currentThread()) {
                    throw new DocBusyException(this, "not owner");
                }
                if (n == Integer.MAX_VALUE && this.getTagName(this.items[0]).equals("plaintext")) {
                    n4 = 0;
                    while (n4 < this.items.length && this.items[n4] != null) {
                        ++n4;
                    }
                    this.endTagComplete(this.items[0], n4 << 12);
                }
                if (this.ncompleted < (n4 = n >> 12)) {
                    n3 = Math.min(this.nitems, n4);
                    n2 = this.ncompleted;
                    while (n2 < n3) {
                        int n5 = this.items[n2].offset;
                        if (n5 <= 0 && this.needsActivation(n2 + n5)) {
                            this.notifyViews(20, n2 + n5 << 12, 1 - n5 << 12);
                        }
                        ++n2;
                    }
                } else {
                    n3 = Math.min(this.nitems, this.ncompleted);
                    n2 = n4;
                    while (n2 < n3) {
                        int n6 = this.items[n2].offset;
                        if (n6 <= 0 && this.needsActivation(n2 + n6)) {
                            this.notifyViews(21, n2 + n6 << 12, 1 - n6 << 12);
                        }
                        ++n2;
                    }
                }
                n3 = this.ncompleted;
                this.ncompleted = n4;
                if (n == Integer.MAX_VALUE) {
                    this.nitems = n3;
                    DocItem[] docItemArray = new DocItem[this.nitems];
                    System.arraycopy(this.items, 0, docItemArray, 0, this.nitems);
                    this.items = docItemArray;
                    this.endPtr = this.nitems;
                    if (this.wasReloaded()) {
                        DocumentCache.putDocument(this);
                    }
                    this.notifyViews(22, 0, Integer.MAX_VALUE);
                    this.parsingCompleted = true;
                    this.dispatchFormatScreen();
                }
            }
            return;
        }
    }

    public void setParsingCompleted(boolean bl) {
        this.parsingCompleted = bl;
    }

    public boolean doneParsing() {
        return this.parsingCompleted;
    }

    public String getPragma() {
        return this.pragma;
    }

    public void setPragma(String string) {
        this.pragma = string;
    }

    public Object getProperty(String string) {
        return this.props.get(string);
    }

    public Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (object2 != null) {
            return object2;
        }
        return object;
    }

    public DTD getDTD() {
        return (DTD)this.getProperty("dtd");
    }

    public URL getURL() {
        return (URL)this.getProperty("url");
    }

    public URL getReferer() {
        return (URL)this.getProperty("referer");
    }

    public URL getBaseURL() {
        URL uRL = (URL)this.getProperty("base");
        if (uRL != null) {
            return uRL;
        }
        return this.getURL();
    }

    public String getTitle() {
        return (String)this.getProperty("title");
    }

    public String getDoctype() {
        return (String)this.getProperty("doctype");
    }

    public String getTitleString() {
        String string = this.getTitle();
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        if (string == null || string.equals("")) {
            string = hJBProperties.getProperty("hotjava.untitled");
            URL uRL = this.getURL();
            if (uRL != null) {
                string = String.valueOf(string) + " (" + uRL + ")";
            }
        }
        return string;
    }

    public Document getDocThisIsSourceOf() {
        return (Document)this.getProperty("docThisIsSourceOf");
    }

    public Date getExpirationDate() {
        return (Date)this.getProperty("expiration-date");
    }

    public void setExpirationDate(Date date) {
        try {
            this.setProperty("expiration-date", date);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public Date getLastModifiedDate() {
        return (Date)this.getProperty("last-modified");
    }

    public void setLastModifiedDate(Date date) {
        try {
            this.setProperty("last-modified", date);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public void setProperty(String string, Object object) throws DocException {
        Object object2 = Globals.getAwtLock();
        synchronized (object2) {
            Document document = this;
            synchronized (document) {
                if (this.changeNotVetoed(string, object)) {
                    this.modify();
                    if (object == null) {
                        this.props.remove(string);
                    } else {
                        this.props.put(string, object);
                    }
                    this.dispatchDocumentEvent(1004, string);
                }
            }
            return;
        }
    }

    public Thread getOwner() {
        return this.owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setOwner(int n, Thread thread) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3 = this.state;
                if (this.owner != null && this.owner != Thread.currentThread()) {
                    throw new DocBusyException(this, "not owner");
                }
                this.owner = thread;
                if (this.state == n) return n3;
                this.state = n;
                this.dispatchDocumentEvent(1005, new Integer(n));
                return n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setOwner(int n, Thread thread, Parser parser) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3 = this.setOwner(n, thread);
                this.currentParser = parser;
                if (!(parser instanceof DocParser)) return n3;
                ((DocParser)parser).addPropertyChangeListener(this);
                return n3;
            }
        }
    }

    public Parser getParser() {
        return this.currentParser;
    }

    public BasefontTagRecord getBasefontTagRecord() {
        return this.basefontTagRecord;
    }

    public int basefontSizeAt(DocStyle docStyle, int n) {
        return this.basefontTagRecord.basefontSizeAt(docStyle, n);
    }

    public int length() {
        return this.nitems << 12;
    }

    public synchronized void interruptOwner() {
        if (this.owner != null) {
            this.owner.interrupt();
        }
    }

    public void interruptOwnerWaitCompletion() {
        Thread thread;
        if (this.owner == null) {
            return;
        }
        Object object = this.owner;
        synchronized (object) {
            thread = this.owner;
            this.owner.interrupt();
        }
        try {
            thread.setPriority(2);
        }
        catch (NullPointerException nullPointerException) {}
        object = new Properties();
        ((Hashtable)object).put("baseurl", this.getBaseURL().toExternalForm());
        this.dispatchDocumentEvent(1012, object);
        if (this.state != 11) {
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
        this.state = 15;
    }

    private void dispatchDocumentEvent(int n, Object object) {
        DocumentEvent documentEvent = new DocumentEvent(this, n, object);
        documentEvent.setDocument(this);
        this.listeners.documentChanged(documentEvent);
    }

    public void notifyViews(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.nviews) {
            this.views[n4].notify(this, n, n2, n3);
            ++n4;
        }
    }

    public int countViews() {
        return this.nviews;
    }

    public void addView(DocView docView) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (this.nviews >= this.views.length) {
                    DocView[] docViewArray = new DocView[this.nviews + 8];
                    System.arraycopy(this.views, 0, docViewArray, 0, this.nviews);
                    this.views = docViewArray;
                }
                this.views[this.nviews++] = docView;
                docView.notify(this, 15, 0, this.nitems << 12);
                int n = 0;
                while (n < this.nitems) {
                    int n2;
                    DocItem docItem = this.items[n];
                    if (docItem != null && (n2 = docItem.offset) >= 0 && n + n2 < this.ncompleted && this.needsActivation(n)) {
                        docView.notify(this, 20, n << 12, n2 + 1 << 12);
                    }
                    ++n;
                }
            }
            return;
        }
    }

    public void removeView(DocView docView) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n = 0;
                while (n < this.nviews) {
                    if (this.views[n] == docView) {
                        System.arraycopy(this.views, n + 1, this.views, n, this.nviews - (n + 1));
                        --this.nviews;
                        n = 0;
                        while (n < this.nitems) {
                            int n2;
                            DocItem docItem = this.items[n];
                            if (docItem != null && (n2 = docItem.offset) >= 0 && n + n2 < this.ncompleted && this.needsActivation(n)) {
                                docView.notify(this, 21, n << 12, n2 + 1 << 12);
                            }
                            ++n;
                        }
                        docView.notify(this, 16, 0, this.nitems << 12);
                        break;
                    }
                    ++n;
                }
                this.views[this.nviews] = null;
            }
            return;
        }
    }

    TagItem makeTag(String string) {
        return this.makeTag(this.getDTD().getElement(string), null);
    }

    TagItem makeTag(Element element, Attributes attributes) {
        TagItem tagItem;
        try {
            Class<?> clazz = (Class<?>)tagClassCache.get(element);
            if (clazz == null) {
                HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
                String string = hJBProperties.getProperty(String.valueOf(element.getName()) + ".class");
                if (string == null) {
                    string = "sunw.hotjava.tags." + element.getName().toUpperCase();
                }
                clazz = Class.forName(string);
                tagClassCache.put(element, clazz);
            }
            tagItem = (TagItem)clazz.newInstance();
        }
        catch (Exception exception) {
            tagItem = element.isEmpty() ? new EmptyTagItem() : new FlowTagItem();
        }
        tagItem.style = StyleSheet.getStyleSheet(element);
        tagItem.atts = attributes;
        try {
            tagItem.init(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tagItem;
    }

    synchronized void endTagComplete(DocItem docItem, int n) {
        int n2 = n >> 12;
        if (this.endPtr != n2) {
            DocItem docItem2;
            int n3;
            int n4 = docItem.index + docItem.offset;
            docItem.offset = n3 = n2 - docItem.index;
            this.items[n2] = docItem2 = this.items[n4];
            docItem2.offset = -n3;
            docItem2.setIndex(n2, this);
            this.items[this.endPtr] = null;
        }
        ++this.endPtr;
    }

    private void modify() throws DocBusyException, DocNotEditableException {
        switch (this.state) {
            case 0: {
                this.setState(2);
                return;
            }
            case 2: 
            case 4: {
                return;
            }
        }
        if (this.state >= 10) {
            if (this.owner != Thread.currentThread()) {
                throw new DocBusyException(this, "document busy");
            }
            return;
        }
        throw new DocNotEditableException(this, "document not editable: " + this.state);
    }

    private void insertItems(int n, int n2) {
        if (n + n2 > this.endPtr) {
            int n3 = Math.max(this.nitems + n2, this.items.length * 2);
            DocItem[] docItemArray = new DocItem[n3];
            int n4 = n3 - this.items.length;
            System.arraycopy(this.items, 0, docItemArray, 0, n);
            int n5 = this.endPtr + n4;
            System.arraycopy(this.items, this.endPtr, docItemArray, n5, this.items.length - this.endPtr);
            int n6 = n5;
            while (n6 < n3) {
                int n7;
                DocItem docItem = docItemArray[n6];
                docItem.offset = n7 = docItem.offset - n4;
                docItem.setIndex(n6, this);
                docItemArray[n6 + n7].offset = -n7;
                ++n6;
            }
            this.items = docItemArray;
            this.endPtr = n5;
        }
        this.nitems += n2;
    }

    private int deleteItems(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            n3 = this.items[n5].offset;
            if (n5 + n3 >= n2 || n3 < 0) {
                n4 = this.deleteItems(n5 + 1, n2);
                n2 = n5;
                break;
            }
            n5 += n3 + 1;
        }
        if (n < n2) {
            int n6;
            int n7;
            n3 = n;
            while (n3 < n2) {
                DocItem docItem = this.items[n3];
                n7 = docItem.offset;
                if (n7 >= 0 && n3 + n7 < this.ncompleted && this.needsActivation(n3)) {
                    this.notifyViews(21, n3 << 12, n7 + 1 << 12);
                }
                ++n3;
            }
            int n8 = n2 - n;
            System.arraycopy(this.items, n2, this.items, n, this.nitems - n2);
            this.nitems -= n8;
            this.basefontTagRecord.notifyDocItemsDeleted(n, n8);
            n7 = 0;
            while (n7 < n8) {
                this.items[this.nitems + n7] = null;
                ++n7;
            }
            if (this.nitems < this.items.length >> 1) {
                DocItem[] docItemArray = new DocItem[this.items.length >> 1];
                System.arraycopy(this.items, 0, docItemArray, 0, this.nitems);
                this.items = docItemArray;
            }
            int n9 = n - 1;
            while (n9 >= 0) {
                n6 = this.items[n9].offset;
                if (n6 > 0) {
                    this.items[n9].offset = n6 -= n8;
                    this.items[n9 + n6].offset = -n6;
                } else {
                    n9 += n6;
                }
                --n9;
            }
            n6 = n;
            while (n6 < this.nitems) {
                this.items[n6].setIndex(this.items[n6].index - n8, this);
                ++n6;
            }
            this.notifyViews(16, n << 12, n2 - n << 12);
        }
        return n4;
    }

    private int splitItem(int n) {
        DocItem docItem;
        if (n < 0) {
            return 0;
        }
        if (n > this.nitems << 12) {
            return this.nitems;
        }
        int n2 = n >> 12;
        if ((n & 0xFFF) == 0) {
            return n2;
        }
        if ((docItem = this.items[n2++].split(this, n)) != null) {
            this.insertItems(n2, 1);
            docItem.setIndex(n2, this);
            this.items[n2] = docItem;
            this.notifyViews(10, n, 0);
        }
        return n2;
    }

    public int insertTag(int n, String string, Attributes attributes) throws DocException {
        return this.insertTag(n, this.getDTD().getElement(string), attributes);
    }

    public int insertTag(int n, Element element, Attributes attributes) throws DocException {
        return this.insertTag(n, this.makeTag(element, attributes));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertTag(int n, TagItem tagItem) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                int n3 = this.splitItem(n);
                this.insertItems(n3, 1);
                tagItem.offset = 0;
                tagItem.setIndex(n3, this);
                this.items[n3] = tagItem;
                this.notifyViews(15, n3 << 12, 4096);
                if (n3 >= this.ncompleted) return n3 + 1 << 12;
                if (!this.needsActivation(n3)) return n3 + 1 << 12;
                this.notifyViews(20, n3 << 12, 4096);
                return n3 + 1 << 12;
            }
        }
    }

    public int insertTagPair(int n, String string, Attributes attributes) throws DocException {
        return this.insertTagPair(n, this.getDTD().getElement(string), attributes);
    }

    public int insertTagPair(int n, Element element, Attributes attributes) throws DocException {
        return this.insertTagPair(n, this.makeTag(element, attributes));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertTagPair(int n, TagItem tagItem) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                EndTagItem endTagItem = new EndTagItem();
                int n3 = this.splitItem(n);
                this.insertItems(n3, 2);
                --this.endPtr;
                tagItem.offset = this.endPtr - n3;
                tagItem.setIndex(n3, this);
                this.items[n3] = tagItem;
                endTagItem.offset = -tagItem.offset;
                endTagItem.setIndex(this.endPtr, this);
                this.items[this.endPtr] = endTagItem;
                this.notifyViews(15, n3 << 12, 8192);
                if (n3 + 1 >= this.ncompleted) return n3 + 1 << 12;
                if (!this.needsActivation(n3)) return n3 + 1 << 12;
                this.notifyViews(20, n3 << 12, 8192);
                return n3 + 1 << 12;
            }
        }
    }

    public int insert(int n, String string) throws DocException {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        return this.insert(n, cArray, 0, cArray.length);
    }

    public int insert(int n, int n2) throws DocException {
        char[] cArray = new char[]{(char)(n2 & 0xFFFF)};
        return this.insert(n, cArray, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insert(int n, char[] cArray, int n2, int n3) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                TextItem textItem;
                int n4;
                int n5;
                this.modify();
                if (n < 0) {
                    n = 0;
                } else if (n > this.nitems << 12) {
                    n = this.nitems << 12;
                }
                int n6 = n5 = n >> 12;
                if (n6 >= 0 && n6 < this.nitems && this.items[n6] != null && this.items[n6].isText() && (n4 = this.items[n6].insert(this, n, cArray, n2, n3)) != -1) {
                    this.notifyViews(12, n4 - n3, n3);
                    return n4;
                }
                if (n6 > 0 && (n & 0xFFF) == 0 && this.items[n6 - 1].isText() && (n4 = this.items[n6 - 1].insert(this, n - 1, cArray, n2, n3)) != -1) {
                    this.notifyViews(12, n4 - n3, n3);
                    return n4;
                }
                n6 = this.splitItem(n);
                n4 = 0;
                int n7 = n2;
                int n8 = n3 - n7;
                while (n8 > 4095) {
                    this.insertItems(n6, 1);
                    textItem = new TextItem(cArray, n7, 4095);
                    ++n4;
                    textItem.offset = 0;
                    textItem.setIndex(n6, this);
                    this.items[n6] = textItem;
                    n7 += 4095;
                    n8 -= 4095;
                    ++n6;
                }
                this.insertItems(n6, 1);
                textItem = new TextItem(cArray, n7, n8);
                textItem.offset = 0;
                textItem.setIndex(n6, this);
                this.items[n6] = textItem;
                ++this.ncompleted;
                this.notifyViews(15, n5 << 12, ++n4 << 12);
                return n6 + 1 << 12;
            }
        }
    }

    public void surround(int n, int n2, TagItem tagItem, int n3) throws DocException {
        if (n2 >> 12 <= n >> 12 || n >> 12 < 0) {
            throw new DocError(this, "invalid surround: " + (n >> 12) + " - " + (n2 >> 12));
        }
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                EndTagItem endTagItem = new EndTagItem();
                int n4 = n2 >> 12;
                int n5 = n >> 12;
                int n6 = n3 >> 12;
                int n7 = this.items.length;
                this.insertItems(n6, 2);
                int n8 = this.items.length;
                n4 += n8 - n7;
                System.arraycopy(this.items, n5, this.items, n5 + 1, n6 - n5);
                int n9 = n5 + 1;
                while (n9 <= n6) {
                    DocItem docItem = this.items[n9];
                    if (docItem.offset > 0 && n9 + docItem.offset > n6) {
                        docItem.offset -= 2;
                    }
                    docItem.setIndex(n9, this);
                    ++n9;
                }
                tagItem.offset = n4 - n5;
                tagItem.setIndex(n5, this);
                this.items[n5] = tagItem;
                System.arraycopy(this.items, this.endPtr, this.items, this.endPtr - 1, n4 - this.endPtr + 1);
                --this.endPtr;
                int n10 = this.endPtr;
                while (n10 < n4) {
                    DocItem docItem = this.items[n10];
                    if (docItem.offset < 0 && n10 + docItem.offset < this.endPtr) {
                        docItem.offset += 2;
                    }
                    docItem.setIndex(n10, this);
                    ++n10;
                }
                endTagItem.offset = -tagItem.offset;
                endTagItem.setIndex(n4, this);
                this.items[n4] = endTagItem;
                this.notifyViews(15, n4 << 12, 4096);
                this.notifyViews(15, n5 << 12, 4096);
                this.notifyViews(17, n5 + 1 << 12, n4 - n5 - 1 << 12);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int delete(int n, int n2) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3;
                this.modify();
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 12) {
                    n2 = this.nitems << 12;
                }
                if (n >= n2) {
                    return n2;
                }
                int n4 = n >> 12;
                int n5 = n2 >> 12;
                if ((n2 & 0xFFF) > 0 && !this.items[n5].isText()) {
                    n2 = ++n5 << 12;
                }
                if (n4 == n5) {
                    this.items[n4].delete(this, n, n2 - n);
                    this.notifyViews(13, n, n2 - n);
                    return n;
                }
                if ((n & 0xFFF) > 0 && this.items[n4].isText()) {
                    n3 = 4095 - (n & 0xFFF);
                    this.items[n4++].delete(this, n, n3);
                    this.notifyViews(13, n, n3);
                }
                if (n4 < n5) {
                    n5 = this.deleteItems(n4, n5);
                }
                if ((n2 & 0xFFF) <= 0) return n5 << 12;
                n3 = n2 & 0xFFF;
                this.items[n5].delete(this, n4 << 12, n3);
                this.notifyViews(13, n4 << 12, n3);
                return n5 << 12;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void change(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 12) {
                    n2 = this.nitems << 12;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(17, n, n2 - n);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 12) {
                    n2 = this.nitems << 12;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(18, n, n2 - n);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 12) {
                    n2 = this.nitems << 12;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(19, n, n2 - n);
            }
            return;
        }
    }

    DocItem getInnermostOpenStartTag() {
        if (this.endPtr < this.items.length) {
            DocItem docItem = this.items[this.endPtr];
            return this.items[this.endPtr + docItem.offset];
        }
        return null;
    }

    DocItemEnumeration getDocItems(int n, int n2) {
        return new DocItemEnumeration(this, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized DocStyle getStyle(DocStyle var1_1, int var2_2, int var3_3) {
        var4_4 = null;
        var5_5 = var2_2 >> 12;
        if ((var2_2 & 4095) == 0) ** GOTO lbl29
        if (true) ** GOTO lbl29
        do {
            if ((var6_6 = this.items[var5_5]) != null) {
                var7_7 = var6_6.offset;
                if (var7_7 > 0) {
                    var8_9 = this.getStyle(var1_1, var5_5 << 12, var3_3).push(var6_6);
                    if (var4_4 != null) {
                        while (!var4_4.empty()) {
                            var9_10 = (DocItem)var4_4.pop();
                            var8_9 = var9_10.modifyStyleInPlace(var8_9);
                        }
                    }
                    return var8_9;
                }
                if (var7_7 == 0 && var6_6.modifiesStyleInPlace()) {
                    if (var4_4 == null) {
                        var4_4 = new Stack<DocItem>();
                    }
                    var4_4.push(var6_6);
                } else if (var7_7 < 0) {
                    v0 = var8_8 = this.basefontTagRecord.numIndices > 0 ? this.basefontTagRecord.maxLessThanOrEqual(var5_5) : -1;
                    if (var8_8 > (var5_5 += var7_7)) {
                        if (var4_4 == null) {
                            var4_4 = new Stack<E>();
                        }
                        var4_4.push(this.items[var8_8]);
                    }
                }
            }
lbl29:
            // 10 sources

            v1 = ++var5_5;
            --var5_5;
        } while (v1 > var3_3 && this.items != null);
        if (var4_4 != null) {
            while (!var4_4.empty()) {
                var6_6 = (DocItem)var4_4.pop();
                if (var6_6 == null) break;
                var1_1 = var6_6.modifyStyleInPlace(var1_1);
            }
        }
        return var1_1;
    }

    public synchronized int findLabel(String string) {
        int n = 0;
        while (n < this.nitems) {
            int n2;
            DocItem docItem = this.items[n];
            if (docItem.offset >= 0 && (n2 = docItem.findLabel(string)) != -1) {
                return n2;
            }
            ++n;
        }
        return -1;
    }

    private String getColorString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        char[] cArray = new char[]{'#', Character.forDigit(n >> 4, 16), Character.forDigit(n & 0xF, 16), Character.forDigit(n2 >> 4, 16), Character.forDigit(n2 & 0xF, 16), Character.forDigit(n3 >> 4, 16), Character.forDigit(n3 & 0xF, 16)};
        return new String(cArray);
    }

    public void write(OutputStream outputStream) throws DocException, IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(outputStreamWriter);
        outputStreamWriter.flush();
    }

    public void write(Writer writer) throws DocException, IOException {
        HTMLOutputWriter hTMLOutputWriter = new HTMLOutputWriter(writer, this.getDTD());
        int n = this.state;
        try {
            Color color;
            n = this.setOwner(13, Thread.currentThread());
            String string = this.getDoctype();
            if (string != null) {
                hTMLOutputWriter.doctype(string);
            }
            HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
            hTMLOutputWriter.comment(String.valueOf(hJBProperties.getProperty("hotjava.html.header")) + " " + new Date());
            TagItem tagItem = this.makeTag("html");
            TagItem tagItem2 = this.makeTag("head");
            TagItem tagItem3 = this.makeTag("title");
            TagItem tagItem4 = this.makeTag("body");
            Attributes attributes = new Attributes();
            String string2 = (String)this.getProperty("background.img");
            if (string2 != null) {
                attributes.put("background", string2);
            }
            if ((color = (Color)this.getProperty("background.color")) != null) {
                attributes.put("bgcolor", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("text.color")) != null) {
                attributes.put("text", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("link.color")) != null) {
                attributes.put("link", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("vlink.color")) != null) {
                attributes.put("vlink", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("alink.color")) != null) {
                attributes.put("alink", this.getColorString(color));
            }
            tagItem4.atts = attributes;
            hTMLOutputWriter.startTag(tagItem);
            hTMLOutputWriter.startTag(tagItem2);
            hTMLOutputWriter.startTag(tagItem3);
            string2 = this.getTitle();
            if (string2 != null) {
                hTMLOutputWriter.text(string2);
            }
            hTMLOutputWriter.endTag(tagItem3);
            URL uRL = (URL)this.getProperty("base");
            if (uRL != null) {
                TagItem tagItem5 = this.makeTag("base");
                tagItem5.atts = new Attributes();
                tagItem5.atts.put("href", uRL.toExternalForm());
                hTMLOutputWriter.emptyTag(tagItem5);
            }
            hTMLOutputWriter.endTag(tagItem2);
            hTMLOutputWriter.startTag(tagItem4);
            int n2 = 0;
            while (n2 < this.nitems) {
                int n3 = this.items[n2].offset;
                if (n3 > 0) {
                    this.items[n2].writeStartTag(hTMLOutputWriter);
                } else if (n3 < 0) {
                    this.items[n2 + n3].writeEndTag(hTMLOutputWriter);
                } else {
                    this.items[n2].write(hTMLOutputWriter);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_18 = null;
            this.setOwner(n, null);
            hTMLOutputWriter.flush();
            throw throwable;
        }
        Object var5_17 = null;
        this.setOwner(n, null);
        hTMLOutputWriter.flush();
    }

    public synchronized int startPos(int n) {
        int n2 = n >> 12;
        int n3 = n & 0xFFF;
        while (n2 >= 0 && n2 < this.nitems) {
            n = this.items[n2].startOffset(this, n3);
            if (n >= 0) {
                return n2 << 12 | n;
            }
            n3 = 4096;
            --n2;
        }
        return 0;
    }

    public int getSize() {
        return this.srcLength / 2;
    }

    protected CharArrayWriter getWriter() {
        return this.cw;
    }

    protected void zipSource() {
        this.srcBuffer = null;
        try {
            Object object;
            if (!GZIPOutputStream) {
                GZIPOutputStream = true;
                object = Class.forName("java.util.zip.GZIPOutputStream");
                GZIPOutputStreamCon = ((Class)object).getConstructor(class$java$io$OutputStream != null ? class$java$io$OutputStream : (class$java$io$OutputStream = Document.class$("java.io.OutputStream")));
                GZIPOutputStreamWrite = ((Class)object).getMethod("write", array$B != null ? array$B : (array$B = Document.class$("[B")), Integer.TYPE, Integer.TYPE);
                GZIPOutputStreamClose = ((Class)object).getMethod("close", new Class[0]);
            }
            object = new byte[this.cw.size() * 2];
            char[] cArray = this.cw.toCharArray();
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                object[n++] = (byte)(cArray[n2] & 0xFF);
                object[n++] = (byte)(cArray[n2] >> 8 & 0xFF);
                ++n2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Object t = GZIPOutputStreamCon.newInstance(byteArrayOutputStream);
            GZIPOutputStreamWrite.invoke(t, object, new Integer(0), new Integer(cArray.length * 2));
            GZIPOutputStreamClose.invoke(t, new Object[0]);
            this.srcBuffer = byteArrayOutputStream.toByteArray();
            this.srcLength = ((Object)object).length;
            this.cw = null;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected Reader unzipSource() {
        if (this.cw != null) {
            return new CharArrayReader(this.cw.toCharArray());
        }
        try {
            int n;
            Object object;
            if (!GZIPInputStream) {
                GZIPInputStream = true;
                object = Class.forName("java.util.zip.GZIPInputStream");
                GZIPInputStreamCon = ((Class)object).getConstructor(class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = Document.class$("java.io.InputStream")));
                GZIPInputStreamRead = ((Class)object).getMethod("read", array$B != null ? array$B : (array$B = Document.class$("[B")), Integer.TYPE, Integer.TYPE);
                GZIPInputStreamClose = ((Class)object).getMethod("close", new Class[0]);
            }
            object = null;
            int n2 = 1;
            Object t = GZIPInputStreamCon.newInstance(new ByteArrayInputStream(this.srcBuffer));
            object = new byte[this.srcLength];
            while ((n = ((Integer)GZIPInputStreamRead.invoke(t, object, new Integer(n2 - 1), new Integer(this.srcLength - n2))).intValue()) > 0) {
                n2 += n;
            }
            GZIPInputStreamClose.invoke(t, new Object[0]);
            char[] cArray = new char[n2 / 2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2 / 2) {
                int n5 = n4;
                cArray[n5] = (char)(cArray[n5] | (char)(object[n3++] & 0xFF));
                int n6 = n4++;
                cArray[n6] = (char)(cArray[n6] | (char)(object[n3++] << 8 & 0xFF00));
            }
            return new CharArrayReader(cArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Reader getSourceDocument() throws DocException {
        if (this.getProperty("template.src.url") == null) {
            if (this.srcLength > 0) {
                return this.unzipSource();
            }
            return new CharArrayReader(this.cw.toCharArray());
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            this.write(charArrayWriter);
        }
        catch (IOException iOException) {
            throw new DocError(this, "I/O error on buffer");
        }
        StringReader stringReader = new StringReader(charArrayWriter.toString());
        return stringReader;
    }

    public synchronized void reset() throws DocException {
        this.setState(0);
        this.owner = null;
        this.parsingCompleted = false;
        this.setIsOkToFormat(false);
    }

    public void clearProperties() throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                DTD dTD = this.getDTD();
                URL uRL = this.getURL();
                URL uRL2 = this.getReferer();
                this.props = new Hashtable(11);
                this.setProperty("dtd", dTD);
                this.setProperty("url", uRL);
                this.setProperty("referer", uRL2);
            }
            return;
        }
    }

    public void clear() throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                this.delete(0, Integer.MAX_VALUE);
                this.cw = new CharArrayWriter();
                this.srcBuffer = null;
                this.endPtr = this.items.length;
            }
            return;
        }
    }

    public Range find(String string) {
        return this.find(string, 0);
    }

    public Range find(String string, int n) {
        return this.find(string, n, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Range find(String string, int n, boolean bl) {
        OverlappingStringMatch overlappingStringMatch = new OverlappingStringMatch();
        String string2 = null;
        int n2 = n >> 12;
        int n3 = n & 0xFFF;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        while (n2 < this.nitems) {
            int n6;
            DocItem docItem = this.items[n2];
            if (!bl2) {
                n6 = docItem.find(string, n3, bl, overlappingStringMatch);
                if (n6 >= 0) {
                    if (overlappingStringMatch.matchLength == string.length()) {
                        return new Range(n2 << 12 | n6, n2 << 12 | n6 + string.length());
                    }
                    bl2 = true;
                    n4 = n2;
                    n5 = n6;
                    string2 = string.substring(overlappingStringMatch.matchLength);
                }
            } else if (docItem instanceof FlowTagItem || docItem instanceof TextItem || docItem instanceof EndTagItem || docItem instanceof EmptyTagItem) {
                n6 = docItem.find(string2, n3, bl, overlappingStringMatch);
                if (n6 >= 0) {
                    String string3 = docItem.getText();
                    if (!string3.startsWith(overlappingStringMatch.overlappingMatch)) {
                        bl2 = false;
                        n3 = 0;
                        continue;
                    }
                    if (overlappingStringMatch.matchLength >= string2.length()) return new Range(n4 << 12 | n5, n2 << 12 | overlappingStringMatch.matchLength);
                    string2 = string2.substring(overlappingStringMatch.matchLength);
                } else if (docItem instanceof TextItem) {
                    bl2 = false;
                    n3 = 0;
                    continue;
                }
            } else {
                bl2 = false;
                n3 = 0;
                continue;
            }
            n3 = 0;
            ++n2;
        }
        return null;
    }

    public synchronized int count(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            int n5 = this.items[n4].offset;
            if (n5 > 0) {
                n4 += n5;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    public void print() {
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            System.out.println(String.valueOf(k) + "=" + this.props.get(k));
        }
        int n = 0;
        while (n < this.nitems) {
            DocItem docItem = this.items[n];
            String string = docItem.getClass().getName();
            System.out.println(String.valueOf(n) + " = " + string.substring(string.lastIndexOf(46) + 1) + "," + docItem);
            ++n;
        }
    }

    public synchronized DocItem getItem(int n) {
        if (n < 0 || n > this.ncompleted && n < this.endPtr && this.items[n] == null) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.items[n];
    }

    public boolean isStateless() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof APPLET || this.items[n] instanceof FORM) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean releaseImages() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof IMG && !((IMG)this.items[n]).isMappable()) {
                IMG iMG = (IMG)this.items[n];
                iMG.flush();
            }
            ++n;
        }
        return false;
    }

    private boolean releaseImageMaps() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof IMG && ((IMG)this.items[n]).isMappable()) {
                IMG iMG = (IMG)this.items[n];
                iMG.flush();
            }
            ++n;
        }
        return false;
    }

    private boolean releaseApplets() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof APPLET) {
                this.items[n].flush();
                this.notifyViews(21, n << 12, 4096);
            }
            ++n;
        }
        return false;
    }

    private boolean releaseForms() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof FORM) {
                this.items[n].flush();
                this.notifyViews(21, n << 12, n + this.items[n].getOffset() << 12);
            }
            ++n;
        }
        return false;
    }

    public void invalidateFrames() {
        int n = 0;
        while (n < this.nitems) {
            Serializable serializable;
            if (this.items[n] instanceof FRAMESET && (serializable = ((FRAMESET)this.items[n]).getPanel()) != null) {
                ((FrameSetPanel)serializable).invalidateFrames();
            }
            if (this.items[n] instanceof FRAME && (serializable = ((FRAME)this.items[n]).getSrc()) != null) {
                DocumentCache.removeDocument((URL)serializable);
            }
            ++n;
        }
    }

    public void setIHaveFrameSet() {
        this.framed = true;
    }

    public boolean hasFrameSet() {
        return this.framed;
    }

    public boolean checkDate() {
        if (this.getConnector() != null) {
            return false;
        }
        URL uRL = this.getURL();
        if (uRL == null) {
            return false;
        }
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.getInputStream();
            Date date = new Date(httpURLConnection.getLastModified());
            if (this.getLastModifiedDate().equals(date)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public void reloadFrames() {
        if (!this.hasFrameSet()) {
            return;
        }
        int n = 0;
        while (n < this.nitems) {
            Container container;
            if (this.items[n] instanceof FRAMESET && (container = ((FRAMESET)this.items[n]).getPanel()) != null) {
                ((FrameSetPanel)container).reload();
            }
            ++n;
        }
    }

    public void reload() throws DocException {
        this.setState(4);
        this.interruptOwnerWaitCompletion();
        this.invalidateFrames();
        this.frameList = null;
        ImageCacher imageCacher = HotJavaBrowserBean.getImageCache();
        if (imageCacher != null) {
            imageCacher.flushDocumentImages(this);
        }
        this.setState(0);
        this.delete(0, Integer.MAX_VALUE);
        this.reset();
        this.setProperty("background.img", null);
        this.setProperty("background.color", null);
        this.setProperty("text.color", null);
        this.setProperty("link.color", null);
        this.setProperty("vlink.color", null);
        this.setProperty("alink.color", null);
        this.setProperty("charset", null);
        this.reloaded = true;
        this.notifyViews(24, 0, 0);
        DocParser docParser = new DocParser(this, false);
        docParser.addPropertyChangeListener(this);
        this.releaseImages();
        this.releaseImageMaps();
    }

    public void setParserProperties(Properties properties) {
        try {
            new DocParser(this, properties);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public void setConnector(URLConnector uRLConnector) {
        this.connector = uRLConnector;
    }

    public URLConnector getConnector() {
        return this.connector;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[title=" + this.getTitle() + ",url=" + this.getURL() + ",state=" + this.state + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vchanges.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vchanges.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setErrorMessage(String string) {
        this.changes.firePropertyChange("documentError", this.documentError, string);
        this.documentError = string;
    }

    public void setDocumentTitle(String string) {
        String cfr_ignored_0 = (String)this.getProperty("title");
        try {
            this.setProperty("title", string);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public String getDocumentTitle() {
        return this.getTitle();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("parseError")) {
            this.setErrorMessage("parse: " + (String)propertyChangeEvent.getNewValue());
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("documentString")) {
            this.changes.firePropertyChange("documentString", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    protected boolean changeNotVetoed(String string, Object object) {
        boolean bl = true;
        String[] stringArray = new String[]{"background.img", "background.color", "text.color", "link.color", "vlink.color", "alink.color"};
        String[] stringArray2 = new String[]{"backgroundImage", "backgroundColor", "textColor", "linkColor", "visitedLinkColor", "clickLinkColor"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                try {
                    this.vchanges.fireVetoableChange(stringArray2[n], this.props.get(string), object);
                }
                catch (PropertyVetoException propertyVetoException) {
                    bl = false;
                }
                break;
            }
            ++n;
        }
        return bl;
    }

    public void printDocContext(int n, int n2) {
        int n3 = n >> 12;
        int n4 = n3 - n2;
        int n5 = n3 + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > this.items.length) {
            n5 = this.items.length;
        }
        System.out.println("***************************************");
        System.out.println("*  Current doc context of " + n2);
        int n6 = n4;
        while (n6 < n5) {
            TagItem tagItem = null;
            if (this.items[n6] != null && this.items[n6] instanceof TagItem) {
                tagItem = (TagItem)this.items[n6];
            }
            if (n6 == n3) {
                System.out.println("* ===> items[" + n6 + "] == <" + (this.items[n6] != null ? this.getTagName(this.items[n6]) : "null") + "> offset = " + (this.items[n6] != null ? this.items[n6].offset : 0));
            } else {
                System.out.println("*      items[" + n6 + "] == <" + (this.items[n6] != null ? this.getTagName(this.items[n6]) : "null") + "> offset = " + (this.items[n6] != null ? this.items[n6].offset : 0));
            }
            ++n6;
        }
        System.out.println("***************************************");
    }

    public String getTagName(DocItem docItem) {
        if (docItem instanceof TagItem) {
            return ((TagItem)docItem).getElement().getName();
        }
        if (docItem instanceof EndTagItem) {
            return "/" + ((EndTagItem)docItem).getTag(this).getElement().getName();
        }
        if (docItem instanceof TextItem) {
            return "text item";
        }
        return "Unknown";
    }

    public Hashtable getImageMaps() {
        if (this.imageMaps == null) {
            Document document = this;
            synchronized (document) {
                if (this.imageMaps == null) {
                    this.imageMaps = new Hashtable(11);
                }
            }
        }
        return this.imageMaps;
    }

    public ImageMap findImageMap(URL uRL) {
        if (this.imageMaps != null) {
            return (ImageMap)this.imageMaps.get(uRL);
        }
        return null;
    }

    public void addSizeItemWidthWaitRef(SizeItem sizeItem) {
        this.startTimer();
        this.sizeItemListWidth.put(sizeItem, dummyInt);
    }

    public void addSizeItemHeightWaitRef(SizeItem sizeItem) {
        this.startTimer();
        this.sizeItemListHeight.put(sizeItem, dummyInt);
    }

    public void addSizeItemWaitRef(SizeItem sizeItem) {
        this.addSizeItemWidthWaitRef(sizeItem);
        this.addSizeItemHeightWaitRef(sizeItem);
    }

    public void removeSizeItemWidthWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemWidthWaitRef();
        this.sizeItemListWidth.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void removeSizeItemHeightWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemHeightWaitRef();
        this.sizeItemListHeight.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void removeSizeItemWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemWaitRef();
        this.sizeItemListWidth.remove(sizeItem);
        this.sizeItemListHeight.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void dispatchFormatScreen() {
        this.setIsOkToFormat(false);
        if (this.sizeItemListWidth.size() <= 0 && this.sizeItemListHeight.size() <= 0 && this.parsingCompleted) {
            Object object = Globals.getAwtLock();
            synchronized (object) {
                Document document = this;
                synchronized (document) {
                    this.timeOutStack.removeAllElements();
                    this.notifyViews(23, 0, 0);
                }
                return;
            }
        }
    }

    public void purgeSizeItemWidthWaitRef() {
        this.sizeItemListWidth = new Hashtable();
    }

    public void purgeSizeItemHeightWaitRef() {
        this.sizeItemListHeight = new Hashtable();
    }

    public void purgeSizeItemWaitRef() {
        this.purgeSizeItemWidthWaitRef();
        this.purgeSizeItemHeightWaitRef();
    }

    public boolean isSizeItemWidthWaitRef() {
        return this.sizeItemListWidth.size() > 0;
    }

    public boolean isSizeItemHeightWaitRef() {
        return this.sizeItemListHeight.size() > 0;
    }

    public boolean isSizeItemWaitRef() {
        return this.sizeItemListWidth.size() > 0 || this.sizeItemListHeight.size() > 0;
    }

    public void setIsOkToFormat(boolean bl) {
        if (!this.isSizeItemWaitRef() && this.doneParsing() && !bl) {
            this.bIsOkToFormat = true;
            return;
        }
        this.bIsOkToFormat = bl;
    }

    public boolean isOkToFormat() {
        return this.bIsOkToFormat;
    }

    public void updateClient(Object object) {
        boolean bl = this.isSizeItemWaitRef();
        Long l = null;
        if (!this.timeOutStack.empty()) {
            l = (Long)this.timeOutStack.peek();
        }
        if (object != null && l != null && l.equals(object)) {
            SizeItem sizeItem;
            this.timeOutStack.removeAllElements();
            System.out.println("DOC TIMED OUT ON IMG");
            Enumeration enumeration = this.sizeItemListWidth.keys();
            while (enumeration.hasMoreElements()) {
                sizeItem = (SizeItem)enumeration.nextElement();
                sizeItem.waiterTimedOut();
            }
            enumeration = this.sizeItemListHeight.keys();
            while (enumeration.hasMoreElements()) {
                sizeItem = (SizeItem)enumeration.nextElement();
                sizeItem.waiterTimedOut();
            }
        }
        this.purgeSizeItemWaitRef();
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    private void startTimer() {
        if (this.sizeItemListWidth.size() <= 0 && this.sizeItemListHeight.size() <= 0) {
            Long l = new Long(System.currentTimeMillis());
            this.timeOutStack.push(l);
            int n = HJBProperties.getHJBProperties("beanPropertiesKey").getInteger("allimages.timeout", 60000);
            ScreenUpdater.updater.notify((UpdateClient)this, (long)n, (Object)l);
        }
    }

    public int addFrame(FRAME fRAME) {
        if (this.frameList == null) {
            this.frameList = new Vector();
        }
        this.frameList.addElement(fRAME);
        return this.frameList.size() - 1;
    }

    public void removeFrame(FRAME fRAME) {
        if (this.frameList != null) {
            this.frameList.removeElement(fRAME);
        }
    }

    public Enumeration getFrameList() {
        if (this.frameList != null) {
            return this.frameList.elements();
        }
        return null;
    }

    public FRAME getFrameAt(int n) {
        if (this.frameList != null && this.frameList.size() > n) {
            return (FRAME)this.frameList.elementAt(n);
        }
        return null;
    }

    public int getNumberOfFrames() {
        if (this.frameList != null) {
            return this.frameList.size();
        }
        return 0;
    }

    public void addJavaScriptTag(Tag tag) {
        if (this.javaScriptTags == null) {
            this.javaScriptTags = new Hashtable(10);
        }
        this.javaScriptTags.put(tag, tag);
    }

    public void setHasScriptWrites(boolean bl) {
        this.hasScriptWrites = bl;
    }

    public boolean hasJavaScriptTags() {
        if (this.windowHandlerExists) {
            return true;
        }
        this.windowHandlerExists = this.hasWindowHandler();
        return this.windowHandlerExists || this.javaScriptTags != null || this.hasScriptWrites;
    }

    public boolean doesTagHasJavaScript(Tag tag) {
        if (this.javaScriptTags == null) {
            return false;
        }
        return this.javaScriptTags.get(tag) != null;
    }

    public Enumeration getJavaScriptTags() {
        return this.javaScriptTags.elements();
    }

    private boolean hasWindowHandler() {
        int n = 0;
        while (n < windowHandlers.length) {
            if (this.getProperty(windowHandlers[n]) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExpired() {
        Date date = this.getExpirationDate();
        return date != null && date.getTime() <= System.currentTimeMillis();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        windowHandlers = new String[]{"onblur", "onfocus", "ondragdrop", "onload", "onmove", "onresize", "onunload"};
    }
}

