/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.applets.HotJavaApplet;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.URLApplicationLauncher;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.UserTextButton;

public class ContentViewerUnknownApplet
extends HotJavaApplet
implements URLApplicationLauncher.ErrorListener {
    URL url;
    UserTextButton save;
    UserTextButton view;
    UserTextButton application;
    HJBProperties props;
    String targetFile;

    public ContentViewerUnknownApplet() {
        this.setName("contentviewerunknown");
    }

    public void init() {
        super.init();
        this.setLayout(new FlowLayout());
        this.props = HJBProperties.getHJBProperties("hjbrowser");
        try {
            this.url = new URL(this.getParameter("url"));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("saveFile: bad url " + this.getParameter("url"));
        }
        this.targetFile = this.getParameter("targetFile");
        this.save = new UserTextButton("viewerunknown.save", this.props);
        this.add(this.save);
        this.view = new UserTextButton("viewerunknown.view", this.props);
        this.add(this.view);
        this.application = new UserTextButton("viewerunknown.application", this.props);
        this.add(this.application);
    }

    public boolean action(Event event, Object object) {
        String string = (String)object;
        if (string.equals(this.save.getName())) {
            return this.saveFile();
        }
        if (string.equals(this.view.getName())) {
            return this.viewInBrowser();
        }
        if (string.equals(this.application.getName())) {
            return this.askForApplication();
        }
        return false;
    }

    boolean saveFile() {
        int n;
        String string = this.targetFile;
        if ((string == null || string.length() == 0) && (n = (string = this.url.getFile()).lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        File file = this.askUserForFile("viewerunknown.savedialog", 1, string);
        HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
        if (file != null) {
            String string2 = file.getAbsolutePath();
            String string3 = String.valueOf(this.props.getPropertyReplace("progressDialog.title.label", "Saving to: ")) + string2;
            hJFrame.save(this.url, string2, string3, true, false);
        }
        return true;
    }

    boolean viewInBrowser() {
        URL uRL = null;
        try {
            uRL = new URL(this.getParameter("url"));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ContentViewerUnknownApplet bad URL: " + malformedURLException);
        }
        try {
            URL uRL2 = new URL("verbatim:" + uRL.toExternalForm());
            HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
            hJFrame.getHTMLBrowsable().setDocumentURL(uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("ContentViewerUnknownApplet view as-is exception: " + malformedURLException);
        }
        return true;
    }

    boolean askForApplication() {
        try {
            File file = this.askUserForFile("viewerunknown.getapplicationdialog", 0, "");
            if (file != null) {
                String string = file.getAbsolutePath();
                if (!file.exists()) {
                    String string2 = this.props.getPropertyReplace("viewerunknown.appnotfound.msg", "Application not found  : ");
                    this.showErrorMessage(String.valueOf(string2) + string);
                } else {
                    try {
                        URLApplicationLauncher uRLApplicationLauncher = new URLApplicationLauncher(this.url, string);
                        uRLApplicationLauncher.addListener(this);
                        uRLApplicationLauncher.start();
                    }
                    catch (Exception exception) {
                        String string3 = this.props.getPropertyReplace("viewerunknown.faillaunch.msg", "Could not launch: ");
                        this.showErrorMessage(String.valueOf(string3) + string);
                    }
                }
            } else {
                String string = this.props.getPropertyReplace("viewerunknown.cancel.msg", "Canceled");
                this.showStatus(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            String string = this.props.getPropertyReplace("viewerunknown.nonrecoverable.msg", "Could not launch, a non-recoverable error occurred.");
            this.showErrorMessage(string);
        }
        return true;
    }

    private Frame getEnclosingFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    private void showErrorMessage(String string) {
        Frame frame = this.getEnclosingFrame();
        ConfirmDialog confirmDialog = new ConfirmDialog(String.valueOf(this.getName()) + ".error", frame, 1);
        confirmDialog.setPrompt(string);
        confirmDialog.show();
    }

    private void showErrorMessageFromKey(String string) {
        String string2 = this.props.getProperty(String.valueOf(this.getName()) + "." + string + ".msg");
        this.showErrorMessage(string2);
    }

    public void launcherErrorOccurred(URLApplicationLauncher.ErrorEvent errorEvent) {
        switch (errorEvent.getId()) {
            case 2001: {
                this.showErrorMessageFromKey("file-not-found");
                return;
            }
            case 2002: {
                this.showErrorMessageFromKey("file-not-executable");
                return;
            }
        }
        this.showErrorMessageFromKey("launch-failed");
    }
}

