/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import sunw.hotjava.HJFrame;
import sunw.hotjava.PeriodicSaveManager;
import sunw.hotjava.applet.AppletManager;
import sunw.hotjava.bean.CookieJarInterface;
import sunw.hotjava.bean.CurrentDocument;
import sunw.hotjava.bean.HTMLBrowsable;
import sunw.hotjava.bean.LinkEvent;
import sunw.hotjava.bean.LinkListener;
import sunw.hotjava.bean.URLPooler;
import sunw.hotjava.misc.GlobalRegistry;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.RequestProcessor;

public class HJWindowManager
implements LinkListener {
    static final int defaultXOffset = 25;
    static final int defaultYOffset = 10;
    private static WindowAdapter windowAdapter;
    private static HJFrame lastActiveFrame;
    private static CurrentDocument prevDocument;
    private static AppletManager appletMan;
    private static HJWindowManager hjwm;
    private static URLPooler urlpool;
    private static CookieJarInterface cookies;
    private static CookieJarInterface cookieJar;
    private static final String urlpoolManagerClass = "sunw.hotjava.bean.URLPool";
    private static final String cookieManagerClass = "sunw.hotjava.bean.CookieJar";
    HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private static Vector frames;

    public static HJWindowManager getHJWindowManager() {
        if (hjwm == null) {
            hjwm = new HJWindowManager();
        }
        return hjwm;
    }

    private HJWindowManager() {
        frames = new Vector();
        this.initBeans();
    }

    private void initBeans() {
        try {
            if (urlpool == null) {
                urlpool = (URLPooler)Beans.instantiate(null, this.properties.getProperty("hotjava.urlpool.manager", urlpoolManagerClass));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Temporary warning message: couldn't find URLPool!! Get a new message for this warning in hjbrowserResourceBundle");
        }
        catch (IOException iOException) {}
        try {
            if (cookies == null) {
                cookies = (CookieJarInterface)Beans.instantiate(null, this.properties.getProperty("hotjava.cookie.manager", cookieManagerClass));
                GlobalRegistry.setCookiesManager(cookies);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Temporary warning message: couldn't find URLPool!! Get a new message for this warning in hjbrowserResourceBundle");
            return;
        }
        catch (IOException iOException) {}
    }

    public URLPooler getURLPoolManager() {
        return urlpool;
    }

    public CookieJarInterface getCookiesManager() {
        return cookies;
    }

    public HJFrame createFrame(URL uRL) {
        if (windowAdapter == null) {
            windowAdapter = new 1();
        }
        HJFrame hJFrame = new HJFrame(uRL);
        Vector vector = frames;
        synchronized (vector) {
            frames.addElement(hJFrame);
        }
        hJFrame.addWindowListener(windowAdapter);
        hJFrame.getHTMLBrowsable().addLinkListener(this);
        if (appletMan == null) {
            appletMan = hJFrame.getAppletManager();
        }
        return hJFrame;
    }

    public HJFrame createFrame(URL uRL, boolean bl, boolean bl2, boolean bl3, boolean bl4, Point point, Dimension dimension) {
        if (windowAdapter == null) {
            windowAdapter = new 2();
        }
        HJFrame hJFrame = new HJFrame(uRL, bl, bl2, bl3, bl4, point, dimension);
        Vector vector = frames;
        synchronized (vector) {
            frames.addElement(hJFrame);
        }
        hJFrame.addWindowListener(windowAdapter);
        hJFrame.getHTMLBrowsable().addLinkListener(this);
        if (appletMan == null) {
            appletMan = hJFrame.getAppletManager();
        }
        return hJFrame;
    }

    public HJFrame createNoDecorFrame(URL uRL, HJFrame hJFrame) {
        if (windowAdapter == null) {
            windowAdapter = new 3();
        }
        HTMLBrowsable hTMLBrowsable = hJFrame.getHTMLBrowsable();
        HJWindowManager.prevDocument.documentURL = hTMLBrowsable.getDocumentURL();
        HJWindowManager.prevDocument.documentTitle = hTMLBrowsable.getDocumentTitle();
        HJWindowManager.prevDocument.documentSource = hTMLBrowsable.getDocumentSource();
        Point point = hJFrame.getLocation();
        point.translate(-50, 50);
        HJFrame hJFrame2 = new HJFrame(uRL, point);
        Vector vector = frames;
        synchronized (vector) {
            frames.addElement(hJFrame2);
        }
        hJFrame2.addWindowListener(windowAdapter);
        hJFrame2.getHTMLBrowsable().addLinkListener(this);
        if (appletMan == null) {
            appletMan = hJFrame2.getAppletManager();
        }
        return hJFrame2;
    }

    public void closeFrame(Window window) {
        Vector vector = frames;
        synchronized (vector) {
            if (window == null) {
                Object var3_3 = null;
                return;
            }
            frames.removeElement(window);
            ((Component)window).setVisible(false);
            window.dispose();
            if (frames.size() == 0) {
                this.quit();
            }
            return;
        }
    }

    public synchronized void quit() {
        PeriodicSaveManager.getPeriodicSaveManager().prepareToExit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        Vector vector = frames;
        synchronized (vector) {
            String string = this.properties.getProperty("appletpanel.thread.cleanup.interval");
            int n = 5000;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            this.hideAllWindows();
            this.startQuitWatchdog();
            appletMan.destroyApplets(n);
            int n2 = 0;
            while (n2 < frames.size()) {
                HJFrame hJFrame = (HJFrame)frames.elementAt(n2);
                hJFrame.dispose();
                ++n2;
            }
            frames.setSize(0);
            System.exit(0);
            return;
        }
    }

    private void startQuitWatchdog() {
        String string = "hotjava.quit.watchdog.timeout";
        int n = this.properties.getInteger(string, 6000);
        new 4(n).start();
    }

    private void hideAllWindows() {
        RequestProcessor.getHJBeanQueue().postRequest(new 5());
    }

    public void resetDecorationsAllWindows() {
        RequestProcessor.getHJBeanQueue().postRequest(new 6());
    }

    public void setDocFontAllWindows() {
        RequestProcessor.getHJBeanQueue().postRequest(new 7());
    }

    public void openFrame(String string, URL uRL) {
        HJFrame hJFrame = this.findFrameNamed(string, lastActiveFrame.getHTMLBrowsable());
        if (hJFrame != null && string.equals("_hotjava_help") && hJFrame.isIconified()) {
            hJFrame.getHTMLBrowsable().setName("");
            hJFrame = null;
        }
        if (hJFrame == null || "_blank".equals(string)) {
            hJFrame = this.createFrame(uRL);
            hJFrame.getHTMLBrowsable().setName(string);
            hJFrame.show();
            return;
        }
        hJFrame.getHTMLBrowsable().setDocumentURL(uRL);
        if (string.equals("_hotjava_help")) {
            hJFrame.toFront();
        }
    }

    public HTMLBrowsable openFrame(String string, URL uRL, boolean bl, boolean bl2, boolean bl3, boolean bl4, Point point, Dimension dimension) {
        HJFrame hJFrame = this.findFrameNamed(string, lastActiveFrame.getHTMLBrowsable());
        if (hJFrame == null || "_blank".equals(string)) {
            hJFrame = this.createFrame(uRL, bl, bl2, bl3, bl4, point, dimension);
            hJFrame.getHTMLBrowsable().setName(string);
            hJFrame.show();
        } else {
            LinkEvent linkEvent = uRL == null ? new LinkEvent(null, string, "") : new LinkEvent(null, string, uRL.toExternalForm());
            hJFrame.getHTMLBrowsable().handleLinkEvent(linkEvent);
        }
        return hJFrame.getHTMLBrowsable();
    }

    public HJFrame cloneFrame(HJFrame hJFrame, URL uRL) {
        HJFrame hJFrame2 = this.createFrame(uRL);
        if (hJFrame != null) {
            Dimension dimension = hJFrame.getSize();
            Point point = hJFrame.getLocation();
            Insets insets = hJFrame.getInsets();
            ((Component)hJFrame2).setBounds(point.x + insets.top, point.y + insets.top, dimension.width, dimension.height);
        }
        hJFrame2.show();
        return hJFrame2;
    }

    public void showStatusAll(String string) {
        int n = 0;
        while (n < frames.size()) {
            HJFrame hJFrame = (HJFrame)frames.elementAt(n);
            hJFrame.showStatus(string);
            ++n;
        }
    }

    public HJFrame[] getAllFrames() {
        Object[] objectArray;
        Vector vector = frames;
        synchronized (vector) {
            objectArray = new HJFrame[frames.size()];
            frames.copyInto(objectArray);
        }
        return objectArray;
    }

    public HJFrame getLastFocusHolder() {
        return lastActiveFrame;
    }

    public CurrentDocument getPrevDocument() {
        return prevDocument;
    }

    public int noOfFrames() {
        return frames.size();
    }

    public synchronized HTMLBrowsable hyperlinkPerformed(LinkEvent linkEvent) {
        HTMLBrowsable hTMLBrowsable = null;
        String string = linkEvent.getTarget();
        if (string == null || string.equalsIgnoreCase("_self") || string.equalsIgnoreCase("_parent") || string.startsWith("_refresh") || string.equalsIgnoreCase("_top")) {
            HJFrame hJFrame = this.findFrameNamed(linkEvent.getFrameSource(), linkEvent.getBrowser());
            HTMLBrowsable hTMLBrowsable2 = hJFrame.getHTMLBrowsable();
            HJWindowManager.prevDocument.documentURL = hTMLBrowsable2.getDocumentURL();
            HJWindowManager.prevDocument.documentTitle = hTMLBrowsable2.getDocumentTitle();
            HJWindowManager.prevDocument.documentSource = hTMLBrowsable2.getDocumentSource();
            hTMLBrowsable = hJFrame.getHTMLBrowsable();
            hTMLBrowsable.handleLinkEvent(linkEvent);
        } else {
            HJFrame hJFrame = null;
            if (!string.equalsIgnoreCase("_blank") && (hJFrame = this.findFrameNamed(string, linkEvent.getBrowser())) != null) {
                hTMLBrowsable = hJFrame.getHTMLBrowsable();
                hTMLBrowsable.handleLinkEvent(linkEvent);
                return hTMLBrowsable;
            }
            String string2 = linkEvent.getHREF();
            if (string2 == null) {
                string2 = this.properties.getProperty("hotjava.blank.html", "doc:/lib/hotjava/blank.html");
            }
            try {
                HJFrame hJFrame2;
                URL uRL = new URL(string2);
                hJFrame = (HJFrame)frames.elementAt(0);
                if (string.equals("_mailto")) {
                    hJFrame2 = this.createNoDecorFrame(uRL, hJFrame);
                } else {
                    hJFrame2 = this.createFrame(uRL);
                    Dimension dimension = hJFrame.getSize();
                    Point point = hJFrame.getLocation();
                    Insets insets = hJFrame.getInsets();
                    ((Component)hJFrame2).setBounds(point.x + insets.top, point.y + insets.top, dimension.width, dimension.height);
                }
                hJFrame2.show();
                hTMLBrowsable = hJFrame2.getHTMLBrowsable();
                if (!string.equalsIgnoreCase("_blank")) {
                    hTMLBrowsable.setName(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Malformed URL Exception " + string2);
                Thread.dumpStack();
            }
        }
        return hTMLBrowsable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HJFrame findFrameNamed(String string, HTMLBrowsable hTMLBrowsable) {
        Vector vector = frames;
        synchronized (vector) {
            int n = frames.size();
            if (this.isBrowserContainFrame(hTMLBrowsable, string)) {
                int n2 = 0;
                while (n2 < n) {
                    HJFrame hJFrame = (HJFrame)frames.elementAt(n2);
                    if (hJFrame.getHTMLBrowsable() == hTMLBrowsable) {
                        return hJFrame;
                    }
                    ++n2;
                }
                return null;
            } else {
                int n3 = 0;
                while (n3 < n) {
                    HJFrame hJFrame = (HJFrame)frames.elementAt(n3);
                    if (this.isBrowserContainFrame(hJFrame.getHTMLBrowsable(), string)) {
                        return hJFrame;
                    }
                    ++n3;
                }
            }
            return null;
        }
    }

    private boolean isBrowserContainFrame(HTMLBrowsable hTMLBrowsable, String string) {
        if (hTMLBrowsable == null) {
            return false;
        }
        if (hTMLBrowsable.getName().equalsIgnoreCase(string)) {
            return true;
        }
        String[] stringArray = hTMLBrowsable.getFrameList();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        prevDocument = new CurrentDocument();
    }

    private final class 1
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            lastActiveFrame = (HJFrame)windowEvent.getWindow();
            HJBProperties.setLastFocusHolder(lastActiveFrame);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            lastActiveFrame = (HJFrame)windowEvent.getWindow();
            HJBProperties.setLastFocusHolder(lastActiveFrame);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            lastActiveFrame = (HJFrame)windowEvent.getWindow();
            HJBProperties.setLastFocusHolder(lastActiveFrame);
        }

        /* synthetic */ 3() {
        }
    }

    private static final class 4
    extends Thread {
        private final /* synthetic */ int val$maxDelay;

        public void run() {
            try {
                Thread.sleep(this.val$maxDelay);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Watchdog interrupted!");
            }
            String string = "Quit watchdog timer expired.";
            string.concat(" -- Calling System.exit()");
            System.out.println(string);
            System.exit(1);
        }

        /* synthetic */ 4(int n) {
            this.val$maxDelay = n;
        }
    }

    private final class 5
    extends RequestProcessor.Request {
        public void execute() {
            Vector vector = frames;
            synchronized (vector) {
                int n = 0;
                while (n < frames.size()) {
                    HJFrame hJFrame = (HJFrame)frames.elementAt(n);
                    ((Component)hJFrame).setVisible(false);
                    ++n;
                }
                return;
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends RequestProcessor.Request {
        public void execute() {
            Vector vector = frames;
            synchronized (vector) {
                int n = 0;
                while (n < frames.size()) {
                    HJFrame hJFrame = (HJFrame)frames.elementAt(n);
                    if (hJFrame.isDecorated()) {
                        hJFrame.reset();
                    }
                    ++n;
                }
                return;
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends RequestProcessor.Request {
        public void execute() {
            Vector vector = frames;
            synchronized (vector) {
                int n = 0;
                while (n < frames.size()) {
                    HJFrame hJFrame = (HJFrame)frames.elementAt(n);
                    hJFrame.getHTMLBrowsable().setDocFontNotInPlace();
                    ++n;
                }
                return;
            }
        }

        /* synthetic */ 7() {
        }
    }
}

