/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import java.net.MalformedURLException;

public class NfsURL {
    private String url;
    private String protocol;
    private String host;
    private String location;
    private int port;
    private String file;
    private int version;
    private String proto;
    private boolean pub = true;

    public NfsURL(String string) throws MalformedURLException {
        int n;
        int n2 = string.length();
        this.url = string = string.trim();
        int n3 = string.indexOf(58);
        if (n3 < 0) {
            throw new MalformedURLException("colon expected");
        }
        this.protocol = string.substring(0, n3);
        if (string.regionMatches(++n3, "//", 0, 2)) {
            n = string.indexOf(47, n3 += 2);
            if (n < 0) {
                n = n2;
            }
            this.location = string.substring(0, n);
            int n4 = string.indexOf(58, n3);
            if (n4 > 0 && n4 < n) {
                byte[] byArray = string.substring(n4 + 1, n).toLowerCase().getBytes();
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (byArray[n5] >= 48 && byArray[n5] <= 57) {
                        this.port = this.port * 10 + (byArray[n5] - 48);
                    } else {
                        switch (byArray[n5]) {
                            case 118: {
                                this.version = byArray[++n5] - 48;
                                break;
                            }
                            case 116: {
                                this.proto = "tcp";
                                break;
                            }
                            case 117: {
                                this.proto = "udp";
                                break;
                            }
                            case 119: {
                                this.pub = true;
                                break;
                            }
                            case 109: {
                                this.pub = false;
                                break;
                            }
                            default: {
                                throw new MalformedURLException("invalid port number");
                            }
                        }
                    }
                    ++n5;
                }
            } else {
                n4 = n;
            }
            if (n3 < n4) {
                this.host = string.substring(n3, n4);
            }
        } else {
            n = n3;
        }
        if (n < n2) {
            this.file = string.substring(n + 1, n2);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getFile() {
        return this.file;
    }

    int getVersion() {
        return this.version;
    }

    String getProto() {
        return this.proto;
    }

    boolean getPub() {
        return this.pub;
    }

    public String toString() {
        String string = String.valueOf(this.getProtocol()) + ":";
        if (this.host != null) {
            string = String.valueOf(string) + "//" + this.host;
        }
        if (this.port > 0) {
            string = String.valueOf(string) + ":" + this.port;
        }
        if (this.file != null) {
            string = String.valueOf(string) + "/" + this.file;
        }
        return string;
    }
}

