/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import javax.swing.JPanel;

class HistoPanel
extends JPanel {
    private float[] bars;
    private float start;
    private float end;
    private float bucket;
    private float xmin;
    private float xmax;
    private float xunit;
    private float ymin;
    private float ymax;
    private float yunit;
    private float xscale;
    private float yscale;
    private int xsize;
    private int ysize;
    private int xborder = 50;
    private int yborder = 40;
    private boolean bypercentage;

    HistoPanel() {
    }

    public void setStartEndPoints(float f, float f2, float f3) {
        this.start = f;
        this.end = f2;
        this.bucket = f3;
    }

    public void setXYAxis(float f, float f2, float f3, float f4, float f5, float f6) {
        this.xmin = f;
        this.xmax = f2;
        this.xunit = f3;
        this.ymin = f4;
        this.ymax = f5;
        this.yunit = f6;
        this.xscale = f2 - f;
        this.yscale = f5 - f4;
        int n = String.valueOf(f4).length();
        int n2 = String.valueOf(f5).length();
        int n3 = String.valueOf(f6).length();
        int n4 = Math.max(Math.max(n, n2), n3);
        this.xborder = n4 * this.getGraphics().getFontMetrics().charWidth('0') + 10;
    }

    public void setByPercentage(boolean bl) {
        this.bypercentage = bl;
    }

    public void setData(float[] fArray) {
        this.bars = fArray;
    }

    public float[] getData() {
        return this.bars;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        if (this.bars == null) {
            return;
        }
        this.xsize = this.getXSize();
        this.ysize = this.getYSize();
        if (this.xsize < 0 || this.ysize < 0) {
            return;
        }
        float f = this.xscale / (float)this.xsize;
        float f2 = this.yscale / (float)this.ysize;
        this.drawLine(graphics, 0, 0, this.xsize + 20, 0);
        this.drawLine(graphics, 0, 0, 0, this.ysize + 20);
        if (this.bypercentage) {
            this.cString(graphics, "(%)", 0, this.ysize + 30);
        }
        float f3 = this.xmin;
        while (f3 <= this.xmax) {
            int n2 = (int)((f3 - this.xmin) / f);
            this.drawLine(graphics, n2, 3, n2, -3);
            this.cString(graphics, String.valueOf(f3), n2, -20);
            f3 += this.xunit;
        }
        float f4 = this.ymin;
        while (f4 <= this.ymax) {
            n = (int)((f4 - this.ymin) / f2);
            this.drawLine(graphics, -3, n, 3, n);
            this.rString(graphics, String.valueOf(f4), -5, n);
            f4 += this.yunit;
        }
        n = 0;
        while (n < this.bars.length) {
            float f5 = this.start + (float)(n - 1) * this.bucket;
            int n3 = (int)((this.bars[n] - this.ymin) / f2);
            int n4 = (int)((f5 - this.xmin) / f);
            int n5 = (int)((f5 + this.bucket - this.xmin) / f);
            n4 = Math.max(n4, 0);
            n5 = Math.min(n5, this.xsize);
            if (n == 0) {
                n4 = 0;
            }
            if (n == this.bars.length - 1) {
                n5 = this.xsize;
            }
            if (n4 < n5) {
                this.drawLine(graphics, n4, 0, n4, n3);
                this.drawLine(graphics, n5, 0, n5, n3);
                this.drawLine(graphics, n4, n3, n5, n3);
            }
            ++n;
        }
    }

    private int getXSize() {
        return this.getWidth() - 2 * this.xborder;
    }

    private int getYSize() {
        return this.getHeight() - 2 * this.yborder;
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n + this.xborder, this.ysize - n2 + this.yborder, n3 + this.xborder, this.ysize - n4 + this.yborder);
    }

    private void drawString(Graphics graphics, String string, int n, int n2) {
        graphics.drawString(string, n + this.xborder, this.ysize - n2 + this.yborder);
    }

    private int getx(int n) {
        return n + this.xborder;
    }

    private int gety(int n) {
        return this.ysize - n + this.yborder;
    }

    private void cString(Graphics graphics, String string, int n, int n2) {
        int n3 = graphics.getFontMetrics().stringWidth(string);
        this.drawString(graphics, string, n - n3 / 2, n2);
    }

    private void rString(Graphics graphics, String string, int n, int n2) {
        int n3 = graphics.getFontMetrics().stringWidth(string);
        this.drawString(graphics, string, n - n3, n2);
    }
}

