/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractSequentialList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeSet;

public class Formula {
    private static HashMap funcTable;
    private TreeSet dependency;
    private LinkedList postfix;
    private int row;
    private int col;
    private String formulaString;
    private ParserException error;
    private boolean needsRecalc;

    Formula(String string, int n, int n2, ParserException parserException) {
        this.formulaString = string.toUpperCase();
        this.col = n2;
        this.row = n;
        this.error = parserException;
    }

    Formula(String string, int n, int n2) throws ParserException {
        this.col = n2;
        this.row = n;
        this.formulaString = string.toUpperCase();
        try {
            LinkedList linkedList = this.tokenize(this.formulaString);
            this.dependency = this.createDependency(linkedList);
            this.postfix = this.toPostfix(this.convertParams(linkedList));
            Debug.println("Postfix: " + this.postfix);
        }
        catch (ParserException parserException) {
            Debug.println("Formula constructor: " + parserException);
            this.throwError(parserException);
        }
    }

    Formula(Formula formula, int n, int n2) throws ParserException {
        this.col = n2;
        this.row = n;
        try {
            this.formulaString = Formula.fixRelAddr(formula.formulaString, n - formula.row, n2 - formula.col);
            if (this.formulaString == null) {
                this.formulaString = "$REFS$0";
                this.error = new ParserException("REFS");
                return;
            }
            LinkedList linkedList = this.tokenize(this.formulaString);
            this.dependency = this.createDependency(linkedList);
            this.postfix = this.toPostfix(this.convertParams(linkedList));
        }
        catch (ParserException parserException) {
            System.err.println("Shouldn't happen!");
            this.throwError(parserException);
        }
    }

    public static boolean isSafe(Formula formula, int n, int n2) {
        String string = Formula.fixRelAddr(formula.formulaString, n, n2);
        return string != null;
    }

    public boolean isBad() {
        return this.postfix == null;
    }

    public boolean needsRecalc() {
        return this.needsRecalc;
    }

    public void setNeedsRecalc(boolean bl) {
        this.needsRecalc = bl;
    }

    public static String fixRelAddr(String string, int n, int n2) {
        if (n2 == 0 && n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            int n5 = n4;
            if (Character.isUpperCase(c)) {
                boolean bl = n4 > 0 && string.charAt(n4 - 1) == '$';
                StringBuffer stringBuffer2 = new StringBuffer();
                while (n4 < string.length() && Character.isUpperCase(string.charAt(n4))) {
                    stringBuffer2.append(string.charAt(n4++));
                }
                String string2 = stringBuffer2.toString();
                if (n4 == string.length()) break;
                if (!bl && Character.isDigit(string.charAt(n4))) {
                    String string3;
                    StringBuffer stringBuffer3 = new StringBuffer();
                    while (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
                        stringBuffer3.append(string.charAt(n4++));
                    }
                    String string4 = stringBuffer3.toString();
                    stringBuffer.append(string.substring(n3, n5));
                    if (n2 == 0) {
                        stringBuffer.append(string2);
                    } else {
                        string3 = Formula.translateColumn(Formula.translateColumn(string2) + n2);
                        if (string3 == null) {
                            return null;
                        }
                        stringBuffer.append(string3);
                    }
                    if (n == 0) {
                        stringBuffer.append(string4);
                    } else {
                        string3 = Formula.translateRow(Formula.translateRow(string4) + n);
                        if (string3 == null) {
                            return null;
                        }
                        stringBuffer.append(string3);
                    }
                    n3 = n4;
                }
            }
            ++n4;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private LinkedList tokenize(String string) throws ParserException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Stack stack = new Stack();
        Node node = new Node();
        node.setType(6);
        node.setNumber(0.0f);
        int n = 0;
        int n2 = 0;
        Node node2 = null;
        int n3 = 0;
        while (n < string.length()) {
            Node node3 = new Node();
            try {
                Node node4;
                char c = string.charAt(n++);
                node3.setData(String.valueOf(c));
                if (Character.isLetter(c)) {
                    node3.setType(3);
                    node3.setParams(new LinkedList());
                    while (n < string.length() && Character.isLetter(string.charAt(n))) {
                        node3.appendData(string.charAt(n++));
                    }
                    if (Character.isDigit(string.charAt(n))) {
                        node3.setType(1);
                        node3.setCol(Formula.translateColumn(node3.getData()) - this.col);
                        node3.setData("");
                        while (n < string.length() && Character.isDigit(string.charAt(n))) {
                            node3.appendData(string.charAt(n++));
                        }
                        node3.setRow(Formula.translateRow(node3.getData()) - this.row);
                        node3.setData(null);
                    }
                } else if (Character.isDigit(c) || c == '.') {
                    while (n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.')) {
                        node3.appendData(string.charAt(n++));
                    }
                    try {
                        try {
                            node3.setNumber(Integer.parseInt(node3.getData()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            node3.setNumber(Float.parseFloat(node3.getData()));
                        }
                        node3.setType(6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.throwError("#NUM?");
                    }
                } else if (c == '(') {
                    ++n3;
                    node3.setType(4);
                } else if (c == ')') {
                    --n3;
                    node3.setType(5);
                } else if (c == ',') {
                    node3.setType(8);
                } else if (c == ':') {
                    node3.setPending(true);
                    node3.setType(9);
                    node4 = null;
                    try {
                        node4 = (Node)linkedList.removeLast();
                    }
                    catch (Exception exception) {
                        this.throwError("#ADDR?");
                    }
                    if (node4.isType(1) || node4.isType(2)) {
                        node3.setNextRange(node4);
                    } else {
                        this.throwError("#ADDR?");
                    }
                } else if (c == '+' || c == '-' || c == '*' || c == '/' || c == '^' || c == '%') {
                    node3.setType(7);
                } else if (c == '$') {
                    node3.setType(2);
                    node3.setData("");
                    if (!Character.isLetter(string.charAt(n))) {
                        this.throwError("#ADDR?");
                    }
                    while (Character.isLetter(string.charAt(n))) {
                        node3.appendData(string.charAt(n++));
                    }
                    if (string.charAt(n++) != '$' || !Character.isDigit(string.charAt(n))) {
                        this.throwError("#ADDR?");
                    }
                    node3.setCol(Formula.translateColumn(node3.getData()));
                    node3.setData("");
                    while (n < string.length() && Character.isDigit(string.charAt(n))) {
                        node3.appendData(string.charAt(n++));
                    }
                    node3.setRow(Formula.translateRow(node3.getData()));
                    node3.setData(null);
                } else {
                    if (c == ' ') continue;
                    this.throwError("#NAME?");
                }
                if (n < string.length() && (node3.isType(1) || node3.isType(2) || node3.isType(6)) && Character.isLetterOrDigit(string.charAt(n))) {
                    this.throwError("#NAME?");
                }
                if (node2 != null && node2.isType(9) && node2.isPending()) {
                    if (node3.isType(1) || node3.isType(2)) {
                        node4 = (Node)linkedList.removeLast();
                        try {
                            node4.getNextRange().setNextRange(node3);
                            node4.setPending(false);
                        }
                        catch (NullPointerException nullPointerException) {
                            this.throwError("#ADDR?");
                        }
                        node3 = node4;
                    } else {
                        this.throwError("#ADDR?");
                    }
                }
                if (node3.isType(7) && (node3.getData().equals("+") || node3.getData().equals("-")) && (node2 == null || node2.isType(4) || node2.isType(8))) {
                    linkedList.add(node);
                }
                linkedList.add(node3);
                n2 = node3.getType();
                node2 = node3;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.throwError("#NAME?");
            }
            catch (ParserException parserException) {
                this.throwError(parserException);
            }
            catch (Exception exception) {
                Debug.println(exception.toString());
            }
        }
        if (n3 != 0) {
            this.throwError("#PAREN?");
        }
        return linkedList;
    }

    private LinkedList convertParams(LinkedList linkedList) throws ParserException {
        if (linkedList == null) {
            throw this.error;
        }
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        Iterator iterator = linkedList.iterator();
        try {
            while (iterator.hasNext()) {
                Node node;
                LinkedList<Node> linkedList3;
                Node node2;
                Node node3 = (Node)iterator.next();
                if (node3.isType(3)) {
                    node3.setPending(true);
                    linkedList2.add(node3);
                    node3 = (Node)iterator.next();
                    if (node3.isType(4)) continue;
                    this.throwError("#NO(?");
                    continue;
                }
                if (node3.isType(4)) {
                    node3.setPending(true);
                    linkedList2.add(node3);
                    continue;
                }
                if (node3.isType(8)) {
                    node2 = new Node();
                    linkedList3 = new LinkedList<Node>();
                    node = (Node)linkedList2.removeLast();
                    while (!node.isType(3) || !node.isPending()) {
                        linkedList3.addFirst(node);
                        node = (Node)linkedList2.removeLast();
                    }
                    node2.setType(10);
                    node2.setExp(linkedList3);
                    node.addParam(node2);
                    linkedList2.add(node);
                    continue;
                }
                if (node3.isType(5)) {
                    node2 = new Node();
                    linkedList3 = new LinkedList();
                    node = (Node)linkedList2.removeLast();
                    while (!node.isPending() || !node.isType(3) && !node.isType(4)) {
                        linkedList3.addFirst(node);
                        node = (Node)linkedList2.removeLast();
                    }
                    if (node.isType(4)) {
                        node.setPending(false);
                        linkedList2.add(node);
                        linkedList2.addAll(linkedList3);
                        linkedList2.add(node3);
                        continue;
                    }
                    node2.setType(10);
                    node2.setExp(linkedList3);
                    node.addParam(node2);
                    node.setPending(false);
                    linkedList2.add(node);
                    continue;
                }
                linkedList2.add(node3);
            }
        }
        catch (ParserException parserException) {
            throw parserException;
        }
        catch (Exception exception) {
            Debug.println(exception);
            this.throwError("#PARAM?");
        }
        return linkedList2;
    }

    private LinkedList toPostfix(LinkedList linkedList) throws ParserException {
        if (linkedList == null) {
            throw this.error;
        }
        Stack<Node> stack = new Stack<Node>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        Iterator iterator = linkedList.iterator();
        block9: while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            switch (node.getType()) {
                case 1: 
                case 2: 
                case 6: 
                case 9: {
                    linkedList2.add(node);
                    break;
                }
                case 4: {
                    stack.push(node);
                    break;
                }
                case 7: {
                    int n = Formula.getPriority(node);
                    while (!stack.empty() && !((Node)stack.peek()).isType(4) && Formula.getPriority((Node)stack.peek()) >= n) {
                        linkedList2.add((Node)stack.pop());
                    }
                    stack.push(node);
                    break;
                }
                case 5: {
                    Object object;
                    try {
                        object = (Node)stack.pop();
                        while (!((Node)object).isType(4)) {
                            linkedList2.add(object);
                            object = (Node)stack.pop();
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        this.throwError("#PAREN?");
                    }
                    continue block9;
                }
                case 3: {
                    Object object = node.getParams();
                    Iterator iterator2 = ((AbstractSequentialList)object).iterator();
                    while (iterator2.hasNext()) {
                        Node node2 = (Node)iterator2.next();
                        node2.setExp(this.toPostfix(node2.getExp()));
                    }
                    linkedList2.add(node);
                    break;
                }
                default: {
                    this.throwError("#ERROR?");
                }
            }
        }
        while (!stack.empty()) {
            linkedList2.add((Node)stack.pop());
        }
        return linkedList2;
    }

    private TreeSet createDependency(LinkedList linkedList) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            CellPoint[] cellPointArray;
            Node node = (Node)iterator.next();
            if (node.isType(1) || node.isType(2)) {
                cellPointArray = node.toCellPoint(this.row, this.col);
                treeSet.add(cellPointArray);
                continue;
            }
            if (!node.isType(9)) continue;
            cellPointArray = node.getAddressRange(this.row, this.col);
            int n = cellPointArray[0].getRow();
            while (n <= cellPointArray[1].getRow()) {
                int n2 = cellPointArray[0].getCol();
                while (n2 <= cellPointArray[1].getCol()) {
                    treeSet.add(new CellPoint(n, n2));
                    ++n2;
                }
                ++n;
            }
        }
        return treeSet;
    }

    public TreeSet getDependency() {
        if (this.isBad()) {
            return new TreeSet();
        }
        return this.dependency;
    }

    private static int getPriority(char c) {
        switch (c) {
            case '+': 
            case '-': {
                return 1;
            }
            case '%': 
            case '*': 
            case '/': {
                return 2;
            }
            case '^': {
                return 3;
            }
        }
        return 0;
    }

    private static int getPriority(Node node) {
        return Formula.getPriority(node.getData().charAt(0));
    }

    public String toString() {
        return this.formulaString;
    }

    private static Number calc(char c, Number number, Number number2) {
        float f;
        float f2 = number.floatValue();
        float f3 = number2.floatValue();
        switch (c) {
            case '+': {
                f = f2 + f3;
                break;
            }
            case '-': {
                f = f2 - f3;
                break;
            }
            case '*': {
                f = f2 * f3;
                break;
            }
            case '/': {
                f = f2 / f3;
                break;
            }
            case '^': {
                f = (float)Math.pow(f2, f3);
                break;
            }
            case '%': {
                f = (int)f2 % (int)f3;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return new Float(f);
    }

    private static Number evalFunction(SharpTableModel sharpTableModel, Node node, int n, int n2) throws ParserException {
        String string = node.getData();
        Function function = Formula.getFuncHandler(string);
        if (function == null) {
            throw new ParserException("#FUNC?");
        }
        return function.evaluate(sharpTableModel, node, n, n2);
    }

    public static Number evaluate(SharpTableModel sharpTableModel, int n, int n2) throws ParserException {
        if (Debug.isDebug()) {
            Debug.println("recalculating " + new CellPoint(n, n2));
        }
        Formula formula = sharpTableModel.getCellAt(n, n2).getFormula();
        formula.setNeedsRecalc(false);
        if (formula == null) {
            return new Integer(0);
        }
        return formula.evaluate(sharpTableModel);
    }

    private Number evaluate(SharpTableModel sharpTableModel) throws ParserException {
        if (this.isBad()) {
            throw this.error;
        }
        return Formula.evaluate(sharpTableModel, this.postfix, this.row, this.col);
    }

    public static Number evaluate(SharpTableModel sharpTableModel, LinkedList linkedList, int n, int n2) throws ParserException {
        try {
            Object object;
            Stack<Number> stack = new Stack<Number>();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Number number;
                object = (Node)iterator.next();
                switch (((Node)object).getType()) {
                    case 7: {
                        Number number2 = (Number)stack.pop();
                        Number number3 = (Number)stack.pop();
                        number = Formula.calc(((Node)object).getData().charAt(0), number3, number2);
                        break;
                    }
                    case 3: {
                        number = Formula.evalFunction(sharpTableModel, (Node)object, n, n2);
                        break;
                    }
                    case 6: {
                        number = new Float(((Node)object).getNumber());
                        break;
                    }
                    case 2: {
                        number = sharpTableModel.getNumericValueAt(((Node)object).getRow(), ((Node)object).getCol());
                        break;
                    }
                    case 1: {
                        number = sharpTableModel.getNumericValueAt(((Node)object).getRow() + n, ((Node)object).getCol() + n2);
                        break;
                    }
                    default: {
                        throw new ParserException("#EVAL?");
                    }
                }
                stack.push(number);
            }
            object = (Number)stack.pop();
            return object;
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParserException("#OP?");
        }
        catch (ParserException parserException) {
            throw parserException;
        }
        catch (Exception exception) {
            Debug.println(exception);
            return new Integer(0);
        }
    }

    private static final int translateRow(String string) {
        return Node.translateRow(string);
    }

    private static final String translateRow(int n) {
        return Node.translateRow(n);
    }

    private static final int translateColumn(String string) {
        return Node.translateColumn(string);
    }

    private static final String translateColumn(int n) {
        return Node.translateColumn(n);
    }

    private void throwError(Object object) throws ParserException {
        this.postfix = null;
        if (this.error instanceof ParserException) {
            throw (ParserException)object;
        }
        this.error = new ParserException(object);
        throw this.error;
    }

    private String getCellString() {
        return Formula.getCellString(this.row, this.col);
    }

    private static final String getCellString(int n, int n2) {
        return "" + Formula.translateColumn(n2) + Formula.translateRow(n);
    }

    public static final CellPoint parseAddress(String string) {
        try {
            char c;
            int n;
            string = string.toUpperCase();
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < n2; ++n) {
                c = string.charAt(n);
                if (Character.isUpperCase(c)) {
                    stringBuffer.append(c);
                    continue;
                }
                if (Character.isDigit(c)) break;
                return null;
            }
            int n3 = Formula.translateColumn(stringBuffer.toString());
            if (n3 == 0) {
                return null;
            }
            stringBuffer = new StringBuffer();
            while (n < n2) {
                c = string.charAt(n);
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                    ++n;
                    continue;
                }
                return null;
            }
            int n4 = Formula.translateRow(stringBuffer.toString());
            if (n4 == 0) {
                return null;
            }
            return new CellPoint(n4, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void register(String string, Function function) {
        funcTable.put(string, function);
    }

    public static void registerFunctions() {
        funcTable = new HashMap();
        Formula.register("SUM", new FunctionSum());
        Formula.register("MEAN", new FunctionAverage());
        Formula.register("AVERAGE", new FunctionAverage());
        Formula.register("MEDIAN", new FunctionMedian());
        Formula.register("ABS", new FunctionAbs());
        Formula.register("INT", new FunctionInt());
        Formula.register("ROUND", new FunctionRound());
        Formula.register("SIN", new FunctionSin());
        Formula.register("COS", new FunctionCos());
        Formula.register("TAN", new FunctionTan());
        Formula.register("ASIN", new FunctionAsin());
        Formula.register("ACOS", new FunctionAcos());
        Formula.register("ATAN", new FunctionAtan());
        Formula.register("SQRT", new FunctionSqrt());
        Formula.register("LOG", new FunctionLog());
        Formula.register("MIN", new FunctionMin());
        Formula.register("MAX", new FunctionMax());
        Formula.register("RANGE", new FunctionRange());
        Formula.register("STDDEV", new FunctionStddev());
        Formula.register("MEANDEV", new FunctionMeandev());
        Formula.register("COUNT", new FunctionCount());
        Formula.register("PI", new FunctionPI());
        Formula.register("E", new FunctionE());
    }

    public static Function getFuncHandler(String string) {
        return (Function)funcTable.get(string);
    }
}

