/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public final class HistoDialog
extends SharpDialog {
    private JFrame owner;
    private JTextField title;
    private AddressField startCell;
    private AddressField endCell;
    private NumberField startValue;
    private NumberField endValue;
    private NumberField bucket;
    private NumberField xMin;
    private NumberField xMax;
    private NumberField xUnit;
    private NumberField yMin;
    private NumberField yMax;
    private NumberField yUnit;
    private JRadioButton percentageButton;
    private JRadioButton countButton;
    private final ImageIcon histogramIcon32 = SharpTools.getImageIcon("chart32.gif");
    private static final String bucketstring = "Bucket Size";
    private static final String startvaluestring = "Start Value";
    private static final String endvaluestring = "End Value";
    private static final String xunitstring = "X Unit";
    private static final String yunitstring = "Y Unit";
    private static final String xminstring = "X Start";
    private static final String xmaxstring = "X End";
    private static final String yminstring = "Y Start";
    private static final String ymaxstring = "Y End";

    HistoDialog(JFrame jFrame) {
        super(jFrame, "Histogram Options", true);
        this.owner = jFrame;
        this.title = new JTextField(10);
        this.startCell = new AddressField(5);
        this.endCell = new AddressField(5);
        this.startValue = new NumberField(5);
        this.endValue = new NumberField(5);
        this.bucket = new NumberField(5, true);
        this.xMin = new NumberField(5);
        this.xMax = new NumberField(5);
        this.xUnit = new NumberField(5, true);
        this.yMin = new NumberField(5);
        this.yMax = new NumberField(5);
        this.yUnit = new NumberField(5, true);
        this.startCell.setToolTipText("Start cell");
        this.endCell.setToolTipText("End cell");
        this.startValue.setToolTipText("Start value");
        this.endValue.setToolTipText("End value");
        this.xMin.setToolTipText("Minumum value on X axis");
        this.xMax.setToolTipText("Maximum value on X axis");
        this.xUnit.setToolTipText("Unit on X axis");
        this.yMin.setToolTipText("Minumum value on Y axis");
        this.yMax.setToolTipText("Maximum value on Y axis");
        this.yUnit.setToolTipText("Unit on Y axis");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("Chart Title: ");
        jLabel.setLabelFor(this.title);
        jLabel.setDisplayedMnemonic(84);
        jPanel2.add(jLabel);
        jPanel2.add(this.title);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JSeparator());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jLabel = new JLabel("Cell Range: ");
        jLabel.setLabelFor(this.startCell);
        jLabel.setDisplayedMnemonic(67);
        jPanel2.add(jLabel);
        jPanel2.add(this.startCell);
        jPanel2.add(new JLabel(":"));
        jPanel2.add(this.endCell);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jLabel = new JLabel("Value Range: ");
        jLabel.setLabelFor(this.startValue);
        jLabel.setDisplayedMnemonic(86);
        jPanel2.add(jLabel);
        jPanel2.add(this.startValue);
        jLabel = new JLabel(" to ");
        jLabel.setLabelFor(this.endValue);
        jPanel2.add(jLabel);
        jPanel2.add(this.endValue);
        jPanel.add(jPanel2);
        jLabel = new JLabel("   Bucket ");
        jLabel.setLabelFor(this.bucket);
        jLabel.setDisplayedMnemonic(66);
        jPanel2.add(jLabel);
        jPanel2.add(this.bucket);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JSeparator());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jLabel = new JLabel("X Scale: ");
        jLabel.setLabelFor(this.xMin);
        jLabel.setDisplayedMnemonic(88);
        jPanel2.add(jLabel);
        jPanel2.add(this.xMin);
        jLabel = new JLabel(" to ");
        jLabel.setLabelFor(this.xMax);
        jPanel2.add(jLabel);
        jPanel2.add(this.xMax);
        jLabel = new JLabel("   Unit ");
        jLabel.setLabelFor(this.xUnit);
        jLabel.setDisplayedMnemonic(85);
        jPanel2.add(jLabel);
        jPanel2.add(this.xUnit);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jLabel = new JLabel("Y Scale: ");
        jLabel.setLabelFor(this.yMin);
        jLabel.setDisplayedMnemonic(89);
        jPanel2.add(jLabel);
        jPanel2.add(this.yMin);
        jLabel = new JLabel(" to ");
        jLabel.setLabelFor(this.yMax);
        jPanel2.add(jLabel);
        jPanel2.add(this.yMax);
        jLabel = new JLabel("   Unit ");
        jLabel.setLabelFor(this.yUnit);
        jLabel.setDisplayedMnemonic(78);
        jPanel2.add(jLabel);
        jPanel2.add(this.yUnit);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JSeparator());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.percentageButton = new JRadioButton("Percentage");
        this.percentageButton.setMnemonic(80);
        buttonGroup.add(this.percentageButton);
        jLabel = new JLabel("Display Y by ");
        jPanel2.add(jLabel);
        jPanel2.add(this.percentageButton);
        this.countButton = new JRadioButton("Count");
        this.countButton.setMnemonic(79);
        buttonGroup.add(this.countButton);
        jPanel2.add(this.countButton);
        jPanel.add(jPanel2);
        this.setOptionPane(jPanel, -1, 2, this.histogramIcon32);
        this.setDefaultCloseOperation(2);
        this.startCell.requestFocus();
    }

    private boolean validateInput() {
        if (!this.addressOK(this.startCell, "Start Cell")) {
            return false;
        }
        if (!this.addressOK(this.endCell, "End Cell")) {
            return false;
        }
        if (!this.orderOK(this.startValue, this.endValue, startvaluestring, endvaluestring)) {
            return false;
        }
        if (!this.orderOK(this.xMin, this.xMax, xminstring, xmaxstring)) {
            return false;
        }
        if (!this.orderOK(this.yMin, this.yMax, yminstring, ymaxstring)) {
            return false;
        }
        if (this.isNegative(this.bucket, bucketstring)) {
            return false;
        }
        if (this.isNegative(this.xUnit, xunitstring)) {
            return false;
        }
        return !this.isNegative(this.yUnit, yunitstring);
    }

    private boolean isNegative(NumberField numberField, String string) {
        Float f = numberField.getNumber();
        if (f == null || f.floatValue() <= 0.0f) {
            this.invalidInput(string);
            numberField.selectAll();
            numberField.requestFocus();
            return true;
        }
        return false;
    }

    private boolean orderOK(NumberField numberField, NumberField numberField2, String string, String string2) {
        Float f = numberField.getNumber();
        if (f == null) {
            this.invalidInput(string);
            numberField.selectAll();
            numberField.requestFocus();
            return false;
        }
        Float f2 = numberField2.getNumber();
        if (f2 == null) {
            this.invalidInput(string2);
            numberField2.selectAll();
            numberField2.requestFocus();
            return false;
        }
        if (f.floatValue() > f2.floatValue()) {
            numberField.setNumber(f2);
            numberField2.setNumber(f);
        }
        return true;
    }

    private boolean addressOK(AddressField addressField, String string) {
        CellPoint cellPoint = addressField.getAddress();
        if (cellPoint == null) {
            this.invalidInput(string);
            addressField.selectAll();
            addressField.requestFocus();
            return false;
        }
        return true;
    }

    public void setTitleField(String string) {
        this.title.setText(string);
        this.setTitle("Options - " + string);
    }

    public String getTitleField() {
        return this.title.getText();
    }

    public void setCellRange(CellRange cellRange) {
        if (cellRange != null) {
            this.startCell.setAddress(cellRange.getminCorner());
            this.endCell.setAddress(cellRange.getmaxCorner());
        }
    }

    public CellRange getCellRange() {
        CellPoint cellPoint = this.startCell.getAddress();
        CellPoint cellPoint2 = this.endCell.getAddress();
        if (cellPoint == null || cellPoint2 == null) {
            return null;
        }
        int n = Math.min(cellPoint.getRow(), cellPoint2.getRow());
        int n2 = Math.max(cellPoint.getRow(), cellPoint2.getRow());
        int n3 = Math.min(cellPoint.getCol(), cellPoint2.getCol());
        int n4 = Math.max(cellPoint.getCol(), cellPoint2.getCol());
        return new CellRange(n, n2, n3, n4);
    }

    public CellPoint getStartCell() {
        return this.startCell.getAddress();
    }

    public void setStartCell(CellPoint cellPoint) {
        this.startCell.setAddress(cellPoint);
    }

    public CellPoint getEndCell() {
        return this.endCell.getAddress();
    }

    public void setEndCell(CellPoint cellPoint) {
        this.endCell.setAddress(cellPoint);
    }

    public Float getStartValue() {
        return this.startValue.getNumber();
    }

    public void setStartValue(Float f) {
        this.startValue.setNumber(f);
    }

    public Float getEndValue() {
        return this.endValue.getNumber();
    }

    public void setEndValue(Float f) {
        this.endValue.setNumber(f);
    }

    public Float getBucket() {
        return this.bucket.getNumber();
    }

    public void setBucket(Float f) {
        this.bucket.setNumber(f);
    }

    public Float getXMin() {
        return this.xMin.getNumber();
    }

    public void setXMin(Float f) {
        this.xMin.setNumber(f);
    }

    public Float getXMax() {
        return this.xMax.getNumber();
    }

    public void setXMax(Float f) {
        this.xMax.setNumber(f);
    }

    public Float getXUnit() {
        return this.xUnit.getNumber();
    }

    public void setXUnit(Float f) {
        this.xUnit.setNumber(f);
    }

    public Float getYMin() {
        return this.yMin.getNumber();
    }

    public void setYMin(Float f) {
        this.yMin.setNumber(f);
    }

    public Float getYMax() {
        return this.yMax.getNumber();
    }

    public void setYMax(Float f) {
        this.yMax.setNumber(f);
    }

    public Float getYUnit() {
        return this.yUnit.getNumber();
    }

    public void setYUnit(Float f) {
        this.yUnit.setNumber(f);
    }

    public boolean getByPercentage() {
        return this.percentageButton.isSelected();
    }

    public void setByPercentage(boolean bl) {
        this.percentageButton.setSelected(bl);
        this.countButton.setSelected(!bl);
    }

    private void invalidInput(String string) {
        SharpOptionPane.showMessageDialog(this.owner, "Sorry, " + string + " does not have a valid value.  Please go back to check it.", "Histogram", 0, null);
    }

    protected boolean onOK() {
        return this.validateInput();
    }
}

