/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FileOp
implements ActionListener,
Printable {
    private static final int UNNAMED = 0;
    private static final int FILE = 1;
    private static final int DATABASE = 2;
    private int openType = 0;
    private int maxNumPage = 1;
    private boolean columnOverflow;
    private StringTokenizer tokenizer;
    private PrintStream out;
    private BufferedReader in;
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private File file;
    private String password;
    private JFileChooser fileChooser;
    private static SharpFileFilter filter;
    private static final ImageIcon newIcon;
    private static final ImageIcon openIcon;
    private static final ImageIcon saveIcon;
    private static final String extname = ".csv";

    public FileOp(SharpTools sharpTools) {
        this.sharp = sharpTools;
        this.table = sharpTools.getTable();
        this.tableModel = sharpTools.getTableModel();
        this.fileChooser = new JFileChooser(new File("."));
        filter = new SharpFileFilter();
        this.fileChooser.addChoosableFileFilter(filter);
        this.sharp.setTitle("Untitled - Sharp Tools Spreadsheet");
        this.columnOverflow = false;
        this.table.registerKeyboardAction(this, "New", KeyStroke.getKeyStroke(78, 2, false), 0);
        this.table.registerKeyboardAction(this, "OpenFile", KeyStroke.getKeyStroke(79, 2, false), 0);
        this.table.registerKeyboardAction(this, "OpenDb", KeyStroke.getKeyStroke(68, 2, false), 0);
        this.table.registerKeyboardAction(this, "Save", KeyStroke.getKeyStroke(83, 2, false), 0);
        this.table.registerKeyboardAction(this, "Print", KeyStroke.getKeyStroke(80, 2, false), 0);
        this.table.registerKeyboardAction(this, "Exit", KeyStroke.getKeyStroke(69, 2, false), 0);
    }

    public int queryForSave() {
        String string = "Untitled";
        if (this.file != null) {
            string = this.file.getName();
        }
        int n = SharpOptionPane.showOptionDialog(this.sharp, "Do you want to save the changes you made to \"" + string + "\"?", "Save", 1, 3, saveIcon);
        return n;
    }

    public void newFile() {
        int n = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (n) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                Config config = SharpTools.getConfig();
                NewFileDialog newFileDialog = new NewFileDialog(this.sharp, config.getInt("ROWS"), config.getInt("COLUMNS"));
                newFileDialog.setLocationRelativeTo(this.sharp);
                newFileDialog.setVisible(true);
                if (newFileDialog.isCancelled()) {
                    return;
                }
                int n2 = newFileDialog.getRows();
                int n3 = newFileDialog.getColumns();
                this.file = null;
                this.sharp.setTitle("Untitled - Sharp Tools Spreadsheet");
                this.sharp.newTableModel(n2, n3);
                this.tableModel = this.sharp.getTableModel();
                this.setPasswordValue(this.password);
            }
        }
    }

    public void saveFile() {
        if (this.tableModel.isModified()) {
            if (this.file == null) {
                this.saveAsFile();
            } else {
                this.saveTableModel();
            }
        }
    }

    public void saveAsFile() {
        int n = this.fileChooser.showSaveDialog(this.sharp);
        if (n == 0) {
            String string;
            File file = this.fileChooser.getSelectedFile();
            this.fileChooser = new JFileChooser(file.getParentFile());
            this.fileChooser.addChoosableFileFilter(filter);
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.fileOpError("Save", "Unexpected error!");
                return;
            }
            if (!string.endsWith(extname)) {
                file = new File(string + extname);
            }
            if (file.exists() && (n = SharpOptionPane.showOptionDialog(this.sharp, "File " + file.getName() + " already exists.\n\n" + "Do you want to overwrite it?\n\n", "Save", 0, 2, saveIcon, 1)) != 0) {
                return;
            }
            this.saveTableModel(file);
        }
    }

    public void openFile() {
        int n = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (n) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                int n2 = this.fileChooser.showOpenDialog(this.sharp);
                if (n2 != 0) break;
                File file = this.fileChooser.getSelectedFile();
                this.fileChooser = new JFileChooser(file.getParentFile());
                this.fileChooser.addChoosableFileFilter(filter);
                this.openTableModel(file);
            }
        }
    }

    public boolean closeFile() {
        int n = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (n) {
            case 2: {
                return false;
            }
            case 0: {
                this.saveFile();
            }
        }
        return true;
    }

    public void saveTableModel(File file) {
        try {
            this.out = new PrintStream(new FileOutputStream(file));
            int n = this.tableModel.getRowCount();
            int n2 = this.tableModel.getColumnCount();
            if (this.password != null && this.password.length() > 0) {
                this.out.println("Password: " + this.password);
            }
            this.out.print(this.tableModel.toString());
            this.out.flush();
            this.file = file;
            this.tableModel.setPasswordModified(false);
            this.tableModel.setModified(false);
            this.addRecentFile(this.file);
            String string = this.file.getName();
            if (string.endsWith(extname)) {
                string = string.substring(0, string.length() - 4);
            }
            this.sharp.setTitle(string + " - Sharp Tools Spreadsheet");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fileOpError("Save", "File \"" + file.getName() + "\" cannot be created!");
        }
        catch (IOException iOException) {
            this.fileOpError("Save", "I/O error in saving \"" + file.getName() + "\"!");
        }
    }

    public void saveTableModel() {
        this.saveTableModel(this.file);
    }

    public void openTableModel(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            this.in = new BufferedReader(new FileReader(file));
            String string2 = this.in.readLine();
            if (string2.indexOf(9) == -1 && string2.startsWith("Password: ")) {
                string = string2.substring(10);
                if (!this.verifyPassword(string)) {
                    return;
                }
            } else {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            while ((string2 = this.in.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            this.setPasswordValue(string);
            String string3 = stringBuffer.toString();
            CellPoint cellPoint = SharpTableModel.getSize(string3);
            this.sharp.newTableModel(cellPoint.getRow(), cellPoint.getCol());
            this.tableModel = this.sharp.getTableModel();
            this.tableModel.fromString(string3, 0, 0, new CellRange(SharpTools.baseRow, cellPoint.getRow(), SharpTools.baseCol, cellPoint.getCol()));
            this.file = file;
            String string4 = this.file.getName();
            if (string4.endsWith(extname)) {
                string4 = string4.substring(0, string4.length() - 4);
            }
            this.sharp.setTitle(string4 + " - Sharp Tools Spreadsheet");
            this.addRecentFile(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fileOpError("Open", "File \"" + file.getName() + "\" not found!");
        }
        catch (IOException iOException) {
            this.fileOpError("Open", "I/O error in opening \"" + file.getName() + "\"!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getRecentFile(int n) {
        Config config = SharpTools.getConfig();
        return config.get("RECENTFILE" + String.valueOf(n));
    }

    private void setRecentFile(int n, String string) {
        Config config = SharpTools.getConfig();
        config.set("RECENTFILE" + String.valueOf(n), string);
    }

    private void moveToFront(int n) {
        if (n <= 0) {
            return;
        }
        String string = this.getRecentFile(n);
        int n2 = n;
        while (n2 > 0) {
            this.setRecentFile(n2, this.getRecentFile(n2 - 1));
            --n2;
        }
        this.setRecentFile(0, string);
    }

    private void addRecentFile(File file) {
        try {
            String string = file.getCanonicalPath();
            int n = SharpTools.getConfig().getInt("RECENTFILELIST");
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(this.getRecentFile(n2))) {
                    this.moveToFront(n2);
                    return;
                }
                ++n2;
            }
            this.setRecentFile(n - 1, string);
            this.moveToFront(n - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createRecentFilesMenu(JMenu jMenu) {
        Config config = SharpTools.getConfig();
        jMenu.removeAll();
        try {
            int n = 0;
            while (n < config.getInt("RECENTFILELIST")) {
                String string = this.getRecentFile(n);
                if (string.length() > 0) {
                    File file = new File(string);
                    JMenuItem jMenuItem = new JMenuItem(file.getName(), openIcon);
                    jMenuItem.addActionListener(new RecentFileListener(file, this));
                    jMenu.add(jMenuItem);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPasswordValue(String string) {
        this.password = string;
        this.sharp.checkPasswordState();
    }

    public void printData() {
        FileOp fileOp = this;
        this.columnOverflow = false;
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(fileOp);
            if (!printerJob.printDialog()) {
                return;
            }
            this.maxNumPage = 1;
            printerJob.print();
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            this.fileOpError("Print", "Printing error: " + printerException.toString());
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (n >= this.maxNumPage) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n3 = 0;
        int n4 = 0;
        if (pageFormat.getOrientation() == 1) {
            n3 = (int)pageFormat.getImageableWidth();
            n4 = (int)pageFormat.getImageableHeight();
            n3 = 550;
            n4 = 950;
        } else {
            n3 = (int)pageFormat.getImageableWidth();
            n3 += n3 / 2;
            n4 = (int)pageFormat.getImageableHeight();
            n3 = 950;
            n4 = 550;
            graphics.setClip(0, 0, n3, n4);
        }
        int n5 = 0;
        graphics.setColor(Color.black);
        Font font = graphics.getFont().deriveFont(1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n5 += fontMetrics.getAscent();
        if (this.getFile() == null) {
            graphics.drawString("Untitled File", 0, n5);
        } else {
            graphics.drawString(this.getFile().getName(), 0, n5);
        }
        n5 += 20;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n6];
        nArray[0] = 0;
        int n7 = fontMetrics.getAscent();
        n5 += n7;
        int n8 = 1;
        while (n8 < n6) {
            TableColumn tableColumn = tableColumnModel.getColumn(n8);
            n2 = tableColumn.getWidth();
            if (nArray[n8] + n2 > n3) {
                n6 = n8;
                if (this.columnOverflow) break;
                this.fileOpError("Print", "Table width exceeds printed width,\nsome data will not be printed.");
                this.columnOverflow = true;
                break;
            }
            if (n8 + 1 < n6) {
                nArray[n8 + 1] = nArray[n8] + n2;
            }
            String string = (String)tableColumn.getIdentifier();
            ++n8;
        }
        graphics.setFont(this.table.getFont());
        fontMetrics = graphics.getFontMetrics();
        int n9 = n5;
        n7 = fontMetrics.getHeight();
        n2 = Math.max((int)((double)n7 * 1.5), 10);
        int n10 = (n4 - n9) / n2;
        this.maxNumPage = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)n10), 1);
        int n11 = n * n10;
        int n12 = Math.min(this.table.getRowCount(), n11 + n10);
        int n13 = n11 + 1;
        while (n13 < n12) {
            n5 += n7;
            n8 = 1;
            while (n8 < n6) {
                int n14 = this.table.getColumnModel().getColumn(n8).getModelIndex();
                String string = this.tableModel.getCellAt(n13, n8).getValue().toString();
                graphics.setColor(Color.black);
                graphics.drawString(string, nArray[n8], n5);
                ++n8;
            }
            ++n13;
        }
        System.gc();
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasPassword() {
        return this.password != null && this.password.length() > 0;
    }

    public void setPassword() {
        PasswordDialog passwordDialog = new PasswordDialog(this.sharp, null);
        passwordDialog.setVisible(true);
        String string = passwordDialog.getValidatedText();
        if (string != null) {
            this.setPasswordValue(string);
            this.tableModel.setPasswordModified(true);
        }
        this.table.requestFocus();
    }

    private boolean verifyPassword(String string) {
        PasswordDialog passwordDialog = new PasswordDialog(this.sharp, string);
        passwordDialog.pack();
        passwordDialog.setLocationRelativeTo(this.sharp);
        passwordDialog.setVisible(true);
        String string2 = passwordDialog.getValidatedText();
        this.table.requestFocus();
        return string2 != null;
    }

    private void fileOpError(String string, String string2) {
        SharpOptionPane.showMessageDialog(this.sharp, string2, string, 0, null);
        this.table.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("New") == 0) {
            this.newFile();
        } else if (actionEvent.getActionCommand().compareTo("OpenFile") == 0) {
            this.openFile();
        } else if (actionEvent.getActionCommand().compareTo("OpenDb") == 0) {
            this.openDb();
        } else if (actionEvent.getActionCommand().compareTo("Save") == 0) {
            this.saveFile();
        } else if (actionEvent.getActionCommand().compareTo("Print") == 0) {
            this.printData();
        } else if (actionEvent.getActionCommand().compareTo("Exit") == 0) {
            this.sharp.exit();
        }
    }

    public void openDb() {
        int n = this.tableModel.isModified() ? this.queryForSave() : 1;
        switch (n) {
            case 0: {
                this.saveFile();
            }
            case 1: {
                Database database = new Database(this.sharp);
                database.connectDb();
            }
        }
    }

    static {
        newIcon = SharpTools.getImageIcon("new32.gif");
        openIcon = SharpTools.getImageIcon("open.gif");
        saveIcon = SharpTools.getImageIcon("save32.gif");
    }

    class SharpFileFilter
    extends FileFilter {
        SharpFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(FileOp.extname);
        }

        public String getDescription() {
            return "Sharp Tools Spreadsheet (*.csv)";
        }
    }
}

