/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class Database {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private static final ImageIcon connectedIcon = SharpTools.getImageIcon("database32.gif");
    private static final ImageIcon dbErrorIcon = null;

    Database(SharpTools sharpTools) {
        this.sharp = sharpTools;
        this.table = sharpTools.getTable();
        this.tableModel = sharpTools.getTableModel();
    }

    public void connectDb() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string = null;
        Object var6_6 = null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        ConnectDialog connectDialog = new ConnectDialog(this.sharp);
        connectDialog.setVisible(true);
        if (connectDialog.isCancelled()) {
            return;
        }
        Connection connection = connectDialog.getConnection();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            SharpOptionPane.showMessageDialog(this.sharp, "Connected to database " + databaseMetaData.getDatabaseProductName() + " v" + databaseMetaData.getDatabaseProductVersion() + "\nusing driver " + databaseMetaData.getDriverName() + " v" + databaseMetaData.getDriverVersion(), "Connected", 1, connectedIcon);
            if (string == null || string.equals("")) {
                string = this.selectDbTable(databaseMetaData);
            }
            if (string == null) {
                return;
            }
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
            String string2 = this.checkForWarning(connection.getWarnings());
            if (string2 != null && !string2.equals("")) {
                SharpOptionPane.showMessageDialog(this.sharp, string2, "Warning", 1, connectedIcon);
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 1;
            while (n2 <= n) {
                if (n2 != 1) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(resultSetMetaData.getColumnLabel(n2));
                ++n2;
            }
            stringBuffer.append("\n");
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    if (n3 != 1) {
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(resultSet.getString(n3));
                    ++n3;
                }
                stringBuffer.append("\n");
            }
            String string3 = stringBuffer.toString();
            CellPoint cellPoint = SharpTableModel.getSize(string3);
            this.sharp.newTableModel(cellPoint.getRow(), cellPoint.getCol());
            this.tableModel = this.sharp.getTableModel();
            this.tableModel.fromString(string3, 0, 0, new CellRange(1, cellPoint.getRow(), 1, cellPoint.getCol()));
            this.sharp.setTitle(string + " - Sharp Tools Spreadsheet");
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            SharpOptionPane.showMessageDialog(this.sharp, "Unable to get data from the database.\n" + sQLException.toString(), "ERROR", 1, dbErrorIcon);
            return;
        }
    }

    private String checkForWarning(SQLWarning sQLWarning) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (sQLWarning != null) {
            stringBuffer.append("Warning:\n\n");
            while (sQLWarning != null) {
                stringBuffer.append("Message:  " + sQLWarning.getMessage() + "\n");
                stringBuffer.append("SQLState: " + sQLWarning.getSQLState() + "\n");
                stringBuffer.append("Vendor:   " + sQLWarning.getErrorCode() + "\n");
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
        return stringBuffer.toString();
    }

    private String selectDbTable(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTables(null, null, "%", null);
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(3));
        }
        if (vector.size() == 0) {
            SharpOptionPane.showMessageDialog(this.sharp, "This database has no tables defined.", "Empty Database", 2);
            return null;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        Object object = SharpOptionPane.showInputDialog(this.sharp, "Please select the table you wish to load: ", "Select Table", 0, connectedIcon, objectArray, objectArray[0]);
        if (object == null) {
            return null;
        }
        return object.toString();
    }
}

