/*
 * Decompiled with CFR 0.152.
 */
import java.util.TreeSet;

public class Cell {
    public static final int TEXT = 0;
    public static final int NUMBER = 1;
    public static final int FORMULA = 2;
    private Object value;
    private Formula expression;
    private TreeSet refs;

    public Cell() {
        this.value = null;
        this.expression = null;
        this.refs = null;
    }

    public Cell(Object object) {
        this.value = object;
        this.expression = null;
        this.refs = null;
    }

    public Cell(Object object, TreeSet treeSet) {
        this.value = object;
        this.expression = null;
        this.refs = treeSet;
    }

    public Cell(Formula formula, Object object, TreeSet treeSet) {
        this.expression = formula;
        this.value = object;
        this.refs = treeSet;
    }

    public Formula getFormula() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void setData(Object object) {
        this.value = object;
        this.expression = null;
    }

    public void setFormula(Formula formula) {
        this.expression = formula;
    }

    public boolean isEmpty() {
        return this.value.equals("") && this.expression == null;
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public TreeSet getRefs() {
        return this.refs;
    }

    public void removeRef(CellPoint cellPoint) {
        if (this.refs != null) {
            this.refs.remove(cellPoint);
            if (this.refs.isEmpty()) {
                this.refs = null;
            }
        }
    }

    public void addRef(CellPoint cellPoint) {
        if (this.refs == null) {
            this.refs = new TreeSet();
        }
        this.refs.add(cellPoint);
    }

    public int getType() {
        if (this.expression != null) {
            return 2;
        }
        if (this.value instanceof Number) {
            return 1;
        }
        return 0;
    }

    public boolean isFormula() {
        return this.expression != null;
    }

    public boolean isErrorCell() {
        return this.isFormula() && this.value instanceof ParserException;
    }

    public int compare(Cell cell, boolean bl) {
        if (this.value.equals("")) {
            if (!cell.value.equals("")) {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        if (cell.value.equals("")) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        if (this.isErrorCell()) {
            if (cell.isErrorCell()) {
                return 0;
            }
            return -1;
        }
        if (cell.isErrorCell()) {
            return 1;
        }
        if (this.getType() == 0) {
            if (cell.getType() == 0) {
                String string = (String)this.value;
                return string.compareToIgnoreCase((String)cell.value);
            }
            return -1;
        }
        if (cell.getType() == 0) {
            return 1;
        }
        Float f = (Float)this.value;
        Float f2 = (Float)cell.value;
        return f.compareTo(f2);
    }

    public String toString() {
        if (this.expression != null) {
            return "=" + this.expression.toString();
        }
        return this.value.toString();
    }
}

