/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser.node;

import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.ConstantNode;
import com.eteks.parser.node.ExpressionNode;
import com.eteks.parser.node.ParameterizedNode;

public class UnaryOperatorNode
extends ConstantNode
implements ParameterizedNode {
    private ExpressionNode operand;

    public UnaryOperatorNode(Object object) {
        super(object);
    }

    public void addParameter(ExpressionNode expressionNode) {
        this.operand = expressionNode;
    }

    public int getParameterCount() {
        return this.operand != null ? 1 : 0;
    }

    public ExpressionNode getOperand() {
        return this.operand;
    }

    public Object computeExpression(Interpreter interpreter, Object[] objectArray) {
        Object object = this.operand.computeExpression(interpreter, objectArray);
        return interpreter.getUnaryOperatorValue(this.getKey(), object);
    }

    public double computeExpression(double[] dArray) {
        double d = this.operand.computeExpression(dArray);
        Object object = this.getKey();
        if (object.equals(Syntax.OPERATOR_OPPOSITE)) {
            return -d;
        }
        if (object.equals(Syntax.OPERATOR_POSITIVE)) {
            return d;
        }
        if (object.equals(Syntax.OPERATOR_LOGICAL_NOT)) {
            return d != 0.0 ? 1.0 : 0.0;
        }
        if (object.equals(Syntax.OPERATOR_BITWISE_NOT)) {
            if (Math.floor(d) != d) {
                throw new IllegalArgumentException("Operator operand not an integer");
            }
            return (long)d ^ 0xFFFFFFFFFFFFFFFFL;
        }
        throw new IllegalArgumentException("Unary operator key " + object + " not implemented");
    }
}

