/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser.node;

import com.eteks.parser.Interpreter;
import com.eteks.parser.Syntax;
import com.eteks.parser.node.ExpressionNode;

public class ConstantNode
implements ExpressionNode {
    public static final double FALSE_DOUBLE = 0.0;
    public static final double TRUE_DOUBLE = 1.0;
    private Object key;

    public ConstantNode(Object object) {
        this.key = object;
    }

    public Object getKey() {
        return this.key;
    }

    public Object computeExpression(Interpreter interpreter, Object[] objectArray) {
        return interpreter.getConstantValue(this.key);
    }

    public double computeExpression(double[] dArray) {
        if (Syntax.CONSTANT_PI.equals(this.key)) {
            return Math.PI;
        }
        if (Syntax.CONSTANT_E.equals(this.key)) {
            return Math.E;
        }
        if (Syntax.CONSTANT_FALSE.equals(this.key)) {
            return 0.0;
        }
        if (Syntax.CONSTANT_TRUE.equals(this.key)) {
            return 1.0;
        }
        throw new IllegalArgumentException("Constant key " + this.key + " not implemented");
    }
}

