/*
 * Decompiled with CFR 0.152.
 */
package csheets.io;

import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import csheets.io.Codec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.LinkedList;

public class CSVCodec
implements Codec {
    public static final String SEPARATOR = ";";

    public Workbook read(InputStream inputStream) throws IOException {
        String[] stringArray;
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 0;
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        while ((string = bufferedReader.readLine()) != null) {
            stringArray = string.split(SEPARATOR);
            linkedList.add(stringArray);
            if (stringArray.length <= n) continue;
            n = stringArray.length;
        }
        stringArray = new String[linkedList.size()][n];
        int n2 = 0;
        for (String[] stringArray2 : linkedList) {
            stringArray[n2++] = stringArray2;
        }
        bufferedReader.close();
        ((Reader)inputStreamReader).close();
        inputStream.close();
        return new Workbook(new String[][][]{stringArray});
    }

    public void write(Workbook workbook, OutputStream outputStream) throws IOException {
        System.out.println("Writing!");
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        Spreadsheet spreadsheet = workbook.getSpreadsheet(0);
        for (int i = 0; i < spreadsheet.getRowCount(); ++i) {
            for (int j = 0; j < spreadsheet.getColumnCount(); ++j) {
                if (j + 1 >= spreadsheet.getColumnCount()) continue;
                printWriter.print(spreadsheet.getCell(j, i).getContent() + SEPARATOR);
            }
            if (i + 1 >= spreadsheet.getRowCount()) continue;
            printWriter.println();
        }
        printWriter.close();
        outputStream.close();
        System.out.println("Done!");
    }
}

