/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.style.ui;

import csheets.ext.style.StylableCell;
import csheets.ext.style.ui.AlignCenterAction;
import csheets.ext.style.ui.AlignLeftAction;
import csheets.ext.style.ui.AlignRightAction;
import csheets.ext.style.ui.BackgroundAction;
import csheets.ext.style.ui.BoldAction;
import csheets.ext.style.ui.BorderAction;
import csheets.ext.style.ui.FontAction;
import csheets.ext.style.ui.ForegroundAction;
import csheets.ext.style.ui.FormatAction;
import csheets.ext.style.ui.ItalicAction;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ctrl.UIController;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class StyleToolBar
extends JToolBar
implements SelectionListener {
    private static final Insets INSETS = new Insets(2, 2, 2, 2);
    private JToggleButton boldButton;
    private JToggleButton italicButton;
    private Map<Integer, JToggleButton> hAlignButtons = new HashMap<Integer, JToggleButton>();

    public StyleToolBar(UIController uIController) {
        super("Style");
        uIController.addSelectionListener(this);
        this.add(new FontAction(uIController));
        this.boldButton = this.addToggleButton(new BoldAction(uIController), new ButtonGroup[0]);
        this.italicButton = this.addToggleButton(new ItalicAction(uIController), new ButtonGroup[0]);
        this.addSeparator();
        this.add(new FormatAction(uIController));
        this.add(new BorderAction(uIController));
        this.add(new ForegroundAction(uIController));
        this.add(new BackgroundAction(uIController));
        this.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.hAlignButtons.put(2, this.addToggleButton(new AlignLeftAction(uIController), buttonGroup));
        this.hAlignButtons.put(0, this.addToggleButton(new AlignCenterAction(uIController), buttonGroup));
        this.hAlignButtons.put(4, this.addToggleButton(new AlignRightAction(uIController), buttonGroup));
    }

    public JButton add(Action action) {
        JButton jButton = super.add(action);
        jButton.setMargin(INSETS);
        return jButton;
    }

    public JToggleButton addToggleButton(Action action, ButtonGroup ... buttonGroupArray) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setText(null);
        jToggleButton.setMargin(INSETS);
        this.add(jToggleButton);
        for (ButtonGroup buttonGroup : buttonGroupArray) {
            buttonGroup.add(jToggleButton);
        }
        return jToggleButton;
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        if (selectionEvent.getCell() != null && selectionEvent.isCellChanged()) {
            StylableCell stylableCell = (StylableCell)selectionEvent.getCell().getExtension("Style");
            this.boldButton.setSelected(stylableCell.getFont().isBold());
            this.italicButton.setSelected(stylableCell.getFont().isItalic());
            this.hAlignButtons.get(stylableCell.getHorizontalAlignment()).setSelected(true);
        }
    }
}

