/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.ext.assertion.Interval;
import csheets.ext.assertion.MultiInterval;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assertion
implements Serializable {
    protected MultiInterval intervals = new MultiInterval();
    protected boolean isInteger;

    public Iterator<Interval> getIntervalIterator() {
        return this.intervals.iterator();
    }

    public MultiInterval getMultiInterval() {
        return this.intervals;
    }

    public boolean allowsIntegersOnly() {
        return this.isInteger;
    }

    public Result validate(Value value) {
        if (value.toAny() == null) {
            return Result.NO_DATA;
        }
        try {
            return this.validate(value.toDouble());
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            return Result.NAN;
        }
    }

    public Result validate(double d) {
        if (Double.isNaN(d)) {
            return Result.NAN;
        }
        if (this.isInteger && Math.ceil(d) != Math.floor(d)) {
            return Result.FAILED;
        }
        return this.intervals.contains(d) ? Result.OK : Result.FAILED;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Assertion)) {
            return false;
        }
        Assertion assertion = (Assertion)object;
        return this.intervals.equals(assertion.intervals);
    }

    public String toString() {
        String string = "";
        Iterator<Interval> iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            string = string + interval.toString();
            if (!iterator.hasNext()) continue;
            string = string + " or ";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonResult {
        OK,
        NON_EQUAL,
        ILLEGAL_INTERVAL{
            private String errorMsg;

            public void setErrorMsg(String string) {
                this.errorMsg = string;
            }

            public String getErrorMsg() {
                return this.errorMsg;
            }
        };


        public void setErrorMsg(String string) {
        }

        public String getErrorMsg() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        OK,
        FAILED,
        NO_DATA,
        NAN;

    }
}

