/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.util;

import csheets.core.formula.BinaryOperation;
import csheets.core.formula.FunctionCall;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.UnaryOperation;
import csheets.core.formula.util.AbstractExpressionVisitor;

public class ExpressionTreePrinter
extends AbstractExpressionVisitor {
    public static final int INDENT_DISTANCE = 3;
    private int indentCount = 0;

    public Object visitLiteral(Literal literal) {
        this.print(literal);
        return literal;
    }

    public Object visitUnaryOperation(UnaryOperation unaryOperation) {
        this.print(unaryOperation.getOperator());
        ++this.indentCount;
        super.visitUnaryOperation(unaryOperation);
        --this.indentCount;
        return unaryOperation;
    }

    public Object visitBinaryOperation(BinaryOperation binaryOperation) {
        this.print(binaryOperation.getOperator());
        ++this.indentCount;
        super.visitBinaryOperation(binaryOperation);
        --this.indentCount;
        return binaryOperation;
    }

    public Object visitReference(Reference reference) {
        this.print(reference);
        return reference;
    }

    public Object visitFunctionCall(FunctionCall functionCall) {
        this.print(functionCall.getFunction());
        ++this.indentCount;
        super.visitFunctionCall(functionCall);
        --this.indentCount;
        return functionCall;
    }

    private void print(Object object) {
        String string = "";
        for (int i = 0; i < this.indentCount * 3; ++i) {
            string = string + " ";
        }
        System.out.println(string + object);
    }
}

