/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.util;

import csheets.core.formula.BinaryOperation;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Expression;
import csheets.core.formula.FunctionCall;
import csheets.core.formula.Literal;
import csheets.core.formula.Reference;
import csheets.core.formula.UnaryOperation;
import csheets.core.formula.UnaryOperator;
import csheets.core.formula.compiler.IllegalFunctionCallException;
import csheets.core.formula.lang.CellReference;
import csheets.core.formula.lang.ReferenceOperation;
import csheets.core.formula.util.ExpressionVisitor;

public class ExpressionBuilder
implements ExpressionVisitor {
    public Expression getExpression(Expression expression) {
        return (Expression)expression.accept(this);
    }

    public Expression visitLiteral(Literal literal) {
        return new Literal(literal.getValue());
    }

    public Expression visitUnaryOperation(UnaryOperation unaryOperation) {
        Expression expression = (Expression)unaryOperation.getOperand().accept(this);
        return new UnaryOperation((UnaryOperator)unaryOperation.getOperator(), expression);
    }

    public Expression visitBinaryOperation(BinaryOperation binaryOperation) {
        Expression expression = (Expression)binaryOperation.getLeftOperand().accept(this);
        Expression expression2 = (Expression)binaryOperation.getRightOperand().accept(this);
        return new BinaryOperation(expression, (BinaryOperator)binaryOperation.getOperator(), expression2);
    }

    public Expression visitReference(Reference reference) {
        if (reference instanceof CellReference) {
            CellReference cellReference = (CellReference)reference;
            return new CellReference(cellReference.getCell(), cellReference.isColumnAbsolute(), cellReference.isRowAbsolute());
        }
        ReferenceOperation referenceOperation = (ReferenceOperation)reference;
        return new ReferenceOperation((Reference)referenceOperation.getLeftOperand().accept(this), referenceOperation.getOperator(), (Reference)referenceOperation.getRightOperand().accept(this));
    }

    public Expression visitFunctionCall(FunctionCall functionCall) {
        Expression[] expressionArray = functionCall.getArguments();
        Expression[] expressionArray2 = new Expression[expressionArray.length];
        int n = 0;
        for (Expression expression : expressionArray) {
            expressionArray2[n++] = (Expression)expression.accept(this);
        }
        try {
            return new FunctionCall(functionCall.getFunction(), expressionArray2);
        }
        catch (IllegalFunctionCallException illegalFunctionCallException) {
            return null;
        }
    }
}

