/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.core.IllegalValueTypeException;
import csheets.core.Value;
import csheets.core.formula.Expression;
import csheets.core.formula.Function;
import csheets.core.formula.FunctionParameter;

public class Factorial
implements Function {
    public static final FunctionParameter[] parameters = new FunctionParameter[]{new FunctionParameter(Value.Type.NUMERIC, "Number", false, "The positive integer for which to calculate the factorial")};

    public String getIdentifier() {
        return "FACT";
    }

    public Value applyTo(Expression[] expressionArray) throws IllegalValueTypeException {
        double d = expressionArray[0].evaluate().toDouble();
        if (d >= 1.0 && d == (double)Math.round(d)) {
            int n = 1;
            int n2 = 2;
            while ((double)n2 <= d) {
                n *= n2;
                ++n2;
            }
            return new Value(n);
        }
        return new Value(new IllegalArgumentException("Argument must be a positive integer"));
    }

    public FunctionParameter[] getParameters() {
        return parameters;
    }

    public boolean isVarArg() {
        return false;
    }
}

