/*
 * Decompiled with CFR 0.152.
 */
package csheets.ui.ctrl;

import csheets.CleanSheets;
import csheets.SpreadsheetAppEvent;
import csheets.SpreadsheetAppListener;
import csheets.core.Cell;
import csheets.core.Spreadsheet;
import csheets.core.Workbook;
import csheets.ext.Extension;
import csheets.ext.ExtensionManager;
import csheets.ui.ctrl.EditEvent;
import csheets.ui.ctrl.EditListener;
import csheets.ui.ctrl.SelectionEvent;
import csheets.ui.ctrl.SelectionListener;
import csheets.ui.ext.UIExtension;
import csheets.ui.sheet.CellTransferHandler;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class UIController
implements SpreadsheetAppListener {
    private Workbook activeWorkbook;
    private Spreadsheet activeSpreadsheet;
    private Cell activeCell;
    private Stack<Workbook> workbooks = new Stack();
    private Map<Workbook, Boolean> changeLog = new HashMap<Workbook, Boolean>();
    private CleanSheets app;
    private TransferHandler transferHandler = new CellTransferHandler();
    private UIExtension[] extensions;
    private List<SelectionListener> selListeners = new ArrayList<SelectionListener>();
    private List<EditListener> editListeners = new ArrayList<EditListener>();

    public UIController(CleanSheets cleanSheets) {
        this.app = cleanSheets;
        cleanSheets.addSpreadsheetAppListener(this);
        LinkedList<UIExtension> linkedList = new LinkedList<UIExtension>();
        for (Extension extension : ExtensionManager.getInstance().getExtensions()) {
            UIExtension uIExtension = extension.getUIExtension(this);
            if (uIExtension == null) continue;
            linkedList.add(uIExtension);
        }
        this.extensions = linkedList.toArray(new UIExtension[linkedList.size()]);
    }

    public Workbook getActiveWorkbook() {
        return this.activeWorkbook;
    }

    public void setActiveWorkbook(Workbook workbook) {
        if (this.activeWorkbook == null || this.activeWorkbook != workbook) {
            Workbook workbook2 = this.activeWorkbook;
            Spreadsheet spreadsheet = this.activeSpreadsheet;
            Cell cell = this.activeCell;
            this.activeWorkbook = workbook;
            this.activeSpreadsheet = null;
            this.activeCell = null;
            if (this.activeWorkbook != null) {
                this.workbooks.remove(this.activeWorkbook);
                this.workbooks.push(this.activeWorkbook);
            }
            this.fireSelectionChanged(new SelectionEvent(this, this.activeWorkbook, this.activeSpreadsheet, this.activeCell, workbook2, spreadsheet, cell));
        }
    }

    public Spreadsheet getActiveSpreadsheet() {
        return this.activeSpreadsheet;
    }

    public void setActiveSpreadsheet(Spreadsheet spreadsheet) {
        if (this.activeSpreadsheet == null || this.activeSpreadsheet != spreadsheet) {
            Workbook workbook = this.activeWorkbook;
            Spreadsheet spreadsheet2 = this.activeSpreadsheet;
            Cell cell = this.activeCell;
            this.activeSpreadsheet = spreadsheet;
            this.activeWorkbook = this.activeSpreadsheet.getWorkbook();
            if (this.activeWorkbook != null) {
                this.workbooks.remove(this.activeWorkbook);
                this.workbooks.push(this.activeWorkbook);
            }
            this.fireSelectionChanged(new SelectionEvent(this, this.activeWorkbook, this.activeSpreadsheet, this.activeCell, workbook, spreadsheet2, cell));
        }
    }

    public Cell getActiveCell() {
        return this.activeCell;
    }

    public void setActiveCell(Cell cell) {
        if (this.activeCell == null || this.activeCell != cell) {
            Workbook workbook = this.activeWorkbook;
            Spreadsheet spreadsheet = this.activeSpreadsheet;
            Cell cell2 = this.activeCell;
            this.activeCell = cell;
            this.activeSpreadsheet = cell.getSpreadsheet();
            this.activeWorkbook = this.activeSpreadsheet.getWorkbook();
            if (this.activeWorkbook != null) {
                this.workbooks.remove(this.activeWorkbook);
                this.workbooks.push(this.activeWorkbook);
            }
            this.fireSelectionChanged(new SelectionEvent(this, this.activeWorkbook, this.activeSpreadsheet, this.activeCell, workbook, spreadsheet, cell2));
        }
    }

    public boolean isActiveWorkbookModified() {
        if (this.activeWorkbook != null) {
            Boolean bl = this.changeLog.get(this.activeWorkbook);
            return bl != null && bl == true;
        }
        return false;
    }

    public boolean isWorkbookModified(Workbook workbook) {
        Boolean bl = this.changeLog.get(workbook);
        return bl != null && bl == true;
    }

    public void setWorkbookModified(Workbook workbook) {
        this.changeLog.put(workbook, true);
        this.fireWorkbookModified(workbook);
    }

    public TransferHandler getCellTransferHandler() {
        return this.transferHandler;
    }

    public Properties getUserProperties() {
        return this.app.getUserProperties();
    }

    public UIExtension[] getExtensions() {
        return this.extensions;
    }

    public void workbookCreated(SpreadsheetAppEvent spreadsheetAppEvent) {
        Workbook workbook = spreadsheetAppEvent.getWorkbook();
        this.changeLog.put(workbook, false);
        if (workbook.getSpreadsheetCount() > 0) {
            this.setActiveCell(workbook.getSpreadsheet(0).getCell(0, 0));
        } else {
            this.setActiveWorkbook(workbook);
        }
    }

    public void workbookLoaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.workbookCreated(spreadsheetAppEvent);
    }

    public void workbookUnloaded(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.changeLog.remove(spreadsheetAppEvent.getWorkbook());
        this.workbooks.remove(spreadsheetAppEvent.getWorkbook());
        Workbook workbook = null;
        try {
            workbook = this.workbooks.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.setActiveWorkbook(workbook);
    }

    public void workbookSaved(SpreadsheetAppEvent spreadsheetAppEvent) {
        this.changeLog.put(spreadsheetAppEvent.getWorkbook(), false);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selListeners.remove(selectionListener);
    }

    public void addEditListener(EditListener editListener) {
        this.editListeners.add(editListener);
    }

    public void removeEditListener(EditListener editListener) {
        this.editListeners.remove(editListener);
    }

    private void fireSelectionChanged(SelectionEvent selectionEvent) {
        SwingUtilities.invokeLater(new EventDispatcher(selectionEvent, this.selListeners.toArray(new SelectionListener[this.selListeners.size()])));
    }

    private void fireWorkbookModified(Workbook workbook) {
        EditEvent editEvent = new EditEvent(this, workbook);
        for (EditListener editListener : this.editListeners.toArray(new EditListener[this.editListeners.size()])) {
            editListener.workbookModified(editEvent);
        }
    }

    public static class EventDispatcher
    implements Runnable {
        private SelectionEvent event;
        private SelectionListener[] listeners;

        public EventDispatcher(SelectionEvent selectionEvent, SelectionListener[] selectionListenerArray) {
            this.event = selectionEvent;
            this.listeners = selectionListenerArray;
        }

        public void run() {
            for (SelectionListener selectionListener : this.listeners) {
                selectionListener.selectionChanged(this.event);
            }
        }
    }
}

