/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.test.ui;

import csheets.core.Value;
import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.Assertion;
import csheets.ext.test.DuplicateUserTCPException;
import csheets.ext.test.TestCaseParam;
import csheets.ext.test.TestableCell;
import csheets.ui.ctrl.UIController;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseParamController {
    private UIController uiController;

    public TestCaseParamController(UIController uIController) {
        this.uiController = uIController;
    }

    public TestCaseParam setTestCaseParams(TestableCell testableCell, String string, Set<TestCaseParam> set) {
        HashSet<TestCaseParam> hashSet = new HashSet<TestCaseParam>(testableCell.getTestCaseParams());
        hashSet.removeAll(set);
        if (!hashSet.isEmpty()) {
            for (TestCaseParam serializable : hashSet) {
                testableCell.removeTestCaseParam(serializable);
            }
        }
        if (string != null) {
            AssertableCell duplicateUserTCPException;
            Value value = Value.parseValue(string, new Value.Type[0]);
            if (value.getType() == Value.Type.NUMERIC && (duplicateUserTCPException = (AssertableCell)testableCell.getExtension("Assertions")) != null && duplicateUserTCPException.isAsserted() && duplicateUserTCPException.assertAny(value) == Assertion.Result.FAILED) {
                this.showError("The test case parameter that was entered for cell " + testableCell + " violated the cell's assertion.");
            }
            try {
                TestCaseParam testCaseParam = testableCell.addTestCaseParam(value);
                this.uiController.setWorkbookModified(testableCell.getSpreadsheet().getWorkbook());
                return testCaseParam;
            }
            catch (DuplicateUserTCPException duplicateUserTCPException2) {
                this.showError(duplicateUserTCPException2.getMessage());
                return null;
            }
        }
        return null;
    }

    private void showError(Object object) {
        JOptionPane.showMessageDialog(null, object, "Error", 0);
    }
}

