/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext.assertion.ui;

import csheets.ext.assertion.AssertableCell;
import csheets.ext.assertion.Assertion;
import csheets.ext.assertion.AssertionException;
import csheets.ext.assertion.AssertionWarning;
import csheets.ext.assertion.USAssertion;
import csheets.ui.ctrl.UIController;
import java.awt.Color;
import javax.swing.JOptionPane;

public class AssertionController {
    private UIController uiController;

    public AssertionController(UIController uIController) {
        this.uiController = uIController;
    }

    public boolean setAssertion(AssertableCell assertableCell, String string) {
        USAssertion uSAssertion;
        if (string == null || string.equals("")) {
            assertableCell.setUSAssertion(null);
            return true;
        }
        try {
            uSAssertion = new USAssertion(string);
        }
        catch (AssertionException assertionException) {
            this.showError(assertionException);
            return false;
        }
        assertableCell.setUSAssertion(uSAssertion);
        this.uiController.setWorkbookModified(assertableCell.getSpreadsheet().getWorkbook());
        if (!uSAssertion.isConsistent()) {
            String string2 = "The assertion may be incorrect or inconsistent:\n";
            for (AssertionWarning assertionWarning : uSAssertion.getWarnings()) {
                string2 = string2 + "\n" + assertionWarning;
            }
            this.showError(string2);
        }
        return true;
    }

    public static Color getAssertionResultColor(Assertion.Result result) {
        switch (result) {
            case OK: {
                return new Color(0.0f, 0.7f, 0.0f);
            }
            case NAN: {
                return new Color(0.7f, 0.0f, 0.0f);
            }
            case FAILED: {
                return new Color(0.7f, 0.0f, 0.0f);
            }
            case NO_DATA: {
                return new Color(0.7f, 0.7f, 0.0f);
            }
        }
        return Color.BLACK;
    }

    private void showError(Object object) {
        JOptionPane.showMessageDialog(null, object, "Error", 0);
    }
}

