/*
 * Decompiled with CFR 0.152.
 */
package csheets.ext;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.CellListener;
import csheets.core.Spreadsheet;
import csheets.core.Value;
import csheets.core.formula.Formula;
import csheets.core.formula.compiler.FormulaCompilationException;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CellExtension
implements Cell,
CellListener {
    private Cell delegate;
    private String name;

    public CellExtension(Cell cell, String string) {
        this.delegate = cell;
        this.name = string;
        cell.addCellListener(this);
    }

    public final Cell getDelegate() {
        return this.delegate;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final Spreadsheet getSpreadsheet() {
        Spreadsheet spreadsheet = this.delegate.getSpreadsheet();
        Spreadsheet spreadsheet2 = (Spreadsheet)spreadsheet.getExtension(this.name);
        if (spreadsheet2 != null) {
            return spreadsheet2;
        }
        return spreadsheet;
    }

    @Override
    public final Address getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public final Value getValue() {
        return this.delegate.getValue();
    }

    @Override
    public final String getContent() {
        return this.delegate.getContent();
    }

    @Override
    public final Formula getFormula() {
        return this.delegate.getFormula();
    }

    @Override
    public final void setContent(String string) throws FormulaCompilationException {
        this.delegate.setContent(string);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public final SortedSet<Cell> getPrecedents() {
        TreeSet<Cell> treeSet = new TreeSet<Cell>();
        for (Cell cell : this.delegate.getPrecedents()) {
            treeSet.add((Cell)cell.getExtension(this.getName()));
        }
        return treeSet;
    }

    @Override
    public final SortedSet<Cell> getDependents() {
        TreeSet<Cell> treeSet = new TreeSet<Cell>();
        for (Cell cell : this.delegate.getDependents()) {
            treeSet.add((Cell)cell.getExtension(this.getName()));
        }
        return treeSet;
    }

    @Override
    public final void copyFrom(Cell cell) {
        this.delegate.copyFrom(cell);
    }

    @Override
    public final void moveFrom(Cell cell) {
        this.delegate.moveFrom(cell);
    }

    @Override
    public final void addCellListener(CellListener cellListener) {
        this.delegate.addCellListener(cellListener);
    }

    @Override
    public final void removeCellListener(CellListener cellListener) {
        this.delegate.removeCellListener(cellListener);
    }

    @Override
    public final CellListener[] getCellListeners() {
        return this.delegate.getCellListeners();
    }

    @Override
    public final Cell getExtension(String string) {
        return (Cell)this.delegate.getExtension(string);
    }

    @Override
    public final int compareTo(Cell cell) {
        return this.delegate.compareTo(cell);
    }

    public final String toString() {
        return this.delegate.toString();
    }

    @Override
    public void valueChanged(Cell cell) {
    }

    @Override
    public void contentChanged(Cell cell) {
    }

    @Override
    public void dependentsChanged(Cell cell) {
    }

    @Override
    public void cellCleared(Cell cell) {
    }

    @Override
    public void cellCopied(Cell cell, Cell cell2) {
    }
}

