/*
 * Decompiled with CFR 0.152.
 */
package csheets.core.formula.lang;

import csheets.CleanSheets;
import csheets.core.formula.BinaryOperator;
import csheets.core.formula.Function;
import csheets.core.formula.UnaryOperator;
import csheets.core.formula.lang.NumericFunction;
import csheets.core.formula.lang.UnknownElementException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Language {
    private static final Language instance = new Language();
    private static final String PROPERTIES_FILENAME = "res/language.props";
    private List<UnaryOperator> unaryOperators = new ArrayList<UnaryOperator>();
    private List<BinaryOperator> binaryOperators = new ArrayList<BinaryOperator>();
    private List<Function> functions = new ArrayList<Function>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Language() {
        Properties properties = new Properties();
        InputStream inputStream = CleanSheets.class.getResourceAsStream(PROPERTIES_FILENAME);
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                System.err.println("An I/O error occurred when loading language properties file (res/language.props).");
                return;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            for (Object e : properties.keySet()) {
                Object object;
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.getClass().getPackage().getName() + "." + (String)e);
                    object = clazz.newInstance();
                }
                catch (Exception exception) {
                    continue;
                }
                if (Function.class.isAssignableFrom(clazz)) {
                    this.functions.add((Function)Function.class.cast(object));
                }
                if (BinaryOperator.class.isAssignableFrom(clazz)) {
                    this.binaryOperators.add((BinaryOperator)BinaryOperator.class.cast(object));
                }
                if (!UnaryOperator.class.isAssignableFrom(clazz)) continue;
                this.unaryOperators.add((UnaryOperator)UnaryOperator.class.cast(object));
            }
        } else {
            System.err.println("Could not find language properties file (res/language.props).");
        }
        for (Method method : Math.class.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Double.TYPE) continue;
            this.functions.add(new NumericFunction(method));
        }
    }

    public static Language getInstance() {
        return instance;
    }

    public UnaryOperator getUnaryOperator(String string) throws UnknownElementException {
        for (UnaryOperator unaryOperator : this.unaryOperators) {
            if (!string.equalsIgnoreCase(unaryOperator.getIdentifier())) continue;
            return unaryOperator;
        }
        throw new UnknownElementException(string);
    }

    public BinaryOperator getBinaryOperator(String string) throws UnknownElementException {
        for (BinaryOperator binaryOperator : this.binaryOperators) {
            if (!string.equalsIgnoreCase(binaryOperator.getIdentifier())) continue;
            return binaryOperator;
        }
        throw new UnknownElementException(string);
    }

    public Function getFunction(String string) throws UnknownElementException {
        for (Function function : this.functions) {
            if (!string.equalsIgnoreCase(function.getIdentifier())) continue;
            return function;
        }
        throw new UnknownElementException(string);
    }

    public boolean hasFunction(String string) {
        try {
            return this.getFunction(string) != null;
        }
        catch (UnknownElementException unknownElementException) {
            return false;
        }
    }

    public Function[] getFunctions() {
        return this.functions.toArray(new Function[this.functions.size()]);
    }
}

