/*
 * Decompiled with CFR 0.152.
 */
package csheets.core;

import csheets.core.Address;
import csheets.core.Cell;
import csheets.core.CellListener;
import csheets.core.IllegalValueTypeException;
import csheets.core.Spreadsheet;
import csheets.core.Value;
import csheets.core.formula.Formula;
import csheets.core.formula.Reference;
import csheets.core.formula.compiler.FormulaCompilationException;
import csheets.core.formula.compiler.FormulaCompiler;
import csheets.core.formula.util.ReferenceTransposer;
import csheets.ext.CellExtension;
import csheets.ext.Extension;
import csheets.ext.ExtensionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellImpl
implements Cell {
    private static final long serialVersionUID = 926673794084390673L;
    private Spreadsheet spreadsheet;
    private Address address;
    private Value value = new Value();
    private String content = "";
    private Formula formula;
    private SortedSet<Cell> precedents = new TreeSet<Cell>();
    private SortedSet<Cell> dependents = new TreeSet<Cell>();
    private transient List<CellListener> listeners = new ArrayList<CellListener>();
    private transient Map<String, CellExtension> extensions = new HashMap<String, CellExtension>();

    CellImpl(Spreadsheet spreadsheet, Address address) {
        this.spreadsheet = spreadsheet;
        this.address = address;
    }

    CellImpl(Spreadsheet spreadsheet, Address address, String string) throws FormulaCompilationException {
        this(spreadsheet, address);
        this.storeContent(string);
        this.reevaluate();
    }

    @Override
    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    private void reevaluate() {
        Value value;
        Value value2 = this.value;
        if (this.formula != null) {
            try {
                value = this.formula.evaluate();
            }
            catch (IllegalValueTypeException illegalValueTypeException) {
                value = new Value(illegalValueTypeException);
            }
        } else {
            value = Value.parseValue(this.content, new Value.Type[0]);
        }
        this.value = value;
        if (!value.equals(value2)) {
            this.fireValueChanged();
        }
    }

    private void fireValueChanged() {
        for (CellListener object : this.listeners) {
            object.valueChanged(this);
        }
        for (CellExtension cellExtension : this.extensions.values()) {
            cellExtension.valueChanged(this);
        }
        for (Cell cell : this.dependents) {
            if (!(cell instanceof CellImpl)) continue;
            ((CellImpl)cell).reevaluate();
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    @Override
    public void clear() {
        try {
            this.setContent("");
        }
        catch (FormulaCompilationException formulaCompilationException) {
            // empty catch block
        }
        this.fireCellCleared();
    }

    @Override
    public void setContent(String string) throws FormulaCompilationException {
        if (!this.content.equals(string)) {
            this.storeContent(string);
            this.fireContentChanged();
            this.reevaluate();
        }
    }

    private void storeContent(String string) throws FormulaCompilationException {
        Formula formula = null;
        if (string.length() > 1) {
            formula = FormulaCompiler.getInstance().compile(this, string);
        }
        this.content = string;
        this.formula = formula;
        this.updateDependencies();
    }

    private void updateDependencies() {
        for (Cell comparable : this.precedents) {
            ((CellImpl)comparable).removeDependent(this);
        }
        this.precedents.clear();
        if (this.formula != null) {
            for (Reference reference : this.formula.getReferences()) {
                for (Cell cell : reference.getCells()) {
                    if (this.equals(cell)) continue;
                    this.precedents.add(cell);
                    ((CellImpl)cell).addDependent(this);
                }
            }
        }
    }

    private void fireContentChanged() {
        for (CellListener cellListener : this.listeners) {
            cellListener.contentChanged(this);
        }
        for (CellExtension cellExtension : this.extensions.values()) {
            cellExtension.contentChanged(this);
        }
    }

    private void fireCellCleared() {
        for (CellListener cellListener : this.listeners) {
            cellListener.cellCleared(this);
        }
        for (CellExtension cellExtension : this.extensions.values()) {
            cellExtension.cellCleared(this);
        }
    }

    @Override
    public SortedSet<Cell> getPrecedents() {
        return new TreeSet<Cell>(this.precedents);
    }

    @Override
    public SortedSet<Cell> getDependents() {
        return new TreeSet<Cell>(this.dependents);
    }

    private void addDependent(Cell cell) {
        this.dependents.add(cell);
        this.fireDependentsChanged();
    }

    private void removeDependent(Cell cell) {
        this.dependents.remove(cell);
        this.fireDependentsChanged();
    }

    private void fireDependentsChanged() {
        for (CellListener cellListener : this.listeners) {
            cellListener.dependentsChanged(this);
        }
        for (CellExtension cellExtension : this.extensions.values()) {
            cellExtension.dependentsChanged(this);
        }
    }

    @Override
    public void copyFrom(Cell cell) {
        if (cell.getFormula() == null) {
            try {
                this.setContent(cell.getContent());
            }
            catch (FormulaCompilationException formulaCompilationException) {}
        } else {
            this.formula = new Formula(this, new ReferenceTransposer(this.getAddress().getColumn() - cell.getAddress().getColumn(), this.getAddress().getRow() - cell.getAddress().getRow()).getExpression(cell.getFormula().getExpression()));
            this.content = cell.getContent().charAt(0) + this.formula.toString();
            this.updateDependencies();
            this.fireContentChanged();
            this.reevaluate();
        }
        this.fireCellCopied(cell);
    }

    @Override
    public void moveFrom(Cell cell) {
    }

    private void fireCellCopied(Cell cell) {
        for (CellListener cellListener : this.listeners) {
            cellListener.cellCopied(this, cell);
        }
        for (CellExtension cellExtension : this.extensions.values()) {
            cellExtension.cellCopied(this, cell);
        }
    }

    @Override
    public void addCellListener(CellListener cellListener) {
        this.listeners.add(cellListener);
    }

    @Override
    public void removeCellListener(CellListener cellListener) {
        this.listeners.remove(cellListener);
    }

    @Override
    public CellListener[] getCellListeners() {
        return this.listeners.toArray(new CellListener[this.listeners.size()]);
    }

    @Override
    public Cell getExtension(String string) {
        Extension extension;
        CellExtension cellExtension = this.extensions.get(string);
        if (cellExtension == null && (extension = ExtensionManager.getInstance().getExtension(string)) != null && (cellExtension = extension.extend(this)) != null) {
            this.extensions.put(string, cellExtension);
        }
        return cellExtension;
    }

    @Override
    public int compareTo(Cell cell) {
        if (this.spreadsheet != cell.getSpreadsheet()) {
            return -1;
        }
        return this.address.compareTo(cell.getAddress());
    }

    public String toString() {
        return this.address.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<CellListener>();
        this.extensions = new HashMap<String, CellExtension>();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                CellExtension cellExtension = (CellExtension)objectInputStream.readObject();
                this.extensions.put(cellExtension.getName(), cellExtension);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.extensions.size());
        for (CellExtension cellExtension : this.extensions.values()) {
            objectOutputStream.writeObject(cellExtension);
        }
    }
}

