/*
 * 01/09/2002 - 20:43:57
 *
 * PluginStatusChanger.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.pluginstuff;

import info.jdictionary.JDictionary;
import info.jdictionary.ImageBank;
import info.jdictionary.IconBank;
import info.jdictionary.gui.PluginInfoSheetPanel;
import info.jdictionary.events.PluginFilesChangeEvent;
import info.jdictionary.listeners.PluginFilesChangeListener;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginStructureChangeListener;
import javax.swing.JPanel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Insets;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;


public class PluginStatusChanger extends JPanel implements Runnable {
    JDictionary jDictionary;
    PluginManager pluginManager;
    ArrayList pluginStatusPanels;
    JPanel availablePluginsPanel = new JPanel();
    JPanel pluginOutputPanel = new JPanel();
    ImageIcon spacerLine = ImageBank.getImageByName("Spacer.jpg");
    ImageIcon headerImage = ImageBank.getImageByName("ActivateHeader.png");
    BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.Y_AXIS);
    BoxLayout boxLayout2 = new BoxLayout(pluginOutputPanel, BoxLayout.Y_AXIS);
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel headerLabel = new JLabel();
    JScrollPane pluginOutputScrollPane = new JScrollPane();


    public PluginStatusChanger(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.pluginManager = jDictionary.getPluginManager();

        pluginManager.addPluginFilesChangeListener(new PluginFilesChangeListener() {
            public void pluginFilesChanged(PluginFilesChangeEvent e) {
                reBuildPluginStatusPanels();
            }
        });

        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void jbInit() throws Exception {
        setLayout(boxLayout1);
        setBackground(Color.white);
        setAlignmentY((float) 0.0);
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));

        availablePluginsPanel.setBackground(Color.white);
        availablePluginsPanel.setAlignmentX((float) 0.0);
        availablePluginsPanel.setMinimumSize(new Dimension(300, 100));
        availablePluginsPanel.setPreferredSize(new Dimension(1000, 1000));
        availablePluginsPanel.setLayout(borderLayout1);
        availablePluginsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailablePlugins")));

        headerLabel.setMinimumSize(new Dimension(300, 65));
        headerLabel.setPreferredSize(new Dimension(500, 65));
        headerLabel.setIcon(headerImage);

        pluginOutputScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

        pluginOutputPanel.setBackground(Color.white);

        add(headerLabel, null);
        add(availablePluginsPanel, null);
        availablePluginsPanel.add(pluginOutputScrollPane, BorderLayout.CENTER);
        pluginOutputScrollPane.getViewport().add(pluginOutputPanel, null);
    }


    public void run() {
        reBuildPluginStatusPanels();
    }


    synchronized void toggleStatus(final PluginStatusPanel p) {
        if(p.isActive())
            pluginManager.setInActive(p.sheet.getFileName());
        else
            pluginManager.setActive(p.sheet.getFileName());
        pluginManager.scanPlugins();
            }


    public void reBuildPluginStatusPanels() {
        pluginStatusPanels = new ArrayList();

        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                pluginOutputPanel.removeAll();
                if (pluginManager.getNumberOfPluginFiles() == 0) {
                    pluginOutputPanel.setLayout(new BorderLayout());
                    pluginOutputPanel.add(new JLabel(JDictionary.getString("NoPlugins"), IconBank.info, 0));
                    pluginOutputPanel.validate();
                    pluginOutputPanel.repaint();
                    return;
                }


                File[] pluginFiles = pluginManager.getPluginFiles();
                //String[] pluginFileNames = pluginManager.getAvailablePluginFileNames();
                PluginInfoSheet tempSheet;
                final ArrayList sheets = new ArrayList();
                for(int i = 0; i < pluginFiles.length; i++) {
                    //if(pluginManager.isThereNewerPluginFileAvailable(pluginFileNames[i]))
                    //this can never happen
                    if(pluginManager.isThereNewerPluginFileAvailable(pluginFiles[i].getName()))
                        continue;
                    try {
                        tempSheet = PluginInfoSheet.CreateInfoSheet(pluginFiles[i]);
                    }
                    catch(java.lang.NullPointerException e) {continue;}

                    sheets.add(tempSheet);
                }

                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        pluginOutputPanel.setLayout(boxLayout2);
                        for (int n = 0; n < sheets.size(); n++) {
                            PluginStatusPanel p = new PluginStatusPanel(jDictionary, (PluginInfoSheet)sheets.get(n));
                            pluginOutputPanel.add(p);
                            pluginStatusPanels.add(p);
                            //Adding a nice spacer between the plugin info panels :)
                            if (n < pluginManager.getNumberOfPluginFiles() - 1) {
                                JLabel spacer = new JLabel(spacerLine);
                                spacer.setPreferredSize(new Dimension(200, 1));
                                pluginOutputPanel.add(spacer);
                            }
                        }
                        pluginOutputPanel.validate();
                        pluginOutputScrollPane.validate();
                        pluginOutputPanel.repaint();
                    }
                });
            }
        });
    }


    class PluginStatusPanel extends JPanel {
        JDictionary jDictionary;
        PluginInfoSheet sheet;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();

        BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.X_AXIS);
        BoxLayout boxLayout2 = new BoxLayout(jPanel1, BoxLayout.Y_AXIS);


        PluginInfoSheetPanel sheetPanel;
        JScrollPane jScrollPane1 = new JScrollPane();
        JButton button = new JButton();
        JLabel status = new JLabel();

        public PluginStatusPanel(JDictionary jDictionary, PluginInfoSheet sheet) {
            this.sheet = sheet;
            this.jDictionary = jDictionary;
            sheetPanel = new PluginInfoSheetPanel(sheet);

            pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener() {
                public void pluginAdded(PluginStructureChangeEvent e) {
                        update();
                }
                public void pluginRemoved(PluginStructureChangeEvent e) {
                        update();
                }
            });



            try {
                jbInit();
            } catch (Exception e) {
                e.printStackTrace();
            }
            update();
        }

        private void jbInit() throws Exception {
            setBackground(new Color(255, 255, 255));
            setPreferredSize(new Dimension(370, 85));
            setMinimumSize(new Dimension(300, 85));
            setLayout(boxLayout1);
            setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            setAlignmentX((float) 0.0);

            jPanel1.setLayout(boxLayout2);
            jPanel1.setPreferredSize(new Dimension(110, 55));
            jPanel1.setBackground(new Color(255, 255, 255));

            jPanel2.setBackground(new Color(255, 255, 255));

            jScrollPane1.setPreferredSize(new Dimension(300, 70));
            jScrollPane1.setMinimumSize(new Dimension(100, 70));

            status.setAlignmentX((float)0.0);

            button.setAlignmentX((float)0.0);
            button.setMargin(new Insets(0, 3, 0, 3));
            button.addActionListener(new java.awt.event.ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             button_actionPerformed(e);
                                         }
                                     }
                                    );

            jPanel1.add(status);
            jPanel1.add(Box.createVerticalGlue());
            jPanel1.add(button);
            jPanel2.add(jPanel1);
            add(jScrollPane1);
            add(jPanel2);
            jScrollPane1.getViewport().add(sheetPanel);
        }

         boolean isActive() {
            return pluginManager.isItActive(sheet.getFileName());
        }

        void update() {
            button.setEnabled(true);
            if(isActive()) {
                status.setText(JDictionary.getString("Active"));
                status.setIcon(IconBank.trafficGreen);
                button.setText(JDictionary.getString("Deactivate"));
                button.setIcon(IconBank.unPlug);
            }
            else {
                status.setText(JDictionary.getString("Deactivated"));
                status.setIcon(IconBank.trafficRed);
                button.setText(JDictionary.getString("Activate"));
                button.setIcon(IconBank.plug);
            }
        }


        void button_actionPerformed(ActionEvent e) {
            button.setEnabled(false);
            if(isActive())
                status.setIcon(IconBank.trafficYellow);
            else
                status.setIcon(IconBank.trafficRedYellow);
            toggleStatus(this);
        }


        public boolean isInstalled() {
            return pluginManager.isItInstalled(sheet);
        }
    }
}