/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultLabelledPane.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.modules;

import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;
import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import java.net.URL;
import info.jdictionary.JDictionary;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.LatestVersionChecker;
import info.jdictionary.IconBank;
import info.jdictionary.gui.UpgradeAgent;
import info.jdictionary.events.NewJDictionaryVersionEvent;
import info.jdictionary.listeners.NewJDictionaryVersionListener;


public class DefaultLabelledPane extends JPanel {
    BoxLayout boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
    JLabel rescanLabel = new JLabel(JDictionary.getString("Rescan"), IconBank.rescan, 0);
    JLabel downloadLabel = new JLabel(JDictionary.getString("Download&Install"), IconBank.FolderIn, 0);
    JLabel activateLabel = new JLabel(JDictionary.getString("ActivateDeactivate"), IconBank.plug, 0);
    JLabel preferencesLabel = new JLabel(JDictionary.getString("Preferences"), IconBank.hammer, 0);
    JLabel newsLabel = new JLabel(JDictionary.getString("News"), IconBank.envelope, 0);
    UpgradeAgent upgradeAgent;
    LatestVersionChecker latestVersionChecker;
    JLabel newAvail;

    DefaultFrameAssembler assembler;
    public DefaultLabelledPane(final DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;

        setLayout(boxLayout);
        setBackground(Color.white);
        add(rescanLabel);
        add(downloadLabel);
        add(activateLabel);
        add(preferencesLabel);
        add(newsLabel);

        rescanLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        rescanLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                rescanLabel_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                rescanLabel_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                rescanLabel_mouseExited(e);
            }
        });

        downloadLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        downloadLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                downloadLabel_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                downloadLabel_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                downloadLabel_mouseExited(e);
            }
        });

        activateLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        activateLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                activateLabel_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                activateLabel_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                activateLabel_mouseExited(e);
            }
        });

        preferencesLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        preferencesLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                preferencesLabel_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                preferencesLabel_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                preferencesLabel_mouseExited(e);
            }
        });

        newsLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        newsLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                newsLabel_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                newsLabel_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                newsLabel_mouseExited(e);
            }
        });

        assembler.getJDictionary().getNewJDictionaryVersionChecker().addNewJDictionaryVersionListener(new NewJDictionaryVersionListener() {
            public void newJDictionaryVersionAvailable(NewJDictionaryVersionEvent e) {
                addNewReleaseAvailableLabel();
            }
        });
    }


    void rescanLabel_mousePressed(MouseEvent e) {
       assembler.getJDictionary().getPluginManager().scanPlugins();
    }


    void rescanLabel_mouseEntered(MouseEvent e) {
        rescanLabel.setForeground(new Color(235,161,66));
    }


    void rescanLabel_mouseExited(MouseEvent e) {
        rescanLabel.setForeground(Color.black);
    }


    void downloadLabel_mousePressed(MouseEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginDownloader());
    }


    void downloadLabel_mouseEntered(MouseEvent e) {
        downloadLabel.setForeground(new Color(235,161,66));
    }


    void downloadLabel_mouseExited(MouseEvent e) {
        downloadLabel.setForeground(Color.black);
    }


    void activateLabel_mousePressed(MouseEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginStatusChanger());
    }


    void activateLabel_mouseEntered(MouseEvent e) {
        activateLabel.setForeground(new Color(235,161,66));
    }


    void activateLabel_mouseExited(MouseEvent e) {
        activateLabel.setForeground(Color.black);
    }



    void newsLabel_mousePressed(MouseEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getNewsAgent());
    }


    void newsLabel_mouseEntered(MouseEvent e) {
        newsLabel.setForeground(new Color(235,161,66));
    }


    void newsLabel_mouseExited(MouseEvent e) {
        newsLabel.setForeground(Color.black);
    }


    void preferencesLabel_mousePressed(MouseEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPreferencesScreen());
    }


    void preferencesLabel_mouseEntered(MouseEvent e) {
        preferencesLabel.setForeground(new Color(235,161,66));
    }


    void preferencesLabel_mouseExited(MouseEvent e) {
        preferencesLabel.setForeground(Color.black);
    }


    void newAvail_mousePressed(MouseEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getUpgradeAgent());
    }


    void newAvail_mouseEntered(MouseEvent e) {
        newAvail.setForeground(new Color(235,161,66));
    }


    void newAvail_mouseExited(MouseEvent e) {
        newAvail.setForeground(Color.black);
    }


    void addNewReleaseAvailableLabel() {
        newAvail = new JLabel(JDictionary.getString("NewJDictionaryAvailable"), IconBank.laptopIn, 0);
        newAvail.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 0));
        newAvail.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                newAvail_mousePressed(e);
            }
            public void mouseEntered(MouseEvent e) {
                newAvail_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                newAvail_mouseExited(e);
            }
        });

        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                add(newAvail);
                assembler.setPluginSplitPaneDivider();
            }
        });
    }
}