package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

public class KunststoffMenuUI extends BasicMenuUI {

  public static ComponentUI createUI(JComponent x) {
    return new KunststoffMenuUI();
  }

  public void update(Graphics g, JComponent c) {
    Container parent = menuItem.getParent();
    if (parent != null && parent instanceof JMenuBar && !menuItem.isSelected()) {
      // menu items in the menubar will never be opaque unless they are selected
      boolean isMenuItemOpaque = menuItem.isOpaque();
      menuItem.setOpaque(false);
      super.update(g, c);
      menuItem.setOpaque(isMenuItemOpaque);
    } else {
      super.update(g, c);
    }
  }



}