/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.JDictionaryFrame;
import info.jdictionary.NewJDictionaryVersionChecker;
import info.jdictionary.NewsAgent;
import info.jdictionary.NewsChecker;
import info.jdictionary.Preferences;
import info.jdictionary.Prefs;
import info.jdictionary.ProxyAuthenticator;
import info.jdictionary.gui.AboutPanel;
import info.jdictionary.gui.AllPluginsDeactivatedPanel;
import info.jdictionary.gui.NoPluginsPanel;
import info.jdictionary.gui.UpgradeAgent;
import info.jdictionary.pluginstuff.PluginDownloader;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.pluginstuff.PluginStatusChanger;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class JDictionary {
    private static ResourceBundle JDictionaryResources;
    private static JDictionary jDictionary;
    private Prefs prefs;
    private PluginManager pluginManager;
    private PluginDownloader pluginDownloader;
    private PluginStatusChanger pluginStatusChanger;
    private NewsAgent newsAgent;
    private UpgradeAgent upgradeAgent;
    private Preferences preferences;
    private JDictionaryFrame frame;
    private DefaultFrameAssembler assembler;
    private NewJDictionaryVersionChecker newJDictionaryVersionChecker = new NewJDictionaryVersionChecker();
    private NewsChecker newsChecker = new NewsChecker(this);
    private String baseDir;

    public JDictionary() {
        this.prefs = this.loadPrefs();
        this.initProxy();
        this.frame = new JDictionaryFrame();
        this.pluginManager = new PluginManager(this);
        this.assembler = new DefaultFrameAssembler(this, this.frame);
        this.pluginManager.scanPlugins();
        if (this.prefs.CheckingForUpgrade) {
            this.newJDictionaryVersionChecker.start();
        }
        if (this.prefs.CheckingForNews) {
            this.newsChecker.start();
        }
    }

    public JPanel getSplashScreen() {
        return new AboutPanel();
    }

    public JPanel getNoPluginInstalledScreen() {
        return new NoPluginsPanel();
    }

    public JPanel getAllPluginsDeactivatedScreen() {
        return new AllPluginsDeactivatedPanel();
    }

    public PluginStatusChanger getPluginStatusChanger() {
        if (this.pluginStatusChanger == null) {
            this.pluginStatusChanger = new PluginStatusChanger(this);
            Thread pluginStatusChangerThread = new Thread(this.pluginStatusChanger);
            pluginStatusChangerThread.start();
        }
        return this.pluginStatusChanger;
    }

    public PluginDownloader getPluginDownloader() {
        if (this.pluginDownloader == null || !this.pluginDownloader.isSuccess()) {
            this.pluginDownloader = new PluginDownloader(this);
            Thread pluginDownloaderThread = new Thread(this.pluginDownloader);
            pluginDownloaderThread.start();
        }
        return this.pluginDownloader;
    }

    public NewsAgent getNewsAgent() {
        if (this.newsAgent == null || !this.newsAgent.isSuccess()) {
            this.newsAgent = new NewsAgent(this);
            Thread newsAgentThread = new Thread(this.newsAgent);
            newsAgentThread.start();
        }
        return this.newsAgent;
    }

    public UpgradeAgent getUpgradeAgent() {
        if (this.upgradeAgent == null || !this.upgradeAgent.isSuccess()) {
            this.upgradeAgent = new UpgradeAgent(this);
        }
        return this.upgradeAgent;
    }

    public Preferences getPreferencesScreen() {
        if (this.preferences == null) {
            this.preferences = new Preferences(this);
        }
        return this.preferences;
    }

    public NewJDictionaryVersionChecker getNewJDictionaryVersionChecker() {
        return this.newJDictionaryVersionChecker;
    }

    public NewsChecker getNewsChecker() {
        return this.newsChecker;
    }

    public DefaultFrameAssembler getAssembler() {
        return this.assembler;
    }

    public void closeJDictionary() {
        this.savePrefs();
        this.pluginManager.removeAllPlugins();
        System.exit(0);
    }

    public void savePrefs() {
        this.assembler.savePrefs();
        this.prefs.lastSelectedPlugin = this.pluginManager.getSelectedPlugin();
        this.prefs.lastSelectedSubPluginName = this.pluginManager.getSelectedSubPlugin();
        Prefs.savePrefs(this.prefs, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    public Prefs loadPrefs() {
        return Prefs.loadPrefs(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedPrefsFileName")))));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public String getBaseDir() {
        if (this.baseDir != null) {
            return this.baseDir;
        }
        URL url = this.getClass().getResource("/".concat(String.valueOf(String.valueOf(JDictionary.getString("ResourcesDirName")))));
        String temp = url.toString();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '%') {
                s.append(temp.charAt(i));
                continue;
            }
            s.append(" ");
            i += 2;
        }
        int e = s.toString().indexOf("jdictionary.jar");
        if (e < 10) {
            return System.getProperty("user.dir");
        }
        this.baseDir = s.toString().substring(9, e - 1);
        return this.baseDir;
    }

    public String getPluginDirPath() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getSavedDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    public String getGlobalPluginDirPath() {
        File dir = null;
        try {
            dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getBaseDir()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("PluginDirName")))));
            if (!(dir.exists() && dir.isDirectory() || dir.mkdir())) {
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        return dir.getAbsolutePath();
    }

    public static void main(String[] args) {
        jDictionary = new JDictionary();
    }

    public static JDictionary getJDictionary() {
        return jDictionary;
    }

    public static String getString(String key) {
        if (JDictionaryResources == null) {
            JDictionaryResources = ResourceBundle.getBundle("info.jdictionary.resource.JDictionaryResources", new Locale("en", "en"));
        }
        return JDictionaryResources.getString(key);
    }

    public static float getJDictionaryVersion() {
        return Float.parseFloat(JDictionary.getString("JDictionaryVersion"));
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getLanguage() {
        return System.getProperty("user.language");
    }

    public static String getSavedDir() {
        File dir = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getUserHome()))).append(JDictionary.getFileSeparator()).append(JDictionary.getString("SavedDirName")))));
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        return dir.getAbsolutePath();
    }

    public void initProxy() {
        PasswordAuthentication passwordAuthentication;
        char[] password;
        String username;
        String port;
        String host;
        ((Hashtable)System.getProperties()).remove("proxySet");
        ((Hashtable)System.getProperties()).remove("proxyHost");
        ((Hashtable)System.getProperties()).remove("proxyPort");
        ((Hashtable)System.getProperties()).remove("socksProxySet");
        ((Hashtable)System.getProperties()).remove("socksProxyHost");
        ((Hashtable)System.getProperties()).remove("socksProxyPort");
        Authenticator.setDefault(null);
        if (this.prefs.usingHttpProxy) {
            host = this.prefs.httpProxyServer;
            if (host == null) {
                return;
            }
            System.setProperty("proxyHost", host);
            port = this.prefs.httpProxyPort;
            if (port != null && port.length() > 0) {
                System.setProperty("proxyPort", port);
            } else {
                System.setProperty("proxyPort", "80");
            }
            System.setProperty("proxySet", "true");
            if (this.prefs.usingHttpProxyLogin) {
                username = this.prefs.httpProxyLogin;
                password = this.prefs.httpProxyPassword;
                if (password == null) {
                    password = new char[]{};
                }
                if (username == null || username.length() == 0) {
                    Authenticator.setDefault(new ProxyAuthenticator(null));
                } else {
                    passwordAuthentication = new PasswordAuthentication(username, password);
                    Authenticator.setDefault(new ProxyAuthenticator(passwordAuthentication));
                }
            }
        }
        if (this.prefs.usingSocksProxy) {
            host = this.prefs.socksProxyServer;
            if (host == null) {
                return;
            }
            System.getProperties().setProperty("socksProxyHost", host);
            port = this.prefs.socksProxyPort;
            if (port != null && port.length() > 0) {
                System.getProperties().setProperty("socksProxyPort", port);
            } else {
                System.getProperties().setProperty("socksProxyPort", "1080");
            }
            System.getProperties().setProperty("socksProxySet", "true");
            if (this.prefs.usingSocksProxyLogin) {
                username = this.prefs.socksProxyLogin;
                password = this.prefs.socksProxyPassword;
                if (password == null) {
                    password = new char[]{};
                }
                if (username == null || username.length() == 0) {
                    Authenticator.setDefault(new ProxyAuthenticator(null));
                } else {
                    passwordAuthentication = new PasswordAuthentication(username, password);
                    Authenticator.setDefault(new ProxyAuthenticator(passwordAuthentication));
                }
            }
        }
    }
}

