/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import info.jdictionary.IconBank;
import info.jdictionary.JDictionary;
import info.jdictionary.gui.JDictionaryTheme;
import info.jdictionary.modules.DefaultFooter;
import info.jdictionary.modules.DefaultHeader;
import info.jdictionary.modules.DefaultLabelledPane;
import info.jdictionary.modules.DefaultMenuBar;
import info.jdictionary.modules.DefaultOutput;
import info.jdictionary.modules.DefaultToolBar;
import info.jdictionary.modules.DefaultTreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DefaultFrameAssembler {
    private JFrame frame;
    private final JDictionary jDictionary;
    private DefaultFooter footer;
    private DefaultHeader header;
    private DefaultLabelledPane labelledPane;
    private DefaultOutput output;
    private DefaultToolBar toolBar;
    private DefaultTreeView treeView;
    private DefaultMenuBar menuBar;
    private int activateCounter = 0;
    JPanel upperPanel = new JPanel();
    public JScrollPane outputScrollPane = new JScrollPane();
    JScrollPane pluginTreeViewScrollPane = new JScrollPane();
    JSplitPane outputSplitPane = new JSplitPane();
    JSplitPane pluginSplitPane = new JSplitPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BoxLayout boxLayout1;

    public DefaultFrameAssembler(final JDictionary jDictionary, JFrame frame) {
        this.jDictionary = jDictionary;
        this.frame = frame;
        this.boxLayout1 = new BoxLayout(frame.getContentPane(), 1);
        this.footer = new DefaultFooter(this);
        this.header = new DefaultHeader(this);
        this.labelledPane = new DefaultLabelledPane(this);
        this.output = new DefaultOutput(this);
        this.toolBar = new DefaultToolBar(this);
        this.treeView = new DefaultTreeView(this);
        this.menuBar = new DefaultMenuBar(this);
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DefaultFrameAssembler.this.frameResized(e);
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                jDictionary.closeJDictionary();
            }

            public void windowActivated(WindowEvent e) {
                if (DefaultFrameAssembler.this.activateCounter > 0) {
                    jDictionary.getPluginManager().scanPlugins();
                }
                ++DefaultFrameAssembler.this.activateCounter;
            }
        });
        this.assemble();
        frame.pack();
        this.restoreSavedScreenState();
        frame.show();
    }

    private void assemble() {
        this.frame.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("JDictionaryName")))).append(" ").append(JDictionary.getString("JDictionaryVersion")))));
        ((Frame)this.frame).setIconImage(IconBank.world.getImage());
        this.frame.getContentPane().setLayout(this.boxLayout1);
        this.frame.getContentPane().add(this.header);
        this.frame.getContentPane().add((Component)this.outputSplitPane, null);
        this.frame.getContentPane().add(this.footer);
        this.outputSplitPane.setMaximumSize(new Dimension(2048, 2048));
        this.outputSplitPane.setContinuousLayout(true);
        this.outputSplitPane.setOneTouchExpandable(true);
        this.outputSplitPane.add((Component)this.outputScrollPane, "right");
        this.outputSplitPane.add((Component)this.pluginSplitPane, "left");
        this.pluginSplitPane.setOrientation(0);
        this.pluginSplitPane.setContinuousLayout(true);
        this.pluginSplitPane.setOneTouchExpandable(true);
        this.pluginSplitPane.add((Component)this.upperPanel, "top");
        this.pluginSplitPane.add((Component)this.labelledPane, "bottom");
        this.outputScrollPane.getViewport().add((Component)this.output, null);
        this.pluginTreeViewScrollPane.getViewport().add((Component)this.treeView, null);
        this.frame.setJMenuBar(this.menuBar);
        this.upperPanel.setLayout(this.borderLayout1);
        this.upperPanel.add((Component)this.pluginTreeViewScrollPane, "Center");
        this.upperPanel.add((Component)this.toolBar, "North");
        this.setLookAndFeel(null);
    }

    public boolean setLookAndFeel(String lf) {
        KunststoffLookAndFeel kunststoffLF = new KunststoffLookAndFeel();
        MetalLookAndFeel.setCurrentTheme(new JDictionaryTheme());
        try {
            UIManager.setLookAndFeel(kunststoffLF);
        }
        catch (UnsupportedLookAndFeelException e) {
            boolean bl = false;
            return bl;
        }
        SwingUtilities.updateComponentTreeUI(this.frame);
        return true;
    }

    public DefaultOutput getOutput() {
        return this.output;
    }

    public DefaultTreeView getTreeView() {
        return this.treeView;
    }

    void restoreSavedScreenState() {
        ((Component)this.frame).setSize(new Dimension(this.jDictionary.getPrefs().width, this.jDictionary.getPrefs().height));
        this.outputSplitPane.setDividerLocation(this.jDictionary.getPrefs().dividerLocation);
    }

    public void setPluginSplitPaneDivider() {
        this.pluginSplitPane.setDividerLocation(this.pluginSplitPane.getMaximumDividerLocation());
    }

    public void savePrefs() {
        this.jDictionary.getPrefs().width = (int)this.frame.getSize().getWidth();
        this.jDictionary.getPrefs().height = (int)this.frame.getSize().getHeight();
        this.jDictionary.getPrefs().dividerLocation = this.outputSplitPane.getDividerLocation();
    }

    public JDictionary getJDictionary() {
        return this.jDictionary;
    }

    void frameResized(ComponentEvent e) {
        this.setPluginSplitPaneDivider();
        Dimension dim = this.frame.getSize();
        if (dim.getWidth() < (double)620 || dim.getHeight() < (double)385) {
            if (dim.getWidth() < (double)620) {
                dim.width = 620;
            }
            if (dim.getHeight() < (double)385) {
                dim.height = 385;
            }
            ((Component)this.frame).setSize(dim);
        }
    }
}

