/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jtides.HTMLPageBuilder;
import jtides.JTides;
import jtides.Rts;
import jtides.SiteDataDialog;
import jtides.SmoothRect;
import jtides.TideConstants;
import jtides.TideDatum;
import jtides.TidesDoc;
import jtides.TidesFindNearest;
import jtides.TimeBundle;

public final class TidePanel
extends JPanel
implements Printable {
    JTides main;
    TidesDoc theDoc;
    GregorianCalendar chartCal;
    long oldTime = 0L;
    HTMLPageBuilder pageBuilder;
    int siteOffset;
    int localOffset;
    int newscalex;
    int oldscalex = -1;
    double oldTimeZone = -100.0;
    boolean isLocal;
    boolean calCalcBusy = false;
    int scalex;
    int scaley;
    int gstartx;
    int gstarty;
    long lastChangeTime = 0L;
    boolean mouseDown = false;
    int mouseX;
    int mouseY;
    static final String defaultTip = "Click the chart for specific information";
    long oldMatBase = -1L;
    int oldMatHeight = 0;
    int oldMatUnits = 0;
    int oldMatx = 0;
    int oldMaty = 0;
    BufferedImage offScreenImage = null;
    boolean oldSmoothGraph = false;
    boolean smoothGraph = false;
    String oldMatName = "";
    TideDatum[][] tideMat = null;
    public int graphWidth = 1;
    Rts sunData;
    Rts twilightData;
    Color gridColor = Color.green.darker();
    Color lineColor = Color.blue;
    Color zeroColor = Color.black;
    Color currentColor = Color.red;
    Color backgroundColor = Color.white;
    Color textColor = Color.black;
    int divsx;
    int divsy;
    int startx;
    int endx;
    int starty;
    int endy;
    double rangex;
    double rangey;
    private JMenuItem ConfigureDataButton;
    private JMenuItem HelpButton;
    private JMenuItem NearestSitesButton;
    private JMenuItem PrintButton;
    private JMenuItem SiteData;
    private JMenuItem SiteExplorerButton;
    private JMenuItem closeMenuItem;
    private JPopupMenu popupMenu;

    public TidePanel(JTides jTides, TidesDoc tidesDoc) {
        this.main = jTides;
        this.theDoc = tidesDoc;
        this.divsx = 12;
        this.divsy = 8;
        this.initComponents();
        this.setFocusTraversalKeys(0, new HashSet());
        this.setFocusTraversalKeys(1, new HashSet());
        this.setToolTipText(defaultTip);
        this.setChartCalendar();
    }

    public GregorianCalendar getCurrentCal() {
        this.siteOffset = (int)(this.theDoc.siteSet.tz * 3600000.0);
        TimeZone timeZone = TimeZone.getDefault();
        this.localOffset = this.main.configValues.timeZone == -14.0 ? timeZone.getRawOffset() : (this.main.configValues.timeZone == -13.0 ? this.siteOffset : (int)(this.main.configValues.timeZone * 3600000.0));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTimeInMillis(new Date().getTime());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5));
        gregorianCalendar2.setTimeZone(timeZone);
        return gregorianCalendar2;
    }

    public GregorianCalendar getChartCalendar() {
        this.lastChangeTime = new Date().getTime();
        return this.chartCal;
    }

    private void setChartCalendar() {
        this.lastChangeTime = new Date().getTime();
        this.chartCal = this.getCurrentCal();
    }

    public void setChartWidth(int n) {
        this.setToolTipText(defaultTip);
        if (n == 1) {
            ++this.graphWidth;
            if (this.graphWidth > 7) {
                this.graphWidth = 30;
            }
        } else if (n == -1) {
            if (this.graphWidth == 30) {
                this.graphWidth = 8;
            }
            --this.graphWidth;
            if (this.graphWidth == 0) {
                this.graphWidth = 1;
            }
        } else if (n == 0) {
            this.graphWidth = 1;
        } else if (n == 30) {
            this.graphWidth = 30;
        } else if (n == 60) {
            this.graphWidth = 60;
        } else if (n == -2) {
            this.graphWidth = -1;
            this.setToolTipText("");
        }
    }

    public void setPrintDims(PageFormat pageFormat) {
        this.main.configValues.printOrientation = pageFormat.getOrientation();
        PageFormat pageFormat2 = new PageFormat();
        pageFormat2.setPaper(pageFormat.getPaper());
        pageFormat2.setOrientation(1);
        this.main.configValues.printWidth = pageFormat2.getWidth();
        this.main.configValues.printHeight = pageFormat2.getHeight();
        this.main.configValues.printIWidth = pageFormat2.getImageableWidth();
        this.main.configValues.printIHeight = pageFormat2.getImageableHeight();
        this.main.configValues.printIX = pageFormat2.getImageableX();
        this.main.configValues.printIY = pageFormat2.getImageableY();
    }

    public void getPrintDims(PageFormat pageFormat) {
        if (this.main.configValues.printWidth > 0.0) {
            Paper paper = new Paper();
            paper.setSize(this.main.configValues.printWidth, this.main.configValues.printHeight);
            paper.setImageableArea(this.main.configValues.printIX, this.main.configValues.printIY, this.main.configValues.printIWidth, this.main.configValues.printIHeight);
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(this.main.configValues.printOrientation);
        }
    }

    public void doPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(0);
        this.getPrintDims(pageFormat);
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
        if (pageFormat != pageFormat2) {
            this.setPrintDims(pageFormat2);
            Book book = new Book();
            book.append(this, pageFormat2);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle rectangle = graphics2D.getClipBounds();
        this.paintImage(graphics2D, rectangle, true);
        return 0;
    }

    private void checkClock() {
        int n;
        long l = new Date().getTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = gregorianCalendar.get(6);
        if (n2 != (n = this.chartCal.get(6))) {
            if (l > this.lastChangeTime + (long)JTides.returnToCurrentTimeDelayMillis) {
                this.setChartCalendar();
                this.theDoc.resetTitle();
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.checkClock();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.paintImage(graphics2D, rectangle, false);
    }

    public void paintImage(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.addRenderingHints(renderingHints);
        if (this.oldTimeZone != this.main.configValues.timeZone) {
            this.setChartCalendar();
            this.oldTimeZone = this.main.configValues.timeZone;
        }
        boolean bl2 = this.isLocal = this.main.configValues.timeZone != -13.0;
        if (this.theDoc.siteSet.units < 2 && this.theDoc.siteSet.currentDisplayUnits != this.main.configValues.displayUnits) {
            this.main.tideComp.findHiLoWater(this.theDoc.siteSet, new GregorianCalendar(this.chartCal.get(1), 0, 1, 0, 0, 0).getTime(), 172800);
        }
        if (bl && rectangle.height > rectangle.width) {
            rectangle.height /= 2;
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.startx = 0;
        this.endx = this.graphWidth * 24;
        this.starty = (int)this.theDoc.siteSet.gLoWater;
        this.endy = (int)this.theDoc.siteSet.gHiWater;
        if ((this.endy - this.starty) % 2 != 0) {
            ++this.endy;
        }
        this.divsy = 8;
        int[] nArray = new int[]{8, 10, 6, 12, 14, 7, 9, 11, 0};
        int n2 = 0;
        while (nArray[n2] != 0 && (this.starty - this.endy) % nArray[n2] != 0) {
            ++n2;
        }
        if (nArray[n2] != 0) {
            this.divsy = nArray[n2];
        }
        this.rangex = this.endx - this.startx;
        this.rangey = this.endy - this.starty;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.gstartx = rectangle.x + n3 / 16;
        this.gstarty = rectangle.y + n4 / 32;
        this.scalex = n3 - this.gstartx - n3 / 30;
        this.scaley = n4 - this.gstarty - n4 / 20;
        if (!bl) {
            n = n3 / 64;
            this.gstartx += n;
            this.scalex -= n * 2;
            n = n4 / 64;
            this.gstarty += n;
            this.scaley -= n * 2;
        }
        n = this.graphWidth == -1 ? this.scalex / 66 : this.scalex / 60;
        Font font = new Font("Monospaced", this.main.configValues.boldFont ? 1 : 0, n);
        graphics2D.setFont(font);
        if (this.graphWidth == -1) {
            this.DrawCalendar(graphics2D, rectangle, bl);
        } else if (this.graphWidth <= 7) {
            this.drawGraph(graphics2D, bl);
        } else {
            this.DrawColorMat(graphics2D, n3, n4);
        }
    }

    void drawTideCurve(Graphics2D graphics2D, boolean bl) {
        graphics2D.setColor(this.lineColor);
        long l = this.chartCal.getTime().getTime() / 1000L;
        if (this.main.configValues.thickLine) {
            graphics2D.setStroke(new BasicStroke(2.0f));
        }
        GraphicsData graphicsData = new GraphicsData(graphics2D);
        graphicsData.start = true;
        double d = ((double)this.endx - (double)this.startx) / (double)this.scalex;
        double d2 = bl ? d : 0.25;
        graphicsData.x = this.startx;
        while (graphicsData.x <= (double)this.endx + 0.001) {
            graphicsData.y = this.main.tideComp.timeToTide(this.theDoc.siteSet, (int)((double)l + graphicsData.x * 3600.0), true);
            graphicsData.y = this.main.tideComp.ConvertHeight(this.theDoc.siteSet, graphicsData.y);
            this.drawLine(graphicsData);
            graphicsData.x += d2;
        }
        if (this.main.configValues.thickLine) {
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    void drawLine(GraphicsData graphicsData) {
        int n = (int)((double)this.gstartx + (graphicsData.x - (double)this.startx) * (double)this.scalex / (double)(this.endx - this.startx));
        int n2 = (int)((double)(this.gstarty + this.scaley) - (graphicsData.y - (double)this.starty) * (double)this.scaley / (double)(this.endy - this.starty));
        if (!graphicsData.start) {
            graphicsData.g.drawLine(graphicsData.ox, graphicsData.oy, n, n2);
        }
        graphicsData.ox = n;
        graphicsData.oy = n2;
        graphicsData.start = false;
    }

    void makeGrid(Graphics graphics, boolean bl) {
        String string;
        Object object;
        int n;
        int n2;
        int n3;
        int n4 = this.gstarty;
        int n5 = this.gstarty + this.scaley;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds("00:00", graphics).getBounds();
        int n6 = this.scalex / 96;
        int n7 = this.scaley / 24;
        int n8 = n3 = this.graphWidth == 1 ? this.divsx : this.graphWidth;
        if (bl) {
            n3 = 12;
        }
        graphics.setColor(this.gridColor);
        for (n2 = 0; n2 <= n3; ++n2) {
            n = (int)((double)this.gstartx + (double)(n2 * this.scalex) / (double)n3);
            if (this.main.configValues.chartGrid && !bl) {
                graphics.setColor(this.gridColor);
                graphics.drawLine(n, n4, n, n5);
            }
            if (!this.main.configValues.gridNums || this.graphWidth != 1 && !bl) continue;
            int n9 = bl ? n2 * 120 : (int)((double)(this.endx - this.startx) * (double)n2 / (double)this.divsx + (double)this.startx) * 60;
            int n10 = n9 / 60 % 24;
            int n11 = n9 % 60;
            object = this.main.tideComp.hourAmPmFormat(n10, "a", "p");
            string = this.main.tideComp.hmsFormat(((TimeBundle)object).hour, n11) + ((TimeBundle)object).ampm;
            graphics.setColor(this.textColor);
            graphics.drawString(string, n - rectangle.width / 2, n5 + n7);
        }
        if (!bl) {
            n4 = this.gstartx;
            n5 = this.gstartx + this.scalex;
            for (n2 = 0; n2 <= this.divsy; ++n2) {
                n = (int)((double)(this.scaley + this.gstarty) - (double)(n2 * this.scaley) / (double)this.divsy);
                if (this.main.configValues.chartGrid) {
                    graphics.setColor(this.gridColor);
                    graphics.drawLine(n4, n, n5, n);
                }
                if (!this.main.configValues.gridNums) continue;
                double d = (double)(this.endy - this.starty) * (double)n2 / (double)this.divsy + (double)this.starty;
                string = this.main.tideComp.formatDouble(d, 1, false);
                object = fontMetrics.getStringBounds(string, graphics).getBounds();
                graphics.setColor(this.textColor);
                graphics.drawString(string, this.gstartx - ((Rectangle)object).width - n6, n + rectangle.height / 4);
            }
            if (this.main.configValues.chartGrid && (n2 = (int)((double)this.gstarty + (double)this.scaley * ((this.rangey + (double)this.starty) / this.rangey))) >= this.gstarty && n2 <= this.gstarty + this.scaley) {
                graphics.setColor(this.zeroColor);
                graphics.drawLine(n4, n2, n5, n2);
            }
        }
    }

    String createTimeLabel() {
        String string = "";
        int n = (int)this.main.configValues.timeZone;
        switch (n) {
            case -14: {
                string = "(system time)";
                break;
            }
            case -13: {
                string = "(site time)";
                break;
            }
            default: {
                string = "(GMT" + (n >= 0 ? "+" : "") + n + ")";
            }
        }
        return string;
    }

    void drawCurrent(Graphics graphics) {
        double d;
        double d2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        TimeZone timeZone = TimeZone.getDefault();
        timeZone.setRawOffset(this.siteOffset);
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.setTimeInMillis(new Date().getTime() + (long)this.siteOffset);
        double d3 = new Date().getTime();
        d3 = Math.IEEEremainder((d3 + (double)this.siteOffset) / 3600000.0, 24.0);
        if (d3 < 0.0) {
            d3 = 24.0 + d3;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        if (this.mouseDown) {
            d2 = this.mouseX;
            d2 = ((double)this.mouseX - (double)this.gstartx) / (double)this.scalex;
            d2 = d2 < 0.0 ? 0.0 : d2;
            d2 = d2 > 1.0 ? 1.0 : d2;
            d = this.mouseY - this.scaley / 48;
            d = d < (double)this.gstarty ? (double)this.gstarty : d;
            d = d > (double)(this.gstarty + this.scaley) ? (double)(this.gstarty + this.scaley) : d;
        } else {
            d2 = (double)(gregorianCalendar.getTime().getTime() - this.chartCal.getTime().getTime() - (long)this.siteOffset) / 3600000.0 / this.rangex;
            if ((d2 = Math.IEEEremainder(d2, 1.0)) < 0.0) {
                d2 = 1.0 + d2;
            }
            d = this.starty + this.scaley - this.scaley / 8;
            if (d2 < 0.0 || d2 > 1.0) {
                return;
            }
        }
        double d4 = (d2 - (double)this.startx) * this.rangex;
        long l = (long)((double)(this.chartCal.getTime().getTime() / 1000L) + d2 * this.rangex * 3600.0);
        double d5 = this.main.tideComp.timeToTide(this.theDoc.siteSet, l, true);
        double d6 = this.main.tideComp.ConvertHeight(this.theDoc.siteSet, d5);
        int n2 = (int)((double)this.gstartx + (d4 - (double)this.startx) / this.rangex * (double)this.scalex);
        graphics.setColor(this.currentColor);
        graphics.drawLine(n2, this.gstarty, n2, this.gstarty + this.scaley);
        boolean bl = this.graphWidth == 1;
        String string = this.main.tideComp.getUnitsTag(this.theDoc.siteSet);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        timeZone.setRawOffset(this.localOffset);
        gregorianCalendar2.setTimeZone(timeZone);
        gregorianCalendar2.setTimeInMillis(l * 1000L);
        String string2 = this.main.tideComp.formatDate(gregorianCalendar2, false, bl, false, false, "") + " " + this.main.tideComp.formatDouble(d6, 1) + " " + string.charAt(0);
        String string3 = this.createTimeLabel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds(string2, graphics).getBounds();
        Rectangle rectangle2 = fontMetrics.getStringBounds(string3, graphics).getBounds();
        int n3 = rectangle.width + 8;
        int n4 = rectangle2.width + 8;
        int n5 = n3 > n4 ? n3 : n4;
        int n6 = rectangle.height * 2 + 4;
        int n7 = n2 - n5 / 2;
        int n8 = (int)(d + 2.0);
        n7 = n7 < 0 ? 0 : n7;
        n7 = n7 + n5 > dimension.width ? dimension.width - n5 : n7;
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(n7, n8 - n6, n5, n6);
        graphics.setColor(this.currentColor);
        graphics.drawRect(n7, n8 - n6, n5, n6);
        graphics.setColor(this.textColor);
        int n9 = (n3 - n4) / 2;
        n9 = n9 < 0 ? 0 : n9;
        graphics.drawString(string2, n7 + 4, (int)d - fontMetrics.getMaxDescent() - rectangle.height);
        graphics.drawString(string3, n7 + 4 + n9, (int)d - fontMetrics.getMaxDescent());
        if (this.mouseDown) {
            // empty if block
        }
    }

    int ShowText(Graphics graphics, int n, int n2, String string, boolean bl) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds(string, graphics).getBounds();
        int n3 = n - 4;
        int n4 = n2;
        int n5 = rectangle.width + 8;
        int n6 = rectangle.height + 4;
        if (bl && this.main.configValues.listBackground) {
            Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n3, n4, n5, n6);
        }
        graphics.setColor(this.textColor);
        graphics.drawString(string, n, n2 + rectangle.height - fontMetrics.getDescent());
        return n2 + rectangle.height;
    }

    String plusSign(int n) {
        String string = n > 0 ? "+" : "";
        return string + n;
    }

    int DrawSitePosText(Graphics graphics, int n) {
        int n2 = this.gstartx + this.scalex / 96;
        String string = "";
        string = this.main.tideComp.isDST(this.chartCal) ? this.theDoc.siteSet.name + " (UTC" + this.plusSign((int)this.theDoc.siteSet.tz + 1) + ") (Daylight Time)" : this.theDoc.siteSet.name + " (UTC" + this.plusSign((int)this.theDoc.siteSet.tz) + ")";
        n = this.ShowText(graphics, n2, n, string, true);
        string = this.main.tideComp.FormatLatLng(this.theDoc.siteSet.lat, this.theDoc.siteSet.lng);
        String string2 = ". Units: " + this.main.tideComp.getUnitsTag(this.theDoc.siteSet);
        int n3 = string2.indexOf("^");
        if (n3 > 0) {
            string2 = string2.substring(0, n3);
        }
        n = this.ShowText(graphics, n2, n, string + string2, true);
        return n;
    }

    void CompSunData(long l, int n) {
        if (n == 0) {
            this.sunData = this.main.sunComp.compRTS(this.theDoc.siteSet, l, n);
        } else {
            this.twilightData = this.main.sunComp.compRTS(this.theDoc.siteSet, l, n);
        }
    }

    void DrawTimeBox(Graphics graphics, int n, int n2, double d, double d2, Color color) {
        int n3 = (int)((double)this.gstartx + d / 24.0 * (double)this.scalex);
        int n4 = (int)((double)this.gstartx + d2 / 24.0 * (double)this.scalex);
        int n5 = n;
        int n6 = n2;
        graphics.setColor(color);
        graphics.fillRect(n3, n5, n4 - n3, n6 - n5);
    }

    void DrawSunLines(Graphics graphics) {
        if (this.graphWidth == 1) {
            Color color;
            Color color2;
            Color color3;
            int n = this.gstarty;
            int n2 = n + this.scaley;
            if (this.main.configValues.sunGraphicDark) {
                color3 = new Color(192, 192, 192);
                color2 = new Color(193, 193, 255);
                color = new Color(255, 255, 204);
            } else {
                color3 = new Color(220, 220, 220);
                color2 = new Color(220, 220, 255);
                color = new Color(255, 255, 220);
            }
            Rts rts = this.twilightData;
            Rts rts2 = this.sunData;
            if (rts.rise < 0.0) {
                rts.rise = 12.0;
                rts.set = 12.0;
            } else if (rts.rise > 24.0) {
                rts.rise = 0.0;
                rts.set = 24.0;
            }
            if (rts2.rise < 0.0) {
                rts2.rise = 12.0;
                rts2.set = 12.0;
            } else if (rts2.rise > 24.0) {
                rts2.rise = 0.0;
                rts2.set = 24.0;
            }
            if (rts2.rise > rts2.set) {
                rts2.rise = 0.0;
                rts2.set = 24.0;
            }
            if (rts.rise > rts.set) {
                rts.rise = 0.0;
                rts.set = 24.0;
            }
            this.DrawTimeBox(graphics, n, n2, 0.0, rts.rise, color3);
            this.DrawTimeBox(graphics, n, n2, rts.set, 24.0, color3);
            this.DrawTimeBox(graphics, n, n2, rts.rise, rts2.rise, color2);
            this.DrawTimeBox(graphics, n, n2, rts2.set, rts.set, color2);
            this.DrawTimeBox(graphics, n, n2, rts2.rise, rts2.set, color);
        }
    }

    int DrawSunData(Graphics graphics, int n, String string, String string2, int n2) {
        String string3;
        String string4;
        int n3 = this.gstartx + this.scalex / 96;
        String string5 = "";
        if (n2 == 0) {
            string4 = this.main.tideComp.formatSunHMS(this.sunData.rise);
            string5 = " Transit " + this.main.tideComp.formatSunHMS(this.sunData.transit) + ",";
            string3 = this.main.tideComp.formatSunHMS(this.sunData.set);
        } else {
            string4 = this.main.tideComp.formatSunHMS(this.twilightData.rise);
            string3 = this.main.tideComp.formatSunHMS(this.twilightData.set);
        }
        String string6 = string + " " + string4 + " " + string5 + " " + string2 + " " + string3;
        n = this.ShowText(graphics, n3, n, string6, true);
        return n;
    }

    int drawTideEventList(Graphics graphics, int n, Vector vector, boolean bl) {
        if (this.graphWidth <= 4) {
            int n2 = this.gstartx + this.scalex / 96;
            long l = this.chartCal.getTime().getTime() / 1000L;
            long l2 = l + (long)((this.endx - this.startx) * 3600);
            boolean bl2 = this.graphWidth == 1 && !bl;
            for (int i = 0; i < vector.size(); ++i) {
                if (n > this.scaley) {
                    n = this.ShowText(graphics, n2, n, " ... ", true);
                    break;
                }
                String string = this.main.tideComp.formatDataString(this.theDoc, i, vector, false, bl2, "", bl, false, true, "");
                if (string.length() <= 0) continue;
                n = this.ShowText(graphics, n2, n, string, true);
            }
        }
        return n;
    }

    void drawGraph(Graphics2D graphics2D, boolean bl) {
        if (this.main.configValues.sunText || this.main.configValues.sunGraphic) {
            long l = this.main.tideComp.setDT(this.chartCal.getTime().getTime() / 1000L, this.theDoc);
            this.CompSunData(l, 0);
            this.CompSunData(l, 1);
        }
        if (this.main.configValues.sunGraphic) {
            this.DrawSunLines(graphics2D);
        }
        this.makeGrid(graphics2D, false);
        this.drawTideCurve(graphics2D, bl);
        int n = this.gstarty + this.scaley / 64;
        if (this.main.configValues.timeLine && !bl) {
            this.drawCurrent(graphics2D);
        }
        if (this.main.configValues.siteLabel) {
            n = this.DrawSitePosText(graphics2D, n);
        }
        if (this.main.configValues.sunText) {
            n = this.DrawSunData(graphics2D, n, "Sunrise", "Sunset", 0);
            n = this.DrawSunData(graphics2D, n, "Twilight Begins", "Ends", 1);
        }
        if (this.main.configValues.tideList) {
            long l = this.chartCal.getTime().getTime() / 1000L;
            long l2 = l + (long)((this.endx - this.startx) * 3600);
            long l3 = this.main.tideComp.getNextEventTime(this.theDoc.siteSet, l, false);
            long l4 = this.main.tideComp.getNextEventTime(this.theDoc.siteSet, l2, true);
            Vector vector = this.main.tideComp.predictTideEvents(this.theDoc.siteSet, l3, l4, l, l2, null, null);
            n = this.drawTideEventList(graphics2D, n, vector, bl);
        }
        bl = false;
    }

    void calendarTideList(Graphics graphics, int n, int n2, int n3, Date date, boolean bl) {
        long l = date.getTime() / 1000L;
        long l2 = l + 86400L;
        long l3 = this.main.tideComp.getNextEventTime(this.theDoc.siteSet, l, false);
        long l4 = this.main.tideComp.getNextEventTime(this.theDoc.siteSet, l2, true);
        Vector vector = this.main.tideComp.predictTideEvents(this.theDoc.siteSet, l3, l4, l, l2, null, null);
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() * 4 / 5);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds("XXX", graphics).getBounds();
        int n4 = vector.size();
        n4 = n4 < 5 ? 5 : n4;
        int n5 = (int)((double)font2.getSize() * (double)(n3 - n2) / (double)(rectangle.height * n4));
        if (font.getSize() < n5) {
            n5 = font.getSize();
        }
        graphics.setFont(new Font(font2.getName(), font2.getStyle(), n5));
        for (int i = 0; i < vector.size(); ++i) {
            String string = this.main.tideComp.formatDataString(this.theDoc, i, vector, false, true, "", bl, false, true, "");
            if (string.length() == 0) continue;
            if (n2 >= n3) break;
            if (n2 + rectangle.height / 2 > n3) {
                string = string + "...";
            }
            n2 = this.ShowText(graphics, n, n2, string, false) - 1;
        }
        graphics.setFont(font);
    }

    int colorStrToInt(String string) {
        string = string.replaceAll("#", "");
        return Integer.parseInt(string, 16);
    }

    void DrawCalendar(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = 128;
        int n5 = rectangle.x + rectangle.width / n4;
        int n6 = rectangle.width + rectangle.x - rectangle.width / n4;
        int n7 = (n6 - n5) / n4;
        int n8 = (n6 - n5) / 7;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(this.chartCal.get(1), this.chartCal.get(2), 1, 0, 0, 0);
        int n9 = gregorianCalendar3.get(2);
        int n10 = gregorianCalendar3.get(7) - 1;
        GregorianCalendar gregorianCalendar4 = (GregorianCalendar)gregorianCalendar3.clone();
        int n11 = gregorianCalendar4.getActualMaximum(5);
        int n12 = (n10 + n11 - 1) / 7 + 1;
        String string = TideConstants.monthNames[n9] + " " + this.chartCal.get(1);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.main.tideComp.isDST(gregorianCalendar4)) {
            stringBuffer.append(this.theDoc.siteSet.name + " (GMT" + this.plusSign((int)this.theDoc.siteSet.tz + 1) + ") (Daylight Time)");
        } else {
            stringBuffer.append(this.theDoc.siteSet.name + " (GMT" + this.plusSign((int)this.theDoc.siteSet.tz) + ")");
        }
        stringBuffer.append(", " + string);
        stringBuffer.append(". Units: " + this.main.tideComp.getUnitsTag(this.theDoc.siteSet));
        String string2 = stringBuffer.toString();
        int n13 = (n5 + n6) / 2;
        int n14 = rectangle.y;
        int n15 = rectangle.height - (rectangle.height - rectangle.y) / n4;
        Font font = graphics.getFont();
        graphics.setFont(new Font(font.getName(), 1, font.getSize()));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle2 = new Rectangle();
        rectangle2 = fontMetrics.getStringBounds(string2, graphics).getBounds();
        graphics.setColor(this.textColor);
        graphics.drawString(string2, n13 - rectangle2.width / 2, n14 + rectangle2.height - fontMetrics.getDescent());
        graphics.setFont(font);
        int n16 = n14 += rectangle2.height + 2;
        n15 = rectangle.height - (rectangle.height - rectangle.y) / n4;
        int n17 = this.colorStrToInt(this.main.configValues.htmlBgColor);
        Color color = new Color(n17);
        graphics.setColor(color);
        graphics.fillRect(n5, n16, n8 * 7 + 1, rectangle2.height + 2);
        int n18 = this.colorStrToInt(this.main.configValues.htmlTitleColor);
        Color color2 = new Color(n18);
        for (n3 = 0; n3 < 7; ++n3) {
            n2 = n5 + n3 * n8;
            n = n2 + n8 / 2;
            graphics.setColor(color2);
            graphics.fillRect(n2 + 1, n16 + 1, n8 - 1, rectangle2.height + 1);
            string2 = TideConstants.dowNames[n3];
            rectangle2 = fontMetrics.getStringBounds(string2, graphics).getBounds();
            graphics.setColor(this.textColor);
            graphics.drawString(string2, n - rectangle2.width / 2, n14 + rectangle2.height - fontMetrics.getDescent());
        }
        n16 = n14 += rectangle2.height + 2;
        n3 = (n15 - n16) / n4;
        n2 = (n15 - n16) / n12;
        graphics.setColor(color);
        graphics.fillRect(n5, n16, n8 * 7 + 1, n2 * n12 + 1);
        int n19 = n = this.theDoc.siteSet.current ? 14 : 11;
        while (gregorianCalendar3.get(2) == n9) {
            int n20 = gregorianCalendar3.get(5);
            int n21 = (n20 + n10 - 1) % 7;
            int n22 = (n20 + n10 - 1) / 7;
            n21 = n5 + n21 * n8;
            n22 = n16 + n22 * n2;
            int n23 = this.colorStrToInt(this.main.configValues.htmlCellColor);
            graphics.setColor(new Color(n23));
            graphics.fillRect(n21, n22, n8, n2);
            graphics.setColor(color);
            graphics.drawRect(n21, n22, n8, n2);
            int n24 = (n22 += n3) - n3 + n2;
            string2 = !bl && gregorianCalendar3.getTime().compareTo(gregorianCalendar2.getTime()) == 0 ? "*** " + n20 + " ***" : "- " + n20 + " -";
            rectangle2 = fontMetrics.getStringBounds(string2, graphics).getBounds();
            graphics.setColor(this.textColor);
            graphics.drawString(string2, (n21 += n7) - n7 + (n8 - rectangle2.width) / 2, n22 + rectangle2.height - fontMetrics.getDescent());
            this.calendarTideList(graphics, n21, n22 += rectangle2.height, n24, gregorianCalendar3.getTime(), bl);
            gregorianCalendar3.add(5, 1);
        }
    }

    int ChooseColor(double d) {
        int n = 255;
        int n2 = 255;
        int n3 = 255;
        if (d >= -1.0 && d < 2.0) {
            boolean bl;
            ColorMat[] colorMatArray = new ColorMat[]{new ColorMat(-1.0, 65, 45, 14), new ColorMat(0.0, 65, 45, 14), new ColorMat(0.25, 104, 104, 32), new ColorMat(0.5, 0, 120, 96), new ColorMat(0.75, 64, 128, 255), new ColorMat(1.0, 255, 255, 255), new ColorMat(2.0, 255, 255, 255)};
            int n4 = 0;
            n = 255;
            n2 = 255;
            n3 = 255;
            do {
                double d2 = colorMatArray[n4].v;
                double d3 = colorMatArray[n4 + 1].v;
                boolean bl2 = bl = d >= d2 && d < d3;
                if (bl) {
                    double d4 = (d - d2) / (d3 - d2);
                    double d5 = 1.0 - d4;
                    n = (int)((double)colorMatArray[n4].r * d5 + (double)colorMatArray[n4 + 1].r * d4);
                    n2 = (int)((double)colorMatArray[n4].g * d5 + (double)colorMatArray[n4 + 1].g * d4);
                    n3 = (int)((double)colorMatArray[n4].b * d5 + (double)colorMatArray[n4 + 1].b * d4);
                    continue;
                }
                ++n4;
            } while (!bl && n4 < colorMatArray.length);
        }
        return n << 16 | n2 << 8 | n3;
    }

    void DrawMatDate(Graphics graphics, long l, int n, int n2, int n3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l * 1000L));
        String string = this.main.tideComp.padChar(gregorianCalendar.get(2) + 1, 2, "0") + "/" + this.main.tideComp.padChar(gregorianCalendar.get(5), 2, "0");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = fontMetrics.getStringBounds(string, graphics).getBounds();
        int n4 = this.gstartx - rectangle.width - this.scalex / 96;
        graphics.setColor(this.textColor);
        graphics.drawString(string, n4, n + rectangle.height / 4);
    }

    void DrawColorMat(Graphics graphics, int n, int n2) {
        long l;
        int n3;
        boolean bl;
        double d = this.graphWidth;
        double d2 = 48.0;
        boolean bl2 = false;
        SmoothRect smoothRect = null;
        long l2 = this.chartCal.getTime().getTime() / 1000L;
        Rectangle rectangle = new Rectangle();
        double d3 = this.theDoc.siteSet.mHiWater - this.theDoc.siteSet.mLoWater;
        boolean bl3 = bl = this.oldMatx != n || this.oldMaty != n2 || this.oldSmoothGraph != this.smoothGraph || this.oldMatUnits != this.theDoc.siteSet.currentDisplayUnits || this.oldMatBase != l2 || (double)this.oldMatHeight != d || !this.oldMatName.equals(this.theDoc.siteSet.fullName) || this.tideMat == null || this.smoothGraph && this.offScreenImage == null;
        if (bl) {
            this.oldMatx = n;
            this.oldMaty = n2;
            this.oldMatBase = l2;
            this.oldMatHeight = (int)d;
            this.oldMatName = this.theDoc.siteSet.fullName;
            this.oldMatUnits = this.theDoc.siteSet.currentDisplayUnits;
            this.oldSmoothGraph = this.smoothGraph;
            if (this.smoothGraph) {
                smoothRect = new SmoothRect();
                bl2 = true;
                this.offScreenImage = new BufferedImage(this.scalex, this.scaley, 1);
            }
            this.tideMat = new TideDatum[(int)(d + (double)bl2)][(int)(d2 + (double)bl2)];
            n3 = 0;
            while ((double)n3 < d + (double)bl2) {
                l = l2 + (long)(n3 * 86400);
                long l3 = (long)(86400.0 / d2);
                int n4 = 0;
                while ((double)n4 < d2 + (double)bl2) {
                    double d4 = this.main.tideComp.timeToTide(this.theDoc.siteSet, l, true);
                    d4 = this.main.tideComp.ConvertHeight(this.theDoc.siteSet, d4);
                    if (d3 != 0.0) {
                        d4 = (d4 - this.theDoc.siteSet.mLoWater) / d3;
                    }
                    this.tideMat[n3][n4] = new TideDatum(this.ChooseColor(d4), d4);
                    l += l3;
                    ++n4;
                }
                ++n3;
            }
            if (this.smoothGraph) {
                n3 = 0;
                while ((double)n3 <= d) {
                    rectangle.y = (int)((double)n3 / d * (double)this.scaley);
                    rectangle.height = (int)((double)(n3 + 1) / d * (double)this.scaley) - rectangle.y;
                    if ((double)n3 < d) {
                        int n5 = 0;
                        while ((double)n5 < d2) {
                            rectangle.x = (int)((double)n5 / d2 * (double)this.scalex);
                            rectangle.width = (int)((double)(n5 + 1) / d2 * (double)this.scalex) - rectangle.x;
                            smoothRect.drawRect(this.offScreenImage, rectangle, n3, n5, this.tideMat);
                            ++n5;
                        }
                    }
                    ++n3;
                }
            }
        }
        n3 = 0;
        while ((double)n3 <= d) {
            rectangle.y = (int)((double)n3 / d * (double)this.scaley);
            rectangle.height = (int)((double)(n3 + 1) / d * (double)this.scaley) - rectangle.y;
            l = l2 + (long)(n3 * 86400);
            if (n3 % 3 == 0) {
                this.DrawMatDate(graphics, l, rectangle.y + this.gstarty, n, n2);
            }
            if (!this.smoothGraph && (double)n3 < d) {
                int n6 = 0;
                while ((double)n6 < d2) {
                    rectangle.x = (int)((double)n6 / d2 * (double)this.scalex);
                    rectangle.width = (int)((double)(n6 + 1) / d2 * (double)this.scalex) - rectangle.x;
                    graphics.setColor(new Color(this.tideMat[n3][n6].color));
                    graphics.fillRect(rectangle.x + this.gstartx, rectangle.y + this.gstarty, rectangle.width, rectangle.height);
                    ++n6;
                }
            }
            ++n3;
        }
        if (this.smoothGraph) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.offScreenImage, this.gstartx, this.gstarty, this);
        }
        this.makeGrid(graphics, true);
        graphics.setColor(Color.black);
        graphics.drawRect(this.gstartx, this.gstarty, this.scalex, this.scaley);
        this.DrawMouseMatPos(graphics, d, d2, n, n2);
    }

    void DrawMouseMatPos(Graphics graphics, double d, double d2, int n, int n2) {
        if (this.mouseDown) {
            Rectangle rectangle = graphics.getClipBounds();
            double d3 = this.mouseX;
            d3 = d3 < (double)this.gstartx ? (double)this.gstartx : d3;
            d3 = d3 > (double)(this.gstartx + this.scalex) ? (double)(this.gstartx + this.scalex) : d3;
            double d4 = (d3 - (double)this.gstartx) / (double)this.scalex;
            double d5 = this.mouseY;
            d5 = d5 < (double)this.gstarty ? (double)this.gstarty : d5;
            d5 = d5 > (double)(this.gstarty + this.scaley) ? (double)(this.gstarty + this.scaley) : d5;
            double d6 = (d5 - (double)this.gstarty) / (double)this.scaley;
            long l = this.chartCal.getTime().getTime() / 1000L;
            long l2 = (long)(d6 * d);
            long l3 = (long)(d4 * 86400.0);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setRawOffset(0);
            gregorianCalendar.setTimeZone(timeZone);
            gregorianCalendar.setTimeInMillis((l += (l2 *= 86400L) + l3) * 1000L + (long)this.localOffset);
            double d7 = this.main.tideComp.timeToTide(this.theDoc.siteSet, l, true);
            double d8 = this.main.tideComp.ConvertHeight(this.theDoc.siteSet, d7);
            String string = this.main.tideComp.getUnitsTag(this.theDoc.siteSet);
            String string2 = this.main.tideComp.formatDate(gregorianCalendar, false, false, true, false, "") + " " + this.main.tideComp.formatDouble(d8, 1, true) + " " + string;
            this.main.updateStatusBar(string2);
            String string3 = this.main.tideComp.formatDate(gregorianCalendar, false, false, false, false, "") + " " + this.main.tideComp.formatDouble(d8, 1, true) + " " + string.charAt(0);
            String string4 = this.createTimeLabel();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle2 = fontMetrics.getStringBounds(string3, graphics).getBounds();
            Rectangle rectangle3 = fontMetrics.getStringBounds(string4, graphics).getBounds();
            int n3 = rectangle2.width + 8;
            int n4 = rectangle3.width + 8;
            int n5 = n4 > n3 ? n4 : n3;
            int n6 = (n3 - n4) / 2;
            n6 = n6 < 0 ? 0 : n6;
            int n7 = rectangle2.height * 2 + 4;
            int n8 = (int)(d3 - (double)(n5 / 2));
            d5 = d5 < 2.0 ? 2.0 : (d5 -= (double)(n7 + n2 / 96));
            int n9 = (int)d5 + n7 * 2 / 3;
            int n10 = (int)(d5 - 2.0);
            n8 = n8 < 0 ? 0 : n8;
            n8 = n8 + n5 > rectangle.width ? rectangle.width - n5 : n8;
            graphics.setColor(Color.white);
            graphics.fillRect(n8, n10, n5, n7);
            graphics.setColor(Color.red);
            graphics.drawRect(n8, n10, n5, n7);
            graphics.setColor(this.textColor);
            graphics.drawString(string3, n8 + 4, n9 + 4 - rectangle2.height);
            graphics.drawString(string4, n8 + 4 + n6, n9 + 4);
        }
    }

    public void keyHandler(KeyEvent keyEvent) {
        boolean bl = true;
        int n = keyEvent.getKeyCode();
        if (n == 39) {
            this.getChartCalendar().add(5, 1);
        } else if (n == 37) {
            this.getChartCalendar().add(5, -1);
        } else if (n == 40) {
            this.getChartCalendar().add(2, 1);
        } else if (n == 38) {
            this.getChartCalendar().add(2, -1);
        } else if (n == 33) {
            this.getChartCalendar().add(1, -1);
        } else if (n == 34) {
            this.getChartCalendar().add(1, 1);
        } else if (n == 36) {
            this.setChartCalendar();
        } else {
            bl = false;
        }
        if (bl) {
            keyEvent.consume();
            this.theDoc.newDisplay();
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.SiteExplorerButton = new JMenuItem();
        this.NearestSitesButton = new JMenuItem();
        this.ConfigureDataButton = new JMenuItem();
        this.PrintButton = new JMenuItem();
        this.SiteData = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.HelpButton = new JMenuItem();
        this.SiteExplorerButton.setText("Site Explorer");
        this.SiteExplorerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.SiteExplorerButtonActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.SiteExplorerButton);
        this.NearestSitesButton.setText("Nearest Sites");
        this.NearestSitesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.NearestSitesButtonActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.NearestSitesButton);
        this.ConfigureDataButton.setText("Configuration/Data");
        this.ConfigureDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.ConfigureDataButtonActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.ConfigureDataButton);
        this.PrintButton.setText("Print Chart");
        this.PrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.PrintButtonActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.PrintButton);
        this.SiteData.setText("Site Data");
        this.SiteData.setToolTipText("Information about this site");
        this.SiteData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.SiteDataActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.SiteData);
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this site");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.HelpButton.setText("Help");
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidePanel.this.HelpButtonActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.HelpButton);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TidePanel.this.formMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TidePanel.this.formMouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                TidePanel.this.formMouseDragged(mouseEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TidePanel.this.formFocusLost(focusEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TidePanel.this.formKeyPressed(keyEvent);
            }
        });
        this.setLayout(new BorderLayout());
    }

    private void formFocusLost(FocusEvent focusEvent) {
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.main.tabbedPaneManager.close();
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.theDoc.handleKey(keyEvent);
    }

    private void HelpButtonActionPerformed(ActionEvent actionEvent) {
        this.main.openFile("Help Browser", true);
    }

    private void ConfigureDataButtonActionPerformed(ActionEvent actionEvent) {
        this.main.launchConfiguration();
    }

    private void PrintButtonActionPerformed(ActionEvent actionEvent) {
        this.doPrint();
    }

    private void SiteExplorerButtonActionPerformed(ActionEvent actionEvent) {
        this.main.openFile("Site Explorer", true);
    }

    private void NearestSitesButtonActionPerformed(ActionEvent actionEvent) {
        TidesFindNearest tidesFindNearest = new TidesFindNearest((Frame)this.main, false);
    }

    private void SiteDataActionPerformed(ActionEvent actionEvent) {
        new SiteDataDialog(this.theDoc);
    }

    public void moveTime(int n, int n2) {
        if (n2 == 0) {
            this.setChartCalendar();
        } else {
            this.getChartCalendar().add(n, n2);
        }
        this.theDoc.newDisplay();
    }

    private void formMouseDragged(MouseEvent mouseEvent) {
        this.formMousePressed(mouseEvent);
    }

    private void formMouseReleased(MouseEvent mouseEvent) {
        if (!this.testPopup(mouseEvent)) {
            this.mouseDown = false;
            if (this.isVisible()) {
                this.repaint();
            }
            this.main.updateStatusBar("Done (F1 = Help)");
        }
        this.requestFocusInWindow();
    }

    private void formMousePressed(MouseEvent mouseEvent) {
        if (!this.testPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.mouseDown = true;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            if (this.isVisible()) {
                this.repaint();
            }
        }
        this.requestFocusInWindow();
    }

    private boolean testPopup(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent) && this.isVisible()) {
            this.popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    final class ColorMat {
        public double v;
        public int r;
        public int g;
        public int b;

        ColorMat(double d, int n, int n2, int n3) {
            this.v = d;
            this.r = n;
            this.g = n2;
            this.b = n3;
        }

        public int getColor() {
            return this.r << 16 | this.g << 8 | this.b;
        }
    }

    final class GraphicsData {
        Graphics2D g;
        double x;
        double y;
        int ox;
        int oy;
        boolean start;

        GraphicsData(Graphics2D graphics2D) {
            this.g = graphics2D;
        }
    }
}

