/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import net.geocentral.geometria.action.GProblemAnswerAction;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionPlaneAnswer;
import net.geocentral.geometria.model.answer.GFixedPlaneAnswer;
import net.geocentral.geometria.model.answer.GLineSetAnswer;
import net.geocentral.geometria.model.answer.GMultipleChoiceAnswer;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.model.answer.GPointSetAnswer;
import net.geocentral.geometria.model.answer.condition.GCondition;
import net.geocentral.geometria.model.answer.condition.GEquilateralTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GHamiltonianCycleCondition;
import net.geocentral.geometria.model.answer.condition.GIsoscellesTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GLineSetCondition;
import net.geocentral.geometria.model.answer.condition.GNotThroughLineCondition;
import net.geocentral.geometria.model.answer.condition.GNotThroughPointCondition;
import net.geocentral.geometria.model.answer.condition.GParallelToLineCondition;
import net.geocentral.geometria.model.answer.condition.GParallelToPlaneCondition;
import net.geocentral.geometria.model.answer.condition.GParallelogramCondition;
import net.geocentral.geometria.model.answer.condition.GPerpendicularToLineCondition;
import net.geocentral.geometria.model.answer.condition.GPerpendicularToPlaneCondition;
import net.geocentral.geometria.model.answer.condition.GPlaneCondition;
import net.geocentral.geometria.model.answer.condition.GRectangleCondition;
import net.geocentral.geometria.model.answer.condition.GRectangularTriangleCondition;
import net.geocentral.geometria.model.answer.condition.GRhombusCondition;
import net.geocentral.geometria.model.answer.condition.GSquareCondition;
import net.geocentral.geometria.model.answer.condition.GThroughLineCondition;
import net.geocentral.geometria.model.answer.condition.GThroughNoEdgeCondition;
import net.geocentral.geometria.model.answer.condition.GThroughNoVertexCondition;
import net.geocentral.geometria.model.answer.condition.GThroughPointCondition;
import net.geocentral.geometria.model.answer.condition.GVolumeCutInRatioCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPointSetUtils;
import net.geocentral.geometria.view.GHelpOkCancelDialog;
import org.apache.log4j.Logger;

public class GProblemAnswerDialog
extends JDialog
implements GHelpOkCancelDialog,
ActionListener {
    private int option = 1;
    private GProblem document;
    private JPanel valuePane;
    private JRadioButton numberButton;
    private JRadioButton pointSetButton;
    private JRadioButton lineSetButton;
    private JRadioButton fixedPlaneButton;
    private JRadioButton conditionPlaneButton;
    private JRadioButton multipleChoiceButton;
    private JTextField numberTextField;
    private JTextField pointSetTextField;
    private JComboBox[] lineSetComboBoxes;
    private JTextField[] conditionPlaneTextFields;
    private JComboBox[] conditionPlaneComboBoxes;
    private List<JTextField> optionTextFields;
    private List<JRadioButton> optionRadioButtons;
    private GLineSetCondition[][] lineSetConditionGroups = new GLineSetCondition[][]{{new GHamiltonianCycleCondition()}};
    private GPlaneCondition[][] planeConditionGroups = new GPlaneCondition[][]{{new GThroughPointCondition(), new GThroughLineCondition(), new GNotThroughPointCondition(), new GNotThroughLineCondition(), new GThroughNoVertexCondition(), new GThroughNoEdgeCondition(), new GParallelToLineCondition(), new GParallelToPlaneCondition(), new GPerpendicularToLineCondition(), new GPerpendicularToPlaneCondition()}, {new GVolumeCutInRatioCondition()}, {new GIsoscellesTriangleCondition(), new GRectangularTriangleCondition(), new GEquilateralTriangleCondition(), new GParallelogramCondition(), new GRhombusCondition(), new GRectangleCondition(), new GSquareCondition()}};
    private GAnswer answer;
    private GProblemAnswerAction action;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GProblemAnswerDialog(Frame ownerFrame, GProblemAnswerAction action, GProblem document) {
        super(ownerFrame, true);
        logger.info((Object)"");
        this.document = document;
        this.action = action;
        this.setDefaultCloseOperation(2);
        this.layoutComponents();
        this.pack();
        GGraphicsFactory.getInstance().setLocation(this, ownerFrame, GGraphicsFactory.LocationType.CENTER);
        this.setTitle(GDictionary.get("Answer", new String[0]));
        this.setResizable(true);
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setPreferredSize(new Dimension(400, 320));
        this.getContentPane().add(tabbedPane);
        JPanel typePane = new JPanel();
        this.valuePane = new JPanel();
        tabbedPane.addTab(GDictionary.get("Type", new String[0]), typePane);
        tabbedPane.addTab(GDictionary.get("Value", new String[0]), this.valuePane);
        this.layoutTypePane(typePane);
        JPanel helpOkCancelPane = GGraphicsFactory.getInstance().createHelpOkCancelPane(this, this.action.getHelpId());
        this.getContentPane().add(helpOkCancelPane);
    }

    private void layoutTypePane(JPanel typePane) {
        logger.info((Object)"");
        typePane.setLayout(new BoxLayout(typePane, 0));
        this.numberButton = new JRadioButton(GDictionary.get("Number", new String[0]));
        this.numberButton.addActionListener(this);
        this.pointSetButton = new JRadioButton(GDictionary.get("PointSet", new String[0]));
        this.pointSetButton.addActionListener(this);
        this.lineSetButton = new JRadioButton(GDictionary.get("LineSet", new String[0]));
        this.lineSetButton.addActionListener(this);
        this.fixedPlaneButton = new JRadioButton(GDictionary.get("FixedPlane", new String[0]));
        this.fixedPlaneButton.addActionListener(this);
        this.conditionPlaneButton = new JRadioButton(GDictionary.get("ConditionPlane", new String[0]));
        this.conditionPlaneButton.addActionListener(this);
        this.multipleChoiceButton = new JRadioButton(GDictionary.get("MultipleChoice", new String[0]));
        this.multipleChoiceButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.numberButton);
        buttonGroup.add(this.pointSetButton);
        buttonGroup.add(this.lineSetButton);
        buttonGroup.add(this.fixedPlaneButton);
        buttonGroup.add(this.conditionPlaneButton);
        buttonGroup.add(this.multipleChoiceButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(this.numberButton);
        buttonPane.add(this.pointSetButton);
        buttonPane.add(this.lineSetButton);
        buttonPane.add(this.fixedPlaneButton);
        buttonPane.add(this.conditionPlaneButton);
        buttonPane.add(this.multipleChoiceButton);
        buttonPane.add(Box.createVerticalGlue());
        typePane.add(Box.createRigidArea(new Dimension(20, 20)));
        typePane.add(buttonPane);
        typePane.add(Box.createHorizontalGlue());
        GAnswer answer = this.document.getAnswer();
        if (answer instanceof GNumberAnswer) {
            this.numberButton.setSelected(true);
        } else if (answer instanceof GPointSetAnswer) {
            this.pointSetButton.setSelected(true);
        } else if (answer instanceof GLineSetAnswer) {
            this.lineSetButton.setSelected(true);
        } else if (answer instanceof GFixedPlaneAnswer) {
            this.fixedPlaneButton.setSelected(true);
        } else if (answer instanceof GConditionPlaneAnswer) {
            this.conditionPlaneButton.setSelected(true);
        } else if (answer instanceof GMultipleChoiceAnswer) {
            this.multipleChoiceButton.setSelected(true);
        }
        this.layoutValuePane();
    }

    private void layoutValuePane() {
        logger.info((Object)"");
        this.valuePane.removeAll();
        if (this.numberButton.isSelected()) {
            this.layoutNumberValuePane();
        } else if (this.pointSetButton.isSelected()) {
            this.layoutPointSetValuePane();
        } else if (this.lineSetButton.isSelected()) {
            this.layoutLineSetValuePane();
        } else if (this.fixedPlaneButton.isSelected()) {
            this.layoutFixedPlaneValuePane();
        } else if (this.conditionPlaneButton.isSelected()) {
            this.layoutConditionPlaneValuePane();
        } else if (this.multipleChoiceButton.isSelected()) {
            this.layoutMultipleChoiceValuePane();
        }
    }

    private void layoutNumberValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.numberTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("Value", new String[0]), new JComponent[]{this.numberTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GNumberAnswer && ((GNumberAnswer)ans).getValue() != null && ((GNumberAnswer)ans).getValue() != 0.0) {
            String stringValue = String.valueOf(((GNumberAnswer)ans).getValue());
            this.numberTextField.setText(stringValue);
        } else {
            GNotepadRecord record = this.document.getNotepad().getSelectedRecord();
            if (record != null) {
                String variableName = record.getVariable().getName();
                this.numberTextField.setText(variableName);
            }
        }
    }

    private void layoutPointSetValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.pointSetTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("Points", new String[0]), new JComponent[]{this.pointSetTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GPointSetAnswer) {
            Point3d[] coords = ((GPointSetAnswer)ans).getCoords();
            String valueString = coords == null ? "" : ans.toString();
            this.pointSetTextField.setText(valueString);
        } else {
            String[] selectedLabels = GPointSetUtils.fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.pointSetTextField.setText(String.valueOf(buf));
            }
        }
    }

    private void layoutLineSetValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.lineSetComboBoxes = new JComboBox[this.lineSetConditionGroups.length];
        String[] captions = new String[]{GDictionary.get("Miscellaneous", new String[0])};
        for (int i = 0; i < this.lineSetConditionGroups.length; ++i) {
            String[] labels = new String[this.lineSetConditionGroups[i].length + 1];
            labels[0] = "-- " + GDictionary.get("NotSelected", new String[0]) + " --";
            for (int j = 0; j < this.lineSetConditionGroups[i].length; ++j) {
                labels[j + 1] = this.lineSetConditionGroups[i][j].getDescription();
            }
            this.lineSetComboBoxes[i] = GGraphicsFactory.getInstance().createComboBox(labels);
            JComponent[] components = new JComponent[]{this.lineSetComboBoxes[i]};
            JPanel pane = this.layoutPane(captions[i], components);
            this.valuePane.add(pane);
            this.valuePane.add(Box.createVerticalGlue());
        }
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GLineSetAnswer) {
            GCondition[] conditions = ((GLineSetAnswer)ans).getConditions();
            for (int i = 0; i < conditions.length; ++i) {
                if (conditions[i] == null) continue;
                for (int j = 0; j < this.lineSetConditionGroups[i].length; ++j) {
                    if (!this.lineSetConditionGroups[i][j].getClass().equals(conditions[i].getClass())) continue;
                    this.lineSetComboBoxes[i].setSelectedIndex(j + 1);
                }
            }
        }
    }

    private void layoutFixedPlaneValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.pointSetTextField = GGraphicsFactory.getInstance().createAnswerInput(null);
        JPanel inputPane = this.layoutPane(GDictionary.get("Points", new String[0]), new JComponent[]{this.pointSetTextField});
        this.valuePane.add(inputPane);
        this.valuePane.add(Box.createVerticalGlue());
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GFixedPlaneAnswer) {
            Point3d[] coords = ((GFixedPlaneAnswer)ans).getCoords();
            String valueString = coords == null ? "" : ans.toString();
            this.pointSetTextField.setText(valueString);
        } else {
            String[] selectedLabels = GPointSetUtils.fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.pointSetTextField.setText(String.valueOf(buf));
            }
        }
    }

    private void layoutConditionPlaneValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        this.valuePane.add(Box.createVerticalGlue());
        this.conditionPlaneComboBoxes = new JComboBox[this.planeConditionGroups.length];
        this.conditionPlaneTextFields = new JTextField[this.planeConditionGroups.length];
        this.conditionPlaneTextFields[0] = GGraphicsFactory.getInstance().createAnswerInput(null);
        this.conditionPlaneTextFields[1] = GGraphicsFactory.getInstance().createAnswerInput(null);
        String[] captions = new String[]{GDictionary.get("Passes", new String[0]), GDictionary.get("Miscellaneous", new String[0]), GDictionary.get("SectionShapedLike", new String[0])};
        for (int i = 0; i < this.planeConditionGroups.length; ++i) {
            String[] labels = new String[this.planeConditionGroups[i].length + 1];
            labels[0] = "-- " + GDictionary.get("NotSelected", new String[0]) + " --";
            for (int j = 0; j < this.planeConditionGroups[i].length; ++j) {
                labels[j + 1] = this.planeConditionGroups[i][j].getDescription();
            }
            this.conditionPlaneComboBoxes[i] = GGraphicsFactory.getInstance().createComboBox(labels);
            JComponent[] components = this.conditionPlaneTextFields[i] == null ? new JComponent[]{this.conditionPlaneComboBoxes[i]} : new JComponent[]{this.conditionPlaneComboBoxes[i], this.conditionPlaneTextFields[i]};
            JPanel pane = this.layoutPane(captions[i], components);
            this.valuePane.add(pane);
            this.valuePane.add(Box.createVerticalGlue());
        }
        GAnswer ans = this.document.getAnswer();
        if (ans instanceof GConditionPlaneAnswer) {
            GCondition[] conditions = ((GConditionPlaneAnswer)ans).getConditions();
            for (int i = 0; i < conditions.length; ++i) {
                if (conditions[i] == null) continue;
                for (int j = 0; j < this.planeConditionGroups[i].length; ++j) {
                    if (!this.planeConditionGroups[i][j].getClass().equals(conditions[i].getClass())) continue;
                    this.conditionPlaneComboBoxes[i].setSelectedIndex(j + 1);
                    if (this.conditionPlaneTextFields[i] == null) continue;
                    String stringValue = conditions[i].getStringValue();
                    this.conditionPlaneTextFields[i].setText(stringValue);
                }
            }
        } else {
            String[] selectedLabels = GPointSetUtils.fromSelection(this.document);
            if (selectedLabels.length > 0) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < selectedLabels.length; ++i) {
                    buf.append(selectedLabels[i]);
                    if (i >= selectedLabels.length - 1) continue;
                    buf.append(",");
                }
                this.conditionPlaneTextFields[0].setText(String.valueOf(buf));
            }
        }
    }

    private void layoutMultipleChoiceValuePane() {
        logger.info((Object)"");
        this.valuePane.setLayout(new BoxLayout(this.valuePane, 1));
        final JPanel optionsPane = new JPanel();
        optionsPane.setLayout(new BoxLayout(optionsPane, 1));
        final JPanel selectionPane = new JPanel();
        selectionPane.setLayout(new BoxLayout(selectionPane, 1));
        selectionPane.add(new JScrollPane(optionsPane));
        JPanel addButtonPane = new JPanel();
        addButtonPane.setLayout(new BoxLayout(addButtonPane, 0));
        addButtonPane.add(Box.createHorizontalGlue());
        JButton addButton = GGraphicsFactory.getInstance().createButton(GDictionary.get("Add", new String[0]));
        addButtonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        addButtonPane.add(addButton);
        selectionPane.add(addButtonPane);
        JPanel inputPane = this.layoutPane(GDictionary.get("Options", new String[0]), new JComponent[]{selectionPane});
        this.valuePane.add(inputPane);
        this.optionTextFields = new ArrayList<JTextField>();
        this.optionRadioButtons = new ArrayList<JRadioButton>();
        final ButtonGroup radioButtonGroup = new ButtonGroup();
        final ArrayList<JButton> removeButtons = new ArrayList<JButton>();
        GAnswer ans = this.document.getAnswer();
        Map<String, Boolean> options = ans instanceof GMultipleChoiceAnswer ? ((GMultipleChoiceAnswer)ans).getOptions() : GMultipleChoiceAnswer.getDefaultOptions();
        for (Map.Entry<String, Boolean> entry : options.entrySet()) {
            String option = entry.getKey();
            boolean selected = entry.getValue();
            JPanel optionPane = this.layoutOptionPane(selected, option, radioButtonGroup, removeButtons, optionsPane, selectionPane);
            optionsPane.add(optionPane);
        }
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPanel optionPane = GProblemAnswerDialog.this.layoutOptionPane(false, "", radioButtonGroup, removeButtons, optionsPane, selectionPane);
                optionsPane.add(optionPane);
                selectionPane.validate();
                selectionPane.repaint();
            }
        });
    }

    private JPanel layoutOptionPane(boolean selected, String option, final ButtonGroup radioButtonGroup, final List<JButton> removeButtons, final JPanel optionsPane, final JPanel selectionPane) {
        JPanel optionPane = new JPanel();
        optionPane.setLayout(new BoxLayout(optionPane, 0));
        optionPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 10));
        JRadioButton radioButton = new JRadioButton();
        radioButtonGroup.add(this.numberButton);
        radioButton.setSelected(selected);
        this.optionRadioButtons.add(radioButton);
        radioButtonGroup.add(radioButton);
        optionPane.add(radioButton);
        JTextField optionTextField = GGraphicsFactory.getInstance().createInput(option);
        optionTextField.setText(option);
        this.optionTextFields.add(optionTextField);
        optionPane.add(optionTextField);
        optionPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        final JButton removeButton = GGraphicsFactory.getInstance().createButton(GDictionary.get("Remove", new String[0]));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int optionIndex = removeButtons.indexOf(removeButton);
                JRadioButton removedRadioButton = (JRadioButton)GProblemAnswerDialog.this.optionRadioButtons.remove(optionIndex);
                radioButtonGroup.remove(removedRadioButton);
                GProblemAnswerDialog.this.optionTextFields.remove(optionIndex);
                removeButtons.remove(optionIndex);
                optionsPane.remove(optionIndex);
                GProblemAnswerDialog.this.updateOptionRemoveButtons(removeButtons);
                selectionPane.validate();
                selectionPane.repaint();
            }
        });
        removeButtons.add(removeButton);
        this.updateOptionRemoveButtons(removeButtons);
        optionPane.add(removeButton);
        return optionPane;
    }

    private void updateOptionRemoveButtons(List<JButton> removeButtons) {
        int optionCount = removeButtons.size();
        for (JButton rButton : removeButtons) {
            rButton.setEnabled(optionCount > 1);
        }
    }

    private JPanel layoutPane(String caption, JComponent[] components) {
        Dimension padding = new Dimension(10, 10);
        JPanel pane = GGraphicsFactory.getInstance().createTitledBorderPane(caption);
        pane.setLayout(new BoxLayout(pane, 0));
        for (int i = 0; i < components.length; ++i) {
            pane.add(components[i]);
            if (i >= components.length - 1) continue;
            pane.add(Box.createRigidArea(padding));
        }
        return pane;
    }

    @Override
    public void ok() {
        logger.info((Object)"");
        GAnswer ans = null;
        if (this.numberButton.isSelected()) {
            ans = new GNumberAnswer();
            try {
                ans.validateInput(this.numberTextField.getText().trim(), this.document);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
        }
        if (this.pointSetButton.isSelected()) {
            Point3d[] coords;
            try {
                GFigure figure = this.document.getSelectedFigure();
                coords = GPointSetUtils.fromString(this.pointSetTextField.getText().trim(), figure);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
            if (coords.length < 1) {
                logger.info((Object)"No points");
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("EnterPoints", new String[0]));
                return;
            }
            ans = new GPointSetAnswer(coords);
        } else if (this.lineSetButton.isSelected()) {
            GLineSetCondition[] conditions = new GLineSetCondition[this.lineSetConditionGroups.length];
            for (int i = 0; i < this.lineSetConditionGroups.length; ++i) {
                int j = this.lineSetComboBoxes[i].getSelectedIndex();
                if (j <= 0) continue;
                conditions[i] = this.lineSetConditionGroups[i][j - 1];
                try {
                    conditions[i].validate(null, this.document);
                    continue;
                }
                catch (Exception exception) {
                    GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                    return;
                }
            }
            ans = new GLineSetAnswer(conditions);
        } else if (this.fixedPlaneButton.isSelected()) {
            Point3d[] coords;
            GFigure figure = this.document.getSelectedFigure();
            try {
                coords = GPointSetUtils.fromString(this.pointSetTextField.getText().trim(), figure);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                return;
            }
            if (coords.length != 3) {
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("RefPlaneBy3Points", new String[0]));
                return;
            }
            if (GMath.areCollinear(coords, 1.0E-7)) {
                GGraphicsFactory.getInstance().showErrorDialog(this, GDictionary.get("RefPointsAreCollinear", new String[0]));
                return;
            }
            ans = new GFixedPlaneAnswer(coords);
        } else if (this.conditionPlaneButton.isSelected()) {
            GPlaneCondition[] conditions = new GPlaneCondition[this.planeConditionGroups.length];
            for (int i = 0; i < this.planeConditionGroups.length; ++i) {
                int j = this.conditionPlaneComboBoxes[i].getSelectedIndex();
                if (j <= 0) continue;
                conditions[i] = this.planeConditionGroups[i][j - 1];
                try {
                    String input = this.conditionPlaneTextFields[i] == null ? null : this.conditionPlaneTextFields[i].getText().trim();
                    conditions[i].validate(input, this.document);
                    continue;
                }
                catch (Exception exception) {
                    GGraphicsFactory.getInstance().showErrorDialog(this, exception.getMessage());
                    return;
                }
            }
            ans = new GConditionPlaneAnswer(conditions);
        } else if (this.multipleChoiceButton.isSelected()) {
            LinkedHashMap<String, Boolean> options = new LinkedHashMap<String, Boolean>();
            int optionCount = this.optionTextFields.size();
            for (int optionIndex = 0; optionIndex < optionCount; ++optionIndex) {
                String option = this.optionTextFields.get(optionIndex).getText().trim();
                if (option.isEmpty()) {
                    String message = GDictionary.get("EmptyOptions", new String[0]);
                    GGraphicsFactory.getInstance().showErrorDialog(this, message);
                    return;
                }
                if (options.containsKey(option)) {
                    String message = GDictionary.get("DuplicateOption", new String[0]);
                    GGraphicsFactory.getInstance().showErrorDialog(this, message);
                    return;
                }
                boolean selected = this.optionRadioButtons.get(optionIndex).isSelected();
                options.put(option, selected);
            }
            if (!options.containsValue(true)) {
                String message = GDictionary.get("SelectCorrectOption", new String[0]);
                GGraphicsFactory.getInstance().showErrorDialog(message);
                return;
            }
            ans = new GMultipleChoiceAnswer(options);
        }
        this.answer = ans;
        this.option = 0;
        this.dispose();
    }

    @Override
    public void cancel() {
        logger.info((Object)"");
        this.dispose();
    }

    @Override
    public int getOption() {
        return this.option;
    }

    public GAnswer getAnswer() {
        return this.answer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.layoutValuePane();
    }
}

