/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.model.GCalculator;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GFiguresPane;
import net.geocentral.geometria.view.GLogPane;
import net.geocentral.geometria.view.GNotepadPane;
import org.apache.log4j.Logger;

public class GMainPanel
extends JPanel
implements DocumentListener {
    public static final Dimension FIGURES_PANE_SIZE = new Dimension(550, 550);
    private JSplitPane contentPane;
    private JTextArea textPane;
    private GNotepadPane notepadPane;
    private JSplitPane rightPane;
    private GFiguresPane figuresPane;
    private GLogPane logPane;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GMainPanel() {
        logger.info((Object)"");
    }

    public void layoutComponents() {
        logger.info((Object)"");
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.contentPane = new JSplitPane();
        this.add(this.contentPane);
        JPanel toolPane = new JPanel();
        toolPane.setBorder(BorderFactory.createEmptyBorder(10, 3, 3, 3));
        toolPane.setLayout(new BoxLayout(toolPane, 1));
        this.textPane = new JTextArea();
        this.textPane.setEditable(false);
        this.textPane.setLineWrap(true);
        this.textPane.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(this.textPane);
        TitledBorder tb = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), GDictionary.get("Problem", new String[0]), 0, 1);
        sp.setBorder(tb);
        sp.setPreferredSize(new Dimension(150, 150));
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 150));
        toolPane.add(sp);
        toolPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel calcPane = new JPanel();
        calcPane.setLayout(new BorderLayout());
        TitledBorder cb = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), GDictionary.get("Calculator", new String[0]), 0, 1);
        calcPane.setBorder(cb);
        JTextField textField = GGraphicsFactory.getInstance().createLongInput("");
        GCalculator calculator = GDocumentHandler.getInstance().getCalculator();
        calculator.setTextField(textField);
        calcPane.add((Component)textField, "Center");
        calcPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        toolPane.add(calcPane);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        JComponent[] buttons = new JButton[2];
        buttonPane.add(Box.createHorizontalGlue());
        AbstractAction actionHandler = GDocumentHandler.getInstance().getActionHandler("calculator.evaluate");
        buttons[0] = GGraphicsFactory.getInstance().createButton(actionHandler);
        buttons[0].setIcon(null);
        buttons[0].setText(GDictionary.get("Evaluate", new String[0]));
        buttonPane.add(buttons[0]);
        buttonPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        actionHandler = GDocumentHandler.getInstance().getActionHandler("calculator.clear");
        buttons[1] = GGraphicsFactory.getInstance().createButton(actionHandler);
        buttons[1].setIcon(null);
        buttons[1].setText(GDictionary.get("Clear", new String[0]));
        buttonPane.add(buttons[1]);
        buttonPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toolPane.add(buttonPane);
        GGraphicsFactory.getInstance().adjustSize(buttons);
        toolPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.notepadPane = new GNotepadPane();
        TitledBorder nb = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), GDictionary.get("Notepad", new String[0]), 0, 1);
        this.notepadPane.setBorder(nb);
        toolPane.add(this.notepadPane);
        this.contentPane.setLeftComponent(toolPane);
        this.contentPane.setDividerSize(8);
        this.rightPane = new JSplitPane();
        this.rightPane.setOrientation(0);
        this.figuresPane = new GFiguresPane();
        this.logPane = new GLogPane();
        this.rightPane.setTopComponent(this.figuresPane);
        this.figuresPane.setPreferredSize(FIGURES_PANE_SIZE);
        this.rightPane.setBottomComponent(this.logPane);
        this.rightPane.setDividerLocation((int)((double)this.rightPane.getPreferredSize().height * 0.75));
        this.rightPane.setDividerSize(8);
        this.contentPane.setRightComponent(this.figuresPane);
    }

    public void documentChanged(GDocument document) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        int rightPaneDividerLocation = this.rightPane.getDividerLocation();
        int contentPaneDividerLocation = this.contentPane.getDividerLocation();
        if (document instanceof GProblem) {
            this.contentPane.setRightComponent(this.figuresPane);
            Document text = ((GProblem)document).getText();
            this.textPane.setDocument(text);
            text.addDocumentListener(this);
            this.textPane.setEditable(true);
            this.figuresPane.documentChanged(document);
            this.notepadPane.documentChanged(document);
        } else if (document instanceof GSolution) {
            GSolution masterSolution = documentHandler.getMasterSolution();
            this.contentPane.setRightComponent(this.rightPane);
            if (this.rightPane.getTopComponent() == null) {
                this.rightPane.setTopComponent(this.figuresPane);
                this.rightPane.setDividerLocation(rightPaneDividerLocation);
            }
            Document text = masterSolution.getProblem().getText();
            this.textPane.setDocument(text);
            this.textPane.setEditable(false);
            this.figuresPane.documentChanged(document);
            this.notepadPane.documentChanged(document);
            this.logPane.documentChanged(masterSolution);
        } else if (document == null) {
            this.figuresPane.removeAllFigures();
            this.contentPane.setRightComponent(this.figuresPane);
            this.textPane.setDocument(new PlainDocument());
            this.textPane.setEditable(false);
            this.notepadPane.documentChanged(null);
        }
        this.contentPane.setDividerLocation(contentPaneDividerLocation);
    }

    public void figureSelectionChanged() {
        logger.info((Object)"");
        this.figuresPane.selectionChanged();
    }

    public void notepadChanged(GDocument document) {
        logger.info((Object)"");
        this.notepadPane.repaintRecords();
    }

    public void addFigure(GFigure figure, int index) {
        logger.info((Object)(figure + ", " + index));
        this.figuresPane.addFigure(figure, index);
    }

    public void addFigure(GFigure figure) {
        logger.info((Object)figure);
        this.figuresPane.addFigure(figure);
    }

    public void removeFigure(String figureName) {
        logger.info((Object)figureName);
        this.figuresPane.removeFigure(figureName);
    }

    public void renameFigure(String oldName, String newName) {
        logger.info((Object)(oldName + ", " + newName));
        this.figuresPane.renameFigure(oldName, newName);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    private void textUpdated() {
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        documentHandler.setDocumentModified(true);
        documentHandler.updateSaveActionHandlerState(true);
    }
}

